<?php
/*
* Template Name: Work Opportunities
*/
?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
//to check if there is a post regarding the url access the page
if (have_posts ()) :
  the_post(); 
endif;
$url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'thumbnail' ); 
?>
<section class="inner-banner">
  <?php if( $url != ""):?>
    <img src="<?php echo $url ?>" alt="" class="img-fluid">
    <?php else:?>
    <img src="<?php echo $template_url; ?>images/spousal_inner.jpg" alt="" class="img-fluid">
    <?php endif;?>
    <div class="inner-banner-text">
      <div class="container">
        <div class="row">
          <div class="col-lg-7">
            <h2><?php the_title();?></h2>
            <p><?php the_field('banner_content'); ?></p>
            </div>
          </div>
        </div>
      </div>
  </section>
  <section class="work-opportunities">
    <div class="container">
      <div class="row">
        <?php if(have_rows('all_content')): ?>
          <?php $i=0; while(have_rows('all_content')): ?>
          <?php the_row(); ?>
            <div class="col-lg-4">
              <div class="section text-left">
                <img src="<?php the_sub_field('image'); ?>" alt="">
                <h3><?php the_sub_field('title'); ?></h3>
                <p><?php the_sub_field('short_content'); ?></p>
              </div>
            </div>
        <?php $i++; endwhile; ?>
        <?php endif; ?>
      </div>
    </div>
  </section>  
<?php get_footer(); ?>