<?php
if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly
}
get_header();
if (have_posts ()) :
  the_post(); 
endif;
$template_url = get_bloginfo ( 'template_url' ) . '/';
$url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'thumbnail' ); 
?>
<section class="inner-banner">
      <img src="<?php echo $template_url; ?>images/blog-details-banner.jpg" alt="" class="img-fluid">
      
   </section>
   <section class="get-started">
      <div class="container-fluid">
         <div class="row align-items-start justify-content-center">
            <div class="col-lg-10 mr-lg-0">
               <div class="blog-details">
                  <div class="blog-share">
                     <div class="date">
                        <p><i class="fa fa-calendar" aria-hidden="true"></i> <?php the_time('jS') ?>, <?php the_time('M Y') ?></p>
                     </div>
                  </div>
                  <div class="blog-heading">
                     <h2><?php echo get_the_title();?></h2>
                     <?php if( $url != ""):?>
                     <img src="<?php echo $url ?>" alt="" class="img-fluid">
                     <?php endif;?>
                  </div>
                  <?php echo get_the_content();?>
               </div>
            </div>
            <div class="col-lg-4 ml-lg-5">               
               <div class="popular-post" id="popular-post-one">
                  <h3>Popular Posts</h3>
                  <ul>
                     <?php
                    $recent_posts = wp_get_recent_posts(array(
                        'numberposts' => 5,
                        'post_status' => 'publish'
                    ));
                    if (is_array($recent_posts) || is_object($recent_posts)):
                    foreach($recent_posts as $post) : 
                    $blog_img_url = get_the_post_thumbnail_url( $post['ID'],'full');
                    $img = get_stylesheet_directory_uri().'/timthumb.php?src='.esc_url($blog_img_url).'&w=101&h=90&zc=2';
                   ?>
                   <a href="<?php echo $post['guid'];?>"><li>
                     <div class="image">
                       <img src="<?php echo $blog_img_url;?>" alt="" class="img-fluid">
                     </div>
                     <div class="text">
                      <p><?php echo $post['post_title'];?></p>
                     </div>
                   </li></a>
                   <?php endforeach; endif; wp_reset_query();?>
                  </ul>
               </div>
            </div>
         </div>
      </div>
   </section>     
<?php get_footer();?>