<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}
?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
//to check if there is a post regarding the url access the page
if (have_posts ()) :
  the_post(); 
endif;
$url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'thumbnail' ); 
?>
<section class="inner-banner">
    <?php if( $url != ""):?>
    <img src="<?php echo $url ?>" class="img-fluid">
    <?php else:?>
    <img src="<?php echo $template_url; ?>images/blog-banner.jpg" class="img-fluid">
    <?php endif;?> 
    <div class="inner-banner-text text-left">
      <div class="container">
        <div class="row">
          <div class="col-lg-8">
            <h2>Informative <span><?php the_title();?></span></h2>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="get-started">
      <div class="container" style="max-width: 90%;">
        <div class="row">
          <div class="col-lg-8 col-md-12 col-sm-12">
            <div class="featured-posts">
              <?php echo do_shortcode('[GHI_blog]');?>
            </div>
          </div>

          <div class="col-lg-4 col-md-12 col-sm-12">
            <div class="popular-post" id="popular-post-one">
              <h3>Popular Posts</h3>
              <ul>
                <?php
                    $recent_posts = wp_get_recent_posts(array(
                        'numberposts' => 5,
                        'post_status' => 'publish'
                    ));
                    if (is_array($recent_posts) || is_object($recent_posts)):
                    foreach($recent_posts as $post) : 
                    $blog_img_url = get_the_post_thumbnail_url( $post['ID'],'full');
                ?>
                <a href="<?php echo $post['guid'];?>"><li>
                     <div class="image">
                       <img src="<?php echo $blog_img_url;?>" alt="" class="img-fluid">
                     </div>
                     <div class="text">
                      <p><?php echo $post['post_title'];?></p>
                     </div>
                   </li></a>
                <?php endforeach; endif; wp_reset_query();?>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </section>

<?php get_footer(); ?>