<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Asap:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet">
    <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" integrity="sha384-wvfXpqpZZVQGK6TAh5PVlGOfQNHSoD2xbE+QkPxCAFlNEevoEH3Sl0sibVcOQVnN" crossorigin="anonymous">
    <style>
        /* Blue outline on focus */
        .StripeElement--focus {
            border-color: #80BDFF;
            outline: 0;
            box-shadow: 0 0 0 .2rem rgba(0, 123, 255, .25);
            transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        }

        /* Can't see what I type without this */
        #card-number.form-control,
        #card-cvc.form-control,
        #card-exp.form-control {
            display: inline-block;
        }
    </style>
</head>

<body>
    <section>
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <div class="heading">
                        <h1>Pay With<span> Stripe</span></h1>
                    </div>
                </div>
            </div>
            <div class="row mt-5">
                <div class="col-sm-6 offset-sm-3">
                    <div id="card-errors" role="alert"></div>
                    <div class="card">
                        <div class="card-body">


                            <form action="javascript:void(0);" method="post" id="payment-form">

                                <div class="col-md-12 form-group">
                                 Payment For: $ <?= $_POST['amount'] ?> (<?= $_POST['currency_type'] ?>)
                                </div>

                                <div class="col-md-12 form-group">
                                <label for="card-number">Name on card</label>
                                <input type="text" class="form-control" id="card_name" name="card_name" value="<?= $_POST['fname'] . ' ' . $_POST['lname'] ?>">

                                </div>

                                

                                <div class="input-group mb-2">
                                    <input type="hidden" name="name" value="<?= $_POST['fname'] . ' ' . $_POST['lname'] ?>" />
                                    <input type="hidden" name="email" value="<?= $_POST['email'] ?>" />
                                    <input type="hidden" name="contact" value="<?= $_POST['contact'] ?>" />
                                    <input type="hidden" name="amount" id="amount" value="<?= $_POST['amount'] ?>" />
                                    <input type="hidden" name="currency_type" id="currency_type" value="<?= $_POST['currency_type'] ?>" />
                                </div>

                                <div class="col-md-12 form-group">
 
                                    <div id="card-element" class="form-control">
                                        <!-- A Stripe Element will be inserted here. -->
                                    </div>
                                </div>

                                <div class="form-group col-lg-12">
                                    <button class="btn btn-success btn-lg btn-block">Proceed to Pay</button>
                                </div>
                            </form>


                            <!-- <form id="payment-form" method="POST">
                                <div class="row mb-4">
                                    Payment For: $ <?= $_POST['amount'] ?> (<?= $_POST['currency_type'] ?>)
                                </div>

                                <label for="card-number">Name on card</label>
                                <div class="input-group mb-2">
                                    <input type="text" class="form-control" id="card_name" name="card_name" value="<?= $_POST['fname'] . ' ' . $_POST['lname'] ?>">
                                    <input type="hidden" name="name" value="<?= $_POST['fname'] . ' ' . $_POST['lname'] ?>" />
                                    <input type="hidden" name="email" value="<?= $_POST['email'] ?>" />
                                    <input type="hidden" name="contact" value="<?= $_POST['contact'] ?>" />
                                    <input type="hidden" name="amount" id="amount" value="<?= $_POST['amount'] ?>" />
                                    <input type="hidden" name="currency_type" id="currency_type" value="<?= $_POST['currency_type'] ?>" />
                                </div>
                                <label for="card-number">Credit Card Number</label>
                                <div class="input-group mb-2">

                                    <span id="card-number" class="form-control">
                                    </span>

                                </div>
                                <label for="card-cvc">CVC Number</label>
                                <div class="input-group mb-2">

                                    <span id="card-cvc" class="form-control">
                                    </span>
                                </div>
                                <label for="card-exp">Expiration</label>
                                <div class="input-group mb-2">
                                    <span id="card-exp" class="form-control">
                                    </span>
                                </div>

                                <button id="payment-submit" class="btn btn-read mt-1">Pay Now</button>
                            </form> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script src="https://code.jquery.com/jquery-3.2.1.min.js" integrity="sha256-hwg4gsxgFZhOsEEamdOYGBf13FyQuiTwlAQgxVSNgt4=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
    <script src="https://js.stripe.com/v3/"></script> 
</body>

<script>
// Create a Stripe client.
var stripe = Stripe('pk_test_5RG9yvjcXoiTxHYGjOkPPtm800TKKDlQaz');//Get publishable Key
//var stripe = Stripe('pk_live_HxHDZSAQ1CpiyAjSpeix3b9l');

// Create an instance of Elements.
var elements = stripe.elements();

// Custom styling can be passed to options when creating an Element.
// (Note that this demo uses a wider set of styles than the guide below.)
var style = {
  base: {
    color: '',
    fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
    fontSmoothing: 'antialiased',
    fontSize: '16px',
    '::placeholder': {
      color: '#aab7c4'
    }
  },
  invalid: {
    color: '#fa755a',
    iconColor: '#fa755a'
  }
};

//Style button with BS

// Create an instance of the card Element.
var card = elements.create('card', {style: style});

// Add an instance of the card Element into the `card-element` <div>.
card.mount('#card-element');

// Handle real-time validation errors from the card Element.
card.addEventListener('change', function(event) {
  var displayError = document.getElementById('card-errors');
  if (event.error) {
    displayError.textContent = event.error.message;
  } else {
    displayError.textContent = '';
  }
});

 


// Handle form submission.
var form = document.getElementById('payment-form');
form.addEventListener('submit', function(event) {
   event.preventDefault(); 

	  //stripe.createToken(card); 

	  stripe.createToken(card).then(function(result) {
		console.log(result);
		if (result.error) {
		  // Inform the user if there was an error.
		  var errorElement = document.getElementById('card-errors');
		  errorElement.textContent = result.error.message;

		} else {
		  // Send the token to your server.
		  stripeTokenHandler(result.token);
		}
	  });  
});


// Submit the form with the token ID.
function stripeTokenHandler(token) {
	
  	//alert(token.id);
	
  // Insert the token ID into the form so it gets submitted to the server
  var form = document.getElementById('payment-form');
  var hiddenInput = document.createElement('input');
  hiddenInput.setAttribute('type', 'hidden');
  hiddenInput.setAttribute('name', 'stripeToken');
  hiddenInput.setAttribute('value', token.id);
  form.appendChild(hiddenInput);

  // Submit the form
  form.submit();
}
</script>

</html>