<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\stripeModel;
use App\defaultModel;
use Stripe\Stripe;

class stripeController extends Controller
{
    public function bankAccountCreate()
    {
        $stripeModel = new stripeModel();
        $secret_key = $stripeModel->getSecretKey();
        \Stripe\Stripe::setApiKey ($secret_key);
        \Stripe\Stripe::setApiVersion("2020-03-02");
        try {

            $bankToken = \Stripe\Token::create([
                'bank_account' => [
                    'country' => 'US',
                    'currency' => 'USD',
                    'account_holder_name' => 'Soura Sankar',
                    'account_holder_type' => 'individual',
                    'routing_number' => '110000000',
                    'account_number' => '000123456789'
                ]
            ]);
            
            return array("status"=>"1","message"=>"Success","value"=>$bankToken);
        } catch (Exception $e) {
            return array("status"=>"0","message"=>$e->getError());
        }
    }
    public function payoutTest()
    {
        // \Stripe\Stripe::setApiKey('sk_test_4eC39HqLyjWDarjtT1zdp7dc');
        $stripeModel = new stripeModel();
        $secret_key = $stripeModel->getSecretKey();
        \Stripe\Stripe::setApiKey ($secret_key);
\Stripe\Stripe::setApiVersion("2020-03-02");
        $balance = \Stripe\Balance::retrieve();
        // $account = \Stripe\Account::all();
        // $stripeAccountObj1 = \Stripe\Account::retrieve('acct_1H719VLB95Sp1OPq');
        //     print_r($stripeAccountObj1);exit();
        try {
                // $transfer = \Stripe\Transfer::create([
                //     'amount' => 1 * 100,
                //     'currency' => 'usd',
                //     'destination' => 'acct_1H719VLB95Sp1OPq',
                //     // 'statement_descriptor' => 'Transfer from Managed Account Stripe balance to Managed Account Bank Account',
                //     // "source_type" => "bank_account",
                // ]);
            $stripeAccountObj1 = \Stripe\Account::retrieve('acct_1H719VLB95Sp1OPq');
            print_r($stripeAccountObj1);exit();
                // $transactionModel->sellerTransactionFailedStatusChange($value->id);
                // $transactionModel->addTransaction($transfer->id,$value->seller_id,$value->seller_f_trnsfr_amount,'usd','Transfer Money to seller from Admin','Succeed','debit');
            } catch (\Stripe\Exception\CardException $e) {
            // Since it's a decline, \Stripe\Exception\CardException will be caught
                return array("status"=>"0","message"=>$e->getError());
            } catch (\Stripe\Exception\RateLimitException $e) {
              // Too many requests made to the API too quickly
                return array("status"=>"0","message"=>$e->getError());
            } catch (\Stripe\Exception\InvalidRequestException $e) {
              // Invalid parameters were supplied to Stripe's API
                return array("status"=>"0","message"=>$e->getError());
            } catch (\Stripe\Exception\AuthenticationException $e) {
              // Authentication with Stripe's API failed
              // (maybe you changed API keys recently)
                return array("status"=>"0","message"=>$e->getError());
            } catch (\Stripe\Exception\ApiConnectionException $e) {
              // Network communication with Stripe failed
                return array("status"=>"0","message"=>$e->getError());
            } catch (\Stripe\Exception\ApiErrorException $e) {
              // Display a very generic error to the user, and maybe send
              // yourself an email
                return array("status"=>"0","message"=>$e->getError());
            } catch (Exception $e) {
              // Something else happened, completely unrelated to Stripe
                return array("status"=>"0","message"=>$e->getError());
            }
        print_r($balance->available[0]->amount);exit();
        $bankToken = \Stripe\Token::create([
            'bank_account' => [
                'country' => 'US',
                'currency' => 'USD',
                'account_holder_name' => 'Soura Sankar',
                'account_holder_type' => 'individual',
                'routing_number' => '110000000',
                'account_number' => '000123456789'
            ]
        ]);
        $user = \Stripe\Account::create(array(
            "type" => "custom",
            "country" => "US",
            "email" => 'sona@whatmail.com',
            "requested_capabilities" => [ "transfers" ],
            "business_profile" => [
                "url" => "http://gh.com",
            ],
            "business_type" => "individual",
            "individual" => [
                'first_name' => "Sona", 
                'last_name' => "Roy",
                'dob' => [
                        'day'   =>  '31',
                        'month' =>  '03',
                        'year'  =>  '1995',
                    ],
                    'ssn_last_4'    =>  '0000',
                ],
            'tos_acceptance' => [
                "date" => time(),
                "ip" => $_SERVER['REMOTE_ADDR'],
            ],
          ));
        // $account = 'acct_1H0kPQAl6cwQNV1K';
        // $btoken = 'btok_1H0kQVAN0tpklIrfvRV2eE8g';
        $bankAccount = \Stripe\Account::createExternalAccount(
                  $user->id,['external_account' => $bankToken->id]
                );
        $stripeAccountObj1 = \Stripe\Account::retrieve($user->id);
        // $transfer = \Stripe\Transfer::create([
        //                 'amount' => 100,
        //                 'currency' => 'usd',
        //                 'destination' => 'acct_1H0kPQAl6cwQNV1K',
        //                 // 'statement_descriptor' => 'Transfer from Managed Account Stripe balance to Managed Account Bank Account',
        //                 'transfer_group' => 'ORDER_95',
        //                 // "source_type" => "bank_account",
        //             ]);
        print_r($stripeAccountObj1);exit();
        // $account = \Stripe\Account::create([
        //   'country' => 'US',
        //   'type' => 'custom',
        //   'requested_capabilities' => ['transfers'],
        //   'email' => 'sohani@whatmail.com',
        // ]);
        // print_r($account);exit();
        // $stripeAccountObj = \Stripe\Account::retrieve('acct_1H0hU1IRLTRFVEnZ');
        // $stripeAccountObj->business_type=
        // print_r($stripeAccountObj);exit();
        // $account_values = [
        //     'external_account' => [
        //             'object' => 'bank_account',
        //             'country' => "CA",
        //             'currency' => "CAD",
        //             'account_holder_name' => "TEST",
        //             'account_holder_type' => "individual",
        //             'routing_number' => '110000000',
        //             'account_number' => '000123456789',
        //         ],
        //     // 'business_url' => 'http://gh.com',
        //     'business_type' => 'individual',
        //     'individual' => [
        //             'first_name' => 'Sohani',
        //             'last_name' =>  'Roy',
        //             'dob' => [
        //                 'day'   =>  '31',
        //                 'month' =>  '03',
        //                 'year'  =>  '1995',
        //             ],
        //             'ssn_last_4'    =>  '0000',
        //         ],
        //     'tos_acceptance' => [
        //         "date" => "1593749941",
        //         "ip" => "127.0.0.1",
        //     ],
        // ];
        // $resAccount = \Stripe\Account::update('acct_1H0hU1IRLTRFVEnZ', $account_values);
        // print_r($resAccount);exit();
        // $stripeAccountId = 'acct_1GwiwkKtvu5b7e3Y';
        // $stripeAccountObj = \Stripe\Account::retrieve('acct_1H05ekFkN0cYZISM');
        // print_r($stripeAccountObj);exit();
        // create bank token
          // $bankToken = \Stripe\Token::create([
          //       'bank_account' => [
          //           'country' => 'US',
          //           'currency' => 'USD',
          //           'account_holder_name' => 'Soura Sankar',
          //           'account_holder_type' => 'individual',
          //           'routing_number' => '110000000',
          //           'account_number' => '000123456789'
          //       ]
          //   ]);
          // print_r($bankToken->bank_account->id);exit();
            // $externalAccount = \Stripe\Account::createExternalAccount(
            //   'acct_1DyTwUAN0tpklIrf',
            //   [
            //     'external_account' => $bankToken->id,
            //   ]
            // );
            // $payout = \Stripe\Payout::create([
            //     'amount' => 1,
            //     'currency' => 'usd',
            //     'description'   =>  'Manual Money Transfer',
            //     'destination' =>  $bankToken->bank_account->id,
            // ]);
        //     $transfer = \Stripe\Transfer::create([
        //                 'amount' => 1,
        //                 'currency' => 'usd',
        //                 'destination' => 'ba_1H0PymAN0tpklIrf3xRwe7cM',
        //                 'statement_descriptor' => 'Transfer from Managed Account Stripe balance to Managed Account Bank Account',
        //                 // 'transfer_group' => 'ORDER_95',
        //                 // "source_type" => "bank_account",
        //             ]);
        //   $balance = \Stripe\Balance::retrieve();
        //   print_r($transfer);exit();
        // if (count($stripeAccountObj->verification->fields_needed) == 0) {
        //    // print_r('You are all setup!');exit();
        //     // die('You are all setup!');
        //     $transfer = \Stripe\Transfer::create([
        //                 'amount' => 1,
        //                 'currency' => 'usd',
        //                 'destination' => $stripeAccountObj->id,
        //                 'transfer_group' => 'ORDER_95',
        //                 "source_type" => "bank_account",
        //             ]);
        //     // $payout = \Stripe\Payout::create([
        //     //     'amount' => 1,
        //     //     'currency' => 'usd',
        //     //     'description'   =>  'Manual Money Transfer',
        //     //     'destination' =>  $stripeAccountObj->external_accounts->data[0]->id,
        //     // ]);
        //     print_r($transfer);exit();
        //   } else {
        //     // $neededCode = $stripeAccountObj->verification->fields_needed[0];
        //     //date of birth update
        //     $stripeAccountObj->legal_entity->dob->year = '1992';
        //     $stripeAccountObj->legal_entity->dob->month = '09';
        //     $stripeAccountObj->legal_entity->dob->day = '09';
        //     // name && type update
        //     $stripeAccountObj->legal_entity->first_name = 'Taniya';
        //     $stripeAccountObj->legal_entity->last_name = 'Roy';
        //     $stripeAccountObj->legal_entity->type = 'individual';
        //     $stripeAccountObj->legal_entity->ssn_last_4 = '0000';
        //     // $stripeAccountObj->legal_entity->personal_id_number = '000000000';
        //     // Accept the TOS
        //     $stripeAccountObj->tos_acceptance->date = time();
        //     $stripeAccountObj->tos_acceptance->ip = $_SERVER['REMOTE_ADDR'];
        //     // address update
        //     $stripeAccountObj->legal_entity->address->line1 = '777 Brockton Avenue';
        //       $stripeAccountObj->legal_entity->address->city = 'Austin';
        //       $stripeAccountObj->legal_entity->address->state = 'Texas';
        //       $stripeAccountObj->legal_entity->address->country = 'US';
        //       $stripeAccountObj->legal_entity->address->postal_code = '2351';
        //     // verification document update


        //     // bank account update
        //     // $bank_account_id = '';
        //       $stripeAccountObj->save();
        //       $bankAccount = \Stripe\Account::createExternalAccount(
        //           $stripeAccountObj->id,['external_account' => $bankToken->id]
        //         );

        //     // print_r("expression");exit();
        //   }
        //   $stripeAccountObj = \Stripe\Account::retrieve('acct_1H05ekFkN0cYZISM');
          
        // print_r($stripeAccountObj);exit();
    }    

    public function createCustomerWithCard(Request $request)
    {
        $stripe_token=$request->input('stripe_token');
        \Stripe\Stripe::setApiKey('sk_test_Yv7FS47rsRwlCOriOGGzlQgY00P8WQutTw');
        $customer = \Stripe\Customer::create(array(
            "email" =>'salam@singind.com',
            // "source" =>$stripe_token,
            //'plan'     => "monthly_recurring_setupfee"
        ));

        print_r($customer);exit;
    }
    public function createChargesWithSameCustomer(Request $request)
    {
        $stripe_token=$request->input('stripe_token');//give token or card id
        $customerId=$request->input('customerId');
        \Stripe\Stripe::setApiKey('sk_test_Yv7FS47rsRwlCOriOGGzlQgY00P8WQutTw');
        $charge = \Stripe\Charge::create ( array (
            "amount" => 10 * 100,
            "currency" => 'usd',
            "source" => $stripe_token, // obtained with Stripe.js
            "description" => 'for testing multiple card',
            "customer" => $customerId
        ));
        print_r($charge);exit;
    }
    public function createCardWithSameCustomer(Request $request)
    {
        $stripe_token=$request->input('stripe_token');
        $customerId=$request->input('customerId');
        \Stripe\Stripe::setApiKey('sk_test_Yv7FS47rsRwlCOriOGGzlQgY00P8WQutTw');
        $card = \Stripe\Customer::createSource(
          $customerId,
          [
            'source' => $stripe_token,
          ]
        );
        print_r($card);exit;
    }
    public function customerCardList()
    {
        // \Stripe\Stripe::setApiKey ($secret_key);
        
        \Stripe\Stripe::setApiKey('sk_test_Yv7FS47rsRwlCOriOGGzlQgY00P8WQutTw');
        $customer = \Stripe\Customer::retrieve('cus_FL0SqkvihFYm6y');
        // $o = \Stripe\Stripe_Customer::retrieve('cus_FL0SqkvihFYm6y');

        // $card_on_file = $customer->sources->all(array(
        //     // 'email'=>3,
        //     'object' => 'card'
        // ));

        // $card_on_file_array = json_decode($card_on_file);
        
        print_r($customer);exit;
    }
    public function getCustomerByEmail(Request $request)
    {
        $email=$request->input('email');
        \Stripe\Stripe::setApiKey('sk_test_Yv7FS47rsRwlCOriOGGzlQgY00P8WQutTw');
        \Stripe\Customer::create([
          "description" => "Customer for jenny.rosen@example.com",
          // "source" => "tok_amex" // obtained with Stripe.js
        ]);
        $customer =  \Stripe\Customer::all(["email" => $email]);
        print_r($customer);exit;
    }







    
    public function customerCardDetailsByEmail(Request $request)
    {
        $email=$request->input('email');
        $stripeModel = new stripeModel();
        $secret_key = $stripeModel->getSecretKey();
        \Stripe\Stripe::setApiKey ($secret_key);
        $customer =  \Stripe\Customer::all(["email" => $email]);
        // print_r($customer->data);exit();
        
        // print_r($customer->data);exit();
        if(!empty($customer->data))
        {
            // for ($i=0; $i <count($customer->data) ; $i++) { 
                # code...
                $data[0]['customer_id'] = $customer->data[0]->id;
                if($customer->data[0]->default_source == '')
                    $data[0]['default_source'] = "";
                else
                    $data[0]['default_source'] = $customer->data[0]->default_source;
                $data[0]['card_details'] = $this->getCardDetails($customer->data[0]->sources->data);
            // }
            $success = array("status"=>"1","message"=>"successful","value"=>$data);
        }
        else
        {
            $success = array("status"=>"0","message"=>"Customer not available");
        }
        return $success;
    }
    public function getCardDetails($sources)
    {
        if(!empty($sources))
        {
            for ($j=0; $j <count($sources) ; $j++) { 
                # code...
                $result[$j]['card_id'] = $sources[$j]->id;
                $result[$j]['card_last4digit'] = $sources[$j]->last4;
                $result[$j]['exp_year'] = $sources[$j]->exp_year;
                $result[$j]['exp_month'] = $sources[$j]->exp_month;
                $result[$j]['brand'] = $sources[$j]->brand;
            }
        }
        else
        {
            $result = array();
        }
        return $result;
        
    }
    public function getUserWalletBalance(Request $request)
    {
        $user_id=$request->input('user_id');
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($user_id=='')
            return array("status"=>"0","message"=>"Please give user id");
        else
        {
            $default = new defaultModel();
            $seller_check_token=$default->seller_check_with_token($user_id,$header);
            // print_r($seller_check_token);exit;
            if($seller_check_token=="unavailable")
                return array("status"=>"0","message"=>"User doesn't Exists");
            else if($seller_check_token=="unauthorized")
                return array("status"=>"0","message"=>"Unauthorized User");
            else if($seller_check_token[0]=="checked")
            {
                $data = array("user_wallet"=>$seller_check_token[1][0]->user_wallet,"virtual_user_wallet"=>$seller_check_token[1][0]->virtual_user_wallet);
                return array("status"=>"1","message"=>"Success","value"=>$data);
            }

        }
    }
    public function getPublishkey()
    {
        $stripeModel = new stripeModel();
        // $secret_key = $stripeModel->getSecretKey();
        $publish_key = $stripeModel->getPublishKey();
        return array("status"=>"1","message"=>"Success","value"=>$publish_key);
    }
    public function sendRentRequest(Request $request)
    {
        $user_id=$request->input('user_id');
        $seller_id=$request->input('seller_id');
        $product_id=$request->input('product_id');
        $rent_from=$request->input('rent_from');
        $rent_to=$request->input('rent_to');
        $payment_method_id=$request->input('payment_method_id');
        $payment_message=$request->input('payment_message');
        // print_r($seller_id);exit();
        // $customer_id=$request->input('customer_id');
        // $card_id=$request->input('card_id');
        // $card_no=$request->input('card_no');
        // $card_date=$request->input('card_date');
        // $cvc=$request->input('cvc');
        // $payment_type=$request->input('payment_type');//must send from front end
        // $card_amount=$request->input('card_amount');//must send from front end
        // $wallet_amount=$request->input('wallet_amount');//must send from front end
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($user_id=='')
            return array("status"=>"0","message"=>"Please give user id");
        else if($product_id=='')
            return array("status"=>"0","message"=>"Please give product id");
        else if($rent_from=='')
            return array("status"=>"0","message"=>"Please give rent from date");
        else if($rent_to=='')
            return array("status"=>"0","message"=>"Please give rent to date");
        else if($payment_method_id=='')
            return array("status"=>"0","message"=>"Please give Payment Method id");
        // else if($card_no=='')
        //     return array("status"=>"0","message"=>"Please give card no.");
        // else if($card_date=='')
        //     return array("status"=>"0","message"=>"Please give card date");
        // else if($cvc=='')
        //     return array("status"=>"0","message"=>"Please give cvc");
        else
        {
            $stripeModel = new stripeModel();
            $default = new defaultModel();
            $seller_check_token=$default->seller_check_with_token($user_id,$header);
            // print_r($seller_check_token);exit;
            if($seller_check_token=="unavailable")
                return array("status"=>"0","message"=>"User doesn't Exists");
            else if($seller_check_token=="unauthorized")
                return array("status"=>"0","message"=>"Unauthorized User");
            else if($seller_check_token[1][0]->status=="I")
                return array("status"=>"0","message"=>"Unable to take rent because user is inactivate from Admin side");
            else if($seller_check_token[0]=="checked")
            {
                $request_data =$stripeModel->getRequestByDate($user_id,$product_id,$rent_from,$rent_to);
                if(!empty($request_data))
                {
                    return array("status"=>"0","message"=>"Already send a request");
                }
                else
                {
                    $rent_status = 'P';//if P then Pending your request
                    $customer_id = '';
                    $card_id = '';
                    
                    $payment_type = '';
                    $card_amount = '';
                    $wallet_amount = '';
                    $sendRentRequest=$stripeModel->sendRentRequest($seller_id,$user_id,$product_id,$rent_from,$rent_to,$customer_id,$card_id,$rent_status,$payment_type,$card_amount,$wallet_amount,$payment_method_id,$payment_message);
                        return $sendRentRequest;
                }
                
            }
        }
    }
    public function sendRentRequest_OLD(Request $request)
    {
        $user_id=$request->input('user_id');
        $seller_id=$request->input('seller_id');
        $product_id=$request->input('product_id');
        $rent_from=$request->input('rent_from');
        $rent_to=$request->input('rent_to');
        $customer_id=$request->input('customer_id');
        $card_id=$request->input('card_id');
        // $card_no=$request->input('card_no');
        // $card_date=$request->input('card_date');
        // $cvc=$request->input('cvc');
        $payment_type=$request->input('payment_type');//must send from front end
        $card_amount=$request->input('card_amount');//must send from front end
        $wallet_amount=$request->input('wallet_amount');//must send from front end
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($user_id=='')
            return array("status"=>"0","message"=>"Please give user id");
        else if($product_id=='')
            return array("status"=>"0","message"=>"Please give product id");
        else if($rent_from=='')
            return array("status"=>"0","message"=>"Please give rent from date");
        else if($rent_to=='')
            return array("status"=>"0","message"=>"Please give rent to date");
        // else if($card_no=='')
        //     return array("status"=>"0","message"=>"Please give card no.");
        // else if($card_date=='')
        //     return array("status"=>"0","message"=>"Please give card date");
        // else if($cvc=='')
        //     return array("status"=>"0","message"=>"Please give cvc");
        else
        {
            $stripeModel = new stripeModel();
            $default = new defaultModel();
            $seller_check_token=$default->seller_check_with_token($user_id,$header);
            // print_r($seller_check_token);exit;
            if($seller_check_token=="unavailable")
                return array("status"=>"0","message"=>"User doesn't Exists");
            else if($seller_check_token=="unauthorized")
                return array("status"=>"0","message"=>"Unauthorized User");
            else if($seller_check_token[1][0]->status=="I")
                return array("status"=>"0","message"=>"Unable to take rent because user is inactivate from Admin side");
            else if($seller_check_token[0]=="checked")
            {
                if($default->checkProductBlock($product_id))
                    return array("status"=>"0","message"=>"Unable to take rent because product is blocked from Admin side");               
                else
                {
                    if($customer_id == '' && $card_id == '')
                    {
                        $customer_id = "0";$card_id = "0";
                    }
                    $rent_status = 'P';//if P then Pending your request
                    $original_amount = $card_amount + $wallet_amount;
                    if($wallet_amount!=0)
                    {
                        $userVirtualWallet = $seller_check_token[1][0]->virtual_user_wallet;
                        $newVirtualWalletBal = $userVirtualWallet - $original_amount;
                        $walletUpdate=$stripeModel->virtualWalletUpdate($user_id,$newVirtualWalletBal);
                    }
                    
                    $sendRentRequest=$stripeModel->sendRentRequest($seller_id,$user_id,$product_id,$rent_from,$rent_to,$customer_id,$card_id,$rent_status,$payment_type,$card_amount,$wallet_amount);
                    return $sendRentRequest;
                }
            }
        }
    }
    public function rentRequestList(Request $request)
    {
        $seller_id=$request->input('seller_id');
        $product_id=$request->input('product_id');
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($seller_id=='')
            return array("status"=>"0","message"=>"Please give seller id");
        else if($product_id=='')
            return array("status"=>"0","message"=>"Please give product id");
        else
        {
            $stripeModel = new stripeModel();
            $default = new defaultModel();
            $seller_check_token=$default->seller_check_with_token($seller_id,$header);
            // print_r($seller_check_token);exit;
            if($seller_check_token=="unavailable")
                return array("status"=>"0","message"=>"User doesn't Exists");
            else if($seller_check_token=="unauthorized")
                return array("status"=>"0","message"=>"Unauthorized User");
            else if($seller_check_token[0]=="checked")
            {
                // print_r($seller_check_token[1][0]->id);exit;
                $data=$stripeModel->rentRequestList($seller_check_token[1][0]->status,$seller_id,$product_id);
                return $data;
                // if(!empty($data))
                // {
                //     // print_r($data);exit;
                //     return array("status"=>"1","user_status"=>$seller_check_token[1]->status,"message"=>"Success","value"=>$data[0]);
                // }
                // else
                // {
                //     return array("status"=>"0","message"=>"RequestList not available");;
                // }
                
            }
        }
    }
    public function rentBookingStatus(Request $request)
    {
        $request_id=$request->input('request_id');
        // $seller_id=$request->input('seller_id');
        $user_id=$request->input('user_id');
        $product_id=$request->input('product_id');
        $wallet_amount=$request->input('wallet_amount');
        $accept_status=$request->input('accept_status');//if R then Owner reject the request, if C then user cancel his/her product rent request
        // $header=$request->header('Auth');
        // if($header=='')
        //     return array("status"=>"0","message"=>"Please give Auth Token");
        // else if($seller_id=='')
        //     return array("status"=>"0","message"=>"Please give seller id");
        if($user_id == '')
            return array("status"=>"0","message"=>"Please give user id");
        else if($product_id=='')
            return array("status"=>"0","message"=>"Please give product id");
        else if($accept_status=='')
            return array("status"=>"0","message"=>"Please give accept or reject status");
        else
        {
            $stripeModel = new stripeModel();
            $default = new defaultModel();
            // $seller_check_token=$default->seller_check_with_token($seller_id,$header);
            // // print_r($seller_check_token);exit;
            // if($seller_check_token=="unavailable")
            //     return array("status"=>"0","message"=>"User doesn't Exists");
            // else if($seller_check_token=="unauthorized")
            //     return array("status"=>"0","message"=>"Unauthorized User");
            // else if($seller_check_token[0]=="checked")
            // {
            // $userData = $default->getUserDetails($user_id);
            // // print_r($userData);exit();
            // if($wallet_amount!=0)
            // {
            //     $virtualWallet = $userData[0]->virtual_user_wallet + $wallet_amount;
            //     // print_r($virtualWallet);exit();
            //     $walletUpdate=$stripeModel->virtualWalletUpdate($user_id,$virtualWallet);
            // }
            
                $data=$stripeModel->rentBookingStatus($request_id,$user_id,$product_id,$accept_status,$wallet_amount);
                return $data;
            // }
        }
    }
    public function setupIntentForCustomer()
    {
        $user_id = request()->get('user_id');
        if($user_id=='')
        {
            return array("status"=>"0","message"=>"Missing user_id");
        }
        else
        {
            $stripeModel = new stripeModel();
            $defaultModel = new defaultModel();
            $user_data = $defaultModel->getUserDetails($user_id);
            if(!empty($user_data))
            {
                // print_r($request_data);exit();
                if($user_data[0]->customerid==null || $user_data[0]->customerid=='')
                {
                    return array("status"=>"0","message"=>"customerid not available for this user. check again");
                }
                else
                {
                    $secret_key = $stripeModel->getSecretKey();
                    \Stripe\Stripe::setApiKey ($secret_key);
                    try{
                        $intent = \Stripe\SetupIntent::create([
                          'customer' => $user_data[0]->customerid,                      
                        ]);
                        return array("status"=>"1","message"=>"Successful","value"=>$intent->client_secret);
                    } catch (\Stripe\Exception\CardException $e) {
                        // Since it's a decline, \Stripe\Exception\CardException will be caught
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (\Stripe\Exception\RateLimitException $e) {
                      // Too many requests made to the API too quickly
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (\Stripe\Exception\InvalidRequestException $e) {
                      // Invalid parameters were supplied to Stripe's API
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (\Stripe\Exception\AuthenticationException $e) {
                      // Authentication with Stripe's API failed
                      // (maybe you changed API keys recently)
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (\Stripe\Exception\ApiConnectionException $e) {
                      // Network communication with Stripe failed
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (\Stripe\Exception\ApiErrorException $e) {
                      // Display a very generic error to the user, and maybe send
                      // yourself an email
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (Exception $e) {
                      // Something else happened, completely unrelated to Stripe
                        return array("status"=>"0","message"=>$e->getError());
                    }

                    // $setup_intent = \Stripe\SetupIntent::create([
                    //   'customer' => $user_data[0]->customerid
                    // ]);
                    // $client_secret = $setup_intent->client_secret;
                    // Pass the client secret to the client
                    
                }
            }
            else
                return array("status"=>"0","message"=>"User Not Exists");
        }
    }
    public function generatePaymentIntent()
    {
        $product_id = request()->get('product_id');
        $request_id = request()->get('request_id');
        $user_id = request()->get('user_id');
        if($product_id=='' || $request_id=='' || $user_id=='')
        {
            return array("status"=>"0","message"=>"Missing product_id OR request_id OR user_id");
        }
        else
        {
            $stripeModel = new stripeModel();
            $defaultModel = new defaultModel();
            $product_data = $stripeModel->getProductData($product_id);
            $request_data = $stripeModel->getRentRequestData($request_id);
            $user_data = $defaultModel->getUserDetails($user_id);
            if((!empty($product_data)) && (!empty($request_data)) && (!empty($user_data)))
            {
                // print_r($request_data);exit();
                if($user_data[0]->customerid==null || $user_data=='')
                {
                    return array("status"=>"0","message"=>"customerid not available for this user. check again");
                }
                else
                {
                    $product_price = $product_data->price;
                    $product_delivery_charge = $product_data->delivery_charge;
                    $product_security_money = $product_data->security_money;
                    if($product_delivery_charge=='' || $product_delivery_charge==null)
                    {
                        $product_delivery_charge = 0;
                        
                    }
                    else if($product_security_money=='')
                    {
                       $product_security_money = 0; 
                    }
                    $request_from_date = $request_data->rent_from;
                    $request_to_date = $request_data->rent_to;
                    // Calulating the difference in timestamps 
                    $diff = strtotime($request_to_date) - strtotime($request_from_date); 
                      
                    // 1 day = 24 hours 
                    // 24 * 60 * 60 = 86400 seconds 
                    $total_days = (abs(round($diff / 86400)) + 1);
                    
                    $total_amount = (($product_price * $total_days) + ($product_delivery_charge + $product_security_money));
                    $total_amount = $total_amount * 100;
                    // print_r($total_amount);exit();
                    $secret_key = $stripeModel->getSecretKey();
                    \Stripe\Stripe::setApiKey ($secret_key);
                    try {
                        $intent = \Stripe\PaymentIntent::create([
                          'amount' => $total_amount,
                          'currency' => 'usd',
                          'payment_method_types' => ['card'],
                          'customer' => $user_data[0]->customerid,
                          'description' => 'Send Booking Request',
                          
                        ]);
                        $data = array('client_secret'=>$intent->client_secret);
                        // print_r($client_secret);
                        return array("status"=>"1","message"=>"Success","value"=>$data);
                    } catch (\Stripe\Exception\CardException $e) {
                        // Since it's a decline, \Stripe\Exception\CardException will be caught
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (\Stripe\Exception\RateLimitException $e) {
                      // Too many requests made to the API too quickly
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (\Stripe\Exception\InvalidRequestException $e) {
                      // Invalid parameters were supplied to Stripe's API
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (\Stripe\Exception\AuthenticationException $e) {
                      // Authentication with Stripe's API failed
                      // (maybe you changed API keys recently)
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (\Stripe\Exception\ApiConnectionException $e) {
                      // Network communication with Stripe failed
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (\Stripe\Exception\ApiErrorException $e) {
                      // Display a very generic error to the user, and maybe send
                      // yourself an email
                        return array("status"=>"0","message"=>$e->getError());
                    } catch (Exception $e) {
                      // Something else happened, completely unrelated to Stripe
                        return array("status"=>"0","message"=>$e->getError());
                    }
                    
                    // $payment_method_create = \Stripe\PaymentMethod::create([
                    //   'type' => 'card',
                    //   'card' => [
                    //     'number' => '4242424242424242',
                    //     'exp_month' => 04,
                    //     'exp_year' => 2022,
                    //     'cvc' => '123',
                    //   ],
                    // ]);
                    // print_r($payment_method_create);exit();
                    // $payment_method = \Stripe\PaymentMethod::retrieve('{{PAYMENT_METHOD_ID}}');
                    // print_r($intent);exit();
                    // $client_secret = $intent->client_secret;
                    
                }
                

            }
            else
            {
                return array("status"=>"0","message"=>"Product && Request not available");
            }
        }
        
    }
    public function productDamageConfirmation(Request $request)
    {
        $request_id=$request->input('request_id');
        $seller_id=$request->input('seller_id');
        $product_id=$request->input('product_id');
        $description = $request->input('description');
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($request_id=='' || $seller_id=='' || $product_id=='')
        {
            return array("status"=>"0","message"=>"Provide required information");
        }
        else
        {
            $stripeModel = new stripeModel();
            $defaultModel = new defaultModel();
            $seller_data = $defaultModel->getUserDetails($seller_id);
            if(!empty($seller_data))
            {
                if($seller_data[0]->api_key!=$header)
                {
                    return array("status"=>"0","message"=>"Unauthorized user");
                }
                else
                {
                    $request_data = $stripeModel->getRentRequestData($request_id);
                    if($request_data->rent_status == 'D')   // This request has an order
                    {
                        $result = $stripeModel->productDamageConfirmation($request_id,$seller_id,$product_id,$description);
                        return $result;
                    }
                    else
                    {
                        return array("status"=>"0","message"=>"This request not accepted, so you can't be report damaged to this product request");
                    }
                }
            }
            else
            {
                return array("status"=>"0","message"=>"Seller Not exist");
            }
        }
    }
    public function transferToSellerAfterAccept(Request $request)
    {
        $request_id=$request->input('request_id');
        $order_id=$request->input('order_id');
        $seller_id=$request->input('seller_id');
        $product_id=$request->input('product_id');
        if($order_id=='' || $request_id=='' || $seller_id=='' || $product_id=='')
        {
            return array("status"=>"0","message"=>"Provide required information");
        }
        else
        {
            $stripeModel = new stripeModel();
            $secret_key = $stripeModel->getSecretKey();
            \Stripe\Stripe::setApiKey ($secret_key);
            \Stripe\Stripe::setApiVersion("2020-03-02");
            try
            {
                $balance = \Stripe\Balance::retrieve();
                $stripe_balance = $balance->available[0]->amount; // client account balance
                $defaultModel = new defaultModel();
                $seller_data = $defaultModel->getUserDetails($seller_id);
                if($seller_data[0]->accountid=='' || $seller_data[0]->accountid == NULL)
                {
                    return array("status"=>"0","message"=>"Customer's account not available for transfer");
                } 
                else
                {
                    $product_data = $stripeModel->getProductData($product_id);
                    $request_data = $stripeModel->getRentRequestData($request_id);
                    $product_price = $product_data->price;
                    $request_from_date = $request_data->rent_from;
                    $request_to_date = $request_data->rent_to;
                    print_r($product_data);exit();
                    // Calulating the difference in timestamps 
                    $diff = strtotime($request_to_date) - strtotime($request_from_date); 
                      
                    // 1 day = 24 hours 
                    // 24 * 60 * 60 = 86400 seconds 
                    $total_days = (abs(round($diff / 86400)) + 1);
                    $seller_amount = ($product_price * $total_days);
                    if($stripe_balance < $seller_amount) // for insufficient balance
                    {
                        $stripeModel->transactionFailedStatusChange($order_id,$seller_amount);
                        $admin_data = $defaultModel->getAdminMailId();
                        // $admin_email = $admin_data[0]->value;
                        $subject = "Stripe Insufficient Balance";
                        $body = "Balance insufficient to your stripe account. Please add balance for successfull payout system.";
                        $defaultModel->sendingMailToUser($admin_data[0]->value,$subject,$body);
                        return array("status"=>"0","message"=>"Insufficient Balance in stripe for transfer");
                    }
                    else
                    {
                        try {
                            $transfer = \Stripe\Transfer::create([
                                'amount' => $seller_amount * 100,
                                'currency' => 'usd',
                                'destination' => $seller_data[0]->accountid,
                                // 'statement_descriptor' => 'Transfer from Managed Account Stripe balance to Managed Account Bank Account',
                                // "source_type" => "bank_account",
                            ]);
                            $sllr_amt = $seller_amount;
                            $stripeModel->addTransaction($transfer->id,$seller_id,$sllr_amt,'usd','Transfer Money to seller','Succeed','debit');
                          return array("status"=>"1","message"=>"Success");
                        } catch (\Stripe\Exception\CardException $e) {
                            // Since it's a decline, \Stripe\Exception\CardException will be caught
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (\Stripe\Exception\RateLimitException $e) {
                          // Too many requests made to the API too quickly
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (\Stripe\Exception\InvalidRequestException $e) {
                          // Invalid parameters were supplied to Stripe's API
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (\Stripe\Exception\AuthenticationException $e) {
                          // Authentication with Stripe's API failed
                          // (maybe you changed API keys recently)
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (\Stripe\Exception\ApiConnectionException $e) {
                          // Network communication with Stripe failed
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (\Stripe\Exception\ApiErrorException $e) {
                          // Display a very generic error to the user, and maybe send
                          // yourself an email
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (Exception $e) {
                          // Something else happened, completely unrelated to Stripe
                            return array("status"=>"0","message"=>$e->getError());
                        }
                    }
                }
            } catch (\Stripe\Exception\CardException $e) {
                // Since it's a decline, \Stripe\Exception\CardException will be caught
                return array("status"=>"0","message"=>$e->getError());
            } catch (\Stripe\Exception\RateLimitException $e) {
              // Too many requests made to the API too quickly
                return array("status"=>"0","message"=>$e->getError());
            } catch (\Stripe\Exception\InvalidRequestException $e) {
              // Invalid parameters were supplied to Stripe's API
                return array("status"=>"0","message"=>$e->getError());
            } catch (\Stripe\Exception\AuthenticationException $e) {
              // Authentication with Stripe's API failed
              // (maybe you changed API keys recently)
                return array("status"=>"0","message"=>$e->getError());
            } catch (\Stripe\Exception\ApiConnectionException $e) {
              // Network communication with Stripe failed
                return array("status"=>"0","message"=>$e->getError());
            } catch (\Stripe\Exception\ApiErrorException $e) {
              // Display a very generic error to the user, and maybe send
              // yourself an email
                return array("status"=>"0","message"=>$e->getError());
            } catch (Exception $e) {
              // Something else happened, completely unrelated to Stripe
                return array("status"=>"0","message"=>$e->getError());
            }
        }
    }
    public function cancelProductBooking(Request $request)
    {
        // print_r("expression");exit();
        $order_id=$request->input('order_id');
        $seller_id=$request->input('seller_id');
        $user_id=$request->input('user_id');
        $product_id=$request->input('product_id');
        // $refund_status=$request->input('refund_status');// if A then owner Accept the request
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($seller_id=='')
            return array("status"=>"0","message"=>"Please give seller id");
        else if($user_id == '')
            return array("status"=>"0","message"=>"Please give user id");
        else if($product_id=='')
            return array("status"=>"0","message"=>"Please give product id");
        else
        {
            $stripeModel = new stripeModel();
            $defaultModel = new defaultModel();
            $user_data = $defaultModel->getUserDetails($user_id);
            if(!empty($user_data))
            {
                if($user_data[0]->api_key!=$header)
                {
                    return array("status"=>"0","message"=>"Unauthorized user");
                }
                else
                {
                    $order_data = $stripeModel->getOrderDataById($order_id);
                    $product_details = $stripeModel->getProductData($product_id);
                    if(!empty($order_data))
                    {
                        $secret_key = $stripeModel->getSecretKey();
                        \Stripe\Stripe::setApiKey ($secret_key);
                        \Stripe\Stripe::setApiVersion("2020-03-02");
                        try {
                            $amount = $order_data->amount;
                            $today_days = date('Y-m-d H:i:s', time());
                            $today = new \DateTime(date('Y-m-d H:i:s', time()));
                            // print_r($today);
                            // print_r($order_data->rent_from);
                            // exit();
                            
                            $rent_from = new \DateTime($order_data->rent_from);
                            $rent_to_date = new \DateTime($order_data->rent_to);
                            $total_rent_interval = $rent_from->diff($rent_to_date);
                            $total_rent_days = $total_rent_interval->format('%a');
                            $rent_from_days = $order_data->rent_from;
                            $rent_to = $order_data->rent_to;
                            $interval = $today->diff($rent_from);
                            $days = $interval->days;
                            $initial_refund_amount = ($product_details->price*$total_rent_days) + $product_details->security_money;
                            // print_r($interval->days);exit();
                            // $rent_to = $order_data->rent_to;
                            $subject = 'Order Cancel';
                            $notification_type = 'cancel_booking';
                            if($today_days>$rent_to)
                            {
                                return array("status"=>"0","message"=>"You are not be able to cancel this booking due to delivery date is exceeded");;
                            }
                            else if($today_days>$rent_from_days)
                            {
                                return array("status"=>"0","message"=>"You are not be able to cancel this booking due to booking date is exceeded");;
                            }
                            else if($days>14)
                            {
                                // 100% refund

                                $refund_data = \Stripe\Refund::create([
                                  'payment_intent' => $order_data->payment_intent_id,
                                  'amount'  =>  $initial_refund_amount*100,
                                ]);
                                $stripeModel->setOrderCancel($order_id);
                                $stripeModel->setRefundData($refund_data->id,$order_id,$refund_data->status,$order_data->user_id,$order_data->product_id,$initial_refund_amount,'100%');
                                // Notification send to Seller
                                $body = 'User has canceled his booking for '.$product_details->product_name;
                                $stripeModel->sendNotificationToSeller($order_data->p_owner_id,$product_id,$product_details->product_name,$notification_type,$subject,$body);
                                // Notification send to user
                                $body = 'You have successfully canceled your booking for '.$product_details->product_name;
                                $stripeModel->sendNotificationToSeller($order_data->user_id,$product_id,$product_details->product_name,$notification_type,$subject,$body);
                                return array("status"=>"1","message"=>"Booking canceled successfully");
                            }
                            else if($days>7)
                            {
                                // 50% refund
                                $refund_amount = (($initial_refund_amount*50)/100);
                                $refund_data = \Stripe\Refund::create([
                                  'payment_intent' => $order_data->payment_intent_id,
                                  'amount'  =>  $refund_amount*100,
                                ]);
                                $stripeModel->setOrderCancel($order_id);
                                $stripeModel->setRefundData($refund_data->id,$order_id,$refund_data->status,$order_data->user_id,$order_data->product_id,$refund_amount,'50%');
                                // Notification send to Seller
                                $body = 'User has canceled his booking for '.$product_details->product_name;
                                $stripeModel->sendNotificationToSeller($order_data->p_owner_id,$product_id,$product_details->product_name,$notification_type,$subject,$body);
                                // Notification send to user
                                $body = 'You have successfully canceled your booking for '.$product_details->product_name;
                                $stripeModel->sendNotificationToSeller($order_data->user_id,$product_id,$product_details->product_name,$notification_type,$subject,$body);
                                return array("status"=>"1","message"=>"Booking canceled successfully");
                            }
                            else if($days<7)
                            {
                                // No refund
                                $stripeModel->setOrderCancel($order_id);
                                // Notification send to Seller
                                $body = 'User has canceled his booking for '.$product_details->product_name;
                                $stripeModel->sendNotificationToSeller($order_data->p_owner_id,$product_id,$product_details->product_name,$notification_type,$subject,$body);
                                // Notification send to user
                                $body = 'You have successfully canceled your booking for '.$product_details->product_name;
                                $stripeModel->sendNotificationToSeller($order_data->user_id,$product_id,$product_details->product_name,$notification_type,$subject,$body);
                                return array("status"=>"1","message"=>"Booking canceled successfully");
                            }
                            
                        } catch (\Stripe\Exception\CardException $e) {
                        // Since it's a decline, \Stripe\Exception\CardException will be caught
                            $stripeModel->rentBookingStatus($request_id,$user_id,$product_id,'P','0');
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (\Stripe\Exception\RateLimitException $e) {
                          // Too many requests made to the API too quickly
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (\Stripe\Exception\InvalidRequestException $e) {
                          // Invalid parameters were supplied to Stripe's API
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (\Stripe\Exception\AuthenticationException $e) {
                          // Authentication with Stripe's API failed
                          // (maybe you changed API keys recently)
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (\Stripe\Exception\ApiConnectionException $e) {
                          // Network communication with Stripe failed
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (\Stripe\Exception\ApiErrorException $e) {
                          // Display a very generic error to the user, and maybe send
                          // yourself an email
                            return array("status"=>"0","message"=>$e->getError());
                        } catch (Exception $e) {
                          // Something else happened, completely unrelated to Stripe
                            return array("status"=>"0","message"=>$e->getError());
                        }
                    }
                    else
                    {
                        return array("status"=>"0","message"=>"This order not exist");
                    }
                }
            }
            else
            {
                return array("status"=>"0","message"=>"User not exist");
            }
        }
    }
    public function rentRequestAccept(Request $request)
    {
        $request_id=$request->input('request_id');
        $seller_id=$request->input('seller_id');
        $user_id=$request->input('user_id');
        $product_id=$request->input('product_id');
        $accept_status=$request->input('accept_status');// if A then owner Accept the request
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($seller_id=='')
            return array("status"=>"0","message"=>"Please give seller id");
        else if($user_id == '')
            return array("status"=>"0","message"=>"Please give user id");
        else if($product_id=='')
            return array("status"=>"0","message"=>"Please give product id");
        else if($accept_status=='')
            return array("status"=>"0","message"=>"Please give accept or reject status");
        else
        {
            $stripeModel = new stripeModel();
            $defaultModel = new defaultModel();
            $seller_data = $defaultModel->getUserDetails($seller_id);
            if(!empty($seller_data))
            {
                if($seller_data[0]->api_key!=$header)
                {
                    return array("status"=>"0","message"=>"Unauthorized user");
                }
                else if($seller_data[0]->accountid == '' || $seller_data[0]->accountid == NULL)
                {
                    return array("status"=>"0","message"=>"Customer's account not available for transfer");
                } 
                else
                {
                    $product_data = $stripeModel->getProductData($product_id);
                    $request_data = $stripeModel->getRentRequestData($request_id);
                    $user_data = $defaultModel->getUserDetails($user_id);
                    // print_r($product_data);exit();
                    if((!empty($product_data)) && (!empty($request_data)) && (!empty($user_data)))
                    {
                        $category_data = $stripeModel->getCategory($product_data->product_category);
                        // print_r($user_data);exit();
                        if($user_data[0]->customerid==null || $user_data=='' || (empty($category_data)))
                        {
                            return array("status"=>"0","message"=>"customerid && category not available for this user. check again");
                        }
                        else if($request_data->payment_method_id==null || $request_data->payment_method_id=='')
                        {
                            return array("status"=>"0","message"=>"payment_method_id not available for this user. check again");
                        }
                        else
                        {
                            $product_price = $product_data->price;
                            $product_security_money = $product_data->security_money;
                            if($product_security_money=='')
                            {
                               $product_security_money = 0; 
                            }
                            $request_from_date = $request_data->rent_from;
                            $request_to_date = $request_data->rent_to;
                            // Calulating the difference in timestamps 
                            $diff = strtotime($request_to_date) - strtotime($request_from_date); 
                              
                            // 1 day = 24 hours 
                            // 24 * 60 * 60 = 86400 seconds 
                            $total_days = (abs(round($diff / 86400)) + 1);
                            
                            $seller_amount = ($product_price * $total_days);
                            $total_amount = ($seller_amount + $product_security_money);
                            $total_amount_with_commission = ($total_amount + (($total_amount * $category_data->commission_charge) / 100));
                            $originalAmnt = $total_amount_with_commission;
                            $total_amount_with_commission = ($total_amount_with_commission * 100);
                            // print_r($total_amount);exit();
                            $secret_key = $stripeModel->getSecretKey();
                            \Stripe\Stripe::setApiKey ($secret_key);
                            \Stripe\Stripe::setApiVersion("2020-03-02");
                            try {
                                // print_r("expression");exit();
                              $paymentIntent = \Stripe\PaymentIntent::create([
                                'amount' => $total_amount_with_commission,
                                'description' => 'Rent Request Payment',
                                'currency' => 'usd',
                                'customer' => $user_data[0]->customerid,
                                'payment_method' => $request_data->payment_method_id,
                                'off_session' => true,
                                'confirm' => true,
                              ]);
                              // print_r($paymentIntent);exit();
                               // $dataAccept = $stripeModel->rentRequestAcceptUpdate($request_id,$accept_status,$product_id,$request_data->rent_from,$request_data->rent_to);
                              $succ = $stripeModel->rentRequestAccept($paymentIntent->id,$request_id,$seller_amount,$seller_id,$product_id,$user_id,$originalAmnt,$request_from_date,$request_to_date,$product_data->product_name);
                              $stripeModel->addTransaction($request_data->payment_method_id,$user_id,$originalAmnt,'usd','Rent Request Payment','Succeed','debit');
                            return $succ;

                            } catch (\Stripe\Exception\CardException $e) {
                            // Since it's a decline, \Stripe\Exception\CardException will be caught
                                $stripeModel->rentBookingStatus($request_id,$user_id,$product_id,'P','0');
                                return array("status"=>"0","message"=>$e->getError());
                            } catch (\Stripe\Exception\RateLimitException $e) {
                              // Too many requests made to the API too quickly
                                return array("status"=>"0","message"=>$e->getError());
                            } catch (\Stripe\Exception\InvalidRequestException $e) {
                              // Invalid parameters were supplied to Stripe's API
                                return array("status"=>"0","message"=>$e->getError());
                            } catch (\Stripe\Exception\AuthenticationException $e) {
                              // Authentication with Stripe's API failed
                              // (maybe you changed API keys recently)
                                return array("status"=>"0","message"=>$e->getError());
                            } catch (\Stripe\Exception\ApiConnectionException $e) {
                              // Network communication with Stripe failed
                                return array("status"=>"0","message"=>$e->getError());
                            } catch (\Stripe\Exception\ApiErrorException $e) {
                              // Display a very generic error to the user, and maybe send
                              // yourself an email
                                return array("status"=>"0","message"=>$e->getError());
                            } catch (Exception $e) {
                              // Something else happened, completely unrelated to Stripe
                                return array("status"=>"0","message"=>$e->getError());
                            }
                        }
                    }
                    else
                    {
                        return array("status"=>"0","message"=>"Product && Request not available");
                    }
                }
            }
            else
            {
                return array("status"=>"0","message"=>"Seller Not exist");
            }
        }
    }
    public function rentRequestAccept12(Request $request)
    {
        $request_id=$request->input('request_id');
        $seller_id=$request->input('seller_id');
        $user_id=$request->input('user_id');
        $product_id=$request->input('product_id');
        $accept_status=$request->input('accept_status');// if A then owner Accept the request
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($seller_id=='')
            return array("status"=>"0","message"=>"Please give seller id");
        else if($user_id == '')
            return array("status"=>"0","message"=>"Please give user id");
        else if($product_id=='')
            return array("status"=>"0","message"=>"Please give product id");
        else if($accept_status=='')
            return array("status"=>"0","message"=>"Please give accept or reject status");
        else
        {
            $stripeModel = new stripeModel();
            $defaultModel = new defaultModel();
            $seller_data = $defaultModel->getUserDetails($seller_id);
            if(!empty($seller_data))
            {
                if($seller_data[0]->api_key!=$header)
                {
                    return array("status"=>"0","message"=>"Unauthorized user");
                }
                else
                {
                    $product_data = $stripeModel->getProductData($product_id);
                    $request_data = $stripeModel->getRentRequestData($request_id);
                    $user_data = $defaultModel->getUserDetails($user_id);
                    if((!empty($product_data)) && (!empty($request_data)) && (!empty($user_data)))
                    {
                        // print_r($request_data);exit();
                        if($user_data[0]->customerid==null || $user_data=='')
                        {
                            return array("status"=>"0","message"=>"customerid not available for this user. check again");
                        }
                        else if($request_data->payment_method_id==null || $request_data->payment_method_id=='')
                        {
                            return array("status"=>"0","message"=>"payment_method_id not available for this user. check again");
                        }
                        else
                        {
                            $product_price = $product_data->price;
                            $product_delivery_charge = $product_data->delivery_charge;
                            $product_security_money = $product_data->security_money;
                            if($product_delivery_charge=='' || $product_delivery_charge==null)
                            {
                                $product_delivery_charge = 0;
                                
                            }
                            else if($product_security_money=='')
                            {
                               $product_security_money = 0; 
                            }
                            $request_from_date = $request_data->rent_from;
                            $request_to_date = $request_data->rent_to;
                            // Calulating the difference in timestamps 
                            $diff = strtotime($request_to_date) - strtotime($request_from_date); 
                              
                            // 1 day = 24 hours 
                            // 24 * 60 * 60 = 86400 seconds 
                            $total_days = (abs(round($diff / 86400)) + 1);
                            
                            $total_amount = (($product_price * $total_days) + ($product_delivery_charge + $product_security_money));
                            $originalAmnt = $total_amount;
                            $total_amount = $total_amount * 100;
                            // print_r($total_amount);exit();
                            $secret_key = $stripeModel->getSecretKey();
                            \Stripe\Stripe::setApiKey ($secret_key);

                            try {
                              $paymentIntent = \Stripe\PaymentIntent::create([
                                'amount' => $total_amount,
                                'description' => 'Rent Request Payment',
                                'currency' => 'usd',
                                'customer' => $user_data[0]->customerid,
                                'payment_method' => $request_data->payment_method_id,
                                'off_session' => true,
                                'confirm' => true,
                              ]);
                              // $dataAccept = $stripeModel->rentRequestAcceptUpdate($request_id,$accept_status,$product_id,$request_data->rent_from,$request_data->rent_to);
                              $stripeModel->rentRequestAccept($request_id,$product_data->product_category,$seller_id,$product_id,$user_id,$originalAmnt,$request_from_date,$request_to_date);
                              $stripeModel->addTransaction($request_data->payment_method_id,$user_id,$originalAmnt,'usd','Rent Request Payment','Succeed','debit');
                              return array("status"=>"1","message"=>"Success");
                            } catch (\Stripe\Exception\CardException $e) {
                              // Error code will be authentication_required if authentication is needed
                              // echo 'Error code is:' . $e->getError()->code;
                              // $payment_intent_id = $e->getError()->payment_intent->id;
                              // $payment_intent = \Stripe\PaymentIntent::retrieve($payment_intent_id)
                                $stripeModel->rentBookingStatus($request_id,$user_id,$product_id,'P','0');
                                return array("status"=>"0","message"=>$e->getError());
                            }
                            // $intent = \Stripe\PaymentIntent::create([
                            //   'amount' => $total_amount,
                            //   'currency' => 'usd',
                            //   'payment_method_types' => ['card'],
                            //   'customer' => $user_data[0]->customerid,
                            //   'description' => 'Send Booking Request',
                              
                            // ]);
                            // $dataAccept = $stripeModel->rentRequestAcceptUpdate($request_id,$accept_status,$product_id,$request_data->rent_from,$request_data->rent_to);
                            // $data = array('client_secret'=>$intent->client_secret);
                            // print_r($client_secret);
                            // return array("status"=>"1","message"=>"Success");
                        }
                    }
                    else
                    {
                        return array("status"=>"0","message"=>"Product && Request not available");
                    }
                }
            }
            else
            {
                return array("status"=>"0","message"=>"Seller Not exist");
            }
        }
    }
    public function paymentSuccess()
    {
        $request_id=request()->get('request_id');
        $amount=request()->get('amount');
        $seller_id=request()->get('seller_id');
        $status=request()->get('status');
        $description=request()->get('description');
        $currency=request()->get('currency');
        $transaction_id=request()->get('transaction_id');
        $category_id=request()->get('category_id');
        $header=request()->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($request_id=='')
            return array("status"=>"0","message"=>"Please give request id");
        else if($seller_id == '')
            return array("status"=>"0","message"=>"Please give seller id");
        else if($amount == '')
            return array("status"=>"0","message"=>"Please give amount");
        else if($status == '')
            return array("status"=>"0","message"=>"Please give status");
        else if($description == '')
            return array("status"=>"0","message"=>"Please give description");
        else if($currency == '')
            return array("status"=>"0","message"=>"Please give currency");
        else if($transaction_id == '')
            return array("status"=>"0","message"=>"Please give transaction id");
        else if($category_id == '')
            return array("status"=>"0","message"=>"Please give category id");
        $stripeModel = new stripeModel();
        $default = new defaultModel();
        $seller_check_token=$default->seller_check_with_token($seller_id,$header);
        // print_r($seller_check_token);exit;
        if($seller_check_token=="unavailable")
            return array("status"=>"0","message"=>"User doesn't Exists");
        else if($seller_check_token=="unauthorized")
            return array("status"=>"0","message"=>"Unauthorized User");
        else if($seller_check_token[0]=="checked")
        {
            $debit_credit_status='credit';
            $amount=($amount / 100);
            $stripeModel->addTransaction($transaction_id,$seller_id,$amount,$currency,$description,$status,$debit_credit_status);
            $request_data = $stripeModel->getRentRequestData($request_id);
            $data = $stripeModel->rentRequestAccept($request_id,$category_id,$request_data->seller_id,$request_data->product_id,$request_data->user_id,$amount,$request_data->rent_from,$request_data->rent_to);
            return $data;
        }
    }
    public function rentRequestAccept1(Request $request)
    {
        $request_id=$request->input('request_id');
        $customer_id=$request->input('customer_id');
        $seller_id=$request->input('seller_id');
        $user_id=$request->input('user_id');
        $product_id=$request->input('product_id');
        $accept_status=$request->input('accept_status');// if A then owner Accept the request
        $payment_type=$request->input('payment_type');
        $stripe_token=$request->input('card_id');//send card_id from front end
        $request_from=$request->input('request_from');
        $request_to=$request->input('request_to');

        // $original_amount=(double)($request->input('amount'));
        $currency=$request->input('currency');
        $description=$request->input('description');
        $product_category=($request->input('product_category'));
        $card_amount=(double)($request->input('card_amount'));
        $wallet_amount=(double)($request->input('wallet_amount'));
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($seller_id=='')
            return array("status"=>"0","message"=>"Please give seller id");
        else if($user_id == '')
            return array("status"=>"0","message"=>"Please give user id");
        else if($product_id=='')
            return array("status"=>"0","message"=>"Please give product id");
        else if($accept_status=='')
            return array("status"=>"0","message"=>"Please give accept or reject status");
        // else if($payment_type == 'card' || $payment_type == 'both')
        // {
        //     if($stripe_token=='')
        //         return array("status"=>"0","message"=>"Please give stripe token");
        //     else if($currency=='')
        //         return array("status"=>"0","message"=>"Please give currency");
        //     else if($description=='')
        //         return array("status"=>"0","message"=>"Please give description");
        // } 
        else
        {
            // print_r("expression");exit;
            $stripeModel = new stripeModel();
            $default = new defaultModel();
            $seller_check_token=$default->seller_check_with_token($seller_id,$header);
            // print_r($seller_check_token);exit;
            if($seller_check_token=="unavailable")
                return array("status"=>"0","message"=>"User doesn't Exists");
            else if($seller_check_token=="unauthorized")
                return array("status"=>"0","message"=>"Unauthorized User");
            else if($seller_check_token[0]=="checked")
            {
                $userData = $default->getUserDetails($user_id);
                // print_r("userData");exit;
                $email = $userData[0]->email;
                // print_r($email);exit;
                $debit_credit_status='credit';
                if($card_amount!=0)
                {
                    $secret_key = $stripeModel->getSecretKey();
                    \Stripe\Stripe::setApiKey ($secret_key);
                    // if($customer_id == '')
                    // {
                    //     $customer = \Stripe\Customer::create(array(
                    //         "email" =>$email,
                    //         "source" =>$stripe_token,
                    //         //'plan'     => "monthly_recurring_setupfee"
                    //     ));
                    //     // print_r($customer);die;
                    //     $charge = \Stripe\Charge::create ( array (
                    //             "amount" => $card_amount * 100,
                    //             "currency" => $currency,
                    //             // "source" => $stripe_token, // obtained with Stripe.js
                    //             "description" => $description,
                    //             "customer" => $customer->id
                    //     ));
                    // }
                    // else if($customer_id != '')
                    // {

                        $charge = \Stripe\Charge::create ( array (
                            "amount" => $card_amount * 100,
                            "currency" => $currency,
                            "source" => $stripe_token, // obtained with Stripe.js
                            "description" => $description,
                            "customer" => $customer_id
                        ));

                    // }
                    // $charge = (object) array("id"=>"inbuild charge for task testing","status"=>"success");
                    $stripeModel->addTransaction($charge->id,$user_id,$card_amount,$currency,$description,$charge->status,$debit_credit_status);
                }
                if($wallet_amount!=0)
                {
                    // print_r($wallet_amount);exit;
                    // print_r($userData[0]->user_wallet);exit;
                    $userWallet = $userData[0]->user_wallet - $wallet_amount;
                    // print_r($userWallet);exit;
                    $updateWallet = $stripeModel->updateUserWalletBallance($user_id,$userWallet);
                    if($updateWallet)
                    {
                        $date = date("M-d-Y H:i:s");
                        $charge_id='Wallet_'.$user_id."_".$date."_".$product_id;
                        $charge = (object) array("id"=>$charge_id,"status"=>"success");
                    }
                    else
                    {
                        return array("status"=>"0","message"=>"Some error happend!!Please try again");
                    }
                    $stripeModel->addTransaction($charge->id,$user_id,$wallet_amount,$currency,$description,$charge->status,$debit_credit_status);
                    
                }
                $original_amount = $card_amount + $wallet_amount;
                
                // $card = $charge->id;
                // print_r($charge);
                // print_r($charge->id);exit;
                if(!empty($charge))
                {
                    $data=$stripeModel->rentRequestAccept($request_id,$product_category,$seller_id,$product_id,$user_id,$accept_status,$original_amount,$request_from,$request_to);
                    return $data;
                }
                else
                    return array("status"=>"0","message"=>"Stripe failed to charge customer");
            }
        }
    }




    // public function takeRentFromCard(Request $request)
    // {
    //     // \Stripe\Stripe::setApiKey ( 'sk_test_xAsHc0yoCm8vYBlDPZhklZv0' );
    //     // $stripe_token=$request->input('stripe_token');
    //     // $charge = \Stripe\Charge::create ( array (
    //     //                 "amount" => 300 * 100,
    //     //                 "currency" => "usd",
    //     //                 "source" => $stripe_token, // obtained with Stripe.js
    //     //                 "description" => "Test payment." 
    //     //         ) );
    //     // return $charge;
        
    //     $seller_id=$request->input('seller_id');
    //     $user_id=$request->input('user_id');
    //     $product_id=$request->input('product_id');
    //     $token=$request->input('stripe_token');
    //     $original_amount=(double)($request->input('amount'));
    //     $currency=$request->input('currency');
    //     $description=$request->input('description');
    //     $header=$request->header('Auth');
    //     if($header=='')
    //         return array("status"=>"0","message"=>"Please give Auth Token");
    //     else if($seller_id=='')
    //         return array("status"=>"0","message"=>"Please give seller id");
    //     else if($user_id=='')
    //         return array("status"=>"0","message"=>"Please give user id");
    //     else if($product_id=='')
    //         return array("status"=>"0","message"=>"Please give product id");
    //     else if($token=='')
    //         return array("status"=>"0","message"=>"Please give stripe token");
    //     else if($original_amount=='')
    //         return array("status"=>"0","message"=>"Please give price");
    //     else if($currency=='')
    //         return array("status"=>"0","message"=>"Please give currency");
    //     else if($description=='')
    //         return array("status"=>"0","message"=>"Please give sdescription");
    //     else
    //     {
    //         $stripe = new stripeModel();
    //         $default = new defaultModel();
    //         $seller_check_token=$default->seller_check_with_token($user_id,$header);
    //         // print_r($seller_check_token);exit;
    //         if($seller_check_token=="unavailable")
    //             return array("status"=>"0","message"=>"User doesn't Exists");
    //         else if($seller_check_token=="unauthorized")
    //             return array("status"=>"0","message"=>"Unauthorized User");
    //         else if($seller_check_token[0]=="checked")
    //         {
    //             $product = $stripe->checkProductExist($product_id,$seller_id);
    //             if($product)
    //             {
    //                 $secret_key = $stripe->getSecretKey();
				// 	// $userEmail = $default->seller_check_with_token($user_id,'');
				// 	$email = $seller_check_token[1][0]->email;
    //                 \Stripe\Stripe::setApiKey ($secret_key);
				// 	$customer = \Stripe\Customer::create(array(
				// 		"email" =>$email,
				// 		"source" =>$token,
				// 		//'plan'     => "monthly_recurring_setupfee"
				// 	));
				// 	// print_r($customer);die;
    //                 $charge = \Stripe\Charge::create ( array (
    //                         "amount" => $original_amount * 100,
    //                         "currency" => $currency,
    //                         // "source" => $token, // obtained with Stripe.js
    //                         "description" => $description,
				// 			"customer" => $customer->id
    //                 ) );
    //                 // $card = $charge->id;
    //                 // print_r($card);exit;
    //                 if(!empty($charge))
    //                 {
    //                     $debit_credit_status='credit';
    //                     $data=$stripe->saveOrder($product,$seller_check_token[1],$charge->id,$seller_id,$product_id,$user_id,$original_amount,$currency,$description,$charge->status,$debit_credit_status);
    //                     if($data['status'] == 1)
    //                     {
    //                         $header = '';
    //                         $sellerData = $default->seller_check_with_token($seller_id,$header);
    //                         $masterSettings = $default->getServerKey();
    //                         $serverKey = $masterSettings[0]->value;
    //                         if($sellerData!='unavailable')
    //                         {
    //                             $deviceToken = $sellerData[0]->fcm;
    //                             $data = array("seller_id"=>$sellerData[0]->id,"text_message"=>"Your Product Sold with $".$original_amount);
    //                             $default->insertNotification($data);
                                
    //                             $notification = array("title"=>"Take Rent","text"=>"Your Product Sold with $".$original_amount);
    //                             $default->sendIOSPushNotification($deviceToken,$serverKey,$notification);
    //                         }
    //                         // print_r($seller_check_token[1]);exit;
    //                         $deviceToken = $seller_check_token[1][0]->fcm;
    //                         $data = array("seller_id"=>$seller_check_token[1][0]->id,"text_message"=>"Payment Successfully done with $".$original_amount);
    //                         $default->insertNotification($data);
                            
    //                         $notification = array("title"=>"Take Rent","text"=>"Payment Successfully done with $".$original_amount);
    //                         $default->sendIOSPushNotification($deviceToken,$serverKey,$notification);
    //                     }
    //                     return $data;
    //                 }
    //                 else
    //                     return array("status"=>"0","message"=>"Stripe failed to charge customer");
    //             }
    //             else
    //                 return array("status"=>"0","message"=>"Product doesn't exist for this seller");
    //         }
    //     }
    // }
    // public function takeRentFromWallet(Request $request)
    // {
    //     $seller_id=$request->input('seller_id');
    //     $user_id=$request->input('user_id');
    //     $product_id=$request->input('product_id');
    //     // $token=$request->input('stripe_token');
    //     $original_amount=(double)($request->input('amount'));
    //     $currency=$request->input('currency');
    //     $description=$request->input('description');
    //     $header=$request->header('Auth');
    //     if($header=='')
    //         return array("status"=>"0","message"=>"Please give Auth Token");
    //     else if($seller_id=='')
    //         return array("status"=>"0","message"=>"Please give seller id");
    //     else if($user_id=='')
    //         return array("status"=>"0","message"=>"Please give user id");
    //     else if($product_id=='')
    //         return array("status"=>"0","message"=>"Please give product id");
    //     // else if($token=='')
    //     //     return array("status"=>"0","message"=>"Please give stripe token");
    //     else if($original_amount=='')
    //         return array("status"=>"0","message"=>"Please give price");
    //     else if($currency=='')
    //         return array("status"=>"0","message"=>"Please give currency");
    //     else if($description=='')
    //         return array("status"=>"0","message"=>"Please give sdescription");
    //     else
    //     {
    //         $stripe = new stripeModel();
    //         $default = new defaultModel();
    //         $seller_check_token=$default->seller_check_with_token($user_id,$header);
    //         // print_r($seller_check_token);exit;
    //         if($seller_check_token=="unavailable")
    //             return array("status"=>"0","message"=>"User doesn't Exists");
    //         else if($seller_check_token=="unauthorized")
    //             return array("status"=>"0","message"=>"Unauthorized User");
    //         else if($seller_check_token[1][0]->status=="I")
    //             return array("status"=>"0","message"=>"Unable to take rent because user is inactivate from Admin side");
    //         else if($seller_check_token[0]=="checked")
    //         {
    //             if($default->checkProductBlock($product_id))
    //                 return array("status"=>"0","message"=>"Unable to take rent because product is blocked from Admin side");               
    //             else
    //             {
    //                 $product = $stripe->checkProductExist($product_id,$seller_id);
    //                 if($product)
    //                 {
    //                     $userAmount = $seller_check_token[1][0]->user_wallet;
    //                     // print_r($userAmount);exit;
    //                     if($userAmount<$original_amount)
    //                     {
    //                         return array("status"=>"0","message"=>"You Can't take rent due to your insufficient wallet balance");
    //                     }
    //                     else
    //                     {
    //                         $chargeStatus='succeeded';
    //                         $debit_credit_status='credit';
    //                         // $date = date("M-d-Y H:i:s");
    //                         $chargeId = 'Wallet_'.$user_id."_".date("M-d-Y H:i:s")."_".$product_id;
    //                         $data=$stripe->saveOrder($product,$seller_check_token[1],$chargeId,$seller_id,$product_id,$user_id,$original_amount,$currency,$description,$chargeStatus,$debit_credit_status);
    //                         if($data['status'] == 1)
    //                         {
    //                             $wallet_balance = $userAmount - $original_amount;
    //                             $updateWallet=$stripe->walletUpdate($user_id,$wallet_balance);

    //                             $header = '';
    //                             $sellerData = $default->seller_check_with_token($seller_id,$header);
    //                             $masterSettings = $default->getServerKey();
    //                             $serverKey = $masterSettings[0]->value;
    //                             if($sellerData!='unavailable')
    //                             {
    //                                 $deviceToken = $sellerData[0]->fcm;
    //                                 // $categoryData = $default->getCategory($product_category);
    //                                 // $cat_name = $categoryData[0]['cat_name'];
    //                                 $data = array("seller_id"=>$sellerData[0]->id,"text_message"=>"Your Product Sold with $".$original_amount);
    //                                 $default->insertNotification($data);
                                    
    //                                 $notification = array("title"=>"Take Rent","text"=>"Your Product Sold with $".$original_amount);
    //                                 $default->sendIOSPushNotification($deviceToken,$serverKey,$notification);
    //                             }
    //                             $deviceToken = $seller_check_token[1][0]->fcm;
    //                             // $masterSettings = $default->getServerKey();
    //                             // $serverKey = $masterSettings[0]->value;
    //                             // $categoryData = $default->getCategory($product_category);
    //                             // $cat_name = $categoryData[0]['cat_name'];
    //                             $data = array("seller_id"=>$seller_check_token[1][0]->id,"text_message"=>"Payment Successfully done with $".$original_amount);
    //                             $default->insertNotification($data);
                                
    //                             $notification = array("title"=>"Take Rent","text"=>"Payment Successfully done with $".$original_amount);
    //                             $default->sendIOSPushNotification($deviceToken,$serverKey,$notification);
    //                             return $updateWallet;
    //                         }
    //                         else
    //                             return $data;
    //                     }
    //                 }
    //                 else
    //                     return array("status"=>"0","message"=>"Product doesn't exist for this seller");
    //             }
    //         }
    //     }
    // }
    public function addMoneyToWallet(Request $request)
    {
        // $seller_id=$request->input('seller_id');
        $user_id=$request->input('user_id');
        // $product_id=$request->input('product_id');
        $customer_id=$request->input('customer_id');
        $token=$request->input('card_id');
        $original_amount=(double)($request->input('amount'));
        $currency=$request->input('currency');
        $description=$request->input('description');
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        // else if($seller_id=='')
        //     return array("status"=>"0","message"=>"Please give seller id");
        else if($user_id=='')
            return array("status"=>"0","message"=>"Please give user id");
        // else if($product_id=='')
        //     return array("status"=>"0","message"=>"Please give product id");
        else if($token=='')
            return array("status"=>"0","message"=>"Please give stripe token");
        else if($original_amount=='')
            return array("status"=>"0","message"=>"Please give price");
        else if($currency=='')
            return array("status"=>"0","message"=>"Please give currency");
        else if($description=='')
            return array("status"=>"0","message"=>"Please give sdescription");
        else
        {
            $stripe = new stripeModel();
            $default = new defaultModel();
            $seller_check_token=$default->seller_check_with_token($user_id,$header);
            // print_r($seller_check_token);exit;
            if($seller_check_token=="unavailable")
                return array("status"=>"0","message"=>"User doesn't Exists");
            else if($seller_check_token=="unauthorized")
                return array("status"=>"0","message"=>"Unauthorized User");
            else if($seller_check_token[0]=="checked")
            {
                // $product = $stripe->checkProductExist($product_id,$seller_id);
                // if($product)
                // {
                // $userData = $default->getUserDetails($user_id);
                // print_r("userData");exit;
                $email = $seller_check_token[1][0]->email;
                // print_r($email);exit;
                    $secret_key = $stripe->getSecretKey();
                    \Stripe\Stripe::setApiKey ($secret_key);
                    if($customer_id == '')
                    {
                        $customer = \Stripe\Customer::create(array(
                            "email" =>$email,
                            "source" =>$token,
                            //'plan'     => "monthly_recurring_setupfee"
                        ));
                        // print_r($customer);die;
                        $charge = \Stripe\Charge::create ( array (
                                "amount" => $original_amount * 100,
                                "currency" => $currency,
                                // "source" => $token, // obtained with Stripe.js
                                "description" => $description,
                                "customer" => $customer->id
                        ));
                    }
                    else if($customer_id != '')
                    {
                        $charge = \Stripe\Charge::create ( array (
                            "amount" => $original_amount * 100,
                            "currency" => $currency,
                            "source" => $token, // obtained with Stripe.js
                            "description" => $description,
                            "customer" => $customer_id
                        ));
                    }
                    // $charge = \Stripe\Charge::create ( array (
                    //         "amount" => $original_amount * 100,
                    //         "currency" => $currency,
                    //         "source" => $token, // obtained with Stripe.js
                    //         "description" => $description
                    // ) );
                    // $card = $charge->id;
                    // print_r($card);exit;
                    if(!empty($charge))
                    {
                        $debit_credit_status='debit';
                        $data=$stripe->addMoneyToWallet($seller_check_token[1],$charge->id,$user_id,$original_amount,$currency,$description,$charge->status,$debit_credit_status);
                        return $data;
                    }
                    else
                        return array("status"=>"0","message"=>"Stripe failed to charge customer");
                // }
                // else
                //     return array("status"=>"0","message"=>"Product doesn't exist for this seller");
            }
        }
    }
    public function userRentList(Request $request)
    {
        $user_id=$request->input('user_id');
        $product_id=$request->input('product_id');
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($user_id=='')
            return array("status"=>"0","message"=>"Please give user id");
        else
        {
            $stripe = new stripeModel();
            $default = new defaultModel();
            $seller_check_token=$default->seller_check_with_token($user_id,$header);
            // print_r($seller_check_token);exit;
            if($seller_check_token=="unavailable")
                return array("status"=>"0","message"=>"User doesn't Exists");
            else if($seller_check_token=="unauthorized")
                return array("status"=>"0","message"=>"Unauthorized User");
            else if($seller_check_token[0]=="checked")
            {
                $data=$stripe->userRentList($user_id,$product_id);
                return $data;
            }
        }
    }
    public function transactionHistory(Request $request)
    {
        $user_id=$request->input('user_id');
        $header=$request->header('Auth');
        if($header=='')
            return array("status"=>"0","message"=>"Please give Auth Token");
        else if($user_id=='')
            return array("status"=>"0","message"=>"Please give user id");
        else
        {
            $stripe = new stripeModel();
            $default = new defaultModel();
            $seller_check_token=$default->seller_check_with_token($user_id,$header);
            // print_r($seller_check_token);exit;
            if($seller_check_token=="unavailable")
                return array("status"=>"0","message"=>"User doesn't Exists");
            else if($seller_check_token=="unauthorized")
                return array("status"=>"0","message"=>"Unauthorized User");
            else if($seller_check_token[0]=="checked")
            {
                $data=$stripe->transactionHistory($user_id);
                return $data;
            }
        }
    }
    public function createEmphemeralKey()
    {
        // \Stripe\Stripe::setApiKey('sk_live_ZIRQPn0BmGjPIFIkY5WKjrGU');
        // $stripeModel = new stripeModel();
        // $secret_key = $stripeModel->getSecretKey();
        // // $secret_key = 'sk_live_ZIRQPn0BmGjPIFIkY5WKjrGU';
        // \Stripe\Stripe::setApiKey ($secret_key);
        // $customer = \Stripe\Customer::create(array(
        //     "email" =>'salam@singind.com',
        //     // "source" =>$stripe_token,
        //     //'plan'     => "monthly_recurring_setupfee"
        // ));
        // $cust_id = $customer->id;
        $cust_id = request()->get('customerid');
        $stripe_version = request()->get('stripe_version');
        if($cust_id!='' && $stripe_version!='')
        {
            $stripeModel = new stripeModel();
            $secret_key = $stripeModel->getSecretKey();
            // $secret_key = 'sk_live_ZIRQPn0BmGjPIFIkY5WKjrGU';
            \Stripe\Stripe::setApiKey ($secret_key);
            $key = \Stripe\EphemeralKey::create(
              ['customer' => $cust_id],
              ['stripe_version' => $stripe_version]//API Version take from stripe dashboard
            );
            // $key->{"status"}='1';
            // print_r($key);exit();
            return $key->jsonSerialize();
        }
        else
        {
            return array("status"=>"0","message"=>"Please give customer id AND stripe version");
        }
        
    }
}
