<?php

// For test payments we want to enable the sandbox mode. If you want to put live
// payments through then this setting needs changing to `false`.
$enableSandbox = false;

// Database settings. Change these for your database configuration.
// $dbConfig = [
//     'host' => 'localhost',
//     'username' => 'user',
//     'password' => 'secret',
//     'name' => 'example_database'
// ];

// PayPal settings. Change these to your account details and the relevant URLs
// for your site.
//Client Id : AVkB833cGMt4RmbTh2odJY1VO6e2NG7aLoEKGP33uJZ_IzpsAOF7-goH49E4aX4L11xEHEpdchU-EjxE
$paypalConfig = [
    'email' => 'marcel@bullseyeaccounting.ca',
    'return_url' => 'https://bullseyeaccounting.ca/success.php',
    'cancel_url' => 'https://bullseyeaccounting.ca/cancel.php',
    'notify_url' => 'https://bullseyeaccounting.ca/paypal.php'
];

$paypalUrl = $enableSandbox ? 'https://www.sandbox.paypal.com/cgi-bin/webscr' : 'https://www.paypal.com/cgi-bin/webscr';

// Product being purchased.
$itemName = $_POST['first_name'].' '.$_POST['last_name'];
$itemAmount = $_POST['amount'];

// Include Functions
//require 'functions.php';

// Check if paypal request or response
if (!isset($_POST["txn_id"]) && !isset($_POST["txn_type"])) {

    // Grab the post data so that we can set up the query string for PayPal.
    // Ideally we'd use a whitelist here to check nothing is being injected into
    // our post data.
    $data = [];
    foreach ($_POST as $key => $value) {
        $data[$key] = stripslashes($value);
    }

    // Set the PayPal account.
    $data['business'] = $paypalConfig['email'];

    // Set the PayPal return addresses.
    $data['return'] = stripslashes($paypalConfig['return_url']);
    $data['cancel_return'] = stripslashes($paypalConfig['cancel_url']);
    $data['notify_url'] = stripslashes($paypalConfig['notify_url']);

    // Set the details about the product being purchased, including the amount
    // and currency so that these aren't overridden by the form data.
    $data['item_name'] = $_POST['first_name'].' '.$_POST['last_name'];
    $data['amount'] = $_POST['amount'];
    $data['currency_code'] = $_POST['lc'];

    // Add any custom fields for the query string.
    //$data['custom'] = USERID;

    // Build the query string from the data.
    $queryString = http_build_query($data);

    // Redirect to paypal IPN
    header('location:' . $paypalUrl . '?' . $queryString);
    exit();

} else {
    // Handle the PayPal response.
}