<?php
   if ( ! defined( 'ABSPATH' ) ) {
     exit; // Exit if accessed directly
   }
?>

<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   
   $img = $template_url."images/our-ferature-bg.jpg";
?>
<!-- Page Header Start -->
<div class="page-header" style="background-image: url(<?=$img;?>); background-position: center; background-size: 100%;">
   <div class="container-fluid">
      <div class="row align-items-center">
         <div class="col-lg-12">
            <!-- Page Header Box Start -->
            <div class="page-header-box">
               <h1 class="text-anime-style-3" data-cursor="-opaque"><?php if(get_field('bradcamp_title') != ""){ echo get_field('bradcamp_title');}else{ the_title();}?> </h1>
               <nav class="wow fadeInUp">
                  <ol class="breadcrumb">
                     <li class="breadcrumb-item"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">home</a></li>
                     <li class="breadcrumb-item active" aria-current="page">Blog Details</li>
                  </ol>
               </nav>
            </div>
            <!-- Page Header Box End -->
         </div>
      </div>
   </div>
</div>
<!-- Page Header End -->
<!-- Page Single Post Start -->
<div class="page-single-post">
   <div class="container">
      <div class="row">
         <div class="col-lg-8">
            <?php echo get_the_content();?>
			 
         </div>
		  <div class="col-lg-4">
            <!-- Page Single Sidebar Start -->
            <div class="page-single-sidebar">
               <!-- Page Category List Start -->
               <div class="page-catagery-list wow fadeInUp">
                  <h3>All <?php echo $parent_post_title;?></h3>
                  <ul>
                     <?php 
                        $args = array(
                          'post_type'      => 'page',
                          'posts_per_page' => 8,
                          'post_parent'    => $parent_id,
                          'order'          => 'ASC',
                          'orderby'        => 'menu_order'
                        );
                        $parent = new WP_Query( $args );
                        if ( $parent->have_posts() ) :
                          while ( $parent->have_posts() ) : $parent->the_post();?>
                     <li><a href="<?php the_permalink(); ?>"><span><?php the_title(); ?></span></a></li>
                     <?php endwhile; ?>
                     <?php endif; wp_reset_query(); ?>
                  </ul>
               </div>
               <!-- Page Category List End -->
               <!-- Sidebar Cta Box Start -->
               <div class="sidebar-cta-box wow fadeInUp" data-wow-delay="0.2s">
                  <!-- Sidebar CTA Image Start -->
                  <div class="sidebar-cta-image">
                     <figure>
                        <img src="<?php echo get_stylesheet_directory_uri();?>/images/sidebar-cta-bg.jpg" alt="">
                     </figure>
                  </div>
                  <!-- Sidebar CTA Image End -->
                  <!-- Sidebar CTA Content Start -->
                  <div class="sidebar-cta-content">
                     <!-- Sidebar CTA Item Start -->
                     <div class="sidebar-cta-item">
                        <!-- Icon Box Start -->
                        <div class="icon-box">
                           <img src="<?php echo get_stylesheet_directory_uri();?>/images/icon-hours.svg" alt="">
                        </div>
                        <!-- Icon Box End -->
                        <!-- Sidebar Cta Content Start -->
                        <div class="cta-item-content">
                           <h3>Opening Hours</h3>
                           <p>Monday - Friday (8am to 5pm)</p>
                           <p>Sunday - Closed</p>
                        </div>
                        <!-- Sidebar Cta Content End -->
                     </div>
                     <!-- Sidebar CTA Item End -->
                     <!-- Sidebar CTA Contact Start -->
                     <div class="sidebar-cta-contact">
                        <a href="tel: <?php echo html_entity_decode( get_option( 'option_8' ) );?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icon-cta-phone.svg" alt=""> <?php echo html_entity_decode( get_option( 'option_8' ) );?></a>
                     </div>
                     <!-- Sidebar CTA Contact End -->
                  </div>
                  <!-- Sidebar CTA Content End -->
               </div>
               <!-- Sidebar Cta Box End -->
            </div>
            <!-- Page Single Sidebar End -->
         </div>
      </div>
   </div>
</div>
<!-- Page Single Post End -->
<?php get_footer(); ?>