<?php
if ( ! defined( 'ABSPATH' ) ) {  
  exit; // Exit if accessed directly 
} 
get_header();
$src = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' ); 
?>
<!-- Hero Section Start -->
    <div class="hero hero-bg-image hero-video dark-section">
      <!-- Video Start -->
      <div class="hero-bg-video">
        <!-- Selfhosted Video Start -->
        <!-- <video autoplay muted loop id="myvideo"><source src="<?php echo get_stylesheet_directory_uri();?>/images/hero-bg-video.mp4" type="video/mp4"></video> -->
        <video autoplay muted loop id="myvideo">
          <source src="https://demo.awaikenthemes.com/assets/videos/kinesi-video.mp4" type="video/mp4">
        </video>
        <!-- Selfhosted Video End -->
        <!-- Youtube Video Start -->
        <!-- <div id="herovideo" class="player" data-property="{videoURL:'OjTRVpgtcG4',containment:'.hero-video', showControls:false, autoPlay:true, loop:true, vol:0, mute:false, startAt:0,  stopAt:296, opacity:1, addRaster:true, quality:'large', optimizeDisplay:true}"></div> -->
        <!-- Youtube Video End -->
      </div>
      <!-- Video End -->
      <div class="container-fluid">
        <div class="row no-gutters">
          <div class="col-lg-12">
            <!-- Hero Content Start -->
            <div class="hero-content">
              <!-- Section Title Start -->
              <div class="section-title"><?php the_field('content');?></div>
              <!-- Section Title End -->
              <!-- Hero Body Start -->
              <div class="hero-body wow fadeInUp" data-wow-delay="0.4s">
                <!-- Hero Button Start -->
                <div class="hero-btn d-none d-md-block">
                  <a href="<?php the_field('link');?>" class="btn-default">Book a Consultation</a>
                </div>
                <!-- Hero Button End -->
                <!-- Video Play Button Start -->
                <div class="video-play-button">
                  <p>Watch video</p>
                  <a href="<?php the_field('video_link');?>" class="popup-video" data-cursor-text="Play">
                    <i class="fa-solid fa-play"></i>
                  </a>
                </div>
                <!-- Video Play Button End -->
              </div>
              <!-- Hero Body End -->
            </div>
            <!-- Hero Content End -->
          </div>
        </div>
      </div>
    </div>
    <!-- Hero Section End -->


    <!-- About Us Section Start -->
    <div class="about-us">
      <div class="container">
        <div class="row section-row">
          <div class="col-lg-12">
            <!-- Section Title Start -->
            <div class="section-title section-title-center">
              <h3 class="wow fadeInUp"><?php the_field('second_section_title');?></h3>
              <?php the_field('second_section_content');?>
            </div>
            <!-- Section Title End -->
          </div>
        </div>
        <div class="row align-items-center">
          <div class="col-lg-12">
            <!-- About Us Content Start -->
            <div class="about-us-content">
              <!-- About Us Image Start -->
              <div class="about-us-image">
                <figure class="image-anime reveal">
                  <img src="<?php the_field('second_section_iamge');?>" alt="">
                </figure>
              </div>
              <!-- About Us Image End -->
            </div>
            <!-- About Us Content End -->
          </div>
        </div>
      </div>
    </div>
    <!-- About Us Section End -->


    <!-- Our Services Section Start -->
<div class="our-services bg-section">
   <div class="container">
      <div class="row section-row">
         <div class="col-lg-12">
            <!-- Section Title Start -->
            <div class="section-title section-title-center">
               <h3 class="wow fadeInUp">our services</h3>
               <h2 class="text-anime-style-3" data-cursor="-opaque">Tailored physiotherapy services for every need</h2>
            </div>
            <!-- Section Title End -->
         </div>
      </div>
      <div class="our-service">
         <div class="service-slider">
            <div class="swiper">
               <div class="swiper-wrapper" data-cursor-text="Drag">
                   <?php 
                        $args = array(
                          'post_type'      => 'page',
                          'posts_per_page' => -1,
                          'post_parent'    => 14,
                          'order'          => 'ASC',
                          'orderby'        => 'menu_order'
                        );
                        $parent = new WP_Query( $args );
                        if ( $parent->have_posts() ) :
                          while ( $parent->have_posts() ) : $parent->the_post();?>
                          <div class="swiper-slide">
                             <div class="service-item wow fadeInUp" style="background-image: url(<?php the_field('front_image');?>);">
                                <!-- Service Content Start -->
                                <div class="service-content">
                                   <h3>
                                      <a href="<?php the_permalink();?>"><?php echo get_the_title();?></a>
                                   </h3>
                                   <p><?php the_field('short_text');?></p>
                                </div>
                                <!-- Service Content End -->
                                <!-- Service Readmore Start -->
                                <div class="service-readmore-btn">
                                   <a href="<?php the_permalink();?>" class="readmore-btn">read more</a>
                                </div>
                                <!-- Service Readmore End -->
                             </div>
                          </div>
                     <?php endwhile; ?>
                     <?php endif; wp_reset_query(); ?>
               </div>
            </div>
            <div class="testimonial-btn">
               <div class="testimonial-button-prev"></div>
               <div class="testimonial-button-next"></div>
            </div>
         </div>
      </div>
   </div>
</div>
<!-- Our Services Section End -->
    
    
    
    <!-- Why Choose Us Section Start -->
    <div class="why-choose-us">
      <div class="container">
        <div class="row section-row">
          <div class="col-lg-12">
            <!-- Section Title Start -->
            <div class="section-title section-title-center">
              <h3 class="wow fadeInUp"><?php the_field('why_choose_section_title');?></h3>
              <h2 class="text-anime-style-3" data-cursor="-opaque"><?php the_field('why_choose_section_short_title');?></h2>
            </div>
            <!-- Section Title End -->
          </div>
        </div>
        <div class="row">
          <div class="col-lg-4">
            <!-- Why Choose Box Start -->
            <div class="why-choose-box-1">
              <!-- Why Choose Item Start -->
              <div class="why-choose-item wow fadeInUp">
                <p><?php the_field('why_choose_section_left_content');?></p>
                <h2><?php the_field('why_choose_section_left_title');?></h2>
              </div>
              <!-- Why Choose Item End -->
              <!-- Why Choose Image Start -->
              <div class="why-choose-image">
                <figure class="image-anime reveal">
                  <img src="<?php the_field('why_choose_section_left_image');?>" alt="">
                </figure>
              </div>
              <!-- Why Choose Image End -->
            </div>
            <!-- Why Choose Box End -->
          </div>
          <div class="col-lg-4">
            <!-- Why Choose Image Box Start -->
            <div class="why-choose-image-box wow fadeInUp" data-wow-delay="0.2s">
              <figure class="image-anime">
                <img src="<?php the_field('why_choose_section_middle_image');?>" alt="">
              </figure>
              <!-- Why Choose Title Start -->
              <div class="why-choose-title">
                <h2><?php the_field('why_choose_section_middle_upper_content');?></h2>
              </div>
              <!-- Why Choose Title End -->
              <!-- Why Choose Content Start -->
              <div class="why-choose-content">
                <p><?php the_field('why_choose_section_middle_lower_content');?></p>
              </div>
              <!-- Why Choose Content End -->
            </div>
            <!-- Why Choose Image Box End -->
          </div>
          <div class="col-lg-4">
            <!-- Why Choose Box Start -->
            <div class="why-choose-box-2">
              <!-- Why Choose Image Start -->
              <div class="why-choose-image">
                <figure class="image-anime reveal">
                  <img src="<?php the_field('why_choose_section_right_image');?>" alt="">
                </figure>
              </div>
              <!-- Why Choose Image End -->
              <!-- Why Choose Item Start -->
              <div class="why-choose-item wow fadeInUp" data-wow-delay="0.4s">
                <p><?php the_field('why_choose_section_right_contnet');?></p>
                <h2><?php the_field('why_choose_section_right_title');?></h2>
              </div>
              <!-- Why Choose Item End -->
            </div>
            <!-- Why Choose Box End -->
          </div>
        </div>
      </div>
    </div>
    <!-- Why Choose Us Section End -->

    <!-- Our Feature Section Start -->
    <div class="our-features bg-section dark-section">
      <div class="container">
        <div class="row section-row">
          <div class="col-lg-12">
            <!-- Section Title Start -->
            <div class="section-title section-title-center">
              <h3 class="wow fadeInUp"><?php the_field('condition_section_ttile');?></h3>
              <h2 class="text-anime-style-3" data-cursor="-opaque"><?php the_field('condition_section_content');?></h2>
            </div>
            <!-- Section Title End -->
          </div>
        </div>
        <div class="row">
           <div class="container">
              <div class="our-condition">
                 <div class="service-slider">
                    <div class="swiper">
                       <div class="swiper-wrapper" data-cursor-text="Drag">
                          <?php 
                             $args = array(
                               'post_type'      => 'page',
                               'posts_per_page' => -1,
                               'post_parent'    => 16,
                               'order'          => 'ASC',
                               'orderby'        => 'menu_order'
                             );
                             $parent = new WP_Query( $args );
                             if ( $parent->have_posts() ) :
                               while ( $parent->have_posts() ) : $parent->the_post();?>
                          <div class="swiper-slide">
                             <div class="service-item wow fadeInUp" style="background-image: url(<?php the_field('front_image');?>);">
                                <!-- Service Content Start -->
                                <div class="service-content">
                                   <h3>
                                      <a href="<?php the_permalink();?>"><?php echo get_the_title();?></a>
                                   </h3>
                                   <p><?php the_field('short_content');?></p>
                                </div>
                                <!-- Service Content End -->
                                <!-- Service Readmore Start -->
                                <div class="service-readmore-btn">
                                   <a href="<?php the_permalink();?>" class="readmore-btn">read more</a>
                                </div>
                                <!-- Service Readmore End -->
                             </div>
                          </div>
                          <?php endwhile; ?>
                          <?php endif; wp_reset_query(); ?>
                       </div>
                    </div>
                 </div>
              </div>
              <div class="testimonial-btn">
                 <div class="testimonial-button-prev"></div>
                 <div class="testimonial-button-next"></div>
              </div>
           </div>
        </div>
      </div>
    </div>
    <!-- Our Feature Section End -->
    <!-- How It Work Section Start -->
    <div class="how-it-work">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <!-- How It Work Content Start -->
            <div class="how-it-work-content">
              <!-- Section Title Start -->
              <div class="section-title">
                <h3 class="wow fadeInUp"><?php the_field('how_it_works_section_title');?></h3>
                <h2 class="text-anime-style-3" data-cursor="-opaque"><?php the_field('how_it_works_section_short_content');?></h2>
              </div>
              <!-- Section Title End -->
              <!-- How It Work Image Start -->
              <div class="how-it-work-image">
                <figure class="image-anime reveal">
                  <img src="<?php the_field('how_it_works_section_iamge');?>" alt="">
                </figure>
              </div>
              <!-- How It Work Image End -->
            </div>
            <!-- How It Work Content End -->
          </div>
          <div class="col-lg-6">
            <!-- Work Step List Box Start -->
            <div class="work-step-list-box">
              <!-- Work Step List Start -->
              <div class="work-step-list">
                <?php if(have_rows('how_it_works_section_points')): ?>
                <?php $i=0; while(have_rows('how_it_works_section_points')): ?>
                <?php the_row(); ?>  
                <!-- Work Step Item Start -->
                <div class="work-step-item wow fadeInUp">
                  <div class="icon-box">
                    <img src="<?php the_sub_field('icon'); ?>" alt="">
                  </div>
                  <div class="work-step-item-content">
                    <h3><?php the_sub_field('title'); ?></h3>
                    <p><?php the_sub_field('content'); ?></p>
                  </div>
                </div>
                <!-- Work Step Item End -->
                <?php $i++; endwhile; ?>
                <?php endif; ?>
              </div>
              <!-- Work Step List End -->
              <!-- Work Step Button Start -->
              <div class="work-step-btn wow fadeInUp" data-wow-delay="0.6s">
                <a href="<?php the_field('how_it_works_section_link');?>" class="btn-default">Get consultation</a>
              </div>
              <!-- Work Step Button End -->
            </div>
            <!-- Work Step List Box End -->
          </div>
        </div>
      </div>
    </div>
    <!-- How It Work Section End- -->
    <!-- What We Do Section Start -->
<!--     <div class="what-we-do bg-section">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-6">
            
            <div class="what-we-do-content">
              
              <div class="section-title">
                <h3 class="wow fadeInUp"><?php the_field('what_we_do_section_title');?></h3>
                <?php the_field('what_we_do_section_content');?>
              </div>
             
              <div class="what-we-do-footer wow fadeInUp" data-wow-delay="0.6s">
                <a href="<?php the_field('what_we_do_section_link');?>" class="btn-default">contact us</a>
              </div>
             
            </div>
            
          </div>
          <div class="col-lg-6">
           
            <div class="what-we-do-image">
              <figure class="image-anime reveal">
                <img src="<?php the_field('what_we_do_section_image');?>" alt="">
              </figure>
            </div>
         
          </div>
        </div>
      </div>
    </div> -->
   
    <!-- Our FAQs Section Start -->
    <div class="our-faqs">
      <div class="container">
        <div class="row">
          <div class="col-lg-6">
            <!-- FAQs Content Start -->
            <div class="faqs-content">
              <!-- Section Title Start -->
              <div class="section-title">
                <h3 class="wow fadeInUp"><?php the_field('faq_section_title');?></h3>
                <h2 class="text-anime-style-3" data-cursor="-opaque"><?php the_field('faq_section_content');?></h2>
              </div>
              <!-- Section Title End -->
              <!-- FAQs Contact Box Start -->
              <div class="faqs-contact-box wow fadeInUp" data-wow-delay="0.2s">
                <!-- FAQs Contact Item Start -->
                <div class="faqs-contact-item">
                  <div class="icon-box">
                    <img src="<?php echo get_stylesheet_directory_uri();?>/images/icon-faq.svg" alt="">
                  </div>
                  <div class="faqs-contact-content">
                    <h3>Answers to Your Recovery Questions</h3>
                  </div>
                </div>
                <!-- FAQs Contact Item End -->
                <!-- FAQs Contact List Start -->
                <div class="faqs-contact-list">
                  <ul>
                    <li>
                      <a href="tel:<?php echo html_entity_decode( get_option( 'option_8' ) );?>">
                        <i class="fa-solid fa-phone"></i> <?php echo html_entity_decode( get_option( 'option_8' ) );?> </a>
                    </li>
                    <li>
                      <a href="mailto:<?php echo html_entity_decode( get_option( 'option_71' ) );?>">
                        <i class="fa-solid fa-envelope"></i> <?php echo html_entity_decode( get_option( 'option_71' ) );?> </a>
                    </li>
                  </ul>
                </div>
                <!-- FAQs Contact List End -->
              </div>
              <!-- FAQs Contact Box End -->
            </div>
            <!-- FAQs Content End -->
          </div>
          <div class="col-lg-6">
            <!-- FAQ Accordion Start -->
            <div class="faq-accordion" id="accordion">
            <?php if(have_rows('faq_section_points',8)): ?>    
            <?php $i=0; while(have_rows('faq_section_points',8)): ?>
            <?php the_row(); ?>  
              <!-- FAQ Item Start -->
              <div class="accordion-item wow fadeInUp">
                <h2 class="accordion-header" id="heading<?=$i?>">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?=$i?>" aria-expanded="true" aria-controls="collapse<?=$i?>"><?php the_sub_field('question',8); ?></button>
                </h2>
                <div id="collapse<?=$i?>" class="accordion-collapse collapse" aria-labelledby="heading<?=$i?>" data-bs-parent="#accordion">
                  <div class="accordion-body">
                    <p><?php the_sub_field('answer',8); ?></p>
                  </div>
                </div>
              </div>
              <!-- FAQ Item End -->
              <?php $i++; endwhile; ?>
              <?php endif; wp_reset_query(); ?>
            </div>
            <!-- FAQ Accordion End -->
          </div>
        </div>
      </div>
    </div>
    <!-- Our FAQs Section End -->
    <!-- Our Testimonials Section Start -->
    <div class="our-testimonials bg-section">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <!-- Our Testimonials Content Start -->
            <div class="our-testimonials-content">
              <!-- Section Title Start -->
              <div class="section-title">
                <h3 class="wow fadeInUp"><?php the_field('testimonial_section_title');?></h3>
                <h2 class="text-anime-style-3" data-cursor="-opaque"><?php the_field('testimonial_section_content');?></h2>
              </div>
              <!-- Section Title End -->
              <!-- Testimonial Body Start -->
              <div class="testimonial-body">
                <!-- Testimonial Image Start -->
                <div class="testimonial-image">
                  <figure class="image-anime reveal">
                    <img src="<?php the_field('testimonial_section_iamge');?>" alt="">
                  </figure>
                </div>
                <!-- Testimonial Image End -->
              </div>
              <!-- Testimonial Body End -->
            </div>
            <!-- Our Testimonials Content End -->
          </div>
          <div class="col-lg-6">
            <!-- Testimonial Slider Start -->
            <div class="testimonial-slider">
              <div class="swiper">
                <div class="swiper-wrapper" data-cursor-text="Drag">
                <?php if(have_rows('testimonials',8)): ?>    
                <?php $i=0; while(have_rows('testimonials',8)): ?>
                <?php the_row(); ?>
                  <!-- Testimonial Slide Start -->
                  <div class="swiper-slide">
                    <div class="testimonial-item">
                      <div class="testimonial-rating">
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                      </div>    
                      <div class="testimonial-content">
                        <?php the_sub_field('testimonial_section_content',8); ?>
                      </div>
                      <div class="testimonial-author">
                        <div class="author-image">
                          <figure class="image-anime">
                            <img src="<?php the_sub_field('testimonial_section_image',8); ?>" alt="">
                          </figure>
                        </div>
                        <div class="author-content">
                          <h3><?php the_sub_field('name',8); ?></h3>
                          <p><?php the_sub_field('designation',8); ?></p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <!-- Testimonial Slide End -->
                <?php $i++; endwhile; ?>
                <?php endif; wp_reset_query(); ?>  
                </div>
                <!-- Testimonial Buttons Start -->
                <div class="testimonial-btn">
                  <div class="testimonial-button-prev"></div>
                  <div class="testimonial-button-next"></div>
                </div>
                <!-- Testimonial Buttons End -->
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- Our Testimonials Section Start -->
<!-- Our Team Section Start -->
<div class="our-team">
   <div class="container">
      <div class="row section-row">
         <div class="col-lg-12">
            <!-- Section Title Start -->
            <div class="section-title section-title-center">
               <h3 class="wow fadeInUp"><?php the_field('our_team_section_title');?></h3>
               <h2 class="text-anime-style-3" data-cursor="-opaque"><?php the_field('our_team_section_content');?></h2>
            </div>
            <!-- Section Title End -->
         </div>
      </div>
      <div class="row">
         <div class="our-condition">
            <div class="service-slider">
               <div class="swiper">
                  <div class="swiper-wrapper" data-cursor-text="Drag">
                     <?php 
                        $args = array(
                          'post_type'      => 'page',
                          'posts_per_page' => -1,
                          'post_parent'    => 20,
                          'order'          => 'ASC',
                          'orderby'        => 'menu_order'
                        );
                        $parent = new WP_Query( $args );
                        if ( $parent->have_posts() ) :
                          while ( $parent->have_posts() ) : $parent->the_post();?>
                     <div class="swiper-slide">
                        <div class="team-item wow fadeInUp">
                           <!-- Team Image Start -->
                           <div class="team-image">
                              <a href="<?php the_permalink();?>" data-cursor-text="View">
                                 <figure class="image-anime">
                                    <img src="<?php the_field('front_image');?>" alt="">
                                 </figure>
                              </a>
                              <!-- Team Social Icon Start -->
                              <!-- Team Social Icon End -->
                           </div>
                           <!-- Team Image End -->
                           <!-- Team Content Start -->
                           <div class="team-content">
                              <h3>
                                 <a href="<?php the_permalink();?>"><?php echo get_the_title();?></a>
                              </h3>
                              <p><?php the_field('short_content');?></p>
                           </div>
                           <!-- Team Content End -->
                        </div>
                     </div>
                     <?php endwhile; ?>
                     <?php endif; wp_reset_query(); ?>
                  </div>
               </div>
               <div class="testimonial-btn">
                  <div class="testimonial-button-prev"></div>
                  <div class="testimonial-button-next"></div>
                </div>
            </div>
         </div>
      </div>
</div>
</div>
<!-- Our Team Section End -->



    <!-- Book Appointment Section Start -->
    <div class="book-appointment bg-section">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <!-- Book Appointment Content Start -->
            <div class="book-appointment-content">
              <!-- Section Title Start -->
              <div class="section-title">
                <h3 class="wow fadeInUp"><?php the_field('booking_appointment_section_title');?></h3>
                <h2 class="text-anime-style-3" data-cursor="-opaque"><?php the_field('booking_appontment_section_content');?></h2>
              </div>
              <!-- Section Title End -->
              <!-- Appointment Info List Start -->
              <div class="appointment-image-info wow fadeInUp" data-wow-delay="0.2s">
                <!-- Appointment Image Start -->
                <div class="appointment-image">
                  <figure class="image-anime">
                    <img src="<?php the_field('booking_appontment_section_image');?>" alt="">
                  </figure>
                </div>
                <!-- Appointment Image End -->
                <!-- Appointment Info List Start -->
                <div class="appointment-info-list">
                  <!-- Appointment Info Item Start -->
                  <div class="appointment-info-item">
                    <div class="icon-box">
                      <img src="<?php echo get_stylesheet_directory_uri();?>/images/icon-customer-service.svg" alt="">
                    </div>
                    <div class="appointment-info-content">
                      <h3>Customer services</h3>
                      <p>
                        <a href="tel:<?php echo html_entity_decode( get_option( 'option_8' ) );?>"><?php echo html_entity_decode( get_option( 'option_8' ) );?></a>
                      </p>
                    </div>
                  </div>
                  <!-- Appointment Info Item End -->
                  <!-- Appointment Info Item Start -->
                  <div class="appointment-info-item">
                    <div class="icon-box">
                      <img src="<?php echo get_stylesheet_directory_uri();?>/images/icon-clock.svg" alt="">
                    </div>
                    <div class="appointment-info-content">
                      <h3>Opening hours</h3>
                      <p>Monday - Friday ( 8am - 5pm )</p>
                    </div>
                  </div>
                  <!-- Appointment Info Item End -->
                </div>
                <!-- Appointment Info List End -->
              </div>
              <!-- Appointment Info List End -->
            </div>
            <!-- Book Appointment Content End -->
          </div>
          <div class="col-lg-6">
            <!-- Book Appointment Form Start -->
            <div class="appointment-form wow fadeInUp" data-wow-delay="0.2s">
              <?php echo do_shortcode('[contact-form-7 id="c815ead" title="Contact form"]');?>
            </div>
            <!-- Book Appointment Form End -->
          </div>
        </div>
      </div>
    </div>
    <!-- Book Appointment Section End -->
    <!-- Our Blog Section Start -->
    <div class="our-blog">
      <div class="container">
        <div class="row section-row">
          <div class="col-lg-12">
            <!-- Section Title Start -->
            <div class="section-title section-title-center">
              <h3 class="wow fadeInUp"><?php the_field('blog_section_title');?></h3>
              <h2 class="text-anime-style-3" data-cursor="-opaque"><?php the_field('blog_section_content');?></h2>
            </div>
            <!-- Section Title End -->
          </div>
        </div>
        <div class="row">
          <?php echo do_shortcode('[BP_HOME_BLOG]');?>
        </div>
      </div>
    </div>
    <!-- Our Blog Section End -->
<?php get_footer();?>
