<?php
   /*
   * Template Name: Team Details Page
   */
   ?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   $img = $template_url."<?php echo get_stylesheet_directory_uri();?>/images/post-2.jpg";
   ?>
<?php
   $postID = get_queried_object_id();
   $parent_id = $post->post_parent;
   $parent_post = get_post($parent_id);
   $parent_post_title = $parent_post->post_title;
   ?>
<!-- Page Header Start -->
<div class="page-header" style="background-image: url(<?=$img;?>); background-position: center; background-size: 100%;">
   <div class="container-fluid">
      <div class="row align-items-center">
         <div class="col-lg-12">
            <!-- Page Header Box Start -->
            <div class="page-header-box">
               <h1 class="text-anime-style-3" data-cursor="-opaque"><?php if(get_field('bradcamp_title') != ""){ echo get_field('bradcamp_title');}else{ the_title();}?> Details</h1>
               <nav class="wow fadeInUp">
                  <ol class="breadcrumb">
                     <li class="breadcrumb-item"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">home</a></li>
                     <li class="breadcrumb-item active" aria-current="page"><?php if(get_field('bradcamp_title') != ""){ echo get_field('bradcamp_title');}else{ the_title();}?> Details</li>
                  </ol>
               </nav>
            </div>
            <!-- Page Header Box End -->
         </div>
      </div>
   </div>
</div>
<!-- Page Header End -->
<!-- Page Team Single Start -->
<div class="page-team-single">
   <div class="container">
      <div class="row">
         <div class="col-lg-4">
            <!-- Team Single Sidebar Start -->
            <div class="page-single-sidebar">
               <!-- Team Sidebar Box Start -->
               <div class="team-sidebar-box wow fadeInUp">
                  <!-- Team Sidebar Image Start -->
                  <div class="team-sidebar-image">
                     <figure class="image-anime">
                        <img src="<?php the_field('front_image');?>" alt="">
                     </figure>
                  </div>
                  <!-- Team Sidebar Image End -->
                  <!-- Team Sidebar Body Start -->
                  <div class="team-sidebar-body">
                     <h3>Personal Details</h3>
                     <ul>
                        <li>Phone :<span><?php the_field('phone');?></span></li>
                        <li>Designation :<span><?php the_field('short_content');?></span></li>
                        <li>email :<span><?php the_field('email');?></span></li>
                        <li>Address :<span><?php the_field('address');?></span></li>
                     </ul>
                  </div>
                  <!-- Team Sidebar Body End -->                  
               </div>
               <!-- Team Sidebar Box End -->
               <!-- Sidebar Cta Box Start -->
               <div class="sidebar-cta-box wow fadeInUp" data-wow-delay="0.2s">
                  <!-- Sidebar CTA Image Start -->
                  <div class="sidebar-cta-image">
                     <figure>
                        <img src="<?php echo get_stylesheet_directory_uri();?>/images/sidebar-cta-bg.jpg" alt="">
                     </figure>
                  </div>
                  <!-- Sidebar CTA Image End -->
                  <div class="sidebar-cta-content">
                     <!-- Sidebar CTA Item Start -->
                     <div class="sidebar-cta-item">
                        <!-- Icon Box Start -->
                        <div class="icon-box">
                           <img src="<?php echo get_stylesheet_directory_uri();?>/images/icon-hours.svg" alt="">
                        </div>
                        <!-- Icon Box End -->
                        <!-- Sidebar Cta Content Start -->
                        <div class="cta-item-content">
                           <h3>Opening Hours</h3>
                           <p>Monday - Friday (8am to 5pm)</p>
                           <p>Sunday - Closed</p>
                        </div>
                        <!-- Sidebar Cta Content End -->
                     </div>
                     <!-- Sidebar CTA Item End -->
                     <!-- Sidebar CTA Contact Start -->
                     <div class="sidebar-cta-contact">
                        <a href="tel: <?php echo html_entity_decode( get_option( 'option_8' ) );?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icon-cta-phone.svg" alt=""> <?php echo html_entity_decode( get_option( 'option_8' ) );?></a>
                     </div>
                     <!-- Sidebar CTA Contact End -->
                  </div>
               </div>
               <!-- Sidebar Cta Box End -->
            </div>
            <!-- Team Member Sidebar End -->
         </div>
         <div class="col-lg-8">
            <!-- Team Single Content Start -->
            <div class="team-single-content">
               <?php echo $content = apply_filters( 'the_content', get_post_field( 'post_content', $postID ) );?>
            </div>
            <!-- Team Single Content End -->
         </div>
      </div>
   </div>
</div>
<!-- Page Team Single End -->
<?php get_footer(); ?>