<?php
   /*
   * Template Name: Details Page
   */
   ?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   $img = $template_url."images/post-2.jpg";
   ?>
<?php
   $postID = get_queried_object_id();
   $parent_id = $post->post_parent;
   $parent_post = get_post($parent_id);
   $parent_post_title = $parent_post->post_title;
   ?>
<!-- Page Header Start -->
<div class="page-header" style="background-image: url(<?=$img;?>); background-position: center; background-size: 100%;">
   <div class="container-fluid">
      <div class="row align-items-center">
         <div class="col-lg-12">
            <!-- Page Header Box Start -->
            <div class="page-header-box">
               <h1 class="text-anime-style-3" data-cursor="-opaque"><?php if(get_field('bradcamp_title') != ""){ echo get_field('bradcamp_title');}else{ the_title();}?> Details</h1>
               <nav class="wow fadeInUp">
                  <ol class="breadcrumb">
                     <li class="breadcrumb-item"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">home</a></li>
                     <li class="breadcrumb-item"><a href="#"><?php echo $parent_post_title;?></a></li>
                     <li class="breadcrumb-item active" aria-current="page"><?php if(get_field('bradcamp_title') != ""){ echo get_field('bradcamp_title');}else{ the_title();}?> Details</li>
                  </ol>
               </nav>
            </div>
            <!-- Page Header Box End -->
         </div>
      </div>
   </div>
</div>
<!-- Page Header End -->
<!-- Page Service Single Start -->
<div class="page-service-single">
   <div class="container">
      <div class="row">
         <div class="col-lg-4">
            <!-- Page Single Sidebar Start -->
            <div class="page-single-sidebar">
               <!-- Page Category List Start -->
               <div class="page-catagery-list wow fadeInUp">
                  <h3>All <?php echo $parent_post_title;?></h3>
                  <ul>
                     <?php 
                        $args = array(
                          'post_type'      => 'page',
                          'posts_per_page' => -1,
                          'post_parent'    => $parent_id,
                          'order'          => 'ASC',
                          'orderby'        => 'menu_order'
                        );
                        $parent = new WP_Query( $args );
                        if ( $parent->have_posts() ) :
                          while ( $parent->have_posts() ) : $parent->the_post();?>
                     <li><a href="<?php the_permalink(); ?>"><span><?php the_title(); ?></span></a></li>
                     <?php endwhile; ?>
                     <?php endif; wp_reset_query(); ?>
                  </ul>
               </div>
               <!-- Page Category List End -->
               <!-- Sidebar Cta Box Start -->
               <div class="sidebar-cta-box wow fadeInUp" data-wow-delay="0.2s">
                  <!-- Sidebar CTA Image Start -->
                  <div class="sidebar-cta-image">
                     <figure>
                        <img src="<?php echo get_stylesheet_directory_uri();?>/images/sidebar-cta-bg.jpg" alt="">
                     </figure>
                  </div>
                  <!-- Sidebar CTA Image End -->
                  <!-- Sidebar CTA Content Start -->
                  <div class="sidebar-cta-content">
                     <!-- Sidebar CTA Item Start -->
                     <div class="sidebar-cta-item">
                        <!-- Icon Box Start -->
                        <div class="icon-box">
                           <img src="<?php echo get_stylesheet_directory_uri();?>/images/icon-hours.svg" alt="">
                        </div>
                        <!-- Icon Box End -->
                        <!-- Sidebar Cta Content Start -->
                        <div class="cta-item-content">
                           <h3>Opening Hours</h3>
                           <p>Monday - Friday (8am to 5pm)</p>
                           <p>Sunday - Closed</p>
                        </div>
                        <!-- Sidebar Cta Content End -->
                     </div>
                     <!-- Sidebar CTA Item End -->
                     <!-- Sidebar CTA Contact Start -->
                     <div class="sidebar-cta-contact">
                        <a href="tel: <?php echo html_entity_decode( get_option( 'option_8' ) );?>"><img src="<?php echo get_stylesheet_directory_uri();?>/images/icon-cta-phone.svg" alt=""> <?php echo html_entity_decode( get_option( 'option_8' ) );?></a>
                     </div>
                     <!-- Sidebar CTA Contact End -->
                  </div>
                  <!-- Sidebar CTA Content End -->
               </div>
               <!-- Sidebar Cta Box End -->
            </div>
            <!-- Page Single Sidebar End -->
         </div>
         <div class="col-lg-8">
            <!-- Service Single Content Start -->
            <div class="service-single-content">
               <!-- Page Single image Start -->
               <?php echo $content = apply_filters( 'the_content', get_post_field( 'post_content', $postID ) );?>
               <!-- Page Single image End -->
               <!-- Page Single FAQs start -->
               <?php if(have_rows('faqs_points',$postID)): ?>
               <div class="page-single-faqs">
                  <!-- Section Title Start -->
                  <div class="section-title">
                     <h2 class="text-anime-style-3" data-cursor="-opaque">Frequently asked question</h2>
                  </div>
                  <!-- Section Title End -->
                  <!-- FAQ Accordion Start -->
                  <div class="faq-accordion" id="accordion">
                     <?php $i=0; while(have_rows('faqs_points',$postID)): ?>
                     <?php the_row(); ?>
                     <!-- FAQ Item Start -->
                     <div class="accordion-item wow fadeInUp">
                        <h2 class="accordion-header" id="heading<?=$i?>">
                           <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?=$i?>" aria-expanded="true" aria-controls="collapse<?=$i?>">
                           <?php the_sub_field('question',$postID); ?>
                           </button>
                        </h2>
                        <div id="collapse<?=$i?>" class="accordion-collapse collapse <?php if($i==0){?> show <?php }?>" aria-labelledby="heading<?=$i?>" data-bs-parent="#accordion">
                           <div class="accordion-body">
                              <p><?php the_sub_field('answer',$postID); ?></p>
                           </div>
                        </div>
                     </div>
                     <!-- FAQ Item End -->
                     <?php $i++; endwhile; ?>
                  </div>
                  <!-- FAQ Accordion End -->
               </div>
               <!-- Page Single FAQs End -->
               <?php endif; ?>
            </div>
            <!-- Service Single Content End -->
         </div>
      </div>
   </div>
</div>
<!-- Page Service Single End -->
<?php get_footer(); ?>