<?php

if ( ! defined( 'ABSPATH' ) ) {  

  exit; // Exit if accessed directly 

} 

get_header();

$src = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' ); 

?>

<div class="main-content-area">

   <section id="home" style="padding: 0px;">

      <div class="container-fluid p-0">

         <div class="row">

            <div class="col">

               <p class="rs-p-wp-fix"></p>

               <rs-module-wrap id="rev_slider_1_1_wrapper" data-alias="home-slider-2" data-source="gallery">

                  <rs-module id="rev_slider_1_1" data-version="6.0.8">

                     <rs-slides>

                     <?php if(have_rows('banner')): ?>

                     <?php $i=0; while(have_rows('banner')): ?>

                     <?php the_row(); ?>                     

                        <rs-slide data-key="rs-<?=$i?>" data-title="Slide" data-anim="ei:d;eo:d;s:1000;r:0;t:fade;sl:0;">

                           <img src="<?php the_sub_field('image'); ?> " title="s1.jpg" class="rev-slidebg" data-no-retina>

                           <div class="slider_text">

                              <?php the_sub_field('content'); ?> 

                              <div class="d-flex">

                                 <a href="<?php echo esc_url( get_permalink(13) ); ?>" class="btn-theme-colored2">CONTACT US</a>  

                                 <a href="#" data-target="#login" data-toggle="modal" class="btn-theme-colored2">BOOK ONLINE</a> 

                              </div>

                           </div>

                        </rs-slide>

                        <?php $i++; endwhile; ?>

                        <?php endif; ?>

                     </rs-slides>

                     <rs-progress class="rs-bottom" style="visibility: hidden !important;"></rs-progress>

                  </rs-module>

               </rs-module-wrap>

            </div>

         </div>

      </div>

   </section>

   <section class="bg-white">

      <div class="container">

         <div class="section-content">

            <div class="row">

               <?php if(have_rows('second_section_points')): ?>

               <?php $i=0; while(have_rows('second_section_points')): ?>

               <?php the_row(); ?> 

                  <div class="col-md-6 col-lg-6 col-xl-3">

                     <div class="tm-sc tm-sc-icon-box icon-box icon-top tm-iconbox-icontype-font-icon iconbox-current-theme-style1 iconbox-style7-hover-moving-border bg-white iconbox-box-shadow iconbox-default-padding iconbox-centered-in-responsive iconbox-theme-colored1 icon-position-icon-top mb-lg-30">

                        <div class="icon-box-wrapper">

                           <div class="icon-wrapper">

                              <a class="icon icon-type-font-icon icon-default"><img src="<?php the_sub_field('image'); ?>" alt="Image"></a>

                           </div>

                           <div class="icon-text">

                              <?php the_sub_field('content'); ?>

                              <!--<div class="btn-view-details "><a target="_self" href class="btn btn-plain-text-with-arrow">Read more</a></div>-->

                           </div>

                           <div class="clearfix"></div>

                        </div>

                     </div>

                  </div> 

                  <?php $i++; endwhile; ?>

                  <?php endif; ?>

            </div>

         </div>

      </div>

   </section>

   <a href="tel:+16478711624">

      <section class="emergency_sec">

         <div class="container">

            <div class="row">

               <div class="col-md-12 col-lg-12 col-xl-12 text-center">

                  <h4>Emergency? Call us now  <?php echo html_entity_decode( get_option( 'option_8' ) );?></h4>

               </div>

            </div>

         </div>

      </section>

   </a>

   <section class="bg-no-repeat bg-img-center-bottom about" data-tm-bg-img="<?php echo get_stylesheet_directory_uri();?>/images/bg/1.png">

      <div class="container pt-0">

         <div class="section-content">

            <div class="row">

               <div class="col-sm-12 col-lg-7">

                  <?php the_field('third_section_content');?>

                  <a href="<?php echo esc_url( get_permalink(11) ); ?>" class="btn-theme-colored2 readmorebtn">READ MORE</a>

               </div>

               <div class="col-md-12 col-lg-5">

                  <div class="tm-sc tm-sc-animated-layer-images mb-lg-80">

                     <div class="layer-image "> <img src="<?php the_field('third_section_image');?>" alt="Image"></div>

                  </div>

               </div>

            </div>

         </div>

      </div>

   </section>

   <section class="bg-white-f5" data-tm-bg-img="<?php echo get_stylesheet_directory_uri();?>/images/bg/1c9.png">

      <div class="container pb-50">

         <div class="section-title">

            <div class="row justify-content-md-center">

               <div class="col-md-8">

                  <div class="text-center mb-60">

                     <div class="tm-sc tm-sc-section-title section-title section-title-style1 text-center bg-img-center bg-no-repeat line-bottom-style3-bordered-line">

                        <div class="title-wrapper">

                           <h2 class="title"> Step closer to justice </h2>

                           <div class="title-seperator-line"></div>

                           <div class="paragraph">

                              <p>Best law practices. Expertise in various law fields. Great results.</p>

                           </div>

                        </div>

                     </div>

                  </div>

               </div>

            </div>

         </div>

         <div class="section-content">

            <div class="row justify-content-center">

               <?php if(have_rows('forth_section_points')): ?>

               <?php $i=0; while(have_rows('forth_section_points')): ?>

               <?php the_row(); ?> 

                  <div class="col-md-12 col-lg-6 col-xl-4">

                     <div class="service-style1">

                        <div class="item-thumb">

                           <img src="<?php the_sub_field('image'); ?>" alt="service">

                        </div>

                        <div class="item-content">

                           <?php the_sub_field('content'); ?>

                           <hr>

                        </div>

                     </div>

                  </div>

                  <?php $i++; endwhile; ?>

                  <?php endif; ?>

            </div>

         </div>

      </div>

   </section>

   <section class="reviews_bg" style="background:url(images/bg/testimonialbg.jpeg) fixed">

      <div class="container pt-50 pb-80">

         <div class="section-title">

            <div class="row justify-content-md-center">

               <div class="col-md-8">

                  <div class="text-center">

                     <div class="tm-sc section-title section-title-style1 text-center bg-img-center bg-no-repeat">

                        <div class="title-wrapper">

                           <h2 class="title">Reviews From Clients</h2>

                        </div>

                     </div>

                  </div>

               </div>

            </div>

         </div>

         <div class="section-content">

            <div class="row">

               <div class="col-lg-12">

                  <div class="tm-sc tm-sc-services tm-sc-services-carousel services-style7-fullwidth-gallery owl-dots-light-skin owl-dots-center">

                     <div class="owl-carousel owl-theme tm-owl-carousel-2col" data-autoplay="true" data-loop="true">

                        <?php if(have_rows('testimonial')): ?>

                        <?php $i=0; while(have_rows('testimonial')): ?>

                        <?php the_row(); ?> 

                           <div class="tm-carousel-item">

                              <div class="tm-sc tm-sc-testimonials testimonial-style7-current-theme">

                                 <div class="tm-testimonial testimonials type-testimonials">

                                    <div class="testimonial-inner">

                                       <div class="testimonial-author-details">

                                          <div class="testimonial-header">

                                             <div class="author-text"><?php the_sub_field('content'); ?></div>

                                             <div class="testimonial-footer">

                                                <div class="author-info">

                                                   <h5 class="name"><?php the_sub_field('name'); ?></h5>

                                                </div>

                                             </div>

                                          </div>

                                       </div>

                                    </div>

                                 </div>

                              </div>

                           </div>

                           <?php $i++; endwhile; ?>

                           <?php endif; ?>

                        

                        <div class="tm-carousel-item">

                           <div class="tm-sc tm-sc-testimonials testimonial-style7-current-theme">

                              <div class="tm-testimonial testimonials type-testimonials">

                                 <div class="testimonial-inner">

                                    <div class="testimonial-author-details">

                                       <div class="testimonial-header">

                                          <div class="author-text">Maecenas temepus, telu eget condimen rhoncrus, sem qua semper libero, sit amet quam adipiscin sem neqe.</div>

                                          <div class="testimonial-footer">

                                             <div class="author-info">

                                                <h5 class="name">luis suárez</h5>

                                             </div>

                                          </div>

                                       </div>

                                    </div>

                                 </div>

                              </div>

                           </div>

                        </div>

                     </div>

                  </div>

               </div>

            </div>

         </div>

      </div>

   </section>

   <section data-tm-bg-img="<?php echo get_stylesheet_directory_uri();?>/images/bg/1c9.png" id="blog_sec">

      <div class="container">

         <div class="section-title">

            <div class="row justify-content-md-center">

               <div class="col-md-8">

                  <div class="text-center mb-60">

                     <div class="tm-sc tm-sc-section-title section-title section-title-style1 text-center bg-img-center bg-no-repeat line-bottom-style3-bordered-line">

                        <div class="title-wrapper">

                           <h2 class="title">Find out about activities on our blog</h2>

                           <div class="title-seperator-line"></div>

                        </div>

                     </div>

                  </div>

               </div>

            </div>

         </div>

         <div class="section-content">

            <div class="row">

               <?php echo do_shortcode('[BP_HOME_BLOG]');?>

            </div>

         </div>

      </div>

   </section>

</div>

<?php get_footer();?>

