<?php
/**
 * Author: Ranjan deb
 *
 */
if (!function_exists('BP_setup')):
    function BP_setup() {

        add_theme_support('title-tag');
        add_theme_support('post-thumbnails');
        set_post_thumbnail_size(825, 510, true);
        register_nav_menus(array('primary' => __('Header Menu', 'BP'),'quick_link_menu' => __('Quick Link Menu', 'BP'),'footer_service' => __('Footer Menu', 'BP')));
        add_theme_support('custom-logo', array('height' => 300, 'width' => 300, 'flex-height' => true,));
        add_theme_support(
            'post-formats',
            array(
                'link',
                'aside',
                'gallery',
                'image',
                'quote',
                'status',
                'video',
                'audio',
                'chat',
            )
        );

        add_theme_support(
            'html5',
            array(
                'comment-form',
                'comment-list',
                'gallery',
                'caption',
                'style',
                'script',
                'navigation-widgets',
            )
        );

        $logo_width  = 300;
        $logo_height = 300;
        add_theme_support(
            'custom-logo',
            array(
                'height'               => $logo_height,
                'width'                => $logo_width,
                'flex-width'           => true,
                'flex-height'          => true,
                'unlink-homepage-logo' => true,
            )
        );
        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );
        // Add support for Block Styles.
        add_theme_support( 'wp-block-styles' );
        // Add support for full and wide align images.
        add_theme_support( 'align-wide' );
    }
endif;
add_action('after_setup_theme', 'BP_setup');


require_once ('inc-BP/navwalker-functions.php');
require_once ('inc-BP/bs4navwalker.php');
require_once ('inc-BP/wordpress-extrafeatures-fuctions.php');
//require_once ('custom-posts/custom-staff.php');
//require_once ('custom-posts/custom-testimonial.php');


@ini_set( 'upload_max_size' , '6400M' );
@ini_set( 'post_max_size', '6400M');
@ini_set( 'max_execution_time', '30000' );

/**
* For Home Video
* =========
*
*/
add_shortcode( 'BP_HOME_VIDEO', 'BP_HOME_VIDEO_list' );

function BP_HOME_VIDEO_list($atts = array(), $content = '', $post_id = '' ) {
    if(have_rows('fifth_section_videos')):
        $i=0; while(have_rows('fifth_section_videos')):
             the_row();       
?>
        <figure class="item videobox">
             <div class="videobox">
                <!--<img class="videopic" src="<?php echo get_stylesheet_directory_uri();?>/images/Rectangle10.jpg" alt=""/>-->
                <iframe width="100%" height="270px" src="<?php the_sub_field('video_link'); ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
             </div>
             <div class="video_con">
                <h4><?php the_sub_field('video_title'); ?></h4>
                <p><img src="<?php the_sub_field('country_flag'); ?>"></p>
             </div>
        </figure>
<?php
        $i++; endwhile;wp_reset_postdata();
    endif;


}

/**
* For Service Video
* =========
*
*/
add_shortcode( 'BP_VIDEO', 'BP_VIDEO_list' );

function BP_VIDEO_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
<section id="testimonials" class="testimonialarea">
   <div class="container">
      <!-- Title row end -->
      <div class="row">
         <div id="video-carousel" class="col-sm-12 owl-carousel owl-theme text-center">
           
         </div>
         <!--/ Owl carousel end -->
      </div>
      <!--/ Content row end -->
   </div>
   <!--/ Container end -->
</section>
<?php
}


/**
* For HOW IT WORKS
* =========
*
*/
add_shortcode( 'BP_HOW_IT_WORKS', 'BP_HOW_IT_WORKS_list' );

function BP_HOW_IT_WORKS_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
            <?php
                $args = array ( 
                    'post_type'      => 'my_how_it_works',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
           ?>

              <div class="col-lg-4">
                  <div
                    class="process-item mb-65 wow fadeInUp"
                    data-wow-delay=".2s"
                  >
                    <div class="text">
                      <span class="step"><?php echo $i;?></span>
                      <h4><?php echo get_the_title();?></h4>
                    </div>
                  </div>
                </div>

           <?php
               $i++;
              }
            }wp_reset_postdata();
            ?>
<?php
}


/**
* For About Page Team
* =========
*
*/
add_shortcode( 'BP_ABOUT_US_TEAM', 'BP_ABOUT_US_TEAM_list' );

function BP_ABOUT_US_TEAM_list($atts = array(), $content = '', $post_id = '' ) {
        
?>

<div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-8">
            <div class="section-title text-center mb-55 wow fadeInUp">
              <span class="sub-title st-one"><?php the_field('team_title',7); ?></span>
              <?php the_field('team_big_title',7); ?>
              <p><?php the_field('team_content',7); ?></p>
            </div>
          </div>
        </div>
        <div class="row">
          <?php
                $args = array ( 
                    'post_type'      => 'my_team',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => 4
                );
                $query = new WP_Query($args);
                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
           ?>
                <div class="col-lg-3 col-md-6 col-sm-12">
                  <div class="team-item mb-55 wow fadeInUp" data-wow-delay=".2s">
                    <div class="img-holder">
                      <img src="<?php echo $img_url;?>" alt="" />
                    </div>
                    <div class="text text-center">
                      <ul class="social-link">
                        <li>
                          <a href="<?php the_field('facebook_link'); ?>"><i class="fab fa-facebook-f"></i></a>
                        </li>
                        <li>
                          <a href="<?php the_field('dribbble_link'); ?>"><i class="fab fa-dribbble"></i></a>
                        </li>
                        <li>
                          <a href="<?php the_field('twitter_link'); ?>"><i class="fab fa-twitter"></i></a>
                        </li>
                      </ul>
                      <h4><a href="team.html"><?php echo get_the_title();?></a></h4>
                      <p class="position"><?php echo get_the_excerpt();?></p>
                    </div>
                  </div>
                </div>
            <?php
               $i++;
              }
            }wp_reset_postdata();
            ?>
        </div>
      </div>
<?php
}

/**
* For About Page Testimonial form
* =========
*
*/
add_shortcode( 'BP_ABOUT_US_TESTIMONIALS', 'BP_ABOUT_US_TESTIMONIALS_list' );

function BP_ABOUT_US_TESTIMONIALS_list($atts = array(), $content = '', $post_id = '' ) {
        
?>

      <div class="container">
        <div class="row">
          <div class="col-lg-8">
            <div class="section-title section-title-white mb-55 wow fadeInLeft">
              <span class="sub-title st-one"><?php the_field('testimonial_title',5); ?></span>
              <?php the_field('testimonial_big_title',5); ?>
              <?php the_field('testimonial_content',5); ?>
            </div>
          </div>
        </div>
        <div class="testimonial-slider-three">
          <?php
                $args = array ( 
                    'post_type'      => 'my_testimonial',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
           ?>
                <div class="testimonial-item mb-55 wow fadeInUp">
                  <div class="author-thumb">
                    <img src="<?php echo $img_url;?>" alt="" />
                  </div>
                  <div class="testimonial-content">
                    <?php echo get_the_content();?>
                    <div class="author-quote-title d-flex">
                      <div class="author-title">
                        <h4><?php echo get_the_title();?></h4>
                        <p class="position"><?php echo get_the_excerpt();?></p>
                      </div>
                    </div>
                  </div>
                </div>
           <?php
               $i++;
              }
            }wp_reset_postdata();
            ?>
        </div>
      </div>
<?php
}

/**
* For Home Testimonial form
* =========
*
*/
add_shortcode( 'BP_HOME_TESTIMONIALS', 'BP_HOME_TESTIMONIALS_list' );

function BP_HOME_TESTIMONIALS_list($atts = array(), $content = '', $post_id = '' ) {
        
?>

<div class="container">
        <div class="row">
          <div class="col-lg-8">
            <div class="section-title section-title-white mb-50 wow fadeInLeft">
              <span class="sub-title st-one"><?php the_field('testimonial_title',5); ?></span>
              <?php the_field('testimonial_big_title',5); ?>
              <?php the_field('testimonial_content',5); ?>
            </div>
          </div>
        </div>
        <div class="row align-items-center">
          <div class="col-lg-12">
            <div class="testimonial-slider-one mb-50 wow fadeInRight">
              <?php
                $args = array ( 
                    'post_type'      => 'my_testimonial',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
              ?>
                  <div class="testimonial-item">
                    <div class="testimonial-content">
                      <div class="testimonial-imagecontainer">
                        <div class="testimonial-imagecontainertemp">
                          <img src="<?php echo $img_url;?>" alt="" />
                        </div>
                        <h3>
                          <?php echo get_the_content();?>
                        </h3>
                      </div>
                      <div class="author-title">
                        <h4><?php echo get_the_title();?></h4>
                        <p class="position"><?php echo get_the_excerpt();?></p>
                      </div>
                    </div>
                  </div>
              <?php
                 $i++;
                }
              }wp_reset_postdata();
              ?>
            </div>
          </div>
        </div>
      </div>
<?php
}

/**
* For Contact US Form
* =========
*
*/
add_shortcode( 'BP_CONTACT_US_FORM', 'BP_CONTACT_US_FORM_list' );

function BP_CONTACT_US_FORM_list() {
        
?>
<section class="contact-area contact-area-v3 pt-130 pb-130">
   <div class="container-1350">
      <div class="contact-wrapper light-gray-bg pt-80 pb-80 wow fadeInUp">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-lg-7">
                  <div class="section-title text-center mb-55">
                     <span class="sub-title st-one"><?php the_field('second_section_short_title',13); ?></span>
                     <h2><?php the_field('second_section_big_title',13); ?></h2>
                  </div>
               </div>
            </div>
            <div class="row">
               <div class="col-lg-12">
                  <div class="contact-form">
                     <?php echo do_shortcode('[contact-form-7 id="42" title="Contact Form"]');?>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>
<?php
wp_reset_postdata();
}


/**
* For Home Team
* =========
*
*/
add_shortcode( 'BP_HOME_TEAM', 'BP_HOME_TEAM_list' );

function BP_HOME_TEAM_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
          <?php
                $args = array ( 
                    'post_type'      => 'my_team',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC', 
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                

                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
                    //$the_cat = get_the_category(get_the_ID());
                    //$cat_name = $the_cat[0]->name;
              ?>
              <div class="col-md-3 trainer-block">
                <div class="trainer-pic zoom-pic"> <a href="<?php the_permalink();?>"> <img src="<?php echo $img_url;?>" alt="" class="img-responsive"></a></div>
                <div class="trainer-caption">
                  <h2><a href="<?php the_permalink();?>" class="trainer-title"><?php echo get_the_title();?></a></h2>
                  <span class="trainer-meta"><?php echo get_the_excerpt();?></span> </div>
              </div>
              <?php
                 $i++;
                }
              }wp_reset_postdata();
              ?>
<?php
}

/**
 * For TEAM 
 * =========
 *
 */
     
add_shortcode( 'BP_TEAM', 'BP_TEAM_list' );

function BP_TEAM_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'our-staff',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => $posts_per_page
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>
        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                <div class="team_con">
                  <div class="box">
                    <img src="<?php echo $img_url; ?>">
                  </div>
                  <h3 class="title"><?php echo get_the_title();?></h3>
                  <h4>(<?php echo get_the_excerpt();?>)</h4>
          <a href="<?php the_permalink();?>" class="readmore">Read More</a>
                </div>
        </div>
           
<?php
    $i++;
    }
    ?>
    <div class="col-lg-12"><nav class="pagination">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</nav></div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }


/**
 * For Condition 
 * =========
 *
 */
     
add_shortcode( 'BP_CONDITION', 'BP_CONDITION_list' );

function BP_CONDITION_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'conditions',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => 6
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
            <div class="service-item hvr-float-shadow">
               <img src="<?php echo $img_url; ?>" alt="">
               <div class="down-content">
                  <h4><?php echo get_the_title();?></h4>
                  <p><?php echo get_the_excerpt();?></p>
                  <a href="<?php the_permalink();?>" class="filled-button">Read More</a>
               </div>
            </div>
         </div>
<?php
     $i++;
    }
  }wp_reset_postdata();
  
}
/**
 * For Conditions
 * =========
 *
 */
     
add_shortcode( 'BP_LOWER_CONDITIONS', 'BP_LOWER_CONDITIONS_list' );

function BP_LOWER_CONDITIONS_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'conditions',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => $posts_per_page
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
          <div class="item hvr-push">
                  <div class="service-item hvr-float-shadow">
              <img src="<?php echo $img_url; ?>" alt="">
              <div class="down-content">
                <h4><?php echo get_the_title();?></h4>
                <p><?php echo get_the_excerpt();?></p>
                <a href="<?php the_permalink();?>" class="filled-button">Read More</a>
              </div>
             </div>
            </div>
<?php
     $i++;
    }
  }wp_reset_postdata();
  
}

/**
 * For ALL CONDITIONS
 * =========
 *
 */
     
add_shortcode( 'BP_ALL_CONDITIONS', 'BP_ALL_CONDITIONS_list' );

function BP_ALL_CONDITIONS_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'conditions',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
            <div class="service-item hvr-float-shadow">
              <img src="<?php echo $img_url; ?>" alt="">
              <div class="down-content">
                <h4><?php echo get_the_title();?></h4>
                <?php echo get_the_excerpt();?>
                <a href="<?php the_permalink();?>" class="filled-button">Read More</a>
              </div>
            </div>
      </div>
<?php
     $i++;
    }
  }wp_reset_postdata();
  
}

/**
 * For Services 
 * =========
 *
 */
     
add_shortcode( 'BP_Services', 'BP_Services_list' );

function BP_Services_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'services',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => $posts_per_page
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
          <div class="item hvr-push">
                  <div class="service-item hvr-float-shadow">
              <img src="<?php echo $img_url; ?>" alt="">
              <div class="down-content">
                <h4><?php echo get_the_title();?></h4>
                <p><?php echo get_the_excerpt();?></p>
                <a href="<?php the_permalink();?>" class="filled-button">Read More</a>
              </div>
             </div>
            </div>
<?php
     $i++;
    }
  }wp_reset_postdata();
  
}

/**
 * For Home Services
 * =========
 *
 */
     
add_shortcode( 'BP_HOME_Services', 'BP_HOME_Services_list' );

function BP_HOME_Services_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'services',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>

        <div class="service-block-one overlay-box">
                    <figure class="image-box">
                        <img src="<?php echo $img_url; ?>" alt="">
                        <div class="overlay">
                            <div class="wrapper">
                                <ul class="list">
                                    <li><a href="<?php the_permalink();?>"><i class="fa fa-link"></i></a></li>
                                </ul>
                            </div>                                    
                        </div>
                    </figure>
                    <div class="lower-content">
                        <h3><a href="<?php the_permalink();?>"><?php echo get_the_title();?></a></h3>
                        <div class="text"><?php echo get_the_excerpt();?></div>
                        <div class="link"><a href="<?php the_permalink();?>" class="btn-style-two">More Details</a></div>
                    </div>
                </div>
<?php
     $i++;
    }
  }wp_reset_postdata();
  
}


/**
 * For ALL Services
 * =========
 *
 */
     
add_shortcode( 'BP_ALL_Services', 'BP_ALL_Services_list' );

function BP_ALL_Services_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'services',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
            <div class="service-item hvr-float-shadow">
              <img src="<?php echo $img_url; ?>" alt="">
              <div class="down-content">
                <h4><?php echo get_the_title();?></h4>
                <?php echo get_the_excerpt();?>
                <a href="<?php the_permalink();?>" class="filled-button">Read More</a>
              </div>
            </div>
      </div>
<?php
     $i++;
    }
  }wp_reset_postdata();
  
}

/**
* For Footer Blog
* =========
*
*/
add_shortcode( 'BP_Footer_BLOG', 'BP_Footer_BLOG_list' );

function BP_Footer_BLOG_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
          <?php
                $args = array ( 
                    'post_type'      => 'post',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => 3
                );
                $query = new WP_Query($args);
                

                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
                    $the_cat = get_the_category(get_the_ID());
                    $cat_name = $the_cat[0]->name;
              ?>
              <article class="post media-post clearfix">
                        <div class="post-right">
                           <h6 class="post-title"> <a href="<?php the_permalink();?>"><?php echo get_the_title();?> </a> </h6>
                           <span class="post-date">
                           <time class="entry-date"><?php echo get_the_date( 'D M j' );?></time>
                           </span>
                        </div>
                     </article>
              <?php
                 $i++;
                }
              }wp_reset_postdata();
              ?>
<?php
}




/**
* For Home Blog
* =========
*
*/
add_shortcode( 'BP_HOME_BLOG', 'BP_HOME_BLOG_list' );

function BP_HOME_BLOG_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
          <?php
                $args = array ( 
                    'post_type'      => 'post',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                

                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
                    $the_cat = get_the_category(get_the_ID());
                    $cat_name = $the_cat[0]->name;
              ?>
              <div class="col-lg-4 col-md-6">
            <!-- Post Item Start -->
            <div class="post-item wow fadeInUp" data-wow-delay="0.4s">
              <!-- Post Featured Image Start-->
              <div class="post-featured-image">
                <a href="<?php the_permalink();?>" data-cursor-text="View">
                  <figure class="image-anime">
                    <img src="<?php the_field('front_image');?>" alt="">
                  </figure>
                </a>
              </div>
              <!-- Post Featured Image End -->
              <!-- Post Item Body Start -->
              <div class="post-item-body">
                <!-- Post Item Content Start -->
                <div class="post-item-content">
                  <h2>
                    <a href="<?php the_permalink();?>"><?php echo get_the_title();?></a>
                  </h2>
                </div>
                <!-- Post Item Content End -->
                <!-- Post Item Readmore Button Start-->
                <div class="post-item-btn">
                  <a href="<?php the_permalink();?>" class="readmore-btn">read more</a>
                </div>
                <!-- Post Item Readmore Button End-->
              </div>
              <!-- Post Item Body End -->
            </div>
            <!-- Post Item End -->
          </div>
              <?php
                 $i++;
                }
              }wp_reset_postdata();
              ?>
<?php
}

/**
 * For Blog 
 * =========
 *
 */
     
add_shortcode( 'BP_blog', 'BP_blog_list' );

function BP_blog_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => '12'
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $args = array ( 
    'post_type'      => array( 'post' ), 
    'orderby'        => 'post_date', 
    'order'          => 'DESC',
    'posts_per_page' => $posts_per_page,
    'paged' => $paged
    ); 

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>
    <div class="col-lg-4 col-md-6">
            <!-- Post Item Start -->
            <div class="post-item wow fadeInUp" data-wow-delay="0.4s">
               <!-- Post Featured Image Start-->
               <div class="post-featured-image">
                  <a href="<?php the_permalink();?>" data-cursor-text="View">
                     <figure class="image-anime">
                        <img src="<?php the_field('front_image');?>" alt="">
                     </figure>
                  </a>
               </div>
               <!-- Post Featured Image End -->
               <!-- Post Item Body Start -->
               <div class="post-item-body">
                  <!-- Post Item Content Start -->
                  <div class="post-item-content">
                     <h2><a href="<?php the_permalink();?>"><?php echo get_the_title();?></a></h2>
                  </div>
                  <!-- Post Item Content End -->
                  <!-- Post Item Readmore Button Start-->
                  <div class="post-item-btn">
                     <a href="<?php the_permalink();?>" class="readmore-btn">read more</a>
                  </div>
                  <!-- Post Item Readmore Button End-->
               </div>
               <!-- Post Item Body End -->
            </div>
            <!-- Post Item End -->
         </div>
<?php
    $i++;
    }
    ?>
    <div class="col-lg-12"><nav class="pagination">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</nav></div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }





/**
* For Home Reviews
* =========
*
*/
add_shortcode( 'BP_HOME_REVIEWS', 'BP_HOME_REVIEWS_list' );

function BP_HOME_REVIEWS_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
          <?php
                $args = array ( 
                    'post_type'      => 'my_testimonial',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                

                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
                    $the_cat = get_the_category(get_the_ID());
                    $cat_name = $the_cat[0]->name;
              ?>
              <div class="item wow fadeInUp" data-wow-duration="1500ms" data-wow-delay="00ms">
                        <div class="testimonial-card @@extraClassName">
                            <p class="testimonial-card__text"><?php the_content();?></p>
                            <!-- /.testimonial-card__text -->
                            <div class="testimonial-card__info">
                                <div class="testimonial-card__inner">
                                    <h4 class="testimonial-card__name"><?php the_title();?></h4><!-- /.testimonial-card__name -->
                                    <span class="testimonial-card__designation"><?php the_excerpt();?></span><!-- /.testimonial-card__designation -->
                                </div><!-- /.testimonial-card__inner -->
                                <svg class="testimonial-card__quote" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 38" fill="none">
                                    <path d="M0 23.7248H10.3849L3.46157 37.5713H13.8465L20.7698 23.7248V2.95508H0V23.7248Z" />
                                    <path d="M27.6929 2.95508V23.7248H38.0778L31.1544 37.5713H41.5393L48.4626 23.7248V2.95508H27.6929Z" />
                                    <path d="M13.34 20.2698H3.45508V0.5H23.2248V20.6517L16.4925 34.1162H7.22567L13.7872 20.9934L14.149 20.2698H13.34Z" />
                                    <path d="M41.0328 20.2698H31.1479V0.5H50.9177V20.6517L44.1854 34.1162H34.9185L41.48 20.9934L41.8419 20.2698H41.0328Z" />
                                </svg><!-- /.testimonial-card__quote -->
                            </div><!-- /.testimonial-card__info -->                            
                            <img src="<?php echo get_stylesheet_directory_uri();?>/assets/images/shapes/testimonials-card-shape-1-1.png" alt="shape" class="testimonial-card__shape">
                        </div><!-- /.testimonial-card -->
                    </div>
              <?php
                 $i++;
                }
              }wp_reset_postdata();
              ?>
<?php
}

/**
 * For Reviews 
 * =========
 *
 */
     
add_shortcode( 'BP_REVIEWS', 'BP_REVIEWS_list' );

function BP_REVIEWS_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => '20'
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $args = array ( 
    'post_type'      => 'my_testimonial', 
    'orderby'        => 'post_date', 
    'order'          => 'DESC',
    'posts_per_page' => $posts_per_page,
    'paged' => $paged
    ); 

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>

    <div class="col-lg-6 col-md-12 col-sm-12 col-12"> 
        <div class="testimonial-card testimonial-card--two">
            <div class="testimonial-card__info">
                <div class="testimonial-card__inner">
                    <h4 class="testimonial-card__name"><?php the_title();?></h4><!-- /.testimonial-card__name -->
                    <span class="testimonial-card__designation"><?php the_excerpt();?></span><!-- /.testimonial-card__designation -->
                </div><!-- /.testimonial-card__inner -->
                <svg class="testimonial-card__quote" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 38" fill="none">
                    <path d="M0 23.7248H10.3849L3.46157 37.5713H13.8465L20.7698 23.7248V2.95508H0V23.7248Z" />
                    <path d="M27.6929 2.95508V23.7248H38.0778L31.1544 37.5713H41.5393L48.4626 23.7248V2.95508H27.6929Z" />
                    <path d="M13.34 20.2698H3.45508V0.5H23.2248V20.6517L16.4925 34.1162H7.22567L13.7872 20.9934L14.149 20.2698H13.34Z" />
                    <path d="M41.0328 20.2698H31.1479V0.5H50.9177V20.6517L44.1854 34.1162H34.9185L41.48 20.9934L41.8419 20.2698H41.0328Z" />
                </svg><!-- /.testimonial-card__quote -->
            </div><!-- /.testimonial-card__info -->
            <p class="testimonial-card__text"><?php the_content();?></p>
            <!-- /.testimonial-card__text -->
        </div><!-- /.testimonial-card -->
      </div>
<?php
    $i++;
    }
    ?>
    <div class="col-lg-12"><nav class="pagination">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</nav></div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }
    

add_shortcode( 'BP_OUR_TEAM', 'BP_OUR_TEAM_list' );

function BP_OUR_TEAM_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => '20'
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $args = array ( 
    'post_type'      => 'our-staff', 
    'orderby'        => 'post_date', 
    'order'          => 'DESC',
    'posts_per_page' => $posts_per_page,
    'paged' => $paged
    ); 

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>

    <div class="col-lg-4 col-md-6 col-sm-12 col-12">
                        <a href="<?php the_permalink();?>"><div class="therapist-card wow fadeInUp">
                            <div class="therapist-card__image">
                                <div class="therapist-card__image__link">
                                    <img src="<?php echo $img_url;?>" alt="Mike Hardson">
                                </div><!-- /.therapist-card__image__link -->
                                <div class="therapist-card__hover">
                                    <!-- /.social-links -->
                                    <div class="therapist-card__identity">
                                        <div class="therapist-card__identity__inner">
                                            <h3 class="therapist-card__name"><?php the_title();?></h3>
                                            <!-- /.therapist-card__name -->
                                            <span class="therapist-card__designation"><?php the_excerpt();?></span><!-- /.therapist-card__designation -->
                                        </div><!-- /.therapist-card__identity__inner -->
                                    </div><!-- /.therapist-card__identity -->
                                </div><!-- /.therapist-card__hover -->
                            </div><!-- /.therapist-card__image -->
                        </div></a><!-- /.therapist-card -->
                    </div><!-- /.col-lg-4 col-md-6 -->
<?php
    $i++;
    }
    ?>
    <div class="col-lg-12"><nav class="pagination">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</nav></div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }
    
/**
* For LOwer Section Page
* =========
*
*/
add_shortcode( 'BP_LOWER_SECTION', 'BP_LOWER_SECTION_list' );

function BP_LOWER_SECTION_list() {
       
?>

<!-- Start Contact Section  -->
    <div class="contact-area section-padding pt-0">
        <div class="container">
            <div class="contact-section-inner">
                <div class="contact-section-content">
                    <h2 class="text-white"><?php the_field('eleven_section_title',7);?></h2>
                    <h5 class="text-white"><?php the_field('eleven_section_title_2',7);?></h5>
                    <a href="<?php the_field('eleven_section_link',7);?>" class="main-btn"><?php the_field('eleven_section_title_3',7);?></a>
                </div>                
            </div>
        </div>
        
    </div>
     <!-- Contact Section End  -->

<?php
}

function contact_form_login_redirect() {
    ?>
    <script>
        document.addEventListener( 'wpcf7mailsent', function ( event ) {
            location = 'https://convirzon.ca/Client/revivephysiotherapist/thank-you/';
        }, false );
    </script>

    <?php
}

//add_action( 'wp_footer', 'contact_form_login_redirect' );


/**
 * For products 
 * =========
 *
 */
     
add_shortcode( 'BP_Products', 'BP_Product_list' );

function BP_Product_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => '12'
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $args = array ( 
    'post_type'      => array( 'page' ),
    'post_parent'    => 19,
    'orderby'        => 'post_date', 
    'order'          => 'DESC',
    'posts_per_page' => $posts_per_page,
    'paged' => $paged
    ); 

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>
                    <article class="pbmit-portfolio-style-1 col-md-4">
                        <a href="<?php the_permalink();?>"><div class="pbminfotech-post-content">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="<?php echo $img_url; ?>" class="img-fluid" alt="">
                                    </div>
                                </div>
                                <div class="pbminfotech-box-content">
                                    <div class="pbminfotech-titlebox">
                                        <!-- <div class="pbmit-port-cat">
                                            <a href="#" rel="tag">Back Pain</a>
                                            , <a href="#" rel="tag"> Elbow Pain</a>
                                            , <a href="#" rel="tag"> Hand Pain</a>
                                        </div> -->
                                        <h3 class="pbmit-portfolio-title">
                                            <a href="<?php the_permalink();?>"><?php echo get_the_title();?></a>
                                        </h3>
                                    </div>
                                </div>
                            </div></a>
                    </article>
<?php
    $i++;
    }
    ?>
    <div class="col-lg-12"><nav class="pagination">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</nav></div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }


/**
 * For How We Treat 
 * =========
 *
 */
     
add_shortcode( 'BP_how_we_treat', 'BP_how_we_treat_list' );

function BP_how_we_treat_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => '12'
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $args = array ( 
    'post_type'      => array( 'page' ),
    'post_parent'    => 17,
    'orderby'        => 'post_date', 
    'order'          => 'DESC',
    'posts_per_page' => $posts_per_page,
    'paged' => $paged
    ); 

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>

    <div class="col-sm-12 col-md-6 col-lg-6 pad-top-bot">
                  <div class="card service-outer">
                     <div class="service-img">
                        <img class="card-img-top" src="<?php echo $img_url; ?>" alt="Service image cap">
                        <div class="card-icon pad"><img src="<?php echo get_stylesheet_directory_uri();?>/assets/images/help/our-services/icon3.png" alt="service icon"></div>
                     </div>
                     <div class="card-body service-body bg2">
                        <h5 class="card-title"><?php echo get_the_title();?></h5>
                        <p class="card-text"><?php the_field('short_note');?> </p>
                        <a href="<?php the_permalink();?>" class="btn btn-primary btn-dark btn-dark-animated btn-link">Read More</a>
                     </div>
                  </div>
               </div>
<?php
    $i++;
    }
    ?>
    <div class="col-lg-12"><nav class="pagination">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</nav></div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }


/**
 * For What We Treat 
 * =========
 *
 */
     
add_shortcode( 'BP_what_we_treat', 'BP_what_we_treat_list' );

function BP_what_we_treat_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => '12'
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $args = array ( 
    'post_type'      => array( 'page' ),
    'post_parent'    => 200,
    'orderby'        => 'post_date', 
    'order'          => 'DESC',
    'posts_per_page' => $posts_per_page,
    'paged' => $paged
    ); 

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>
                    <div class="col-sm-12 col-md-6 col-lg-6 pad-top-bot">
                  <div class="card service-outer">
                     <div class="service-img">
                        <img class="card-img-top" src="<?php echo $img_url; ?>" alt="Service image cap">
                        <div class="card-icon pad"><img src="<?php echo get_stylesheet_directory_uri();?>/assets/images/help/our-services/icon3.png" alt="service icon"></div>
                     </div>
                     <div class="card-body service-body bg2">
                        <h5 class="card-title"><?php echo get_the_title();?></h5>
                        <p class="card-text"><?php the_field('short_note');?> </p>
                        <a href="<?php the_permalink();?>" class="btn btn-primary btn-dark btn-dark-animated btn-link">Read More</a>
                     </div>
                  </div>
               </div>
<?php
    $i++;
    }
    ?>
    <div class="col-lg-12"><nav class="pagination">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</nav></div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }



 /**
 * For Home Page How We Treat 
 * =========
 *
 */
     
add_shortcode( 'BP_home_how_we_treat', 'BP_home_how_we_treat_list' );

function BP_home_how_we_treat_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => '12'
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $args = array ( 
    'post_type'      => array( 'page' ),
    'post_parent'    => 17,
    'orderby'        => 'post_date', 
    'order'          => 'DESC',
    'posts_per_page' => $posts_per_page,
    'paged' => $paged
    ); 

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>

        <div class="swiper-slide">                           
          <!-- Slide1 -->
          <article class="pbmit-service-style-1">
             <div class="pbminfotech-post-item">
                <div class="pbmit-featured-img-wrapper">
                   <div class="pbmit-featured-wrapper">
                      <img src="<?php echo $img_url; ?>" class="img-fluid" alt="">
                   </div>
                </div>
                <div class="pbminfotech-box-content">
                   <div class="pbmit-box-content-inner d-flex justify-content-between align-items-center">
                      <div class="pbmit-cat-title">
                         <h3 class="pbmit-service-title"><a href="<?php the_permalink();?>"><?php echo get_the_title();?></a></h3>
                      </div>
                      <div class="pbmit-service-icon-wrapper">
                         <i class="pbmit-physiofy-icon pbmit-physiofy-icon-pain-3"></i>       
                      </div>
                   </div>
                   <div class="pbmit-service-description">
                      <?php the_field('short_text');?>          
                   </div>
                </div>
                <div class="pbmit-service-btn">
                   <a href="<?php the_permalink();?>"><i class="pbmit-physiofy-icon pbmit-physiofy-icon-up-right-arrow"></i></a>
                </div>
                <div class="pbmit-feature-circle">
                   <div class="pbmit-featured-img-wrapper">
                      <div class="pbmit-featured-wrapper">
                         <img src="<?php echo $img_url; ?>" class="img-fluid" alt="">
                      </div>
                   </div>
                </div>
                <a class="pbmit-link" href="<?php the_permalink();?>"></a>
             </div>
          </article>
       </div>
<?php
    $i++;
    }
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }   
    
    