<?php
/*
* Template Name: Service_Detail Page
*/
?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'thumbnail' );
   if($url != "")
   {
   $img = $url; 
   }else{
   $img = $template_url."/assets/img/bg/breadcumb-bg.jpg";
   }
?>
<?php $postID = get_queried_object_id();
$parent_id = $post->post_parent;
?>
  
    <div class="breadcumb-wrapper" data-bg-src="<?php echo $img;?>">
        <div class="container">
            <div class="breadcumb-content">
                <h1 class="breadcumb-title"><?php the_title(); ?> </h1>
                <ul class="breadcumb-menu">
                    <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                    <li><?php the_title(); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <section class="space-top space-extra-bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-8 col-lg-8">
                    <div class="page-single mb-30">
                        <div class="page-img"><img src="<?php the_field('front_image');?>" alt="Service Image"></div>
                        <div class="page-content">
                            <h2 class="page-title"><?php the_title(); ?></h2>
                            <?PHP the_content();?>
                            
                            <?php the_field('service_faq_repeter_content');?>
                            <div class="accordion mt-40" id="faqAccordion">
                                <?php if (have_rows('service_faq_repeter')): ?>
    <div class="accordion" id="faqAccordion">
        <?php $i = 0; while (have_rows('service_faq_repeter')): the_row(); ?>
            <?php 
                $is_first = ($i === 0); // Check if it's the first item
                $collapse_id = 'collapse-' . $i;
                $header_id = 'collapse-item-' . $i;
            ?>
            <div class="accordion-card">
                <div class="accordion-header" id="<?php echo esc_attr($header_id); ?>">
                    <button class="accordion-button <?php echo $is_first ? '' : 'collapsed'; ?>" 
                        type="button" 
                        data-bs-toggle="collapse" 
                        data-bs-target="#<?php echo esc_attr($collapse_id); ?>" 
                        aria-expanded="<?php echo $is_first ? 'true' : 'false'; ?>" 
                        aria-controls="<?php echo esc_attr($collapse_id); ?>">
                        <?php the_sub_field('question'); ?>
                    </button>
                </div>
                <div id="<?php echo esc_attr($collapse_id); ?>" 
                    class="accordion-collapse collapse <?php echo $is_first ? 'show' : ''; ?>" 
                    aria-labelledby="<?php echo esc_attr($header_id); ?>" 
                    data-bs-parent="#faqAccordion">
                    <div class="accordion-body">
                        <p class="faq-text"><?php the_sub_field('answer'); ?></p>
                    </div>
                </div>
            </div>
        <?php $i++; endwhile; ?>
    </div>
<?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-lg-4">
                    <aside class="sidebar-area">
                        
                        <div class="widget widget_categories">
                            <h3 class="widget_title">Our Related Services</h3>
                            <ul>
                                   <?php
                    $args = array(
                        'post_type'      => 'page',
                        'posts_per_page' => -1,
                        'post_parent'    => 11,
                        'order'          => 'DESC',
                        'orderby'        => 'menu_order'
                    );
                    $query = new WP_Query($args);

                    if ($query->have_posts()) {
                        $i = 1;
                    ?>
                    <!-- <div class="services-one__carousel owl-theme owl-carousel"> -->
                        <?php
                        while ($query->have_posts()) {
                            $query->the_post();
                            $img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                            ?>
                                <li><a href="<?php the_permalink(); ?>" class="active"><?php the_title(); ?></a></li>
                                <?php
                            $i++;
                            }
                            }wp_reset_postdata();
                            ?>
                                
                            </ul>
                        </div>
                        <div class="widget widget_banner" data-bg-src="<?php the_field('help_section_img'); ?>">
                            <div class="widget-banner">
                                <h4 class="box-title">Need Help</h4>
                                <div class="call-feature">
                                    <div class="box-icon"><i class="fal fa-phone"></i></div>
                                    <div class="media-body">
                                        <p class="box-label">Support</p><a href="tel:<?php echo html_entity_decode( get_option( 'option_14' ) );?>" class="box-link"><?php echo html_entity_decode( get_option( 'option_14' ) );?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>




          

    <div class="scroll-top"><svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;"></path>
        </svg></div>
    
<?php get_footer();?>

