<?php
   if ( ! defined( 'ABSPATH' ) ) {
     exit; // Exit if accessed directly
   }
?>

<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   
   $img = $template_url."/assets/img/bg/breadcumb-bg.jpg";
?>
<div class="breadcumb-wrapper" data-bg-src="<?php echo $img;?>">
        <div class="container">
            <div class="breadcumb-content">
                <h1 class="breadcumb-title"><?php the_title();?></h1>
                <ul class="breadcumb-menu">
                    <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                    <li><?php the_title();?></li>
                </ul>
            </div>
        </div>
    </div>


    <section class="th-blog-wrapper blog-details space-top space-extra-bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-8 col-lg-7 col-md-12">
                    <div class="th-blog blog-single">
                        <div class="mainblog-img"><img src="<?php the_field('front_image');?>" alt="Blog Image"></div>
                        <div class="blog-content">
                            <div class="blog-meta"><i class="fal fa-user"></i><?php the_author(); ?> <i class="fal fa-calendar"></i><?php echo get_the_date( 'D M' );?> </div>
                            <h2 class="blog-title"><?php echo get_the_title();?></h2>
                           <?php the_content();?>
                        </div>
                    </div>
                    
                   
                </div>
                <div class="col-xxl-4 col-lg-5 col-md-12">
                    <aside class="sidebar-area">
                       
                    
                        <div class="widget">
                            <h3 class="widget_title">Recent Posts</h3>
                            <div class="recent-post-wrap">
                                 <?php
                                $args = array ( 
                                        'post_type'      => 'post',
                                        'post_status'    => 'publish', 
                                        'orderby' => 'publish_date',
                                        'order' => 'DESC',  
                                        'posts_per_page' => 3
                                    );
                                $query = new WP_Query($args);
                                $post_count = $query->post_count;
                                if ( $query->have_posts() ){
                                  $i = 1;
                                while ( $query->have_posts() ){
                                    $blog_img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                                    $query->the_post();
                                ?>
                                <div class="recent-post">
                                    <a href="<?php the_permalink();?>">
                                    <div class="media-img"><img src="<?php the_field('front_image');?>" alt="Blog Image"></div>
                                    <div class="media-body">
                                        <h4 class="post-title"><?php the_title();?></h4>
                                        <div class="recent-post-meta"><a href="blog.html"><i class="fal fa-calendar"></i><?php echo get_the_date( 'D M' );?></a></div>
                                    </div>
                                    </a>
                                </div>
                                <?php
                                      $i++;
                                      }
                                    }wp_reset_postdata();
                                  ?>
                                
                            </div>
                        </div>
                        <div class="widget widget_tag_cloud">
                            <h3 class="widget_title">Popular Tags</h3>
                             
                            <div class="tagcloud">
                                <?php
                                                // $tags = get_the_tags();
                                                // if ( $tags ) {
                                                //     foreach ( $tags as $tag ) {
                                                //         echo '<a href="' . get_tag_link( $tag->term_id ) . '">' . $tag->name . '</a> ';
                                                //     }
                                                // }
                                            ?>
                                <!-- <a href="blog.html">Home</a> <a href="blog.html">Kitchen</a> <a href="blog.html">Window</a> <a href="blog.html">Bathroom</a> <a href="blog.html">Clean</a> <a href="blog.html">Roof</a> <a href="blog.html">Fresh</a> <a href="blog.html">Office</a> <a href="blog.html">Floor</a> -->
                                 <?php 
                                //  the_tags( '<ul class="post-tags"><li>', '</li><li>', '</li></ul>' ); ?>
                                 <?php wp_tag_cloud( array(
    'smallest' => 10,
    'largest'  => 18,
    'unit'     => 'px',
    'number'   => 0, // 0 means "show all"
    'orderby'  => 'name',
    'order'    => 'ASC',
    'hide_empty' => false,
) ); ?>


                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>
  
<?php get_footer(); ?>