<?php
/**
 * Author: Ranjan deb
 *
 */
if (!function_exists('BP_setup')):
    function BP_setup() {

        add_theme_support('title-tag');
        add_theme_support('post-thumbnails');
        set_post_thumbnail_size(825, 510, true);
        register_nav_menus(array('primary' => __('Header Menu', 'BP'),'useful_link' => __('Useful Link', 'BP'),'our_service' => __('Our Services', 'BP')));
        add_theme_support('custom-logo', array('height' => 300, 'width' => 300, 'flex-height' => true,));
        add_theme_support('wc-product-gallery-zoom');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');
        add_theme_support('post-thumbnails');
        add_theme_support('title-tag');
        add_theme_support('woocommerce');
        add_theme_support(
            'post-formats',
            array(
                'link',
                'aside',
                'gallery',
                'image',
                'quote',
                'status',
                'video',
                'audio',
                'chat',
            )
        );

        add_theme_support(
            'html5',
            array(
                'comment-form',
                'comment-list',
                'gallery',
                'caption',
                'style',
                'script',
                'navigation-widgets',
            )
        );

        $logo_width  = 300;
        $logo_height = 300;
        add_theme_support(
            'custom-logo',
            array(
                'height'               => $logo_height,
                'width'                => $logo_width,
                'flex-width'           => true,
                'flex-height'          => true,
                'unlink-homepage-logo' => true,
            )
        );
        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );
        // Add support for Block Styles.
        add_theme_support( 'wp-block-styles' );
        // Add support for full and wide align images.
        add_theme_support( 'align-wide' );
    }
endif;
add_action('after_setup_theme', 'BP_setup');


require_once ('inc-BP/navwalker-functions.php');
require_once ('inc-BP/bs4navwalker.php');
require_once ('inc-BP/wordpress-extrafeatures-fuctions.php');
/**
     * For Header Slider
     * =================
     *
*/ 
add_shortcode( 'BP_slider', 'BP_slider_list' );
function BP_slider_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    $the_query = new WP_Query( array(
        'post_type' => 'our_slider',
        'post_status' => 'publish',
        'posts_per_page' => $posts_per_page,
        'order' => 'ASC'
    ) );
ob_start();
    $i = 0;
    while ( $the_query->have_posts() ) :$the_query->the_post();
    $active = ( $i == 0 )?'active':'' ;
    $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full');
    ?>

    <div class="carousel-item <?php echo $active;?>" style="background-image:url(<?php echo $featured_img_url;?>)">
         <div class="container">
            <div class="slider-content text-center">
               <div class="col-md-12">
<!--                   <div class="flag"><img src="<?php //echo get_stylesheet_directory_uri();?>/images/usaflag.png"></div>  -->
                  <p><?php the_field('short_title'); ?></p>
                  <h2 class="slide-title-classic animated3"><?php the_field('long_title'); ?></h2>
                  <p class="animated3">
                     <a href="<?php the_field('button_link'); ?>" class="slider btn btn-primary">Find Out if You're Eligible</a>
<!--                      <a class="sliderbtn2 btn-border" id="myBtn"><img src="<?php //echo get_stylesheet_directory_uri();?>/images/sliderbtn2.png">Watch Our Story</a> -->
                  </p>
               </div>
               <!-- Col end -->
            </div>
            <!-- Slider content end -->
         </div>
         <!--Container end -->
      </div>
      
      <!-- The Modal -->
    <div id="myModal" class="modal">
      <!-- Modal content -->
      <div class="modal-content">
        
                <video width="100%" controls>
                 <source src="<?php the_field('watch_our_story_video',7); ?>" type="video/mp4">
                 <source src="movie.ogg" type="video/ogg">
               </video>
               <span class="close">&times;</span>
               <p class="text-center"><a href="#videosec" class="close">Go To Details</a></p>
               <p class="text-center">English, Spanish, Polish, Arabic, Hindi, Japanese, Punjabi, Gujarati, Korean, Russian, Tagalog, Bengali, Mandarin, Cantonese, French, Farsi</p>
               
      </div>
    
    </div>
<?php
    $i++;
    endwhile;
    wp_reset_postdata();
        return ''.ob_get_clean().'';
}
add_shortcode( 'BP_slider_indicator', 'BP_slider_indicator_list' );

@ini_set( 'upload_max_size' , '6400M' );
@ini_set( 'post_max_size', '6400M');
@ini_set( 'max_execution_time', '30000' );

/**
     * For all categories
     * =================
     *
*/  

add_shortcode( 'BP_categories', 'BP_categories_list' );
function BP_categories_list($atts = array(), $content = '', $post_id = '' ) {

            global $product;
            global $woocommerce;

            $taxonomy     = 'product_cat';
            $orderby      = 'name';  
            $show_count   = 0;      // 1 for yes, 0 for no
            $pad_counts   = 0;      // 1 for yes, 0 for no
            $hierarchical = 1;      // 1 for yes, 0 for no  
            $empty        = 0;

              $args = array(
                     'taxonomy'     => $taxonomy,
                     'orderby'      => $orderby,
                     'show_count'   => $show_count,
                     'pad_counts'   => $pad_counts,
                     'hierarchical' => $hierarchical,
                     'hide_empty'   => $empty
              );
               $all_categories = get_categories( $args );

                 foreach ($all_categories as $cat) {
                    if($cat->category_parent == 0) {
                        $category_id = $cat->term_id;

                           // get the thumbnail id using the queried category term_id
                            $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true ); 
                            // get the image URL
                            $image = wp_get_attachment_url( $thumbnail_id );
             ?>        
            <div class="col-lg-12 col-md-12 col-12">
              <div class="image_decor position-relative w-auto">
                <img src="<?php echo $image; ?>" class="img-fluid rounded-end rounded-start d-block w-100" alt="">
                <div class="cat-overlay bg-black bg-opacity-50 rounded-end rounded-start">
                  <h2><?=$cat->name?></h2>
                </div>
              </div>
            </div>

             <?php
                    }   
                }
                wp_reset_postdata();
                

}

 if ( has_nav_menu('product-linting-sidebar') ) {
function add_link_atts($atts) {
  $atts['class'] = "link-dark d-inline-flex text-decoration-none rounded";
  return $atts;
}

add_filter( 'nav_menu_link_attributes', 'add_link_atts');
}


/*echo '<br /><a href="'. get_term_link($cat->slug, 'product_cat') .'">'. $cat->name .'</a>';*/
/*function add_link_atts($atts)
{
    $atts["class"] = "nav-link dropdown-toggle";
    return $atts;
}*/
//add_filter("nav_menu_link_attributes", "add_link_atts");

/**
* For MAP Link
* =========
*
*/
add_shortcode( 'BP_MAP', 'BP_MAP_list' );

function BP_MAP_list($atts = array(), $content = '', $post_id = '' ) {
        
?>

<iframe src="<?php echo html_entity_decode( get_option( 'option_10' ) );?>" width="100%" height="400" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
<?php
wp_reset_postdata();
}

/**
* For Home Video
* =========
*
*/
add_shortcode( 'BP_HOME_VIDEO', 'BP_HOME_VIDEO_list' );

function BP_HOME_VIDEO_list($atts = array(), $content = '', $post_id = '' ) {
    if(have_rows('fifth_section_videos')):
        $i=0; while(have_rows('fifth_section_videos')):
             the_row();       
?>
        <figure class="item videobox">
             <div class="videobox">
                <!--<img class="videopic" src="<?php echo get_stylesheet_directory_uri();?>/images/Rectangle10.jpg" alt=""/>-->
                <iframe width="100%" height="270px" src="<?php the_sub_field('video_link'); ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
             </div>
             <div class="video_con">
                <h4><?php the_sub_field('video_title'); ?></h4>
                <p><img src="<?php the_sub_field('country_flag'); ?>"></p>
             </div>
        </figure>
<?php
        $i++; endwhile;wp_reset_postdata();
    endif;


}

/**
* For Service Video
* =========
*
*/
add_shortcode( 'BP_VIDEO', 'BP_VIDEO_list' );

function BP_VIDEO_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
<section id="testimonials" class="testimonialarea">
   <div class="container">
      <!-- Title row end -->
      <div class="row">
         <div id="video-carousel" class="col-sm-12 owl-carousel owl-theme text-center">
           
         </div>
         <!--/ Owl carousel end -->
      </div>
      <!--/ Content row end -->
   </div>
   <!--/ Container end -->
</section>
<?php
}


/**
* For HOW IT WORKS
* =========
*
*/
add_shortcode( 'BP_HOW_IT_WORKS', 'BP_HOW_IT_WORKS_list' );

function BP_HOW_IT_WORKS_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
            <?php
                $args = array ( 
                    'post_type'      => 'my_how_it_works',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
           ?>

              <div class="col-lg-4">
                  <div
                    class="process-item mb-65 wow fadeInUp"
                    data-wow-delay=".2s"
                  >
                    <div class="text">
                      <span class="step"><?php echo $i;?></span>
                      <h4><?php echo get_the_title();?></h4>
                    </div>
                  </div>
                </div>

           <?php
               $i++;
              }
            }wp_reset_postdata();
            ?>
<?php
}


/**
* For About Page Team
* =========
*
*/
add_shortcode( 'BP_ABOUT_US_TEAM', 'BP_ABOUT_US_TEAM_list' );

function BP_ABOUT_US_TEAM_list($atts = array(), $content = '', $post_id = '' ) {
        
?>

<div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-8">
            <div class="section-title text-center mb-55 wow fadeInUp">
              <span class="sub-title st-one"><?php the_field('team_title',7); ?></span>
              <?php the_field('team_big_title',7); ?>
              <p><?php the_field('team_content',7); ?></p>
            </div>
          </div>
        </div>
        <div class="row">
          <?php
                $args = array ( 
                    'post_type'      => 'my_team',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => 4
                );
                $query = new WP_Query($args);
                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
           ?>
                <div class="col-lg-3 col-md-6 col-sm-12">
                  <div class="team-item mb-55 wow fadeInUp" data-wow-delay=".2s">
                    <div class="img-holder">
                      <img src="<?php echo $img_url;?>" alt="" />
                    </div>
                    <div class="text text-center">
                      <ul class="social-link">
                        <li>
                          <a href="<?php the_field('facebook_link'); ?>"><i class="fab fa-facebook-f"></i></a>
                        </li>
                        <li>
                          <a href="<?php the_field('dribbble_link'); ?>"><i class="fab fa-dribbble"></i></a>
                        </li>
                        <li>
                          <a href="<?php the_field('twitter_link'); ?>"><i class="fab fa-twitter"></i></a>
                        </li>
                      </ul>
                      <h4><a href="team.html"><?php echo get_the_title();?></a></h4>
                      <p class="position"><?php echo get_the_excerpt();?></p>
                    </div>
                  </div>
                </div>
            <?php
               $i++;
              }
            }wp_reset_postdata();
            ?>
        </div>
      </div>
<?php
}

/**
* For About Page Testimonial form
* =========
*
*/
add_shortcode( 'BP_ABOUT_US_TESTIMONIALS', 'BP_ABOUT_US_TESTIMONIALS_list' );

function BP_ABOUT_US_TESTIMONIALS_list($atts = array(), $content = '', $post_id = '' ) {
        
?>

      <div class="container">
        <div class="row">
          <div class="col-lg-8">
            <div class="section-title section-title-white mb-55 wow fadeInLeft">
              <span class="sub-title st-one"><?php the_field('testimonial_title',5); ?></span>
              <?php the_field('testimonial_big_title',5); ?>
              <?php the_field('testimonial_content',5); ?>
            </div>
          </div>
        </div>
        <div class="testimonial-slider-three">
          <?php
                $args = array ( 
                    'post_type'      => 'my_testimonial',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
           ?>
                <div class="testimonial-item mb-55 wow fadeInUp">
                  <div class="author-thumb">
                    <img src="<?php echo $img_url;?>" alt="" />
                  </div>
                  <div class="testimonial-content">
                    <?php echo get_the_content();?>
                    <div class="author-quote-title d-flex">
                      <div class="author-title">
                        <h4><?php echo get_the_title();?></h4>
                        <p class="position"><?php echo get_the_excerpt();?></p>
                      </div>
                    </div>
                  </div>
                </div>
           <?php
               $i++;
              }
            }wp_reset_postdata();
            ?>
        </div>
      </div>
<?php
}

/**
* For Home Testimonial form
* =========
*
*/
add_shortcode( 'BP_HOME_TESTIMONIALS', 'BP_HOME_TESTIMONIALS_list' );

function BP_HOME_TESTIMONIALS_list($atts = array(), $content = '', $post_id = '' ) {
        
?>

<div class="container">
        <div class="row">
          <div class="col-lg-8">
            <div class="section-title section-title-white mb-50 wow fadeInLeft">
              <span class="sub-title st-one"><?php the_field('testimonial_title',5); ?></span>
              <?php the_field('testimonial_big_title',5); ?>
              <?php the_field('testimonial_content',5); ?>
            </div>
          </div>
        </div>
        <div class="row align-items-center">
          <div class="col-lg-12">
            <div class="testimonial-slider-one mb-50 wow fadeInRight">
              <?php
                $args = array ( 
                    'post_type'      => 'my_testimonial',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
              ?>
                  <div class="testimonial-item">
                    <div class="testimonial-content">
                      <div class="testimonial-imagecontainer">
                        <div class="testimonial-imagecontainertemp">
                          <img src="<?php echo $img_url;?>" alt="" />
                        </div>
                        <h3>
                          <?php echo get_the_content();?>
                        </h3>
                      </div>
                      <div class="author-title">
                        <h4><?php echo get_the_title();?></h4>
                        <p class="position"><?php echo get_the_excerpt();?></p>
                      </div>
                    </div>
                  </div>
              <?php
                 $i++;
                }
              }wp_reset_postdata();
              ?>
            </div>
          </div>
        </div>
      </div>
<?php
}

/**
* For Contact US Form
* =========
*
*/
add_shortcode( 'BP_CONTACT_US_FORM', 'BP_CONTACT_US_FORM_list' );

function BP_CONTACT_US_FORM_list() {
        
?>
<section class="contact-area contact-area-v3 pt-130 pb-130">
   <div class="container-1350">
      <div class="contact-wrapper light-gray-bg pt-80 pb-80 wow fadeInUp">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-lg-7">
                  <div class="section-title text-center mb-55">
                     <span class="sub-title st-one"><?php the_field('second_section_short_title',13); ?></span>
                     <h2><?php the_field('second_section_big_title',13); ?></h2>
                  </div>
               </div>
            </div>
            <div class="row">
               <div class="col-lg-12">
                  <div class="contact-form">
                     <?php echo do_shortcode('[contact-form-7 id="42" title="Contact Form"]');?>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>
<?php
wp_reset_postdata();
}


/**
* For Home Team
* =========
*
*/
add_shortcode( 'BP_HOME_TEAM', 'BP_HOME_TEAM_list' );

function BP_HOME_TEAM_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
          <?php
                $args = array ( 
                    'post_type'      => 'my_team',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC', 
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                

                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
                    //$the_cat = get_the_category(get_the_ID());
                    //$cat_name = $the_cat[0]->name;
              ?>
              <div class="col-md-3 trainer-block">
                <div class="trainer-pic zoom-pic"> <a href="<?php the_permalink();?>"> <img src="<?php echo $img_url;?>" alt="" class="img-responsive"></a></div>
                <div class="trainer-caption">
                  <h2><a href="<?php the_permalink();?>" class="trainer-title"><?php echo get_the_title();?></a></h2>
                  <span class="trainer-meta"><?php echo get_the_excerpt();?></span> </div>
              </div>
              <?php
                 $i++;
                }
              }wp_reset_postdata();
              ?>
<?php
}

/**
 * For TEAM 
 * =========
 *
 */
     
add_shortcode( 'BP_TEAM', 'BP_TEAM_list' );

function BP_TEAM_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'our-staff',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => $posts_per_page
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>
        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                <div class="team_con">
                  <div class="box">
                    <img src="<?php echo $img_url; ?>">
                  </div>
                  <h3 class="title"><?php echo get_the_title();?></h3>
                  <h4>(<?php echo get_the_excerpt();?>)</h4>
          <a href="<?php the_permalink();?>" class="readmore">Read More</a>
                </div>
        </div>
           
<?php
    $i++;
    }
    ?>
    <div class="col-lg-12"><nav class="pagination">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</nav></div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }


/**
 * For Condition 
 * =========
 *
 */
     
add_shortcode( 'BP_CONDITION', 'BP_CONDITION_list' );

function BP_CONDITION_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'conditions',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => 6
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
            <div class="service-item hvr-float-shadow">
               <img src="<?php echo $img_url; ?>" alt="">
               <div class="down-content">
                  <h4><?php echo get_the_title();?></h4>
                  <p><?php echo get_the_excerpt();?></p>
                  <a href="<?php the_permalink();?>" class="filled-button">Read More</a>
               </div>
            </div>
         </div>
<?php
     $i++;
    }
  }wp_reset_postdata();
  
}
/**
 * For Conditions
 * =========
 *
 */
     
add_shortcode( 'BP_LOWER_CONDITIONS', 'BP_LOWER_CONDITIONS_list' );

function BP_LOWER_CONDITIONS_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'conditions',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => $posts_per_page
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
          <div class="item hvr-push">
                  <div class="service-item hvr-float-shadow">
              <img src="<?php echo $img_url; ?>" alt="">
              <div class="down-content">
                <h4><?php echo get_the_title();?></h4>
                <p><?php echo get_the_excerpt();?></p>
                <a href="<?php the_permalink();?>" class="filled-button">Read More</a>
              </div>
             </div>
            </div>
<?php
     $i++;
    }
  }wp_reset_postdata();
  
}

/**
 * For ALL CONDITIONS
 * =========
 *
 */
     
add_shortcode( 'BP_ALL_CONDITIONS', 'BP_ALL_CONDITIONS_list' );

function BP_ALL_CONDITIONS_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                        'post_type'      => 'page',
                        'posts_per_page' => -1,
                        'post_parent'    => 15,
                        'order'          => 'DESC',
                        'orderby'        => 'publish_date'
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
    
    <div class="col-lg-4 single_testimonial wow fadeInUp" data-wow-duration="1s">
    <a class="title" href="<?php the_permalink();?>"><div class="services_item">
    <div class="services_img">
    <img src="<?php the_field('front_image');?>" alt="services" class="img-fluid">
    </div>
    <div class="services_text">
     <h3><?php echo get_the_title();?></h3>
    <p><?php the_field('short_note');?></p>
    <div class="services_btn_area">
    <div class="read_btn">read more</div>
    </div>
    </div>
    </div></a>
    </div>


<?php
     $i++;
    }
  }wp_reset_postdata();
  
}

/**
 * For Services 
 * =========
 *
 */
     
add_shortcode( 'BP_Services', 'BP_Services_list' );

function BP_Services_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                    'post_type'      => 'services',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => $posts_per_page
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
          <div class="item hvr-push">
                  <div class="service-item hvr-float-shadow">
              <img src="<?php echo $img_url; ?>" alt="">
              <div class="down-content">
                <h4><?php echo get_the_title();?></h4>
                <p><?php echo get_the_excerpt();?></p>
                <a href="<?php the_permalink();?>" class="filled-button">Read More</a>
              </div>
             </div>
            </div>
<?php
     $i++;
    }
  }wp_reset_postdata();
  
}

/**
 * For Home Services
 * =========
 *
 */
     
add_shortcode( 'BP_HOME_Services', 'BP_HOME_Services_list' );

function BP_HOME_Services_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                        'post_type'      => 'page',
                        'posts_per_page' => 8,
                        'post_parent'    => 13,
                        'order'          => 'DESC',
                        'orderby'        => 'publish_date'
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
    








<div class="col-lg-6 col-sm-12 wow fadeInUp" data-wow-duration="1s">
<a class="title" href="<?php the_permalink();?>"><div class="services_item single_testimonial">
<div class="services_img">
<img src="<?php the_field('front_image');?>" alt="services" class="img-fluid">
</div>
<div class="services_text">
<div class="title" href="<?php the_permalink();?>"><?php echo get_the_title();?></div>
<p><?php the_field('short_note');?></p>
<div class="services_btn_area">
<div class="read_btn" href="<?php the_permalink();?>">read more</div>
</div>
</div>
</div></a>
</div>





            




<?php
     $i++;
    }
  }wp_reset_postdata();
  
}


/**
 * For ALL Services
 * =========
 *
 */
     
add_shortcode( 'BP_ALL_Services', 'BP_ALL_Services_list' );

function BP_ALL_Services_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => ''
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array ( 
                        'post_type'      => 'page',
                        'posts_per_page' => -1,
                        'post_parent'    => 13,
                        'order'          => 'DESC',
                        'orderby'        => 'publish_date'
                );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
    ?>
   

<div class="col-lg-4 col-md-6 col-sm-12 wow fadeInUp" data-wow-duration="1s">
<a href="<?php the_permalink();?>" class=""> 
<div class="services_item">
<div class="services_img">
<img src="<?php the_field('front_image');?>" alt="services" class="img-fluid w-100">
</div>
<div class="services_text">
<div class="title" href="<?php the_permalink();?>"><?php echo get_the_title();?></div>
<p><?php the_field('short_note');?></p>
<div class="services_btn_area">
<div class="read_btn" href="<?php the_permalink();?>">read more</div>
</div>
</div>
</div>
</a>
</div> 

<?php
     $i++;
    }
  }wp_reset_postdata();
  
}






/**
* For Home Blog
* =========
*
*/
add_shortcode( 'BP_HOME_BLOG', 'BP_HOME_BLOG_list' );

function BP_HOME_BLOG_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
          <?php
                $args = array ( 
                    'post_type'      => 'post',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => 3
                );
                $query = new WP_Query($args);
                

                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
                    $the_cat = get_the_category(get_the_ID());
                    $cat_name = $the_cat[0]->name;
              ?>

							 <div class="col-xl-4 col-md-6">
								 <a href="<?php the_permalink();?>">
          <div class="blog-box">
            <div class="blog-img">
              <img src="<?php the_field('front_image');?>" alt="blog image">
            </div>
            <div class="blog-content">
              <div class="blog-meta">
                
                  <i class="fas fa-user">
                  </i><?php the_author(); ?>
                  
              </div>
              <h3 class="box-title">
                <?php the_title(); ?>
              </h3>
              <div class="box-bottom">
                
                  <i class="fas fa-arrow-up-right">
                  </i>                
              </div>
            </div>
          </div>
			  </a>
        </div>

			 
              <?php
                 $i++;
                }
              }wp_reset_postdata();
              ?>
<?php
}

/**
 * For Blog 
 * =========
 *
 */
     
add_shortcode( 'BP_blog', 'BP_blog_list' );

function BP_blog_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => '6'
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $args = array ( 
    'post_type'      => array( 'post' ), 
    'orderby'        => 'post_date', 
    'order'          => 'DESC',
    'posts_per_page' => $posts_per_page,
    'paged' => $paged
    ); 

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>


           <div class="col-xxl-4 col-lg-4 col-md-6 col-sm-12">
             <a href="<?php the_permalink();?>">
                <div class="th-blog blog-single has-post-thumbnail">
                <div class="blog-img"><img src="<?php the_field('front_image');?>" alt="Blog Image"></div>
                <div class="blog-content">
                <div class="blog-meta"><i class="fal fa-user"></i>By Klano <i class="fal fa-calendar"></i><?php echo get_the_date( 'D M' );?></div>
                <h2 class="blog-title"><?php the_title(); ?></h2>
                <p class="blog-text"><?php the_field('short_content');?></p>Read More<i class="fas fa-arrow-up-right ms-2"></i>
                </div>
                </div>
            </a>
                </div>




        
<?php
    $i++;
    }
    ?>
    <div class="th-pagination text-center">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }

/**
* For Home Reviews
* =========
*
*/
add_shortcode( 'BP_HOME_REVIEWS', 'BP_HOME_REVIEWS_list' );

function BP_HOME_REVIEWS_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
          <?php
                $args = array ( 
                    'post_type'      => 'my_testimonial',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => -1
                );
                $query = new WP_Query($args);
                

                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
                    $the_cat = get_the_category(get_the_ID());
                    $cat_name = $the_cat[0]->name;
              ?>
                  <div class="input_reviews">
                                        <div class="input_review_icon">
                  <?php if(get_field('social_icon')!=""){?>
                      <img src="<?php the_field('social_icon');?>" alt="">
                  <?php }else{?>
                      <img src="<?php echo get_stylesheet_directory_uri();?>/images/google-logo.png" alt="">
                  <?php }?>    
                                     
                                        </div>
                                        <div class="input_review_admin">
                                            <h4><?php the_field('review_signature');?></h4>
                                            <div class="star_group">
                  				 <?php if(get_the_excerpt() == 1){?>
                                   <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                   <?php }elseif(get_the_excerpt() == 2){?>
                                   <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>>
                                   <?php }elseif(get_the_excerpt() == 3){?>
                                   <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                   <?php }elseif(get_the_excerpt() == 4){?>
                                   <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <?php }elseif(get_the_excerpt() == 5){?>
                                   <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                  <span><i class="fa-solid fa-star" style="color: #ec8004;"></i></span>
                                   <?php }?>
                                            </div>
                                            <p><?php the_content();?></p>
											 <div class="review-reply">
						  <h4>Response By Admin</h4>
						  <h5><?php the_field('reply_reviews');?></h5>
					  </div>
                                        </div>
					 
                                        <div class="input_review_date"><?php echo get_the_date( 'Y-m-d' );?></div>
<!-- 					  					<div class="input_review_date"><?php echo get_the_date( 'D M j' );?></div> -->
                                    </div>
              <?php
                 $i++;
                }
              }wp_reset_postdata();
              ?>
<?php
}

/**
 * For Reviews 
 * =========
 *
 */
     
add_shortcode( 'BP_REVIEWS', 'BP_REVIEWS_list' );

function BP_REVIEWS_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => '20'
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $args = array ( 
    'post_type'      => 'my_testimonial', 
    'orderby'        => 'post_date', 
    'order'          => 'DESC',
    'posts_per_page' => $posts_per_page,
    'paged' => $paged
    ); 

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>     
    <div class="col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="reviewcon">
               <h3><?php the_field('review_signature');?></h3>
               <div class="star d-flex">
                   <?php if(get_the_excerpt() == 1){?>
                   <i class="fas fa-star"></i>
                   <?php }elseif(get_the_excerpt() == 2){?>
                   <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                   <?php }elseif(get_the_excerpt() == 3){?>
                   <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                   <?php }elseif(get_the_excerpt() == 4){?>
                   <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <?php }elseif(get_the_excerpt() == 5){?>
                   <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                   <?php }?>
                  	
               </div>
               <p><?php the_content();?></p>
            </div>
         </div>
<?php
    $i++;
    }
    ?>
    <div class="col-lg-12"><nav class="pagination">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</nav></div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }
    
    
/**
* For LOwer Section Page
* =========
*
*/
add_shortcode( 'BP_LOWER_SECTION', 'BP_LOWER_SECTION_list' );

function BP_LOWER_SECTION_list() {
       
?>

<!-- Start Contact Section  -->
    <div class="contact-area section-padding pt-0">
        <div class="container">
            <div class="contact-section-inner">
                <div class="contact-section-content">
                    <h2 class="text-white"><?php the_field('eleven_section_title',7);?></h2>
                    <h5 class="text-white"><?php the_field('eleven_section_title_2',7);?></h5>
                    <a href="<?php the_field('eleven_section_link',7);?>" class="main-btn"><?php the_field('eleven_section_title_3',7);?></a>
                </div>                
            </div>
        </div>
        
    </div>
     <!-- Contact Section End  -->

<?php
}

function contact_form_login_redirect() {
    ?>
    <script>
        document.addEventListener( 'wpcf7mailsent', function ( event ) {
            location = 'thank-you/';
        }, false );
    </script>

    <?php
}

//add_action( 'wp_footer', 'contact_form_login_redirect' );