<?php
   if ( ! defined( 'ABSPATH' ) ) {
     exit; // Exit if accessed directly
   }
?>

<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   
   $img = $template_url."/assets/img/bg/breadcumb-bg.jpg";
?>
<div class="breadcumb-wrapper" data-bg-src="<?php echo $img;?>">
        <div class="container">
            <div class="breadcumb-content">
                <h1 class="breadcumb-title"><?php the_title();?></h1>
                <ul class="breadcumb-menu">
                    <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                    <li><?php the_title();?></li>
                </ul>
            </div>
        </div>
    </div>


    <section class="th-blog-wrapper blog-details space-top space-extra-bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-8 col-lg-7 col-md-12">
                    <div class="th-blog blog-single">
                        <div class="mainblog-img"><img src="<?php the_field('front_image');?>" alt="Blog Image"></div>
                        <div class="blog-content">
                            <div class="blog-meta"><i class="fal fa-user"></i><?php the_author(); ?> <i class="fal fa-calendar"></i>01 Jan, 2024 <a href="blog-details.html"><i class="fal fa-comments"></i><?php echo get_comments_number(); ?></a></div>
                            <h2 class="blog-title"><?php echo get_the_title();?></h2>
                           <?php the_content();?>
                        </div>
                    </div>
                    <div class="th-comments-wrap">
                        <h2 class="blog-inner-title h4"><i class="fal fa-comments"></i> Comments (03)</h2>
                        <ul class="comment-list">
                            <li class="th-comment-item">
                                <div class="th-post-comment">
                                    <div class="comment-avater"><img src="<?php echo get_stylesheet_directory_uri();?>/assets/img/blog/comment-author-1.jpg" alt="Comment Author"></div>
                                    <div class="comment-content"><span class="commented-on"><i class="fal fa-calendar"></i>01 Jan, 2024</span>
                                        <h3 class="name">Adam Jhon</h3>
                                        <p class="text">The idea of a Crystal Home as a sanctuary for serenity is truly inspiring. The incorporation of the fire element adds a dynamic.</p>
                                        <div class="reply_and_edit"><a href="blog-details.html" class="reply-btn"><i class="fas fa-reply"></i>Reply</a></div>
                                    </div>
                                </div>
                                <ul class="children">
                                    <li class="th-comment-item">
                                        <div class="th-post-comment">
                                            <div class="comment-avater"><img src="<?php echo get_stylesheet_directory_uri();?>/assets/img/blog/comment-author-2.jpg" alt="Comment Author"></div>
                                            <div class="comment-content"><span class="commented-on"><i class="fal fa-calendar"></i>02 Jan, 2024</span>
                                                <h3 class="name">Jusctin Dacon</h3>
                                                <p class="text">The description of a crystal fireplace and candlelit corners creates vivid mental images, enhancing the reader's connection.</p>
                                                <div class="reply_and_edit"><a href="blog-details.html" class="reply-btn"><i class="fas fa-reply"></i>Reply</a></div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </li>
                            <li class="th-comment-item">
                                <div class="th-post-comment">
                                    <div class="comment-avater"><img src="<?php echo get_stylesheet_directory_uri();?>/assets/img/blog/comment-author-3.jpg" alt="Comment Author"></div>
                                    <div class="comment-content"><span class="commented-on"><i class="fal fa-calendar"></i>03 Jan, 2024</span>
                                        <h3 class="name">Jacklin July</h3>
                                        <p class="text">The blog provides practical suggestions for incorporating the fire element into a Crystal Home, such as crystal fireplaces.</p>
                                        <div class="reply_and_edit"><a href="blog-details.html" class="reply-btn"><i class="fas fa-reply"></i>Reply</a></div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="th-comment-form">
                        <div class="form-title">
                            <h3 class="blog-inner-title h4 mb-2"><i class="fa-solid fa-reply"></i> Leave a Comment</h3>
                            <p class="form-text">Your email address will not be published. Required fields are marked *</p>
                        </div>
                        <div class="row">
                            <div class="col-md-6 form-group"><input type="text" placeholder="Your Name*" class="form-control"> <i class="far fa-user"></i></div>
                            <div class="col-md-6 form-group"><input type="text" placeholder="Your Email*" class="form-control"> <i class="far fa-envelope"></i></div>
                            <div class="col-12 form-group"><input type="text" placeholder="Website" class="form-control"> <i class="far fa-globe"></i></div>
                            <div class="col-12 form-group"><textarea placeholder="Write a Comment*" class="form-control"></textarea> <i class="far fa-pencil"></i></div>
                            <div class="col-12 form-group mb-0"><button class="th-btn">Post Comment</button></div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-4 col-lg-5 col-md-12">
                    <aside class="sidebar-area">
                       
                    
                        <div class="widget">
                            <h3 class="widget_title">Recent Posts</h3>
                            <div class="recent-post-wrap">
                                <div class="recent-post">
                                    <div class="media-img"><a href="blog-details.html"><img src="<?php echo get_stylesheet_directory_uri();?>/assets/img/blog/recent-post-1-1.jpg" alt="Blog Image"></a></div>
                                    <div class="media-body">
                                        <h4 class="post-title"><a class="text-inherit" href="blog-details.html">Pure Serenity Unleash the fire of a Crystal Home</a></h4>
                                        <div class="recent-post-meta"><a href="blog.html"><i class="fal fa-calendar"></i>21 Jun, 2024</a></div>
                                    </div>
                                </div>
                                <div class="recent-post">
                                    <div class="media-img"><a href="blog-details.html"><img src="<?php echo get_stylesheet_directory_uri();?>/assets/img/blog/recent-post-1-2.jpg" alt="Blog Image"></a></div>
                                    <div class="media-body">
                                        <h4 class="post-title"><a class="text-inherit" href="blog-details.html">The Ultimate Floor Cleaner for a Gleaming Home</a></h4>
                                        <div class="recent-post-meta"><a href="blog.html"><i class="fal fa-calendar"></i>22 Jun, 2024</a></div>
                                    </div>
                                </div>
                                <div class="recent-post">
                                    <div class="media-img"><a href="blog-details.html"><img src="<?php echo get_stylesheet_directory_uri();?>/assets/img/blog/recent-post-1-3.jpg" alt="Blog Image"></a></div>
                                    <div class="media-body">
                                        <h4 class="post-title"><a class="text-inherit" href="blog-details.html">Mastering the Art of Effortless Bathroom Cleaning</a></h4>
                                        <div class="recent-post-meta"><a href="blog.html"><i class="fal fa-calendar"></i>23 Jun, 2024</a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="widget widget_tag_cloud">
                            <h3 class="widget_title">Popular Tags</h3>
                             
                            <div class="tagcloud">
                                <?php
                                                // $tags = get_the_tags();
                                                // if ( $tags ) {
                                                //     foreach ( $tags as $tag ) {
                                                //         echo '<a href="' . get_tag_link( $tag->term_id ) . '">' . $tag->name . '</a> ';
                                                //     }
                                                // }
                                            ?>
                                <!-- <a href="blog.html">Home</a> <a href="blog.html">Kitchen</a> <a href="blog.html">Window</a> <a href="blog.html">Bathroom</a> <a href="blog.html">Clean</a> <a href="blog.html">Roof</a> <a href="blog.html">Fresh</a> <a href="blog.html">Office</a> <a href="blog.html">Floor</a> -->
                                 <?php 
                                //  the_tags( '<ul class="post-tags"><li>', '</li><li>', '</li></ul>' ); ?>
                                 <?php wp_tag_cloud( array(
    'smallest' => 10,
    'largest'  => 18,
    'unit'     => 'px',
    'number'   => 0, // 0 means "show all"
    'orderby'  => 'name',
    'order'    => 'ASC',
    'hide_empty' => false,
) ); ?>


                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>
  
