document.addEventListener("DOMContentLoaded", function () {

    // Scroll to next section
    const scrollBtn = document.getElementById("scrollBtn");
    if (scrollBtn) {
        scrollBtn.addEventListener("click", function () {
            const next = document.querySelector(".our_services");
            if (next) next.scrollIntoView({ behavior: "smooth" });
        });
    }

    // Service Slider
    $('.owl_service').owlCarousel({
        loop: true,
        nav: true,
        autoplay: true,
        margin: 20,
        dots: false,
        responsive: {
            0: { items: 1 },
            600: { items: 2 },
            1000: { items: 3 }
        }
    });

    // Testimonial Slider
    $('.owl_testimonial').owlCarousel({
        loop: true,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplayHoverPause: true,
        margin: 20,
        nav: false,
        dots: false,
        responsive: {
            0: { items: 1 },
            600: { items: 1 },
            768: { items: 2 },
            1000: { items: 2 }
        }
    });

    // Navbar scroll sticky
    $(window).on("scroll", function () {
        if ($(this).scrollTop() >= 100) {
            $(".navbar").addClass("fixed_nav scrolled_nav");
        } else {
            $(".navbar").removeClass("fixed_nav scrolled_nav");
        }
    });

});

// image gallery
const imageModal = document.getElementById("imageModal");
const modalImage = imageModal.querySelector("#modalImage");
const modalTitle = imageModal.querySelector("#modalTitle");

const imageLinks = document.querySelectorAll('[data-bs-target="#imageModal"]');
let currentIndex = 0;

function updateModal(index) {
    const link = imageLinks[index];
    modalImage.src = link.getAttribute("data-img");
    modalTitle.textContent = link.getAttribute("data-title");
    currentIndex = index;
}

imageLinks.forEach((link, index) => {
    link.addEventListener("click", () => {
        updateModal(index);
    });
});

document.getElementById("nextBtn").addEventListener("click", () => {
    let nextIndex = currentIndex + 1;
    if (nextIndex >= imageLinks.length) {
        nextIndex = 0; // wrap to start
    }
    updateModal(nextIndex);
});

document.getElementById("prevBtn").addEventListener("click", () => {
    let prevIndex = currentIndex - 1;
    if (prevIndex < 0) {
        prevIndex = imageLinks.length - 1; // wrap to end
    }
    updateModal(prevIndex);
});