<?php
/*
Plugin Name: MCNP Calculator
Description: Custom MCNP calculator with license key validation.
Version: 1.0
Author: Ranjan Deb
*/

if ( ! defined( 'ABSPATH' ) ) exit;

// Include files
require_once plugin_dir_path(__FILE__) . 'includes/license.php';
require_once plugin_dir_path(__FILE__) . 'includes/calculator.php';

// Shortcode to display calculator
function mcnp_calculator_shortcode() {
    if ( !mcnp_check_license() ) {
        return '<p style="color:red;">❌ Invalid or missing license key.</p>';
    }
    ob_start();
    include plugin_dir_path(__FILE__) . 'templates/calculator-form.php';
    return ob_get_clean();
}
add_shortcode('mcnp_calculator', 'mcnp_calculator_shortcode');
