<?php
// Save license in admin settings
function mcnp_license_menu() {
    add_options_page('MCNP License', 'MCNP License', 'manage_options', 'mcnp-license', 'mcnp_license_page');
}
add_action('admin_menu', 'mcnp_license_menu');

function mcnp_license_page() {
    if (isset($_POST['mcnp_license_key'])) {
        update_option('mcnp_license_key', sanitize_text_field($_POST['mcnp_license_key']));
        echo '<div class="updated"><p>License saved.</p></div>';
    }
    ?>
    <div class="wrap">
        <h2>MCNP License</h2>
        <form method="post">
            <input type="text" name="mcnp_license_key" value="<?php echo esc_attr(get_option('mcnp_license_key')); ?>" style="width:300px;">
            <input type="submit" value="Save" class="button button-primary">
        </form>
    </div>
    <?php
}

// License validation
function mcnp_check_license() {
    $key = get_option('mcnp_license_key');
    $valid_keys = ['ABC123', 'XYZ789']; // Replace with your actual license keys
    return in_array($key, $valid_keys);
}
