<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class model_user extends CI_Model {

	function __construct()
	{
		parent::__construct();
	}
	function get_data1()
	{
		$get_query = "SELECT * FROM tom_user ORDER BY name ASC";
		$query = $this->db->query($get_query);
		$result = $query->result();

		return $result;
	}

	function get_data()
	{
		$get_query = "SELECT * FROM tom_user 
						ORDER BY id DESC";

		$query = $this->db->query($get_query);
		$result = $query->result();

		return $result;
	}

	function get_num_data($data)
	{
		$get_query = "SELECT * FROM tom_user";

		$query = $this->db->query($get_query);
		return $query->num_rows();
	}
	
	function get_single_data($data)
	{
		$get_query = "SELECT u.*,
						ua.address 
						FROM tom_user u
						LEFT JOIN tom_user_address ua ON u.id = ua.user_id 
						WHERE u.id = ?";

		$query = $this->db->query($get_query, array($data['id']));
		$result = $query->row();

		return $result;
	}

	function add_data($data)
	{
		$valid_query = "SELECT * FROM tom_user 
							WHERE email = ? 
							OR phone = ?";
		$query = $this->db->query($valid_query, array(
														$data['email'], 
														$data['phone']
													));													
		$num = $query->num_rows();

		if($num == 0){
			$add_query = "INSERT INTO tom_user SET 
							  name = ?, 
							  phone = ?, 
							  email = ?,
							  password = ?, 
							  created = NOW(),
							  status = 'Active'";

			$this->db->query($add_query, array(
												$data['name'], 
												$data['phone'], 
												$data['email'],
												sha1($data['password'])
											));
			
			$id = $this->db->insert_id();
			return $id;
		}else{
			$value = "No";
			return $value;
		}
	}

	function update_data($data)
	{
		$valid_query = "SELECT * FROM tom_user 
							WHERE (email = ? OR phone = ?)
							AND id <> ?";

		$query = $this->db->query($valid_query, array(
														$data['email'], 
														$data['phone'], 
														$data['id']
													));

		$num = $query->num_rows();
		if($num == 0){
				$update_query = "UPDATE tom_user SET
										  name = ?, 
										  phone = ?, 
										  email = ? 
										WHERE id = ?";

				$this->db->query($update_query, array(
														$data['name'], 
														$data['phone'], 
														$data['email'],
														$data['id']
													));

				$get_query = "SELECT * FROM tom_user_address WHERE user_id = ?";

				$query = $this->db->query($get_query, array($data['id']));
				$noRows = $query->num_rows();
				$value = $data['id'];
				return $value;
		}else{
			$value = "No";
			return $value;
		}		
	}

	function change_status($data)
	{
		$update_query = "UPDATE tom_user 
							SET status = ?
							WHERE id = ?";

		$query = $this->db->query($update_query, array(
														$data['status'], 
														$data['id']
													));
		return true;
	}

	function delete($data)
	{	  
		$delete_query = "DELETE FROM tom_user 
							WHERE id = ?";

		$del_query = $this->db->query($delete_query, array($data['id']));
		return true;
	}

	function ajaxCheckEmail($data)
	{
		$get_query = "SELECT * FROM tom_user WHERE email = ?";
		$query = $this->db->query($get_query, array($data['email']));
		$result = $query->num_rows();

		return $result;
	}
	function ajaxCheckPhoneNumber($data)
	{
		$get_query = "SELECT * FROM tom_user WHERE phone = ?";
		$query = $this->db->query($get_query, array($data['phone_no']));
		$result = $query->num_rows();

		return $result;
	}

}//END CLASS
?>