<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Model_mpnpcalculator extends CI_Model {

	function __construct()
	{
		parent::__construct();
	}

	function get_data()
	{
		$get_query = "SELECT * FROM aws_calculators ORDER BY id DESC";
		$query = $this->db->query($get_query);
		$result = $query->result();

		return $result;
	}

	function get_num_data($data)
	{
		$get_query = "SELECT * FROM aws_calculators";
		$query = $this->db->query($get_query);
		return $query->num_rows();
	}
	
	function get_single_data($data)
	{
		$get_query = "SELECT * FROM aws_calculators WHERE id = ?";
		$query = $this->db->query($get_query, array($data['id']));
		$result = $query->row();

		return $result;
	}

	function add_data($data)
	{
		$add_query = "INSERT INTO aws_calculators SET 
						  calculator_name = ?,
						  calculator = ?,
						  user_id = ?,
						  license_key = ?,
						  status = 'Inactive'";

		$this->db->query($add_query, array(
							$data['calculator_name'],
							$data['calculator'],
							$data['user_id'],
							$data['license_key']
						));
		
		$id = $this->db->insert_id();
		return $id;
	}

	function update_data($data)
	{
		$update_query = "UPDATE aws_calculators SET
						calculator_name = ?,
						calculator = ?,
						user_id = ?,
						license_key = ?,
						status = 'Inactive'
						WHERE id = ?";

		$this->db->query($update_query, array(
											$data['calculator_name'],
											$data['calculator'],
											$data['user_id'],
							                $data['license_key'],
											$data['id']
											));

		$value = $data['id'];
		return $value;
	}

	function change_status($data)
	{
		if($data['status'] == "Active"){
			$get_query = "SELECT * FROM aws_calculators WHERE status ='Active'";
			$query = $this->db->query($get_query);
			$num_rows = $query->num_rows();

			if($num_rows >= 3){
				return 2;
			}else{
				$update_query = "UPDATE aws_calculators 
							SET status = ?
							WHERE id = ?";

				$query = $this->db->query($update_query, array(
											$data['status'], 
											$data['id']
										));

				return true;
			}
		}else{
			$update_query = "UPDATE aws_calculators 
							SET status = ?
							WHERE id = ?";

			$query = $this->db->query($update_query, array(
										$data['status'], 
										$data['id']
									));

			return true;

		}

		
		
	}

	function delete($data)
	{	  
		$delete_query = "DELETE FROM aws_calculators WHERE id = ?";
		$del_query = $this->db->query($delete_query, array($data['id']));
		return true;
	}

	function get_all_user_data()
	{
		$get_query = "SELECT * FROM aws_user ORDER BY id DESC";
		$query = $this->db->query($get_query);
		$result = $query->result();
		
		return $result;
	}

}//END CLASS
?>