<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class model_services extends CI_Model {

	function __construct()
	{
		parent::__construct();
	}

	// check user email exist
	public function checkUserAuthentication($data)
	{
		$qry = "SELECT * FROM aws_calculators 
					WHERE license_key = '".$data['license_key']."'";			

		$res = $this->db->query($qry);

		$num = $res->num_rows();
		if($num) {
			return true;
		} else {
			return false;
		}
	}

	// check user email exist
	public function getData($data)
	{
		$qry = "SELECT calculator FROM aws_calculators WHERE license_key = '".$data['license_key']."'";			

		$res = $this->db->query($qry);
		return $res->row();
	}
	
	// get user details
	public function getUserLogin($data)
	{
		$qry = "SELECT id,
					   name, 
					   email, 
					   phone 
					FROM tom_user  
					WHERE email = ? 
					AND password = ?  
					AND status = 'Active'";

		$res = $this->db->query($qry, array(
										$data['email'],
										SHA1($data['password'])
									));

		$num = $res->num_rows();

		if($num) {
			return $res->row();
		} else {
			return false;
		}
	}

	// check if user already exists
	public function checkUserExists($data)
	{
		$qry = "SELECT * FROM tom_user  
					WHERE email = ? 
					OR phone = ?";

		$res = $this->db->query($qry, array(
										$data['email'], 
										$data['phone']
									));
		
		return $res->num_rows();
	}

	// register a new user
	public function setUserRegistration($data)
	{
		$this->db->trans_start();
		$qry = "INSERT INTO tom_user SET 
					name = ?, 
					email = ?, 
					phone = ?, 
					password = ?, 
					status = 'Active', 
					created = NOW()";

		$res = $this->db->query($qry, array(
										$data['name'],
										$data['email'],
										$data['phone'], 
										SHA1($data['password']) 
									));

		$user_id = $this->db->insert_id();

		$qry = "INSERT INTO tom_user_address SET 
					user_id = ?, 
					address = ?";

		$res = $this->db->query($qry, array(
										$user_id,
										$data['address']
									));

		$this->db->trans_complete();
		return $user_id;
	}


	// get chef details
	public function getBannerDetails()
	{
		$qry = "SELECT bn.chef_id, 
					   bn.banner_image AS orig_image 
					FROM tom_banner bn 
					WHERE bn.status = 'Active'";

		$res = $this->db->query($qry);
		$num = $res->num_rows();

		if($num) {
			$response = $res->result();
			foreach ($response as $index => $row)
			{
		        $banner_image = site_url('uploads/banner_upload/'.$row->orig_image);
		        $response[$index]->banner_image = site_url('image.php?src='.$banner_image.'&w=222&h=110&zc=1&s=1');
			}
			return $response;
		} else {
			return false;
		}
	}

	// get chef list
	public function getChefs($data)
	{
		$qry = "SELECT cf.id, 
					   cf.chef_name, 
					   cf.chef_photo AS orig_photo, 
					   cf.price_range, 
					   GROUP_CONCAT(DISTINCT cs.name SEPARATOR ', ') AS cuisines, 
					   AVG(od.order_rating) AS average_ratings, 
					   COUNT(DISTINCT od.id) AS total_ratings 
					FROM tom_chef cf 
					LEFT JOIN tom_chef_cuisine cc 
					ON cf.id = cc.chef_id 
					INNER JOIN tom_cuisine cs 
					ON cc.cuisine_id = cs.id 
					LEFT JOIN tom_order od 
					ON cf.id = od.chef_id 
					WHERE cf.status = 'Active' 
					AND cf.is_available = 'Y'"; 

		if($data['cuisine'] != '') {

			$qry .= " AND cs.id IN (".$data['cuisine'].")";
		}

		$qry .= " GROUP BY cc.chef_id 
					ORDER BY average_ratings DESC";

		$res = $this->db->query($qry);
		$num = $res->num_rows();

		if($num) {
			$response = $res->result();
			foreach ($response as $index => $row)
			{
		        $chef_photo = site_url('uploads/chef_upload/'.$row->orig_photo);
		        $response[$index]->chef_photo = site_url('image.php?src='.$chef_photo.'&w=150&h=150&zc=1&s=1');
			}
			return $response;
		} else {
			return false;
		}
	}

	// search chefs
	public function getSearchChefs($data)
	{
		$qry = "SELECT cf.id, 
					   cf.chef_name, 
					   cf.chef_photo AS orig_photo, 
					   cf.price_range, 
					   GROUP_CONCAT(DISTINCT cs.name SEPARATOR ', ') AS cuisines, 
					   AVG(od.order_rating) AS average_ratings, 
					   COUNT(DISTINCT od.id) AS total_ratings 
					FROM tom_chef cf 
					LEFT JOIN tom_chef_cuisine cc 
					ON cf.id = cc.chef_id 
					INNER JOIN tom_cuisine cs 
					ON cc.cuisine_id = cs.id 
					LEFT JOIN tom_order od 
					ON cf.id = od.chef_id 
					WHERE cf.status = 'Active' 
					AND cf.is_available = 'Y' 
					AND (
							(cf.chef_name LIKE '%{$data['query']}%') 
							OR (cs.name LIKE '%{$data['query']}%')
						)
					GROUP BY cc.chef_id 
					ORDER BY average_ratings DESC";

		$res = $this->db->query($qry);
		$num = $res->num_rows();

		if($num) {
			$response = $res->result();
			foreach ($response as $index => $row)
			{
		        $chef_photo = site_url('uploads/chef_upload/'.$row->orig_photo);
		        $response[$index]->chef_photo = site_url('image.php?src='.$chef_photo.'&w=150&h=150&zc=1&s=1');
			}
			return $response;
		} else {
			return false;
		}
	}

	// get cuisines list
	public function getCuisines($data)
	{
		$qry = "SELECT * FROM tom_cuisine WHERE status = 'Active'";
		$res = $this->db->query($qry);
		$num = $res->num_rows();

		if($num) {
			return $res->result();
		} else {
			return false;
		}
	}

	// get food categories list
	public function getMenuCategories($data)
	{
		$qry = "SELECT * FROM tom_category WHERE status = 'Active'";
		$res = $this->db->query($qry);
		$num = $res->num_rows();

		if($num) {
			return $res->result();
		} else {
			return false;
		}
	}

	// get chef details by id
	public function getChefDetails($data)
	{
		$qry = "SELECT cf.id, 
					   cf.address,
					   cf.chef_description,
					   cf.chef_description_ar,
					   cf.chef_name,
					   cf.chef_name_ar,
					   cf.chef_photo AS orig_photo, 
					   cf.document_6 AS orig_banner, 
					   AVG(od.order_rating) AS average_ratings, 
					   COUNT(DISTINCT od.id) AS total_ratings 
					FROM tom_chef cf 
					LEFT JOIN tom_order od 
					ON cf.id = od.chef_id 
					WHERE cf.status = 'Active' 
					AND cf.id = ? 
					GROUP BY od.chef_id";

		$res = $this->db->query($qry, array($data['chef_id']));
		$num = $res->num_rows();

		if($num) {
			$response = $res->row();
			$orig_banner = site_url('uploads/doc_upload/'.$response->orig_banner);
			$response->chef_banner = site_url('image.php?src='.$orig_banner.'&w=375&h=178&zc=1&s=1');
			$orig_photo = site_url('uploads/chef_upload/'.$response->orig_photo);
			$response->chef_photo = site_url('image.php?src='.$orig_photo.'&w=150&h=150&zc=1&s=1');
			return $response;
		} else {
			return false;
		}
	}

	// get chef menu by id
	public function getChefMenu($data)
	{
		if($data['category_id'] == 0) {

			$qry = "SELECT id,
					   dish_name_en,
					   dish_name_ar,
					   description_en,
					   description_ar,
					   dish_photo AS orig_photo,
					   out_of_stock,
					   price,
					   sale_price,
					   quantity,
					   sufficient_for 
					FROM tom_chef_menu 
					WHERE status = 'Active' 
					AND chef_id = ?";

			$res = $this->db->query($qry, array($data['chef_id']));
		
		} else {

			$qry = "SELECT m.id,
					   m.dish_name_en,
					   m.dish_name_ar,
					   m.description_en,
					   m.description_ar,
					   m.dish_photo AS orig_photo,
					   m.out_of_stock,
					   m.price,
					   m.sale_price,
					   m.quantity,
					   m.sufficient_for 
					FROM tom_chef_menu m
					LEFT JOIN tom_dish_category c 
					ON m.id = c.dish_id 
					WHERE m.status = 'Active' 
					AND m.chef_id = ? 
					AND c.category_id = ?";

			$res = $this->db->query($qry, array($data['chef_id'], $data['category_id']));

		}
		
		$num = $res->num_rows();

		if($num) {
			$response = $res->result();
			foreach ($response as $index => $row)
			{
		        $dish_photo = site_url('uploads/chef_upload/'.$row->orig_photo);
		        $response[$index]->dish_photo = site_url('image.php?src='.$dish_photo.'&w=150&h=150&zc=1&s=1');
			}
			return $response;
		} else {
			return false;
		}
	}

	// get food category by chef id
	public function getFoodCategoryByChefID($data)
	{
		$qry = "SELECT ct.* 
					FROM tom_category ct 
					LEFT JOIN tom_dish_category dc 
					ON ct.id = dc.category_id 
					LEFT JOIN tom_chef_menu cm 
					ON dc.dish_id = cm.id 
					WHERE cm.status = 'Active' 
					AND cm.chef_id = ?";

		$res = $this->db->query($qry, array($data['chef_id']));
		$num = $res->num_rows();

		if($num) {
			return $res->result();
		} else {
			return false;
		}
	}

	// get dish details by id
	public function getDishDetails($data)
	{
		$qry = "SELECT cm.id, 
					   cm.dish_name_en, 
					   cm.dish_name_ar, 
					   cm.dish_photo AS orig_photo, 
					   cm.description_en,
					   cm.description_ar,
					   cm.sufficient_for, 
					   cm.quantity, 
					   cm.out_of_stock, 
					   cf.chef_name, 
					   cf.id AS chef_id, 
					   CASE WHEN cm.sale_price = 0 or cm.sale_price IS NULL THEN cm.price
						    WHEN cm.price = 0 or cm.price IS NULL THEN cm.sale_price
						    ELSE LEAST(cm.sale_price, cm.price)
					   END AS price
					FROM tom_chef_menu cm 
					LEFT JOIN tom_chef cf  
					ON cm.chef_id = cf.id 
					WHERE cm.id = ?";

		$res = $this->db->query($qry, array($data['dish_id']));
		$num = $res->num_rows();

		if($num) {
			$response = $res->row();
			$dish_photo = site_url('uploads/chef_upload/'.$response->orig_photo);
			$response->dish_photo = site_url('image.php?src='.$dish_photo.'&w=375&h=250&zc=1&s=1');
			return $response;
		} else {
			return false;
		}
	}

	// get dish details by chef id
	public function getDishDetailsByDishID($data)
	{
		$qry = "SELECT id, 
					   dish_name_en, 
					   dish_name_ar, 
					   dish_photo AS orig_photo, 
					   description_en,
					   description_ar,
					   sufficient_for, 
					   quantity 
					FROM tom_chef_menu 
					WHERE id = ? 
					AND chef_id = ?";

		$res = $this->db->query($qry, array(
											$data['dish_id'],
											$data['chef_id']
										));
		$num = $res->num_rows();

		if($num) {
			$response = $res->row();
			$dish_photo = site_url('uploads/chef_upload/'.$response->orig_photo);
			$response->dish_photo = site_url('image.php?src='.$dish_photo.'&w=375&h=250&zc=1&s=1');

			$qry1 = "SELECT id, name FROM tom_category WHERE status = 'Active'";
			$res1 = $this->db->query($qry1);
			$response->all_categories = $res1->result();

			$qry1 = "SELECT category_id FROM tom_dish_category WHERE dish_id = ?";
			$res1 = $this->db->query($qry1, array($data['dish_id']));
			$response->sel_categories = array();
			foreach($res1->result() as $row)
			{
		        $response->sel_categories[] = $row->category_id;
			}

			return $response;
		} else {
			return false;
		}
	}

	// check if item is from same chef
	public function isSameChefItem($data)
	{
		// determine if item exists in cart
		$qry = "SELECT * FROM tom_cart 
					WHERE user_id = ? 
					AND chef_id != ?";

		$res = $this->db->query($qry, array(
										$data['user_id'], 
										$data['chef_id']
									));

		$num = $res->num_rows();
		if($num > 0) {
			return false;
		} else {
			return true;
		}
	}

	// add item to cart
	public function setUserCart($data)
	{
		// determine if item exists in cart
		$qry = "SELECT id FROM tom_cart 
					WHERE user_id = ? 
					AND dish_id = ?";

		$res = $this->db->query($qry, array(
										$data['user_id'], 
										$data['dish_id']
									));
		
		$num = $res->num_rows();

		if($num > 0) {
			// if exists then update
			$row = $res->row();

			$qry = "UPDATE tom_cart SET 
						price = ?, 
						quantity = ?, 
						updated = NOW() 
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['price'], 
										$data['quantity'],
										$row->id
									));

		} else {
			// else add a new row
			$qry = "INSERT INTO tom_cart SET 
						user_id	= ?, 
						dish_id = ?, 
						chef_id = ?, 
						price = ?, 
						quantity = ?, 
						added = NOW(), 
						updated = NOW()";

			$res = $this->db->query($qry, array(
											$data['user_id'],
											$data['dish_id'],
											$data['chef_id'],
											$data['price'],
											$data['quantity']
										));
		}

		return true;
	}

	// delete item from cart
	public function deleteUserCart($data)
	{
		$qry = "DELETE FROM tom_cart  
					WHERE id = ? 
					AND user_id = ?";

		$res = $this->db->query($qry, array(
										$data['cart_id'],
										$data['user_id'],
									));

		return true;
	}

	// update user cart
	public function updateUserCart($data)	
	{
		$qry = "UPDATE tom_cart SET 
					quantity = ?, 
					updated = NOW() 
					WHERE id = ? 
					AND user_id = ?";

		$res = $this->db->query($qry, array(
									$data['quantity'],
									$data['cart_id'],
									$data['user_id']
								));

		return true;
	}

	// retrieve user cart
	public function getCartSummary($data)
	{
		$qry = "SELECT ct.id,
					   ct.price,
					   ct.quantity, 
					   cm.dish_name_en, 
					   cm.dish_name_ar,
					   cm.dish_photo AS orig_photo, 
					   cf.chef_name, 
					   cf.chef_photo AS orig_avatar, 
					   cf.id AS chef_id    
					FROM tom_cart ct 
					LEFT JOIN tom_chef_menu cm  
					ON ct.dish_id = cm.id 
					LEFT JOIN tom_chef cf 
					ON ct.chef_id = cf.id 
					WHERE ct.user_id = ?";

		$res = $this->db->query($qry, array(
										$data['user_id']
									));

		$num = $res->num_rows();

		if($num > 0) {
			$response['cart'] = $res->result();
			foreach ($response['cart'] as $index => $row)
			{
		        $dish_photo = site_url('uploads/chef_upload/'.$row->orig_photo);
		        $response['cart'][$index]->dish_photo = site_url('image.php?src='.$dish_photo.'&w=150&h=150&zc=1&s=1');
			}

			$response['chef'] = new \stdClass();
			$response['chef']->chef_id = $response['cart'][0]->chef_id;
			$chef_photo = site_url('uploads/chef_upload/'.$row->orig_avatar);
			$response['chef']->orig_avatar = $response['cart'][0]->orig_avatar;
			$response['chef']->chef_photo = site_url('image.php?src='.$chef_photo.'&w=150&h=150&zc=1&s=1');
			$response['chef']->chef_name = $response['cart'][0]->chef_name;

			// calculate cart summary
			$qry = "SELECT SUM(price * quantity) AS item_amount 
					FROM tom_cart
					GROUP BY user_id";

			$res = $this->db->query($qry, array(
										$data['user_id']
									));

			$row = $res->row();

			$response['summary'] = new \stdClass();
			$response['summary']->item_amount = $row->item_amount;

			return $response;
		} else {
			return false;
		}
	}

	// retrieve user cart item count
	public function getCartCount($data)
	{
		$qry = "SELECT SUM(quantity) AS quantity 
					FROM tom_cart 
					WHERE user_id = ?";

		$res = $this->db->query($qry, array(
										$data['user_id']
									));

		$row = $res->row();
		return $row->quantity;
	}

	// get user details by user_id
	public function getUserProfile($data)
	{
		$qry = "SELECT us.name, 
					   us.email, 
					   us.phone, 
					   ad.address,
					   ad.city,
					   ad.state,
					   ad.district,
					   ad.country,
					   ad.zip_code,
					   ad.user_lat,
					   ad.user_lng 
					FROM tom_user us 
					LEFT JOIN tom_user_address ad 
					ON us.id = ad.user_id 
					WHERE us.id = ? 
					AND ad.is_default = 'Y'";

		$res = $this->db->query($qry, array($data['user_id']));
		$num = $res->num_rows();

		if($num) {
			return $res->row();
		} else {
			return false;
		}
	}

	// get settings
	public function getSettings($data)
	{
		$qry = "SELECT * FROM tom_settings WHERE id = 1";
		$res = $this->db->query($qry);
		$num = $res->num_rows();

		if($num) {
			return $res->row();
		} else {
			return false;
		}
	}

	// get all user addresses
	public function getUserAddresses($data)
	{
		$qry = "SELECT * FROM tom_user_address 
					WHERE user_id = ? 
					ORDER BY is_default DESC, id DESC";
		$res = $this->db->query($qry, array($data['user_id']));
		$num = $res->num_rows();

		if($num) {
			return $res->result();
		} else {
			return false;
		}
	}

	// set a new user address
	public function setUserAddress($data)
	{
		if($data['is_default'] == 'undefined') $data['is_default'] = 'N';

		// reset the existing default address
		$this->db->trans_start();
		if($data['is_default'] == 'true')
		{
			$data['is_default'] = 'Y';
			$qry = "UPDATE tom_user_address SET 
							is_default = 'N' 
						WHERE user_id = ?";

			$this->db->query($qry, array($data['user_id']));
		}

		$qry = "INSERT INTO tom_user_address SET 
					user_id = ?, 
					address = ?,
					city = ?,
					state = ?,
					district = ?,
					country = ?,
					zip_code = ?,
					is_default = ?";

		$res = $this->db->query($qry, array(
										$data['user_id'],
										$data['address'],
										$data['city'],
										$data['state'],
										$data['district'],
										$data['country'],
										$data['zip_code'],
										$data['is_default']
									));

		$this->db->trans_complete();
		if($this->db->trans_status() === FALSE) {
		    return false;
		} else {
			return true;
		}
	}

	// get user address by address ID
	public function getUserAddressByID($data)
	{
		$qry = "SELECT * FROM tom_user_address 
					WHERE user_id = ? 
					AND id = ?";

		$res = $this->db->query($qry, array(
											$data['user_id'],
											$data['address_id']
										));

		$num = $res->num_rows();
		if($num) {
			return $res->row();
		} else {
			return false;
		}
	}

	// get user address by address ID
	public function updateUserAddress($data)
	{
		if($data['is_default'] == 'undefined') $data['is_default'] = 'N';

		// reset the existing default address
		$this->db->trans_start();
		if($data['is_default'] == 'true')
		{
			$data['is_default'] = 'Y';
			$qry = "UPDATE tom_user_address SET 
							is_default = 'N' 
						WHERE user_id = ?";

			$this->db->query($qry, array($data['user_id']));
		}

		$qry = "UPDATE tom_user_address SET 
						address = ?,
						city = ?,
						state = ?,
						district = ?,
						country = ?,
						zip_code = ?,
						is_default = ? 
					WHERE user_id = ? 
					AND id = ?";

		$res = $this->db->query($qry, array(
											$data['address'],
											$data['city'],
											$data['state'],
											$data['district'],
											$data['country'],
											$data['zip_code'],
											$data['is_default'],
											$data['user_id'],
											$data['address_id']
										));

		$this->db->trans_complete();
		if($this->db->trans_status() === FALSE) {
		    return false;
		} else {
			return true;
		}
	}

	// delete user address by address ID
	public function deleteUserAddress($data)
	{
		$qry = "DELETE FROM tom_user_address 
					WHERE user_id = ? 
					AND id = ? 
					AND is_default = 'N'";

		$res = $this->db->query($qry, array(
											$data['user_id'],
											$data['address_id']
										));

		return true;
	}

	// delete user address by address ID
	public function setDefaultAddress($data)
	{
		$this->db->trans_start();
		$qry = "UPDATE tom_user_address SET 
						is_default = 'N' 
					WHERE user_id = ?";

		$this->db->query($qry, array($data['user_id']));

		$qry = "UPDATE tom_user_address SET 
						is_default = 'Y' 
					WHERE user_id = ? 
					AND id = ?";

		$this->db->query($qry, array(
										$data['user_id'],
										$data['address_id']
									));

		$this->db->trans_complete();
		if($this->db->trans_status() === FALSE) {
		    return false;
		} else {
			return true;
		}
	}

	// get user scheduled orders
	public function getScheduledOrders($data)
	{
		$qry = "SELECT od.id, 
					   od.scheduled_date, 
					   od.payable_amount, 
					   od.notes, 
					   cf.chef_name,
					   cf.chef_photo AS orig_photo, 
			   		   cf.document_6 AS orig_banner 
					FROM tom_order od 
					LEFT JOIN tom_chef cf 
					ON od.chef_id = cf.id 
					WHERE od.status = 'Scheduled' 
					AND od.user_id = ? 
					ORDER BY id DESC";

		$res = $this->db->query($qry, array($data['user_id']));
		$num = $res->num_rows();

		if($num) {
			$response = $res->result();
			foreach($response as $index => $row) {
				
				$orig_banner = site_url('uploads/doc_upload/'.$row->orig_banner);
				$response[$index]->chef_banner = site_url('image.php?src='.$orig_banner.'&w=375&h=178&zc=1&s=1');
				$orig_photo = site_url('uploads/chef_upload/'.$row->orig_photo);
				$response[$index]->chef_photo = site_url('image.php?src='.$orig_photo.'&w=150&h=150&zc=1&s=1');

				$sqr = "SELECT cm.dish_name_en, 
							   cm.dish_name_ar, 
							   od.quantity  
						FROM tom_order_details od 
						LEFT JOIN tom_chef_menu cm 
						ON od.dish_id = cm.id 
						WHERE od.order_id = ?";

				$srs = $this->db->query($sqr, array($row->id));
				$response[$index]->order_details = $srs->result();
			}
			return $response;
		} else {
			return false;
		}
	}

	// get user past orders
	public function getPastOrders($data)
	{
		$qry = "SELECT od.id, 
					   od.order_date, 
					   od.payable_amount, 
					   od.shipping_address,
					   od.shipping_city,
					   od.shipping_state,
					   od.shipping_district,
					   od.shipping_zip_code,
					   od.item_amount,
					   od.tax_amount,
					   od.delivery_amount,
					   od.coupon_discount, 
					   od.status,
					   cf.chef_name,
					   cf.chef_photo AS orig_photo 
					FROM tom_order od 
					LEFT JOIN tom_chef cf 
					ON od.chef_id = cf.id 
					WHERE od.status IN ('Delivered','Cancelled') 
					AND od.user_id = ? 
					ORDER BY id DESC";

		$res = $this->db->query($qry, array($data['user_id']));
		$num = $res->num_rows();

		if($num) {
			$response = $res->result();
			foreach($response as $index => $row) {
				
				$orig_photo = site_url('uploads/chef_upload/'.$row->orig_photo);
				$response[$index]->chef_photo = site_url('image.php?src='.$orig_photo.'&w=150&h=150&zc=1&s=1');

				$sqr = "SELECT cm.dish_name_en, 
							   cm.dish_name_ar, 
							   od.quantity  
						FROM tom_order_details od 
						LEFT JOIN tom_chef_menu cm 
						ON od.dish_id = cm.id 
						WHERE od.order_id = ?";

				$srs = $this->db->query($sqr, array($row->id));
				$response[$index]->order_details = $srs->result();
			}
			return $response;
		} else {
			return false;
		}
	}

	// get coupon details
	public function getCouponDetails($data)
	{
		$qry = "SELECT * FROM tom_coupon  
					WHERE coupon_code = ? 
					AND status = 'Active'";

		$res = $this->db->query($qry, array($data['coupon_code']));

		$num = $res->num_rows();
		if($num) {
			return $res->row();
		} else {
			return false;
		}
	}

	// update user profile
	public function setUserProfile($data)
	{
		$qry = "SELECT id FROM tom_user 
					WHERE (email = ? OR phone = ?)
					AND id <> ?";

		$res = $this->db->query($qry, array(
										$data['email'],
										$data['phone'],
										$data['user_id']
									));
		
		$num = $res->num_rows();
		if($num) {
			return false;
		} else {
			$qry = "UPDATE tom_user SET 
							name = ?, 
							email = ?, 
							phone = ? 
						WHERE id = ?";					

			$res = $this->db->query($qry, array(
											$data['name'],
											$data['email'],
											$data['phone'],
											$data['user_id']
										));

			return true;
		}
	}

	// check user email exist
	public function checkUserEmail($data)
	{
		$qry = "SELECT name FROM tom_user 
					WHERE email = ?";					

		$res = $this->db->query($qry, array(
										$data['email']
									));

		$num = $res->num_rows();
		if($num) {
			return $res->row();
		} else {
			return false;
		}
	}

	// update user password by email
	public function setUserPassword($data)
	{
		$qry = "UPDATE tom_user SET 
					password = ? 
					WHERE email = ?";					

		$res = $this->db->query($qry, array(
										SHA1($data['password']),
										$data['email']
									));

		return true;
	}

	// check chef email exist
	public function checkChefEmail($data)
	{
		$qry = "SELECT chef_name FROM tom_chef 
					WHERE email = ?";					

		$res = $this->db->query($qry, array(
										$data['email']
									));

		$num = $res->num_rows();
		if($num) {
			return $res->row();
		} else {
			return false;
		}
	}

	// update chef password by email
	public function setChefPassword($data)
	{
		$qry = "UPDATE tom_chef SET 
					password = ? 
					WHERE email = ?";					

		$res = $this->db->query($qry, array(
										SHA1($data['password']),
										$data['email']
									));

		return true;
	}

	// check delivery email exist
	public function checkDeliveryEmail($data)
	{
		$qry = "SELECT delivery_name FROM tom_delivery  
					WHERE email = ?";					

		$res = $this->db->query($qry, array(
										$data['email']
									));

		$num = $res->num_rows();
		if($num) {
			return $res->row();
		} else {
			return false;
		}
	}

	// update delivery password by email
	public function setDeliveryPassword($data)
	{
		$qry = "UPDATE tom_delivery SET 
						password = ? 
					WHERE email = ?";					

		$res = $this->db->query($qry, array(
										SHA1($data['password']),
										$data['email']
									));

		return true;
	}

	// check if chef exists
	public function checkChefExists($data)
	{
		$qry = "SELECT * FROM tom_chef  
					WHERE email = ? 
					OR phone = ?";

		$res = $this->db->query($qry, array(
										$data['email'], 
										$data['phone']
									));

		return $res->num_rows();
	}

	// register a new chef
	public function setChefRegistration($data)
	{
		$qry = "INSERT INTO tom_chef SET 
					chef_name = ?, 
					email = ?, 
					phone = ?, 
					address = ?,
					password = ?, 
					application_status = 'Pending', 
					revenue_share = '0', 
					status = 'Inactive', 
					created = NOW()";

		$res = $this->db->query($qry, array(
										$data['name'],
										$data['email'],
										$data['phone'],
										$data['address'],
										SHA1($data['password'])
									));

		$user_id = $this->db->insert_id();

		return $user_id;
	}

	// update uploaded documents
	public function setChefDocuments($data)
	{
		$qry = "UPDATE tom_chef SET 
					   document_1 = ?, 
					   document_2 = ?,
					   document_3 = ?,
					   document_4 = ?, 
					   document_5 = ?, 
					   preparation_time = ?  
					WHERE id = ?";

		$res = $this->db->query($qry, array(
										$data['document_1'],
										$data['document_2'],
										$data['document_3'],
										$data['document_4'],
										$data['document_5'],
										$data['preparation_time'],
										$data['chef_id']
									));

		return true;
	}

	// edit profile of chef
	public function setChefProfileEditData($data)
	{
		if($data['chef_name'] != "")
		{
			$qry = "UPDATE tom_chef SET 
							chef_name_new = ?,
							flag = '1' 
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['chef_name'],
										$data['chef_id']
									));
		}

		if($data['chef_name_ar'] != "")
		{
			$qry = "UPDATE tom_chef SET 
							chef_name_ar_new = ?,
							flag = '1' 
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['chef_name_ar'],
										$data['chef_id']
									));
		}

		if($data['chef_description'] != "")
		{
			$qry = "UPDATE tom_chef SET 
							chef_description_new = ?,
							flag = '1' 
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['chef_description'],
										$data['chef_id']
									));
		}

		if($data['chef_description_ar'] != "")
		{
			$qry = "UPDATE tom_chef SET 
							chef_description_ar_new = ?,
							flag = '1'   
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['chef_description_ar'],
										$data['chef_id']
									));
		}

		if($data['price_range'] != "")
		{
			$qry = "UPDATE tom_chef SET 
							price_range = ?  
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['price_range'],
										$data['chef_id']
									));
		}

		if($data['cuisine_ids'] != "")
		{
			$ex = explode(",", $data['cuisine_ids']);
			$num = count($ex);

			$delete_query = "DELETE FROM tom_chef_cuisine
								 WHERE chef_id = ?";

			$del_query = $this->db->query($delete_query, array($data['chef_id']));

			for($i=0;$i<$num;$i++)
			{
				$add_query = "INSERT INTO tom_chef_cuisine SET 
									  		chef_id = ?,
									  		cuisine_id = ?";

				$query = $this->db->query($add_query, array(
														$data['chef_id'], 
														$ex[$i]
													));
			}
		}

		return true;
	}

	// get chef login details
	public function getChefLogin($data)
	{
		$qry = "SELECT id,
					   chef_name,
					   chef_name_ar,
					   email,
					   phone,
					   chef_photo as orig_photo, 
					   is_available 
					FROM tom_chef  
					WHERE email = ?
					AND password = ? 
					AND status = 'Active'";

		$res = $this->db->query($qry, array(
										$data['email'],
										SHA1($data['password'])
									));

		$num = $res->num_rows();

		if($num) {
			$response =  $res->row();
			$orig_photo = site_url('uploads/chef_upload/'.$response->orig_photo);
			$response->chef_photo = site_url('image.php?src='.$orig_photo.'&w=150&h=150&zc=1&s=1');
			return $response;
		} else {
			return false;
		}
	}

	// get details of chef
	public function getChefDetailsData($data)
	{
		$qry = "SELECT id, 
					   email, 
					   phone, 
					   is_available, 
					   chef_name,
					   chef_name_ar,
					   chef_description,
					   chef_description_ar,
					   price_range,
					   chef_photo AS orig_photo, 
					   document_6 AS orig_banner 
				FROM tom_chef  
				WHERE id = ?";

		$res = $this->db->query($qry, array(
										$data['chef_id']
									));

		$num = $res->num_rows();

		if($num) {
			$response = $res->row();
			$orig_banner = site_url('uploads/doc_upload/'.$response->orig_banner);
			$response->chef_banner = site_url('image.php?src='.$orig_banner.'&w=375&h=178&zc=1&s=1');
			$orig_photo = site_url('uploads/chef_upload/'.$response->orig_photo);
			$response->chef_photo = site_url('image.php?src='.$orig_photo.'&w=150&h=150&zc=1&s=1');

			$qry1 = "SELECT id, name FROM tom_cuisine WHERE status = 'Active'";
			$res1 = $this->db->query($qry1);
			$response->all_cuisines = $res1->result();

			$qry1 = "SELECT cuisine_id FROM tom_chef_cuisine WHERE chef_id = ?";
			$res1 = $this->db->query($qry1, array($data['chef_id']));
			$response->sel_cuisines = array();
			foreach($res1->result() as $row)
			{
		        $response->sel_cuisines[] = $row->cuisine_id;
			}
			return $response;
		} else {
			return false;
		}
	}

	// edit Picture and Banner of chef
	public function setChefImageEditData($data)
	{
		if($data['status'] == "banner")
		{
			$qry = "UPDATE tom_chef SET document_6 = ?  
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['photo'],
										$data['chef_id']
									));
		}

		if($data['status'] == "avatar")
		{
			$qry = "UPDATE tom_chef SET chef_photo = ?  
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['photo'],
										$data['chef_id']
									));
		}

		return true;
	}

	// edit picture of delivery boy
	public function setDeliveryBoyImage($data)
	{
		$qry = "UPDATE tom_delivery SET delivery_photo = ?  
						WHERE id = ?";

		$res = $this->db->query($qry, array(
									$data['photo'],
									$data['delivery_id']
								));

		return true;
	}

	// quick edit api of chef
	public function setChefQuickEditData($data)
	{
		if($data['sale_price'] == 'null') $data['sale_price'] = null;

		$qry = "UPDATE tom_chef_menu SET 
							price = ?,
							sale_price = ?, 
							out_of_stock = ?  
					WHERE chef_id = ?
					AND id = ?";

		$res = $this->db->query($qry, array(
										$data['price'],
										$data['sale_price'],
										$data['out_of_stock'],
										$data['chef_id'],
										$data['dish_id']
									));

		return true;
	}

	// get order history of chef
	public function getChefHistoryOrders($data)
	{
		$qry = "SELECT od.id,
		               od.order_number, 
					   od.order_date, 
					   od.payable_amount, 
					   od.notes, 
					   od.chef_payment, 
					   od.chef_status_date, 
					   od.order_rating   
					FROM tom_order od 
					WHERE od.status IN ('Delivered') 
					AND od.chef_id = ? 
					ORDER BY id DESC";

		$res = $this->db->query($qry, array($data['chef_id']));
		$num = $res->num_rows();

		if($num) {
			$response = $res->result();
			foreach($response as $index => $row) {				

				$sqr = "SELECT *  
						FROM tom_order_details 
						WHERE order_id = ?";

				$srs = $this->db->query($sqr, array($row->id));
				$response[$index]->order_details = $srs->result();
			}
			return $response;
		} else {
			return false;
		}
	}

	// get chef curent orders
	public function getChefCurrentOrders($data)
	{
		$qry1 = "SELECT od.id,
		               od.order_number, 
					   od.order_date, 
					   od.scheduled_date, 
					   od.payable_amount, 
					   od.notes, 
					   dl.delivery_name, 
					   dl.phone 
					FROM tom_order od 
					LEFT JOIN tom_delivery dl 
					ON od.delivery_id = dl.id 
					WHERE od.status = 'In Progress' 
					AND od.notes = 'Accepted' 
					AND od.chef_id = ? 
					ORDER BY od.id DESC";

		$res1 = $this->db->query($qry1, array($data['chef_id']));
		$num1 = $res1->num_rows();

		$qry2 = "SELECT od.id,
		               od.order_number, 
					   od.order_date, 
					   od.scheduled_date, 
					   od.payable_amount, 
					   od.notes 
					FROM tom_order od 
					WHERE od.status = 'In Progress' 
					AND od.notes = 'Pending' 
					AND od.chef_id = ? 
					ORDER BY od.id DESC";

		$res2 = $this->db->query($qry2, array($data['chef_id']));
		$num2 = $res2->num_rows();

		if($num1 || $num2) 
		{	
			$acceptedOrders = $res1->result();
			foreach($acceptedOrders as $index => $row) 
			{
				$sqr = "SELECT * FROM tom_order_details 
								WHERE order_id = ?";

				$srs = $this->db->query($sqr, array($row->id));

				$acceptedOrders[$index]->order_details = $srs->result();
			}

			$pendingOrders = $res2->result();
			foreach($pendingOrders as $index => $row) 
			{
				$sqr = "SELECT * FROM tom_order_details 
								WHERE order_id = ?";

				$srs = $this->db->query($sqr, array($row->id));

				$pendingOrders[$index]->order_details = $srs->result();
			}

			$response['accepted'] = $acceptedOrders;
			$response['pending'] = $pendingOrders;
			return $response;
		} else {
			return false;
		}
	}

	// get chef scheduled orders
	public function getChefScheduledOrders($data)
	{
		$qry1 = "SELECT od.id,
		               od.order_number, 
					   od.scheduled_date, 
					   od.payable_amount, 
					   od.notes 
					FROM tom_order od 
					WHERE od.status = 'Scheduled' 
					AND od.notes = 'Accepted' 
					AND od.chef_id = ? 
					ORDER BY od.id DESC";

		$res1 = $this->db->query($qry1, array($data['chef_id']));
		$num1 = $res1->num_rows();

		$qry2 = "SELECT od.id,
		               od.order_number, 
					   od.scheduled_date, 
					   od.payable_amount, 
					   od.notes 
					FROM tom_order od 
					WHERE od.status = 'Scheduled' 
					AND od.notes = 'Pending' 
					AND od.chef_id = ? 
					ORDER BY od.id DESC";

		$res2 = $this->db->query($qry2, array($data['chef_id']));
		$num2 = $res2->num_rows();

		if($num1 || $num2) 
		{	
			$acceptedOrders = $res1->result();
			foreach($acceptedOrders as $index => $row) 
			{
				$sqr = "SELECT * FROM tom_order_details 
								WHERE order_id = ?";

				$srs = $this->db->query($sqr, array($row->id));

				$acceptedOrders[$index]->order_details = $srs->result();
			}

			$pendingOrders = $res2->result();
			foreach($pendingOrders as $index => $row) 
			{
				$sqr = "SELECT * FROM tom_order_details 
								WHERE order_id = ?";

				$srs = $this->db->query($sqr, array($row->id));

				$pendingOrders[$index]->order_details = $srs->result();
			}

			$response['accepted'] = $acceptedOrders;
			$response['pending'] = $pendingOrders;
			return $response;
		} else {
			return false;
		}
	}

	// update Accepet/reject status ocuments
	public function getChefAcceptRejectOrders($data)
	{
		if($data['status'] == "Accepted"){
			$qry = "UPDATE tom_order SET 
							notes = ?					 
							WHERE id = ?";
			$res = $this->db->query($qry, array(
												$data['status'],
												$data['order_id']
											));
		}else{
			$qry = "UPDATE tom_order SET 
							notes = ?,
							status = ?					 
							WHERE id = ?";
			$res = $this->db->query($qry, array(
												$data['status'],
												'Cancelled',
												$data['order_id']
											));

		}

		return true;
	}

	// get available / not_available of chef
	public function getChefAvailableStatus($data)
	{
		$qry = "SELECT id, is_available					
					FROM tom_chef  
					WHERE id = ?";

		$res = $this->db->query($qry, array($data['chef_id']));
		$num = $res->num_rows();

		if($num) {
			$response = $res->row();
			return $response;
		} else {
			return false;
		}
	}

	// set available / not_available for chef
	public function setChefAvailableStatus($data)
	{
		$qry = "UPDATE tom_chef 
						SET is_available = ? 
					WHERE id = ?";

		$res = $this->db->query($qry, array(
											$data['is_available'],
											$data['chef_id']
										));
		return true;
	}

	// set available / not_available for delivery boy
	public function setDeliveryAvailableStatus($data)
	{
		$qry = "UPDATE tom_delivery  
						SET is_available = ? 
					WHERE id = ?";

		$res = $this->db->query($qry, array(
											$data['is_available'],
											$data['delivery_id']
										));
		return true;
	}

	// get menu of chef
	public function getChefMenuData($data)
	{		
		$qry = "SELECT id,
						dish_name_en,
						dish_name_ar,
						dish_photo as orig_photo,
						description_en,  
						description_ar,
						price,
						sale_price,
						sufficient_for,
						quantity,
						out_of_stock
					FROM tom_chef_menu 
					WHERE chef_id = ?
					AND status = 'Active'";

	 	$res = $this->db->query($qry, array($data['chef_id']));
		$num = $res->num_rows();

		if($num) {
			$response = $res->result();
			for($i=0;$i<count($response);$i++){
				$orig_photo = site_url('uploads/chef_upload/'.$response[$i]->orig_photo);
				$response[$i]->dish_photo = site_url('image.php?src='.$orig_photo.'&w=150&h=150&zc=1&s=1');

				$qry1 = "SELECT ct.name AS category_name 
							FROM tom_category ct 
							LEFT JOIN tom_dish_category dc 
							ON ct.id = dc.category_id 
							WHERE dc.dish_id = ?";

				$res1 = $this->db->query($qry1, array($response[$i]->id));
				$response[$i]->categories = array();
				foreach($res1->result() as $row)
				{
			        $response[$i]->categories[] = $row->category_name;
				}
			}
			return $response;
		} else {
			return false;
		}
	}

	// get finacial data of chef
	public function getChefFinancialData($data)
	{		
		$qry = "SELECT chef_name
					FROM tom_order od
					LEFT JOIN tom_chef cf 
					ON od.chef_id = cf.id  
					WHERE od.chef_id = ?";

	 	$res = $this->db->query($qry, array($data['chef_id']));
		$num = $res->num_rows();

		if($num) {
			$response = $res->row();

			// unpaid amount
			$get_order_not_requested = "SELECT SUM(chef_earning) AS TotalPaymentNotRequested 
											FROM tom_order 
											WHERE chef_id ='".$data['chef_id']."' 
											AND chef_payment ='Unpaid' 
											AND status = 'Delivered'";

			$query_order_not_requested = $this->db->query($get_order_not_requested);
			$unpaidAmount = $query_order_not_requested->row();
			$response->unpaidAmount = $unpaidAmount->TotalPaymentNotRequested;

			//approved payment
			$get_payment_approved = "SELECT SUM(chef_earning) AS TotalPaymentApproved 
										FROM tom_order 
										WHERE chef_id ='".$data['chef_id']."' 
										AND chef_payment ='Approved' 
										AND status = 'Delivered'";

			$query_payment_approved = $this->db->query($get_payment_approved);
			$tot_payment_approved = $query_payment_approved->row();
			$response->accepted = $tot_payment_approved->TotalPaymentApproved;			

			//total payment requested
			$get_payment_requested = "SELECT SUM(chef_earning) AS TotalPaymentRequested 
										FROM tom_order 
										WHERE chef_id ='".$data['chef_id']."' 
										AND chef_payment ='Requested' 
										AND status = 'Delivered'";

			$query_payment_requested = $this->db->query($get_payment_requested);
			$tot_payment_requested = $query_payment_requested->row();
			$response->requested = $tot_payment_requested->TotalPaymentRequested;

			//total payment sent 
			$get_payment_send = "SELECT SUM(chef_earning) AS TotalPaymentSent 
									FROM tom_order 
									WHERE chef_id ='".$data['chef_id']."' 
									AND chef_payment ='Sent' 
									AND status = 'Delivered'";

			$query_payment_send = $this->db->query($get_payment_send);
			$tot_payment_send = $query_payment_send->row();
			$response->sent = $tot_payment_send->TotalPaymentSent;

			//total payment rejected
			$get_payment_rejected = "SELECT SUM(chef_earning) AS TotalPaymentRejected 
										FROM tom_order 
										WHERE chef_id ='".$data['chef_id']."' 
										AND chef_payment ='Declined' 
										AND status = 'Delivered'";

			$query_payment_rejected = $this->db->query($get_payment_rejected);
			$tot_payment_rejected = $query_payment_rejected->row();
			$response->declined = $tot_payment_rejected->TotalPaymentRejected;

			return $response;
		} else {
			return false;
		}
	}
	// get food preparation time of chef
	public function getChefPreparationTime($data)
	{
		$qry = "SELECT preparation_time					
					FROM tom_chef  
					WHERE id = ?";

		$res = $this->db->query($qry, array(
										$data['chef_id']
									));

		$num = $res->num_rows();

		if($num) {
			$response =  $res->row();
			return $response;
		} else {
			return false;
		}
	}

	// set order status upadte
	public function setChefOrderStatusData($data)
	{
		$qry = "UPDATE tom_order SET 
					status = ? 
					WHERE id = ?";

		$res = $this->db->query($qry, array(
										$data['status'],
										$data['order_id']
									));

		return true;
	}

	// add menu by chef
	public function addChefMenuData($data)
	{
		$qry = "INSERT INTO tom_chef_menu SET
		 			chef_id = ?,
					dish_name_en = ?, 
					dish_name_ar = ?, 
					description_en = ?, 
					description_ar = ?,
					price = ?,
					sale_price = '0',
					sufficient_for = ?,
					quantity = ?,
					out_of_stock = 'N',	
					dish_photo = ?, 				
					status = 'Inactive', 
					created = NOW()";

		$res = $this->db->query($qry, array(
										$data['chef_id'],
										$data['dish_name'],
										$data['dish_name_ar'],
										$data['description'],
										$data['description_ar'],
										$data['price'],
										$data['sufficient_for'],
										$data['quantity'],
										$data['dish_photo']
									));

		$dish_id = $this->db->insert_id();

		if($data['categories'] != "")
		{
			$ex = explode(",", $data['categories']);
			$num = count($ex);

			for($i=0;$i<$num;$i++)
			{
				$add_query = "INSERT INTO tom_dish_category SET 
									  		dish_id = ?,
									  		category_id = ?";

				$query = $this->db->query($add_query, array(
														$dish_id, 
														$ex[$i]
													));
			}
		}

		return $dish_id;
	}

	// upload chef dish picture
	public function setChefMenuPicture($data)
	{
		$qry = "UPDATE tom_chef_menu SET 
						dish_photo_new = ?, 
						flag = '1' 
					WHERE id = ?";

		$res = $this->db->query($qry, array(
									$data['dish_photo'],
									$data['dish_id']
								));
		return true;
	}

	// edit menu by chef
	public function editChefMenuData($data)
	{
		if($data['dish_name'] != "")
		{
			$qry = "UPDATE tom_chef_menu SET 
								dish_name_en_new = ?,
								flag = '1' 
							WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['dish_name'],
										$data['dish_id']
									));
		}

		if($data['dish_name_ar'] != "")
		{
			$qry = "UPDATE tom_chef_menu SET 
								dish_name_ar_new = ?,
								flag = '1' 
							WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['dish_name_ar'],
										$data['dish_id']
									));
		}

		if($data['description'] != "")
		{
			$qry = "UPDATE tom_chef_menu SET 
								description_en_new = ?,
								flag = '1' 
							WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['description'],
										$data['dish_id']
									));
		}

		if($data['description_ar'] != "")
		{
			$qry = "UPDATE tom_chef_menu SET 
								description_ar_new = ?,
								flag = '1' 
							WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['description_ar'],
										$data['dish_id']
									));					
		}

		if($data['sufficient_for'] != "")
		{
			$qry = "UPDATE tom_chef_menu SET 
								sufficient_for_new = ?,
								flag = '1' 
							WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['sufficient_for'],
										$data['dish_id']
									));
		}

		if($data['quantity'] != "")
		{
			$qry = "UPDATE tom_chef_menu SET 
								quantity_new = ?,
								flag = '1' 
							WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['quantity'],
										$data['dish_id']
									));
		}

		if($data['categories'] != "")
		{
			$qry = "UPDATE tom_chef_menu SET 
								dish_category_new = ?,
								flag = '1' 
							WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['categories'],
										$data['dish_id']
									));
		}

		$qry1 = "UPDATE tom_chef SET flag = '1' WHERE id = ?";
		$res1 = $this->db->query($qry1, array($data['chef_id']));

		return true;
	}

	// delete menu item of chef
	public function deleteChefMenuData($data)
	{
		$qry = "UPDATE tom_chef_menu 
					SET status = 'Inactive'  
					WHERE id = ? 
					AND chef_id = ?";

		$res = $this->db->query($qry, array(
										$data['dish_id'],
										$data['chef_id'],
									));
		return true;
	}
	

	// check if delivery boy exists
	public function checkdeliveryExists($data)
	{
		$qry = "SELECT * FROM tom_delivery  
					WHERE email = ? 
					OR phone = ?";

		$res = $this->db->query($qry, array(
										$data['email'], 
										$data['phone']
									));

		return $res->num_rows();
	}

	// register a new delivery boy
	public function setDeliveryRegistration($data)
	{
		$qry = "INSERT INTO tom_delivery SET 
					delivery_name = ?, 
					email = ?, 
					phone = ?, 
					address = ?,
					password = ?, 
					application_status = 'Pending', 
					revenue_share = '0', 
					status = 'Inactive', 
					created = NOW()";

		$res = $this->db->query($qry, array(
										$data['name'],
										$data['email'],
										$data['phone'],
										$data['address'],
										SHA1($data['password'])
									));

		$user_id = $this->db->insert_id();
		return $user_id;
	}

	// check delivery boy login credentials
	public function getDeliveryLogin($data)
	{
		$qry = "SELECT id,
					   delivery_name,
					   email,
					   phone,
					   delivery_photo as orig_photo, 
					   is_available 
					FROM tom_delivery  
					WHERE email = ?
					AND password = ? 
					AND status = 'Active'";

		$res = $this->db->query($qry, array(
										$data['email'],
										SHA1($data['password'])
									));

		$num = $res->num_rows();

		if($num) {
			$response =  $res->row();
			$orig_photo = site_url('uploads/delivery_upload/'.$response->orig_photo);
			$response->delivery_photo = site_url('image.php?src='.$orig_photo.'&w=150&h=150&zc=1&s=1');
			return $response;
		} else {
			return false;
		}
	}

	// upload delivery documents
	public function setDeliveryDocuments($data)
	{
		$qry = "UPDATE tom_delivery SET 
						   document_1 = ?, 
						   document_2 = ?,
						   document_3 = ?,
						   document_4 = ?, 
						   document_5 = ?, 
						   document_6 = ?  
						WHERE id = ?";

		$res = $this->db->query($qry, array(
										$data['document_1'],
										$data['document_2'],
										$data['document_3'],
										$data['document_4'],
										$data['document_5'],
										$data['document_6'],
										$data['delivery_id']
									));
		return true;
	}

	// get curent orders of delivery
	public function getDeliveryCurentOrders($data)
	{
		$qry = "SELECT od.id,
		               od.order_number, 
					   od.order_date, 
					   cf.chef_name, 
					   cf.chef_name_ar, 
					   cf.address AS chef_address, 
					   cf.city AS chef_city, 
					   cf.state AS chef_state, 
					   cf.zipcode AS chef_zip, 
					   cf.phone AS chef_phone, 
					   us.name AS customer_name, 
					   od.shipping_address AS customer_address, 
					   od.shipping_city AS customer_city, 
					   od.shipping_state AS customer_state, 
					   od.shipping_zip_code AS customer_zip, 
					   us.phone AS customer_phone, 
					   od.notes, 
					   od.status  
					FROM tom_order od 
					LEFT JOIN tom_chef cf 
					ON od.chef_id = cf.id 
					LEFT JOIN tom_user us 
					ON od.user_id = us.id 
					WHERE od.status = 'In Progress' 
					AND od.delivery_id = ? 
					ORDER BY id DESC 
					LIMIT 1";

		$res = $this->db->query($qry, array($data['delivery_id']));
		$num = $res->num_rows();

		if($num) {
			$response = $res->row();
			$sqr = "SELECT *  
					FROM tom_order_details 
					WHERE order_id = ?";

			$srs = $this->db->query($sqr, array($response->id));
			$response->order_details = $srs->result();
			return $response;
		} else {
			return false;
		}
	}

	// get accept_or_reject of delivery boy
	public function getDeliveryAcceptRejectOrders($data)
	{
		if($data['status'] == "Accepted"){

			$sqr = "SELECT * FROM tom_order WHERE id = ?";
			$srs = $this->db->query($sqr, array($data['order_id']));
			$response =  $srs->row();
			if($response->delivery_id == ""){

				$qry = "UPDATE tom_order SET 
							delivery_id = ?					 
							WHERE id = ?";
				$res = $this->db->query($qry, array(
												$data['delivery_id'],
												$data['order_id']
											));

				$qry = "DELETE FROM tom_delivery_temp  
					    WHERE order_id = ?";
				$res = $this->db->query($qry, array($data['order_id']));
				return true;

			}else{
				return false;
			}
		}else{
			$qry = "DELETE FROM tom_delivery_temp  
					WHERE order_id = ? 
					AND delivery_id = ?";

			$res = $this->db->query($qry, array(
										$data['order_id'],
										$data['delivery_id'],
									));

			return true;
		}
	}

	// get available / not_available of delivery
	public function getDeliveryAvailableStatus($data)
	{
		$qry = "SELECT id, is_available					
					FROM tom_delivery  
					WHERE id = ?";

		$res = $this->db->query($qry, array($data['delivery_id']));
		$num = $res->num_rows();

		if($num) {
			$response =  $res->row();
			return $response;
		} else {
			return false;
		}
	}

	// get finacial data of delivery
	public function getDeliveryFinancialData($data)
	{		
		$qry = "SELECT delivery_name FROM tom_order od
					LEFT JOIN tom_delivery db 
					ON od.delivery_id = db.id  
					WHERE od.delivery_id = ?";

	 	$res = $this->db->query($qry, array($data['delivery_id']));
		$num = $res->num_rows();

		if($num) {
			$response = $res->row();

			// unpaid amount
			$get_order_not_requested = "SELECT SUM(chef_earning) AS TotalPaymentNotRequested 
											FROM tom_order 
											WHERE delivery_id ='".$data['delivery_id']."' 
											AND delivery_payment ='Unpaid' 
											AND status = 'Delivered'";

			$query_order_not_requested = $this->db->query($get_order_not_requested);
			$unpaidAmount = $query_order_not_requested->row();
			$response->unpaidAmount = $unpaidAmount->TotalPaymentNotRequested;

			//approved payment
			$get_payment_approved = "SELECT SUM(chef_earning) AS TotalPaymentApproved 
										FROM tom_order 
										WHERE delivery_id ='".$data['delivery_id']."' 
										AND delivery_payment ='Approved' 
										AND status = 'Delivered'";

			$query_payment_approved = $this->db->query($get_payment_approved);
			$tot_payment_approved = $query_payment_approved->row();
			$response->accepted = $tot_payment_approved->TotalPaymentApproved;			

			//total payment requested
			$get_payment_requested = "SELECT SUM(chef_earning) AS TotalPaymentRequested 
										FROM tom_order 
										WHERE delivery_id ='".$data['delivery_id']."' 
										AND delivery_payment ='Requested'
										AND status = 'Delivered'";

			$query_payment_requested = $this->db->query($get_payment_requested);
			$tot_payment_requested = $query_payment_requested->row();
			$response->requested = $tot_payment_requested->TotalPaymentRequested;

			//total payment sent 
			$get_payment_send = "SELECT SUM(chef_earning) AS TotalPaymentSent 
									FROM tom_order 
									WHERE delivery_id ='".$data['delivery_id']."' 
									AND delivery_payment ='Sent' 
									AND status = 'Delivered'";

			$query_payment_send = $this->db->query($get_payment_send);
			$tot_payment_send = $query_payment_send->row();
			$response->sent = $tot_payment_send->TotalPaymentSent;

			//total payment rejected
			$get_payment_rejected = "SELECT SUM(chef_earning) AS TotalPaymentRejected 
										FROM tom_order 
										WHERE delivery_id ='".$data['delivery_id']."' 
										AND delivery_payment ='Declined' 
										AND status = 'Delivered'";

			$query_payment_rejected = $this->db->query($get_payment_rejected);
			$tot_payment_rejected = $query_payment_rejected->row();
			$response->declined = $tot_payment_rejected->TotalPaymentRejected;

			return $response;
		} else {
			return false;
		}
	}

	// get order history of delivery
	public function getDeliveryHistoryOrders($data)
	{
		$qry = "SELECT od.id,
		               od.order_number, 
					   od.delivery_time, 
					   od.delivery_earning, 
					   od.delivery_payment, 
					   od.delivery_status_date  
					FROM tom_order od 
					WHERE od.status = 'Delivered' 
					AND od.delivery_id = ? 
					ORDER BY id DESC";

		$res = $this->db->query($qry, array($data['delivery_id']));
		$num = $res->num_rows();

		if($num) {
			return $res->result();
		} else {
			return false;
		}
	}

	// set order status upadte for delivery
	public function setDeliveryOrderStatusData($data)
	{
		$qry = "UPDATE tom_order SET 
					status = ? 
					WHERE id = ?";

		$res = $this->db->query($qry, array(
										$data['status'],
										$data['order_id']
									));
		return true;
	}

	// get details of delivery boy
	public function getDeliveryDetailsData($data)
	{
		$qry = "SELECT id, 
						is_available, 
						delivery_name,
						delivery_name_ar,
						address,
						address_ar,
						phone, 
						email, 
						delivery_photo as orig_photo					
					FROM tom_delivery  
					WHERE id = ?";

		$res = $this->db->query($qry, array($data['delivery_id']));
		$num = $res->num_rows();

		if($num) {
			$response =  $res->row();
			$orig_photo = site_url('uploads/delivery_upload/'.$response->orig_photo);
			$response->delivery_photo = site_url('image.php?src='.$orig_photo.'&w=150&h=150&zc=1&s=1');
			return $response;
		} else {
			return false;
		}
	}
	// edit profile of delivery boy
	public function setDeliveryProfileEditData($data)
	{
		if($data['delivery_name'] != "")
		{
			$qry = "UPDATE tom_delivery SET 
							delivery_name_new = ?,
							flag = '1' 
						WHERE id = ?";
			$res = $this->db->query($qry, array(
										$data['delivery_name'],
										$data['delivery_id']
									));
		}

		if($data['delivery_name_ar'] != "")
		{
			$qry = "UPDATE tom_delivery SET 
							delivery_name_ar_new = ?,
							flag = '1' 
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['delivery_name_ar'],
										$data['delivery_id']
									));
		}

		if($data['address'] != "")
		{
			$qry = "UPDATE tom_delivery SET 
							address_new = ?,
							flag = '1' 
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['address'],
										$data['delivery_id']
									));
		}

		if($data['address_ar'] != "")
		{
			$qry = "UPDATE tom_delivery SET 
							address_ar_new = ?,
							flag = '1'  
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['address_ar'],
										$data['delivery_id']
									));
		}

		if($data['phone'] != "")
		{
			$qry = "UPDATE tom_delivery SET 
							phone = ?  
						WHERE id = ?";

			$res = $this->db->query($qry, array(
										$data['phone'],
										$data['delivery_id']
									));
		}

		return true;
	}

	// request payment by delivery boy
	public function getDeliveryRequestPaymentData($data)
	{
		$qry = "UPDATE tom_order SET 
					delivery_payment = 'Requested',
					delivery_status_date = NOW()
					WHERE delivery_id = ?
					AND order_date <= DATE(NOW() - INTERVAL 7 DAY)";
					
		$res = $this->db->query($qry, array($data['delivery_id']));
		return true;
	}

} //END CLASS
?>