<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Signin extends CI_Controller {

	function __construct()
    {
        parent::__construct();
		$this->load->model('admin/model_signin');
		//$this->load->model('admin/model_items');
		//$this->load->model('admin/model_customers');
    }

	public function index()
	{
		if($this->session->userdata('b_logged_in') != TRUE) $this->login();
		else $this->dashboard();
	}

	public function dashboard()
	{
		$status = 'Active';
		$data['record'] = $this->model_signin->get_settings_data();
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/dashboard', $data);
		$this->load->view('admin/footer', $data);
	}

	public function login()
	{
		$data = array();
		$data['session'] = $this->session->all_userdata('admindata');	
		$data['result_copyright'] = $this->model_signin->get_copyright_data();	
		$data['result_logo'] = $this->model_signin->get_logo_data();	

		if(!isset($data['session']['admindata']['logged_in'])){
			$this->load->view('admin/signin_header', $data);	
			$this->load->view('admin/signin', $data);
			$this->load->view('admin/signin_footer', $data);			
		}else{
			redirect('admin/signin/dashboard/', 'refresh');
		}
	}

	public function authorization(){

		$data['username'] 	= $this->input->post('username');
		$data['password'] 	= $this->input->post('password');
		$result = $this->model_signin->get_admin_login($data);
			
		if($result)
		{
			$session_data = array(
								"b_username"  => "$result->admin_username",
								"b_user_id"  => "$result->admin_id",
								"b_name"  => "$result->admin_name",
								"b_site_type"  => "BACKEND",
								"b_logged_in" => "TRUE"
							);	

			$this->session->set_userdata($session_data);
			$this->model_signin->set_login_data($result->admin_id);
			redirect('admin/signin/dashboard');
		}
		else
		{
			$this->session->set_flashdata('user_ermsg', 'Invalid username or password!');
			redirect('admin/signin');
		}
	}
	
	function forgetpassword()
	{
		$data['email'] = $this->input->post('email');
		$result = $this->model_signin->forget_password($data);

		if($result != ""){
		    $this->resetpassword($result);
		    $this->session->set_flashdata('user_msg', 'Password has been sent to - '. $result->admin_email);
		}else{
			$this->session->set_flashdata('user_ermsg', 'The email entered by you does not exist!');
		} 

		redirect('admin/signin');
	}
	
	private function resetpassword($user)
	{
		date_default_timezone_set('GMT');
		$this->load->helper('string');
		$password = random_string('alnum', 6);

		$this->db->where('admin_id', $user->admin_id);
		$this->db->update('admin_master', array('admin_password'=>SHA1($password)));
		$this->load->library('email');
		$this->email->from('info@simmtronics.in', 'Simmtronics');
		$this->email->to($user->admin_email); 	
		$this->email->subject('Password Reset Request');
		$this->email->message('You have requested a new password.<br>Your new password is - '. $password);	
		$this->email->send();
	} 

	function logout()
	{
		$this->session->unset_userdata('b_username');
		$this->session->unset_userdata('b_user_id');
		$this->session->unset_userdata('b_name');
		$this->session->unset_userdata('b_logged_in');
		$this->session->unset_userdata('b_site_type');

		redirect('admin/signin');
	}

	function ajaxOrderDetails()
	{
		$order_id = $this->input->post('order_id');
		$result = $this->model_signin->get_order($order_id);
		$result_details = $this->model_signin->get_order_details($order_id);
	?>
		<table class="table table-bordered table-hover">
		<input type="hidden" name="order_id" id="order_id" value="<?php echo $result->order_number;?>">
		<input type="hidden" name="order_status" id="order_status" value="<?php echo ucwords($result->status);?>">	
            <thead>	
                <tr>
                    <th colspan="2">Order Date & Time</th>
                    <?php if($result->status == "Scheduled" ){?>
                    	<th>Order Scheduled Date & Time</th>
                    <?php }elseif($result->status == "Delivered" ){?>
                    	<th>Order Delivered Date & Time</th>
                    <?php }elseif($result->status == "Cancelled" ){?>
                    	<th>Order Cancelled Date & Time</th>
                    <?php }?>	
                    
                </tr>
            </thead>    
                <tr>
                    <td colspan="2"><?php echo date("d-m-Y H:i",strtotime($result->order_date));?></td>
                    <?php if($result->status == "Scheduled" ){?>
                    	<td><?php echo date("d-m-Y H:i",strtotime($result->scheduled_date));?></td>
                    <?php }elseif($result->status == "Delivered" ){?>
                    	<td><?php echo date("d-m-Y H:i",strtotime($result->delivery_time));?></td>
                    <?php }elseif($result->status == "Cancelled" ){?>
                    	<td><?php echo date("d-m-Y H:i",strtotime($result->cancellation_time));?></td>
                    <?php }?>
                    
                </tr>
            </table>    
            <table class="table table-bordered table-hover">
			<thead>
                <tr>
                    <th colspan="3">Customer Details</th>
                </tr>
            </thead>
			<tbody>
				<tr>
					<td colspan="3">
						Name : <?php echo $result->name;?><br>						
						Email : <?php echo $result->email;?>,<br>
						Phone : <?php echo $result->phone;?><br>
						Address : <?php echo $result->shipping_address.",".$result->shipping_city.",".$result->shipping_state.",".$result->shipping_district.",".$result->shipping_country;?><br>
						Pincode : <?php echo $result->shipping_zip_code;?>
					</td>
				</tr>
			</tbody>
			</table>
			<table class="table table-bordered table-hover">   
            <thead>
                <tr>
                    <th colspan="2">Chef Details</th>
                    <th>Delivery Boy Details</th>
                </tr>
            </thead>
	        <tbody>
				<tr>
					<td colspan="2">
						Name : <?php echo $result->chef_name;?><br>						
						Email : <?php echo $result->email;?><br>
						Phone : <?php echo $result->phone;?>
					</td>
					<td>
						Name : <?php echo $result->delivery_name;?><br>
						Email : <?php echo $result->demail;?><br>
						Phone : <?php echo $result->dphone;?>
					</td>
				</tr>
			</tbody>
			</table>	
			<table class="table table-bordered table-hover">	
                <tr>
                    <th>Dish Name</th>
                    <th>Quantity</th>
                    <th>Price</th>
                </tr>
                <?php foreach($result_details as $val){?>
				<tr>
					<td><?php echo $val['dish_name_en'];?></td>
					<td><?php echo $val['quantity'];?></td>
					<td><?php echo $val['dish_per_quantity_price'];?></td>
					<!-- <td><?php //if($val['sale_price'] == "" || $val['sale_price'] == 0.00){ echo $val['price']; }else{ echo $val['sale_price'];}?></td> -->
				</tr>
				<?php } ?>
				<?php if(isset($result->coupon_code)){?>
				<tr>
					<td colspan="2">Coupon Code : <?php echo $result->coupon_code;?></td>
					<td><?php echo $result->coupon_discount;?></td>
				</tr>
				<?php }?>
				<?php if(isset($result->tax_amount)){?>
				<tr>
					<td colspan="2">Tax : </td>
					<td><?php echo $result->tax_amount;?></td>
				</tr>
				<?php }?>
				<?php if(isset($result->delivery_amount)){?>
				<tr>
					<td colspan="2">Delivery amount : </td>
					<td><?php echo $result->delivery_amount;?></td>
				</tr>
				<?php }?>
				<tr>
					<td colspan="2">Payable amount </td>
					<td><?php echo $result->payable_amount;?></td>
				</tr>
			</table>
	<?php		
	}

}//END CLASS

/* End of file Signin.php */
/* Location: ./application/controllers/admin/Signin.php */