<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Settings extends CI_Controller {

	function __construct()
    {
        parent::__construct();
		
		// SESSION CHECK
		if($this->session->userdata('b_site_type') != "BACKEND" 
			&& $this->session->userdata('b_logged_in') != TRUE) 
		{
            redirect('admin/signin/login/');
        }

		$this->load->model('admin/model_signin');
		$this->load->model('admin/model_settings');
    }

	public function index()
	{
		$data['id'] = $this->session->userdata('b_user_id');
		$data['record'] = $this->model_settings->get_settings_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();
		
		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/settings', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function update_settings()
	{
		foreach($_POST as $key => $value) {
			$data[$key] = $this->input->post($key);
		}

		$data['image'] = $this->input->post('db_image');
		$data['default_food_image'] = $this->input->post('db_default_food_image');
		
		if($_FILES['image']['name'] != ""){
			$result = $this->upload_image("image");
			if($result['result']) {
				$data['image'] = $result['file'];
			}
		}

		if($_FILES['default_food_image']['name'] != ""){
			$result = $this->upload_default_food_image("default_food_image");
			if($result['result']) {
				$data['default_food_image'] = $result['file'];
			}
		}
		
		$result = $this->model_settings->update_settings_data($data);
		$this->session->set_flashdata('user_msg', 'Information updated successfully!');
		redirect('admin/settings');
	}
	
	// UPLOAD LOGO
	public function upload_image($field_name) {

		$config['upload_path'] = './uploads/logo_upload/';
		$config['allowed_types'] = 'jpg|jpeg|png';
		$config['max_size'] = 5120;
		$config['file_ext_tolower'] = TRUE;
		$config['encrypt_name'] = TRUE;
		
		$this->upload->initialize($config);

		if ( ! $this->upload->do_upload($field_name)) {
			$data['result'] = false;
			$data['error'] = $this->upload->display_errors('<p class="startxt">', '</p>');
		} else {
			$data['result'] = true;
			$data['file'] = $this->upload->data('file_name');
		}

		return $data;
	}

	
	// UPLOAD food iamge
	public function upload_default_food_image($field_name) {

		$config['upload_path'] = './uploads/no_image/';
		$config['allowed_types'] = 'jpg|jpeg|png';
		$config['max_size'] = 5120;
		$config['file_ext_tolower'] = TRUE;
		$config['encrypt_name'] = TRUE;
		
		$this->upload->initialize($config);

		if ( ! $this->upload->do_upload($field_name)) {
			$data['result'] = false;
			$data['error'] = $this->upload->display_errors('<p class="startxt">', '</p>');
		} else {
			$data['result'] = true;
			$data['file'] = $this->upload->data('file_name');
		}

		return $data;
	}
	
}//END CLASS

/* End of file Settings.php */
/* Location: ./application/controllers/admin/Settings.php */