<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Myaccount extends CI_Controller {

	function __construct()
    {
        parent::__construct();

		// SESSION CHECK
		if($this->session->userdata('b_site_type') != "BACKEND" 
			&& $this->session->userdata('b_logged_in') != TRUE) 
		{
            redirect('admin/signin/login/');
        }

		$this->load->model('admin/model_signin');
		$this->load->model('admin/model_myaccount');
    }

	public function index()
	{
		$data['admin_id'] = $this->session->userdata('b_user_id');
		$data['record'] = $this->model_myaccount->get_settings_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/myaccount', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function update_settings()
	{
		foreach($_POST as $key => $value) {
			$data[$key] = $this->input->post($key);
		}

		if($this->input->post('admin_password') == ""){
			$data['admin_password'] = $this->input->post('db_pass');
		}else{
			$data['admin_password'] = SHA1($this->input->post('admin_password'));				
		}

		$result = $this->model_myaccount->update_settings_data($data);

		if($result == "No"){
			$this->session->set_flashdata('admin_err', 'Information could not be updated!');
		} else {
			$this->session->set_flashdata('admin_msg', 'Information updated successfully!');
		}
		
		redirect('admin/myaccount');
	}	

}//END CLASS

/* End of file Myaccount.php */
/* Location: ./application/controllers/admin/Myaccount.php */