<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mpnpcalculator extends CI_Controller {

	function __construct()
    {
        parent::__construct();

		// SESSION CHECK
		if($this->session->userdata('b_site_type') != "BACKEND" 
			&& $this->session->userdata('b_logged_in') != TRUE) 
		{
            redirect('admin/signin/login/');
        }

		$this->load->model('admin/model_signin');
		$this->load->model('admin/model_mpnpcalculator');
    }

	public function index()
	{
		$data['status'] = 'Active';
		$data['num_tag'] = $this->model_mpnpcalculator->get_num_data($data);
		$data['record'] = $this->model_mpnpcalculator->get_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$data["page_mode"] = "LISTINGS";

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/mpnpcalculator', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function add()
	{
		$data['alluser'] = $this->model_mpnpcalculator->get_all_user_data();
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();
		$data['page_mode'] 	= "ADD";
		
		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/mpnpcalculator', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function edit($id)
	{
		$data['page_mode'] = "EDIT";
		$data['id'] = $id;
		$data['alluser'] = $this->model_mpnpcalculator->get_all_user_data();
		$data['record'] = $this->model_mpnpcalculator->get_single_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/mpnpcalculator', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function update()
	{
		$data['page_mode'] = $this->input->post('page_mode');
		
		foreach($_POST as $key => $value) {
			$data[$key] = $this->input->post($key);
		}

		

		if($data['page_mode'] == "ADD_RECORD"){			
			$result = $this->model_mpnpcalculator->add_data($data);

			if($result == "No"){
			  	$this->session->set_flashdata('admin_err', 'Record already exists!');
			  	redirect('admin/mpnpcalculator');
			}else{
			  	$this->session->set_flashdata('admin_msg', 'Record updated successfully!');
			  	redirect('admin/mpnpcalculator/edit/'.$result);
			}
		}

		if($data['page_mode'] == "UPDATE_RECORD"){
			$data['id'] = $this->input->post('id');
			$result = $this->model_mpnpcalculator->update_data($data);

			if($result == "No"){
			  	$this->session->set_flashdata('admin_err', 'Record already exists!');
			  	redirect('admin/mpnpcalculator');
			}else{
			  	$this->session->set_flashdata('admin_msg', 'Record updated successfully!');
			  	redirect('admin/mpnpcalculator/edit/'.$data['id']);
			}
		}	
	}

	public function editstatus($id)
	{
		$data['status'] = $this->input->post('status');

		if($data['status'] == "Active"){
			$data['id'] = $id;
			$data['status'] = "Inactive";
			$result = $this->model_mpnpcalculator->change_status($data);
			$this->session->set_flashdata('admin_msg', 'Status updated successfully!');
			redirect('admin/mpnpcalculator');
		}

		if($data['status'] == "Inactive"){
			$data['id'] = $id;
			$data['status'] = "Active";
			$result = $this->model_mpnpcalculator->change_status($data);
			
			$this->session->set_flashdata('admin_msg', 'Status updated successfully!');
			redirect('admin/mpnpcalculator');
		}
	}

	public function delete($id)
	{
		$data['id'] = $id;
		$result = $this->model_mpnpcalculator->delete($data);

		if($result){
			$this->session->set_flashdata('admin_msg', 'Record deleted successfully!');
			redirect('admin/mpnpcalculator');
		}
	}

}//END CLASS

/* End of file mpnpcalculator.php */
/* Location: ./application/controllers/admin/mpnpcalculators.php */