<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Services extends CI_Controller {

	function __construct()
    {
		parent::__construct();
		$this->load->model('model_services');

		// CORS headers
		header("Access-Control-Allow-Methods: GET, POST");
		header("Access-Control-Allow-Headers: Content-Type, Content-Length, Accept-Encoding");
		header("Access-Control-Allow-Origin: *");
    }

	public function index()
	{
		// initialize array variable
		$data = array();
		$response = array();

		// initialize required variables
		$data['action'] = '';
		$data['api_key'] = '';

		// get all posted variables - get or post
		if($this->input->method() == 'post') {
			foreach($_POST as $key => $value) {
				$data[$key] = $this->input->post($key);
			}
		} else {
			foreach($_GET as $key => $value) {
				$data[$key] = $this->input->get($key);
			}
		}
		// validate the retrieved data
		if($data['action'] == '' || $data['api_key'] == '') {
			$response['success'] = 0;
			$response['message'] = 'Invalid data or required parameter missingx.';
		} else if($data['api_key'] != API_KEY) {
			$response['success'] = 0;
			$response['message'] = 'Invalid API key.';
		} else {
			switch($data['action']) {				
				case 'checkUserAuthentication':
					$response = $this->checkUserAuthentication($data);					
					break;
				case 'checkChefEmail':
					$response = $this->checkChefEmail($data);
					break;
				default: 
					$response['success'] = 0;
					$response['message'] = 'Invalid action specified.';					
			}
		}
		/*echo "<pre>";
		print_r($response);
		exit;*/
		echo json_encode($response);
	}

	// check if user authentication exists
	public function checkUserAuthentication($data)
	{
		if(!isset($data['license_key']) || $data['license_key'] == '') {
			$response['success'] = 0;
			$response['message'] = 'Invalid data or required parameter missing.';
		} else {
			$result = $this->model_services->checkUserAuthentication($data);
            if($result) {
            	$result = $this->model_services->getData($data);
				$response['success'] = 1;
				$response['message'] = 'Licence key exists.';
				$response['data'] = $result;
			} else {
				$response['success'] = 0;
				$response['message'] = 'Licence key does not exist.';
			}
		}

		return $response;
	}

} //END CLASS
 
/* End of file Services.php */
/* Location: ./application/controllers/Services.php */