<?php
/*
Plugin Name: EXPRESS CALCULATOR Plugin
Description: A EXPRESS CALCULATOR plugin that stores a license key and ensures it's used on only one website.
Version: 1.0
Author: RANJAN DEB
*/

if (!defined('ABSPATH')) {
    exit; // Prevent direct access
}

/**
 *Create Database Table on Activation
 */
function osl_EXPRESS_activate_plugin() {
    global $wpdb;
    
    $table_name = $wpdb->prefix . 'osl_express_license';
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
    
    
    $table_name = $wpdb->prefix . 'osl_express_license';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        license_key varchar(255) NOT NULL,
        site_url varchar(255) NOT NULL,
        activated tinyint(1) DEFAULT 0,
        updated_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(__FILE__, 'osl_EXPRESS_activate_plugin');

/**
 * Delete Table on Uninstall
 */
function osl_EXPRESS_uninstall_plugin() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'osl_express_license';
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
}
register_uninstall_hook(__FILE__, 'osl_EXPRESS_uninstall_plugin');

/**
 *  Add Menu to Admin
 */
function osl_add_EXPRESS_admin_menu() {
    add_menu_page(
        'License Settings',
        'EXPRESS Calculator',
        'manage_options',
        'one-express-site-license',
        'osl_express_settings_page',
        'dashicons-calculator',
        90
    );
}
add_action('admin_menu', 'osl_add_EXPRESS_admin_menu');

/**
 *  Admin Page: License Form
 */
function osl_express_settings_page() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'osl_express_license';
    $current_site = site_url();

    // Handle form submission
    if (isset($_POST['osl_submit'])) {
        $license_key = sanitize_text_field($_POST['license_key']);

        // Example: Validate license key with remote API
        $response = wp_remote_get("https://convirzon.agency/Clients/convvami_admin/bkend/Services?action=checkEXPRESSUserAuthentication&api_key=uCmNRE-92H1-Ki2K-n6L5Ow8d7b1e3&license_key=$license_key&site_url=$current_site");
        /*echo "<pre>";
        print_r($response);
        exit;*/
        
        if (is_wp_error($response)) {
            echo '<div class="error"><p>Could not verify license. Please try again later.</p></div>';
        } else {
            $body = json_decode(wp_remote_retrieve_body($response), true);
            
           /* echo "<pre>";
        print_r($response);
        exit;*/
            
            if ($body['success'] === 1) {
                 if ($body['site_url'] === $current_site) {
                    // Check if record exists
                    $existing = $wpdb->get_row("SELECT * FROM $table_name LIMIT 1");
                    if ($existing) {
                        $wpdb->update(
                            $table_name,
                            array(
                                'license_key' => $license_key,
                                'site_url'    => $current_site,
                                'activated'   => 1,
                                'updated_at'  => current_time('mysql'),
                            ),
                            array('id' => $existing->id)
                        );
                    } else {
                        $wpdb->insert(
                            $table_name,
                            array(
                                'license_key' => $license_key,
                                'site_url'    => $current_site,
                                'activated'   => 1,
                                'updated_at'  => current_time('mysql'),
                            )
                        );
                    }
                    echo '<div class="updated"><p><strong>'.$body['message'].'</strong></p></div>';
                }else{
                    echo '<div class="updated"><p><strong>License not valid for this site.</strong></p></div>';
                }    
            } else {
                echo '<div class="error"><p><strong>'.$body['message'].'</strong></p></div>';
            }
        }
    }

    // Get current key
    $license_key = $wpdb->get_var("SELECT license_key FROM $table_name LIMIT 1");

    ?>
    <div class="wrap">
        <h1>License Key Settings</h1>
        <form method="post" action="">
            <table class="form-table">
                <tr>
                    <th scope="row">License Key:</th>
                    <td>
                        <input type="text" name="license_key" value="<?php echo esc_attr($license_key); ?>" size="50" />
                    </td>
                </tr>
            </table>
            <?php submit_button('Save License Key', 'primary', 'osl_submit'); ?>
        </form>
    </div>
    <?php
}

/**
 * Function to Check License Before Using Plugin Features
 */
function osl_express_is_license_valid() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'osl_express_license';
    $license = $wpdb->get_row("SELECT * FROM $table_name LIMIT 1");
    $current_site = site_url();

    if ($license && $license->activated && $license->site_url === $current_site) {
        return true;
    }
    return false;
}

// Shortcode: [api_value]
function api_express_value_shortcode( ) {
    global $wpdb;
    $current_site = site_url();
    $table_name = $wpdb->prefix . 'osl_express_license';
    $license = $wpdb->get_row("SELECT * FROM $table_name LIMIT 1");
    $license_key = $license->license_key;
     // Example: Validate license key with remote API
    $response = wp_remote_get("https://convirzon.agency/Clients/convvami_admin/bkend/Services?action=checkEXPRESSUserAuthentication&api_key=uCmNRE-92H1-Ki2K-n6L5Ow8d7b1e3&license_key=".$license_key."&site_url=$current_site");
    
    if (is_wp_error($response)) {
            echo '<div class="error"><p>Could not verify license. Please try again later.</p></div>';
    } else {
        $body = json_decode(wp_remote_retrieve_body($response), true);
        if ($body['success'] === 1) {
                // If API returns other structure, show raw response
                return '<pre>'.print_r( $body['values'], true ) . '</pre>';    
        } else {
            echo '<div class="error"><p><strong>'.$body['message'].'</strong></p></div>';
        }
    }
}
add_shortcode( 'api_express_value', 'api_express_value_shortcode' );
