<?php $var_page_name = "customers"; ?>
<div class="page-container">
	<div class="page-head">
		<div class="container">
			<div class="page-title">
				<h1><?=APP_NAME?> Control Panel</h1>
			</div>
		</div>
	</div>

	<div class="page-content">
		<div class="container">
			<ul class="page-breadcrumb breadcrumb">
				<li>
					<a href="<?=site_url("admin/signin/dashboard");?>">Home</a><i class="fa fa-circle"></i>
				</li>
				<li class="active">
                    <?=ucwords($var_page_name)?>
                </li>
            </ul>
          
            <?php if($page_mode == "LISTINGS") { ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="portlet box blue-hoki">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class="fa fa-user"></i><?=ucwords($var_page_name)?> List
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div id="load_product" style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background-color: #EFF3F8; z-index: 99; height: 100%;">
                                <img src="<?=site_url("assets/global/img/loading.gif");?>" id="load_image" align="center" style="position: absolute; left: 55%; top: 250px; background-repeat: no-repeat; background-position: center; margin: -100px 0 0 -100px;" />
                            </div>

                            <div class="table-toolbar">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="btn-group">
                                            <button id="btn_add" class="btn green">Add New <i class="fa fa-plus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <form id="formlisting" name="formlisting" action="" method="post">
                                <input type="hidden" name="page_mode" id="page_mode" value="" />
                                <input type="hidden" name="status" id="status" value="" />
                                <?php if($this->session->flashdata('admin_msg') != "") { ?>
                                <div class="alert alert-success alert-dismissable" style="margin-top:10px;">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
                                    <strong>Success:</strong> <?=$this->session->flashdata('admin_msg');?>
                                </div>
                                <?php } ?>
                                <?php if($this->session->flashdata('admin_err') != "") { ?>
                                <div class="alert alert-danger alert-dismissable" style="margin-top:10px;">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
                                    <strong>Error:</strong> <?=$this->session->flashdata('admin_err');?>
                                </div>
                                <?php } ?>
                                <table class="table table-bordered table-hover" id="sample_2">
                                    <thead>
                                        <tr>
                                            <th>Full Name</th>
                                            <th>Email</th>
                                            <th>Contact No.</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <?php if($num_tag > 0): ?>
                                    <tbody>
                                        <?php foreach($record as $value): ?>
                                        <tr class="odd gradeX">
                                            <td style="width:150px;"><?=$value->name?></td>
                                            <td style="width:150px;"><?=$value->email?></td>
                                            <td style="width:150px;"><?=$value->phone?></td>
                                            <td style="width:300px;">
                                                <?php if($value->status == "Active"): ?>
                                                <a href="javascript:edit_status('<?=site_url('admin/user/editstatus/'.$value->id);?>','<?=$value->status?>')" class="btn btn-xs green" style="margin-bottom: 5px;"><i class="fa fa-check"></i> Active</a>
                                                <?php else: ?>
                                                <a href="javascript:edit_status('<?=site_url('admin/user/editstatus/'.$value->id);?>','<?=$value->status?>')" class="btn btn-xs red" style="margin-bottom: 5px;"><i class="fa fa-times"></i> Inactive</a>
                                                <?php endif; ?>
                                                <a href="javascript:edit_record('<?=site_url('admin/user/edit/'.$value->id);?>')" class="btn btn-xs yellow" style="margin-bottom: 5px;"><i class="fa fa-edit"></i> Edit </a><!-- <i class="fa fa-eye"></i> Edit</a> -->
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                    <?php endif; ?>
                                </table>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
            <?php }?>

            <?php if($page_mode == "ADD" || $page_mode == "EDIT") { ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="portlet box blue-hoki">
                        <div class="portlet-title">
                            <div class="caption"><i class="fa fa-user"></i><?php if($page_mode == "EDIT"){ ?> View <?php }else{?> Add <?php }?><?=ucfirst($var_page_name)?></div>
                        </div>
                        <div class="portlet-body form">

                            <form name="frm_add" id="frm_add" class="form-horizontal" action="" method="post" enctype="multipart/form-data">
                                <input type="hidden" name="id" id="id" value="<?=($page_mode == "EDIT") ? $record->id : "";?>" />
                                <input type="hidden" id="page_mode" name="page_mode" value="" />
                                <div class="form-body">

                                    <div class="alert alert-danger display-hide">
                                        <button class="close" data-close="alert"></button>
                                        You have some form errors. Please check below.
                                    </div>

                                    <?php if($this->session->flashdata('admin_msg') != "") { ?>
                                    <div class="alert alert-success alert-dismissable" style="margin-top:10px;">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
                                        <strong>Success:</strong> <?=$this->session->flashdata('admin_msg');?>
                                    </div>
                                    <?php } ?>

                                    <?php if($this->session->flashdata('admin_err') != "") { ?>
                                    <div class="alert alert-danger alert-dismissable" style="margin-top:10px;">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
                                        <?=$this->session->flashdata('admin_err');?>
                                    </div>
                                    <?php } ?>

                                    <ul class="nav nav-tabs nav-fill" role="tablist">
                                        <li class="nav-item active">
                                            <a class="nav-link active" data-toggle="tab" href="#m_tabs_1_1" aria-expanded="true"><?=ucfirst($var_page_name)?> Details</a>
                                        </li>
                                    </ul>

                                    <div class="tab-content">
                                        <div class="tab-pane active" id="m_tabs_1_1" role="tabpanel">
                                            <div class="form-group">
                                                <label class="col-md-2 control-label">Full Name</label>
                                                <div class="col-md-4">
                                                    <input type="text" class="form-control" name="name" id="name" value="<?=($page_mode == "EDIT") ? $record->name : "";?>">
                                                </div>
                                            </div>

                                            <!-- <div class="form-group">
                                                <label class="col-md-2 control-label">Address</label>
                                                <div class="col-md-4">
                                                    <input type="text" class="form-control" name="address" id="address" value="<?=($page_mode == "EDIT") ? $record->address : "";?>">
                                                </div>
                                            </div> -->

                                            <div class="form-group">
                                                <label class="col-md-2 control-label">Email</label>
                                                <div class="col-md-4">
                                                    <input type="text" class="form-control" name="email" id="email" value="<?=($page_mode == "EDIT") ? $record->email : "";?>">
                                                    <div id="email_err_msg" style="color: red;"></div>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="col-md-2 control-label">Phone</label>
                                                <div class="col-md-4">
                                                    <input type="text" class="form-control" name="phone" id="phone" value="<?=($page_mode == "EDIT") ? $record->phone : "";?>">
                                                    <div id="err_msg" style="color: red;"></div>
                                                </div>
                                            </div>
                                            <?php if($page_mode == "ADD"){?>
                                            <div class="form-group">
                                                <label class="col-md-2 control-label">Password</label>
                                                <div class="col-md-4">
                                                    <input type="password" class="form-control" name="password" id="password" value="">
                                                </div>
                                            </div>
                                            <?php }?>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-actions">
                                    <div class="row">
                                        <div class="col-md-offset-3 col-md-9">
                                            <?php if($page_mode == "ADD"){?>
                                            <button type="button" class="btn green" id="btn_submit">Submit</button>
                                            <?php }else{?>
                                            <button type="button" class="btn green" id="btn_submit">Update</button>
                                            <?php }?>
                                            <button type="button" class="btn default" id="btn_cancel">Back</button>
                                        </div>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php }?>
        </div>
    </div>
</div>