<!-- BEGIN PAGE CONTAINER -->
<div class="page-container">
	<!-- BEGIN PAGE HEAD -->
	<div class="page-head">
		<div class="container">
			<!-- BEGIN PAGE TITLE -->
			<div class="page-title">
				<h1><?=APP_NAME?> Control Panel</h1>
			</div>
			<!-- END PAGE TITLE -->
		</div>
	</div>
	<!-- END PAGE HEAD -->
	<!-- BEGIN PAGE CONTENT -->
	<div class="page-content">
		<div class="container">
			<!-- BEGIN PAGE BREADCRUMB -->
			<ul class="page-breadcrumb breadcrumb">
				<li>
					<a href="<?=site_url("admin/signin/dashboard");?>">Home</a><i class="fa fa-circle"></i>
				</li>
				<li class="active">
					Users
				</li>
			</ul>
			<!-- END PAGE BREADCRUMB -->
			<?php if($page_mode == "LISTINGS") { ?>
			<!-- BEGIN PAGE CONTENT INNER -->
			<div class="row">
				<div class="col-md-12">
					<!-- BEGIN EXAMPLE TABLE PORTLET-->
					<div class="portlet box blue-hoki">
						<div class="portlet-title">
							<div class="caption">
								<i class="fa fa-users"></i>Users
							</div>
						</div>
						<div class="portlet-body">
							<div class="table-toolbar">
								<div class="row">
									<div class="col-md-6">
										<div class="btn-group">
											<button id="btn_add" class="btn green">
												Add New <i class="fa fa-plus"></i>
											</button>
										</div>
									</div>
								</div>
							</div>
							<form id="formlisting" name="formlisting" action="" method="post">
								<input type="hidden" name="page_mode" id="page_mode" value="" />
								<input type="hidden" name="status" id="status" value="" />
								<?php if($this->session->flashdata('admin_msg') != "") { ?>
								<div class="alert alert-success alert-dismissable" style="margin-top:10px;">
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
									<strong>Success:</strong> <?=$this->session->flashdata('admin_msg');?>
								</div>
								<?php } ?>
								<?php if($this->session->flashdata('admin_err') != "") { ?>
								<div class="alert alert-danger alert-dismissable" style="margin-top:10px;">
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
									<strong>Error:</strong> <?=$this->session->flashdata('admin_err');?>
								</div>
								<?php } ?>
								<table class="table table-bordered table-hover" id="sample_2">
									<thead>
										<tr>
											<th>Name</th>
											<th>Username</th>
											<th>Email</th>
											<th>User Type</th>
											<th>Action</th>
										</tr>
									</thead>
									<?php if($num_tag > 0){?>
									<tbody>
										<?php foreach($record as $value) {?>
										<tr class="odd gradeX">
											<td><?=$value->admin_name?></td>
											<td><?=$value->admin_username?></td>
											<td><?=$value->admin_email?></td>	
											<td>
												<?php
												if($value->user_type == 1){
													echo "Super Admin";
												}elseif($value->user_type == 2){
													echo "Finance";
												}elseif($value->user_type == 3){
													echo "Customer Service";
												}	
												?>
													
											</td>
											<td>
												<?php if($value->status == "Active"){ ?>
												<a href="javascript:admin_edit_status('<?=site_url('admin/adminuser/editstatus/'.$value->admin_id);?>','<?=$value->status?>')" class="btn btn-xs green"  style="margin-bottom: 5px;"><i class="fa fa-check"></i>
													Active
												</a>
												<?php }else{ ?>
												<a href="javascript:edit_status('<?=site_url('admin/adminuser/editstatus/'.$value->admin_id);?>','<?=$value->status?>')" class="btn btn-xs red"  style="margin-bottom: 5px;"><i class="fa fa-times"></i>
													Inactive
												</a>
												<?php }?>
												<a href="javascript:edit_admin_record('<?=site_url('admin/adminuser/edit/'.$value->admin_id);?>')" class="btn btn-xs yellow"  style="margin-bottom: 5px;">
													<i class="fa fa-edit"></i> Edit 
												</a>
												<!-- <a href="javascript:delete_admin_record('<?=site_url('admin/adminuser/delete/'.$value->admin_id);?>')" class="btn btn-xs red">
													<i class="fa fa-trash"></i> Delete 
												</a> -->
											</td>
										</tr>
										<?php }?>
									</tbody>
									<?php } ?>
								</table>
							</form>
						</div>
					</div>
					<!-- END EXAMPLE TABLE PORTLET-->
				</div>
			</div>
			<!-- END PAGE CONTENT INNER -->
			<?php }?>
			<?php if($page_mode == "ADD" || $page_mode == "EDIT") { ?>
			<!-- BEGIN PAGE CONTENT INNER -->
			<div class="row">
				<div class="col-md-12">
					<div class="portlet box blue-hoki">
						<div class="portlet-title">
							<div class="caption">
								<i class="fa fa-users"></i><?php if($page_mode == "EDIT"){ ?> Edit <?php }else{?> Add <?php }?> User
							</div>
						</div>
						<div class="portlet-body form">
							<!-- BEGIN FORM-->
							<form name="frm_adminuser" id="frm_adminuser" class="form-horizontal" action="" method="post" enctype="multipart/form-data">
								<input type="hidden" name="admin_id" value="<?=($page_mode == "EDIT") ? $record->admin_id : "";?>" />
								<input type="hidden" id="page_mode" name="page_mode" value="" />
								<div class="form-body">
									<div class="alert alert-danger display-hide">
										<button class="close" data-close="alert"></button>
										You have some form errors. Please check below.
									</div>
									<?php if($this->session->flashdata('admin_msg') != "") { ?>
									<div class="alert alert-success alert-dismissable" style="margin-top:10px;">
										<button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
										<strong>Success:</strong> <?=$this->session->flashdata('admin_msg');?>
									</div>
									<?php } ?>
									<?php if($this->session->flashdata('admin_err') != "") { ?>
									<div class="alert alert-danger alert-dismissable" style="margin-top:10px;">
										<button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
										<?=$this->session->flashdata('admin_err');?>
									</div>
									<?php } ?>
									<div class="form-group">
										<label class="col-md-3 control-label">Name <span class="required">*</span></label>
										<div class="col-md-4">
											<input type="text" class="form-control" name="admin_name" id="admin_name" value="<?=($page_mode == "EDIT") ? $record->admin_name : "";?>">
										</div>
									</div>
									<!-- <div class="form-group">
										<label class="col-md-3 control-label">Phone <span class="required">*</span></label>
										<div class="col-md-4">
											<input type="text" maxlength="10" class="form-control" name="admin_phone" id="admin_phone" value="<?=($page_mode == "EDIT") ? $record->admin_phone : "";?>" <?=($page_mode == "EDIT") ? "readonly" : "";?>>
										</div>
									</div> -->
									<div class="form-group">
										<label class="col-md-3 control-label">Username <span class="required">*</span></label>
										<div class="col-md-4">
											<input type="text" class="form-control" name="admin_username" id="admin_username" value="<?=($page_mode == "EDIT") ? $record->admin_username : "";?>">
										</div>
									</div>
									<div class="form-group">
										<label class="control-label col-md-3">Password <?php if($page_mode != "EDIT"){?><span class="required">* </span><?php }?> </label>
										<input type="hidden" name="db_pass" id="db_pass" value="<?php if(isset($record->user_type) && $record->admin_password != ""){ echo $record->admin_password;}else{ echo "";}?>" />
										<div class="col-md-4">
											<input type="password" class="form-control" rows="10" name="admin_password" id="admin_password" value="<?=($page_mode == "EDIT") ? "" : "";?>" />
										</div>
									</div>
									<div class="form-group">
										<label class="col-md-3 control-label">Email<span class="required">* </span></label>
										<div class="col-md-4">
											<div class="input-group">
												<span class="input-group-addon">
													<i class="fa fa-envelope"></i>
												</span>
												<input type="text" class="form-control" name="admin_email" id="admin_email" value="<?=($page_mode == "EDIT") ? $record->admin_email : "";?>" <?=($page_mode == "EDIT") ? "readonly" : "";?>>
											</div>
										</div>   
									</div>
									<div class="form-group">
										<label class="col-md-3 control-label">Role<span class="required">* </span></label>
										<div class="col-md-4">
											<select class="form-control select2me" name="user_type" id="user_type">
												<option value="">Select</option>
												<option value="1" <?php if($page_mode == "EDIT" && $record->user_type == "1"): ?> selected="selected" <?php endif; ?>>Super Admin</option>
												<option value="2" <?php if($page_mode == "EDIT" && $record->user_type == "2"): ?> selected="selected" <?php endif; ?>>Finance</option>
												<option value="3" <?php if($page_mode == "EDIT" && $record->user_type == "3"): ?> selected="selected" <?php endif; ?>>Customer Service</option>
											</select>
										</div>
									</div>
								</div>
								<div class="form-actions">
									<div class="row">
										<div class="col-md-offset-3 col-md-9">
											<?php if($page_mode == "ADD"){?>
											<button type="button" class="btn green" id="btn_submit">Submit</button>
											<?php }else{?>
											<button type="button" class="btn green" id="btn_submit">Update</button>
											<?php }?>
											<button type="button" class="btn default" id="btn_cancel">Cancel</button>
										</div>
									</div>
								</div>
							</form>
							<!-- END FORM-->
						</div>
					</div>
				</div>
			</div>
			<!-- END PAGE CONTENT INNER -->
			<?php }?>
		</div>
	</div>
	<!-- END PAGE CONTENT -->
</div>
<!-- END PAGE CONTAINER