<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class model_signin extends CI_Model {

	function __construct()
	{
		parent::__construct();
	}

	function get_admin_login($data)
	{
		$get_query = "SELECT * FROM tom_admin_master 
						WHERE admin_username = ? 
					  	AND admin_password = ? 
					  	AND status = 'Active'";

		$query = $this->db->query($get_query, array($data['username'], SHA1($data['password'])));

		if ($query->num_rows()) 
		{
			return $query->row();
		}
	}

	function set_login_data($id)
	{
		$ip = $this->input->ip_address();
		$set_query = "UPDATE tom_admin_master SET 
							admin_last_login = NOW(),
							admin_last_ip = ? 
						WHERE admin_id = ?";

		$this->db->query($set_query, array($ip, $id));
		return true;
	}

	function get_settings_data()
	{
		$get_query = "SELECT * FROM tom_admin_master 
						WHERE admin_id = ?";

		$query = $this->db->query($get_query, array($this->session->userdata('b_user_id')));
		return $query->row();
	}
	
	function get_copyright_data()
	{
		$get_query = "SELECT copyright FROM tom_settings";

		$query = $this->db->query($get_query);
		$num = $query->num_rows();
		$result = $query->row();

		if($num > 0){
			$organization = $result->copyright;
		}else{
			$organization = "";
		}
		
		return $organization;
	}
	
	function get_code_data()
	{
		$get_query = "SELECT * FROM tom_settings";

		$query = $this->db->query($get_query);
		$num = $query->num_rows();
		$result = $query->row();

		if($num > 0){
			$organization = $result;
		}else{
			$organization = "";
		}
		
		return $organization;
	}
	
	function get_logo_data()
	{
		$get_query = "SELECT image FROM tom_settings";

		$query = $this->db->query($get_query);
		$num = $query->num_rows();
		$result = $query->row();

		if($num > 0){
			$logo = $result->image;
		}else{
			$logo = "";
		}

		return $logo;
	}

	function forget_password($data)
	{
		$get_query = "SELECT * FROM tom_admin_master 
						WHERE admin_email = ?";

		$query = $this->db->query($get_query, array($data['email']));
		$num = $query->num_rows();
		$result = $query->row();
		
		if($num > 0){
			return $result;
		}
	}

	function get_tot_orders()
	{
		$get_query = "SELECT * FROM tom_order";
		$query = $this->db->query($get_query);
		return $query->num_rows();
	}

	function get_tot_users()
	{
		$get_query = "SELECT * FROM tom_user WHERE status = 'Active'";
		$query = $this->db->query($get_query);
		return $query->num_rows();
	}

	function get_tot_chefs()
	{
		$get_query = "SELECT * FROM tom_chef  WHERE status = 'Active'";
		$query = $this->db->query($get_query);
		return $query->num_rows();
	}

	function get_tot_deliveryboys()
	{
		$get_query = "SELECT * FROM tom_delivery  WHERE status = 'Active'";
		$query = $this->db->query($get_query);
		return $query->num_rows();
	}

	function get_tot_avilable_chefs()
	{
		$get_query = "SELECT * FROM tom_chef  WHERE is_available = 'Y' AND status = 'Active'";
		$query = $this->db->query($get_query);
		return $query->num_rows();
	}	

	function get_tot_avilable_deliveryboys()
	{
		$get_query = "SELECT * FROM tom_delivery  WHERE is_available = 'Y' AND status = 'Active'";
		$query = $this->db->query($get_query);
		return $query->num_rows();
	}

	function get_num_data($data)
	{
		$get_query = "SELECT * FROM tom_order";
		$query = $this->db->query($get_query);
		return $query->num_rows();
	}
	function get_data()
	{
		// $get_query = "SELECT od.*,ur.name,cf.chef_name,del.delivery_name FROM tom_order od, tom_user ur, tom_chef cf, tom_delivery del WHERE od.user_id = ur.id AND od.chef_id = cf.id AND od.delivery_id = del.id  ORDER BY od.id DESC LIMIT 0,9";

		$get_query = "SELECT od.*,
						ur.name,
						cf.chef_name,
						del.delivery_name
						FROM tom_order od
						LEFT JOIN tom_user ur ON od.user_id = ur.id
						LEFT JOIN tom_chef cf ON od.chef_id = cf.id
						LEFT JOIN tom_delivery del ON od.delivery_id = del.id
						ORDER BY od.id DESC LIMIT 0,9";
						
		$query = $this->db->query($get_query);
		$result = $query->result_array();

		return $result;
	}

	function get_order($order_id)
	{

		// $get_query = "SELECT od.*,ur.name,ur.email,ur.phone,del.delivery_name,del.email,del.phone,chef.chef_name,chef.email,chef.phone FROM tom_order od, tom_user ur, tom_delivery del, tom_chef chef WHERE od.user_id = ur.id AND od.delivery_id = del.id AND od.chef_id = chef.id AND od.id = '".$order_id."'";

		$get_query = "SELECT od.*,
						ur.name,
						ur.email,
						ur.phone,
						del.delivery_name,
						del.email demail,
						del.phone dphone,
						chef.chef_name,
						chef.email,
						chef.phone 
						FROM tom_order od
						LEFT JOIN tom_user ur ON od.user_id = ur.id
						LEFT JOIN tom_chef chef ON od.chef_id = chef.id
						LEFT JOIN tom_delivery del ON od.delivery_id = del.id						
						WHERE od.id = '".$order_id."'";

		$query = $this->db->query($get_query);
		$result = $query->row();

		return $result;
	}

	function get_order_details($order_id)
	{
		// $get_query = "SELECT dis.* 
		// 				FROM tom_order_details od
		// 				LEFT JOIN tom_chef_menu dis ON od.dish_id = dis.id
		// 				WHERE od.order_id = '".$order_id."'";
		$get_query = "SELECT * FROM tom_order_details WHERE order_id = '".$order_id."'";				
		$query = $this->db->query($get_query);
		$result = $query->result_array();
		return $result;
	}

	function get_notification_chefs()
	{
		$get_query = "SELECT * FROM tom_chef WHERE flag = '1' AND application_status = 'Accepted'";
		$query = $this->db->query($get_query);
		return $query->num_rows();
	}
	function get_notification_delivery()
	{
		$get_query = "SELECT * FROM tom_delivery WHERE flag = '1' AND application_status = 'Accepted'";
		$query = $this->db->query($get_query);
		return $query->num_rows();
	}

}//END CLASS
?>