<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class model_reviews extends CI_Model {

	function __construct()
	{
		parent::__construct();
	}
	function get_data1()
	{
		$get_query = "SELECT * FROM aws_user ORDER BY name ASC";
		$query = $this->db->query($get_query);
		$result = $query->result();

		return $result;
	}

	function get_data()
	{
		$get_query = "SELECT * FROM aws_user 
						ORDER BY id DESC";

		$query = $this->db->query($get_query);
		$result = $query->result();

		return $result;
	}

	function get_num_data($data)
	{
		$get_query = "SELECT * FROM aws_user";

		$query = $this->db->query($get_query);
		return $query->num_rows();
	}
	
	function get_single_data($data)
	{
		$get_query = "SELECT *
						FROM aws_user
						WHERE id = ?";

		$query = $this->db->query($get_query, array($data['id']));
		$result = $query->row();

		return $result;
	}

	function add_data($data)
	{
		$valid_query = "SELECT * FROM aws_user 
							WHERE email = ? 
							OR phone = ?";
		$query = $this->db->query($valid_query, array(
														$data['email'], 
														$data['phone']
													));													
		$num = $query->num_rows();

		if($num == 0){
			$add_query = "INSERT INTO aws_user SET 
							  name = ?, 
							  phone = ?, 
							  email = ?,
							  password = ?, 
							  created = NOW(),
							  status = 'Active'";

			$this->db->query($add_query, array(
												$data['name'], 
												$data['phone'], 
												$data['email'],
												sha1($data['password'])
											));
			
			$id = $this->db->insert_id();
			return $id;
		}else{
			$value = "No";
			return $value;
		}
	}

	function update_data($data)
	{
		$valid_query = "SELECT * FROM aws_user 
							WHERE email = ?
							AND id <> ?";

		$query = $this->db->query($valid_query, array(
														$data['email'], 
														$data['id']
													));

		$num = $query->num_rows();
		if($num == 0){
				$update_query = "UPDATE aws_user SET
										  name = ?, 
										  phone = ?, 
										  email = ? 
										WHERE id = ?";

				$this->db->query($update_query, array(
														$data['name'], 
														$data['phone'], 
														$data['email'],
														$data['id']
													));
				$value = $data['id'];
				return $value;
		}else{
			$value = "No";
			return $value;
		}		
	}

	function change_status($data)
	{
		$update_query = "UPDATE aws_user 
							SET status = ?
							WHERE id = ?";

		$query = $this->db->query($update_query, array(
														$data['status'], 
														$data['id']
													));
		return true;
	}

	function delete($data)
	{	  
		$delete_query = "DELETE FROM aws_user 
							WHERE id = ?";

		$del_query = $this->db->query($delete_query, array($data['id']));
		return true;
	}

	function ajaxCheckEmail($data)
	{
		$get_query = "SELECT * FROM aws_user WHERE email = ?";
		$query = $this->db->query($get_query, array($data['email']));
		$result = $query->num_rows();

		return $result;
	}
	function ajaxCheckPhoneNumber($data)
	{
		$get_query = "SELECT * FROM aws_user WHERE phone = ?";
		$query = $this->db->query($get_query, array($data['phone_no']));
		$result = $query->num_rows();

		return $result;
	}

}//END CLASS
?>