<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User extends CI_Controller {

	function __construct()
    {
        parent::__construct();

		// SESSION CHECK
		if($this->session->userdata('b_site_type') != "BACKEND" 
			&& $this->session->userdata('b_logged_in') != TRUE) 
		{
            redirect('admin/signin/login/');
        }

		$this->load->model('admin/model_signin');
		$this->load->model('admin/model_user');
    }

	public function index()
	{
		$data['status'] = 'Active';
		$data['num_tag'] = $this->model_user->get_num_data($data);
		$data['record'] = $this->model_user->get_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$data["page_mode"] = "LISTINGS";

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/user', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function add()
	{
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();
		$data['page_mode'] 	= "ADD";
		
		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/user', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function edit($id)
	{
		$data['page_mode'] = "EDIT";
		$data['id'] = $id;
		$data['record'] = $this->model_user->get_single_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/user', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function update()
	{
		$data['page_mode'] = $this->input->post('page_mode');
		
		foreach($_POST as $key => $value) {
			$data[$key] = $this->input->post($key);
		}

		if($data['page_mode'] == "ADD_RECORD"){
			if($data['password'] != ""){
				$data['password'] =sha1($data['password']);
			}
			
			$result = $this->model_user->add_data($data);

			if($result == "No"){
			  	$this->session->set_flashdata('admin_err', 'Record already exists!');
			  	redirect('admin/user');
			}else{
			  	$this->session->set_flashdata('admin_msg', 'Record updated successfully!');
			  	redirect('admin/user/edit/'.$result);
			}
		}

		if($data['page_mode'] == "UPDATE_RECORD"){
			$data['id'] = $this->input->post('id');
			$result = $this->model_user->update_data($data);

			if($result == "No"){
			  	$this->session->set_flashdata('admin_err', 'Record already exists!');
			  	redirect('admin/user');
			}else{
			  	$this->session->set_flashdata('admin_msg', 'Record updated successfully!');
			  	redirect('admin/user/edit/'.$data['id']);
			}
		}	
	}

	public function upload_image($field_name) {

		$config['upload_path'] = './uploads/img_upload/';
		$config['allowed_types'] = 'jpg|jpeg';
		$config['max_size'] = 5120;
		$config['file_ext_tolower'] = TRUE;
		$config['encrypt_name'] = TRUE;
		
		$this->upload->initialize($config);

		if ( ! $this->upload->do_upload($field_name)) {
			$data['result'] = false;
			$data['error'] = $this->upload->display_errors('<p class="startxt">', '</p>');
		} else {
			$data['result'] = true;
			$data['file'] = $this->upload->data('file_name');
		}

		return $data;
	}

	public function editstatus($id)
	{
		$data['status'] = $this->input->post('status');

		if($data['status'] == "Active"){
			$data['id'] = $id;
			$data['status'] = "Inactive";
			$result = $this->model_user->change_status($data);
			$this->session->set_flashdata('admin_msg', 'Status updated successfully!');
			redirect('admin/user');
		}

		if($data['status'] == "Inactive"){
			$data['id'] = $id;
			$data['status'] = "Active";
			$result = $this->model_user->change_status($data);
			$this->session->set_flashdata('admin_msg', 'Status updated successfully!');
			redirect('admin/user');
		}
	}

	public function delete($id)
	{
		$data['id'] = $id;
		$result = $this->model_user->delete($data);

		if($result){
			$this->session->set_flashdata('admin_msg', 'Record deleted successfully!');
			redirect('admin/user');
		}
	}

	public function userorders($id){
		$data['id'] = $id;
		$data['num_tag'] = $this->model_user->get_num_orders($data);
		$data['record'] = $this->model_user->listing_orders($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$data["page_mode"] = "LISTINGS";

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/userorders', $data);
		$this->load->view('admin/footer', $data);
	}

	public function order_details(){
		$data['id'] = $this->input->post('order_id');
		$records = $this->model_user->get_order_data($data);		
		echo json_encode($records);
	}

	public function ajaxCheckEmail()
	{
		$data['email'] = $this->input->post('email');
		$result = $this->model_user->ajaxCheckEmail($data);
		echo $result;exit;
	}
	public function ajaxCheckPhoneNumber()
	{
		$data['phone_no'] = $this->input->post('phone_no');
		$result = $this->model_user->ajaxCheckPhoneNumber($data);
		echo $result;exit;
	}

}//END CLASS

/* End of file users.php */
/* Location: ./application/controllers/admin/users.php */