<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sinpcalculator extends CI_Controller {

	function __construct()
    {
        parent::__construct();

		// SESSION CHECK
		if($this->session->userdata('b_site_type') != "BACKEND" 
			&& $this->session->userdata('b_logged_in') != TRUE) 
		{
            redirect('admin/signin/login/');
        }

		$this->load->model('admin/model_signin');
		$this->load->model('admin/model_sinpcalculator');
		$this->load->model('admin/model_user');
    }

	public function index()
	{
	   
	    $data['status'] = 'Active';
		$data['num_tag'] = $this->model_sinpcalculator->get_num_data($data);
		$data['record'] = $this->model_sinpcalculator->get_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_code'] = $this->model_signin->get_code_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$data["page_mode"] = "LISTINGS";

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/sinpcalculator', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function add()
	{
		$data['alluser'] = $this->model_sinpcalculator->get_all_user_data();
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_code'] = $this->model_signin->get_code_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();
		$data['page_mode'] 	= "ADD";
		
		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/sinpcalculator', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function edit($id)
	{
		$data['page_mode'] = "EDIT";
		$data['id'] = $id;
		$data['alluser'] = $this->model_sinpcalculator->get_all_user_data();
		$data['record'] = $this->model_sinpcalculator->get_single_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_code'] = $this->model_signin->get_code_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/sinpcalculator', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function update()
	{
		$data['page_mode'] = $this->input->post('page_mode');
		
		foreach($_POST as $key => $value) {
			$data[$key] = $this->input->post($key);
		}
		
		/*echo "<pre>";
		print_r($data);
		exit;*/

		

		if($data['page_mode'] == "ADD_RECORD"){			
			$result = $this->model_sinpcalculator->add_data($data);

			if($result == "No"){
			  	$this->session->set_flashdata('admin_err', 'Record already exists!');
			  	redirect('admin/sinpcalculator');
			}else{
			  	$this->session->set_flashdata('admin_msg', 'Record updated successfully!');
			  	redirect('admin/sinpcalculator/edit/'.$result);
			}
		}

		if($data['page_mode'] == "UPDATE_RECORD"){
			$data['id'] = $this->input->post('id');
			$result = $this->model_sinpcalculator->update_data($data);

			if($result == "No"){
			  	$this->session->set_flashdata('admin_err', 'Record already exists!');
			  	redirect('admin/sinpcalculator');
			}else{
			  	$this->session->set_flashdata('admin_msg', 'Record updated successfully!');
			  	redirect('admin/sinpcalculator/edit/'.$data['id']);
			}
		}	
	}

	public function editstatus($id)
	{
		$data['status'] = $this->input->post('status');

		if($data['status'] == "Active"){
			$data['id'] = $id;
			$data['status'] = "Inactive";
			/*echo "<pre>";
			print_r($data);
			exit;*/
			$result = $this->model_sinpcalculator->change_status($data);
			$this->session->set_flashdata('admin_msg', 'Status updated successfully!');
			redirect('admin/sinpcalculator');
		}

		if($data['status'] == "Inactive"){
			$data['id'] = $id;
			$data['status'] = "Active";
				/*echo "<pre>";
			print_r($data);
			exit;*/
			$result = $this->model_sinpcalculator->change_status($data);
			
			$this->session->set_flashdata('admin_msg', 'Status updated successfully!');
			redirect('admin/sinpcalculator');
		}
	}

	public function delete($id)
	{
		$data['id'] = $id;
		$result = $this->model_sinpcalculator->delete($data);

		if($result){
			$this->session->set_flashdata('admin_msg', 'Record deleted successfully!');
			redirect('admin/sinpcalculator');
		}
	}

}//END CLASS

/* End of file sinpcalculator.php */
/* Location: ./application/controllers/admin/sinpcalculators.php */