<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reviews extends CI_Controller {

	function __construct()
    {
        parent::__construct();

		// SESSION CHECK
		if($this->session->userdata('b_site_type') != "BACKEND" 
			&& $this->session->userdata('b_logged_in') != TRUE) 
		{
            redirect('admin/signin/login/');
        }

		$this->load->model('admin/model_signin');
		//$this->load->model('admin/model_reviews');
    }

	public function index()
	{
	    echo "123";exit;
		/*$data['status'] = 'Active';
		$data['num_tag'] = $this->model_reviews->get_num_data($data);
		$data['record'] = $this->model_reviews->get_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$data["page_mode"] = "LISTINGS";

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/reviews', $data);
		$this->load->view('admin/footer', $data);*/			
	}

	public function add()
	{
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();
		$data['page_mode'] 	= "ADD";
		
		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/reviews', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function edit($id)
	{
		$data['page_mode'] = "EDIT";
		$data['id'] = $id;
		$data['record'] = $this->model_reviews->get_single_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$this->load->view('admin/header', $data);
		$this->load->view('admin/menu', $data);
		$this->load->view('admin/reviews', $data);
		$this->load->view('admin/footer', $data);			
	}

	public function update()
	{
		$data['page_mode'] = $this->input->post('page_mode');
		
		foreach($_POST as $key => $value) {
			$data[$key] = $this->input->post($key);
		}

		if($data['page_mode'] == "ADD_RECORD"){
			if($data['password'] != ""){
				$data['password'] =sha1($data['password']);
			}
			
			$result = $this->model_reviews->add_data($data);

			if($result == "No"){
			  	$this->session->set_flashdata('admin_err', 'Record already exists!');
			  	redirect('admin/reviews');
			}else{
			  	$this->session->set_flashdata('admin_msg', 'Record updated successfully!');
			  	redirect('admin/reviews/edit/'.$result);
			}
		}

		if($data['page_mode'] == "UPDATE_RECORD"){
			$data['id'] = $this->input->post('id');
			$result = $this->model_reviews->update_data($data);

			if($result == "No"){
			  	$this->session->set_flashdata('admin_err', 'Record already exists!');
			  	redirect('admin/reviews');
			}else{
			  	$this->session->set_flashdata('admin_msg', 'Record updated successfully!');
			  	redirect('admin/reviews/edit/'.$data['id']);
			}
		}	
	}

	public function upload_image($field_name) {

		$config['upload_path'] = './uploads/img_upload/';
		$config['allowed_types'] = 'jpg|jpeg';
		$config['max_size'] = 5120;
		$config['file_ext_tolower'] = TRUE;
		$config['encrypt_name'] = TRUE;
		
		$this->upload->initialize($config);

		if ( ! $this->upload->do_upload($field_name)) {
			$data['result'] = false;
			$data['error'] = $this->upload->display_errors('<p class="startxt">', '</p>');
		} else {
			$data['result'] = true;
			$data['file'] = $this->upload->data('file_name');
		}

		return $data;
	}

	public function editstatus($id)
	{
		$data['status'] = $this->input->post('status');

		if($data['status'] == "Active"){
			$data['id'] = $id;
			$data['status'] = "Inactive";
			$result = $this->model_reviews->change_status($data);
			$this->session->set_flashdata('admin_msg', 'Status updated successfully!');
			redirect('admin/reviews');
		}

		if($data['status'] == "Inactive"){
			$data['id'] = $id;
			$data['status'] = "Active";
			$result = $this->model_reviews->change_status($data);
			$this->session->set_flashdata('admin_msg', 'Status updated successfully!');
			redirect('admin/reviews');
		}
	}

	public function delete($id)
	{
		$data['id'] = $id;
		$result = $this->model_reviews->delete($data);

		if($result){
			$this->session->set_flashdata('admin_msg', 'Record deleted successfully!');
			redirect('admin/reviews');
		}
	}

}//END CLASS

/* End of file reviews.php */
/* Location: ./application/controllers/admin/reviews.php */