<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Adminuser extends CI_Controller {

	function __construct()
    {
        parent::__construct();

		// SESSION CHECK
		if($this->session->userdata('b_site_type') != "BACKEND" 
			&& $this->session->userdata('b_username') != "admin") 
		{
            redirect('admin/signin/login/');
        }

		$this->load->model('admin/model_signin');
		$this->load->model('admin/model_adminuser');
    }

	public function index()
	{
		$data['status'] = 'Active';
		$data['num_tag'] = $this->model_adminuser->get_num_data($data);
		$data['record'] = $this->model_adminuser->get_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$data["page_mode"] = "LISTINGS";

		$this->load->view('admin/header',$data);
		$this->load->view('admin/menu',$data);
		$this->load->view('admin/adminuser',$data);
		$this->load->view('admin/footer',$data);			
	}

	public function add()
	{
		$data['page_mode'] 	= "ADD";
		//$data['usertype'] = $this->model_adminuser->get_usertype_data($data);
		//$data['properties'] = $this->model_property->get_data();
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();
		
		$this->load->view('admin/header',$data);
		$this->load->view('admin/menu',$data);
		$this->load->view('admin/adminuser',$data);
		$this->load->view('admin/footer',$data);			
	}

	public function edit($id)
	{
		$data['page_mode'] = "EDIT";
		$data['admin_id'] = $id;
		//$data['usertype'] = $this->model_adminuser->get_usertype_data($data);
		$data['record'] = $this->model_adminuser->get_single_data($data);
		$data['result_copyright'] = $this->model_signin->get_copyright_data();
		$data['result_logo'] = $this->model_signin->get_logo_data();

		$this->load->view('admin/header',$data);
		$this->load->view('admin/menu',$data);
		$this->load->view('admin/adminuser',$data);
		$this->load->view('admin/footer',$data);			
	}

	public function update()
	{ 
		$data['page_mode'] 	= $this->input->post('page_mode');

		foreach($_POST as $key => $value) {
			$data[$key] = $this->input->post($key);
		}

		if($this->input->post('admin_password') == "") {
			$data['admin_password'] = $this->input->post('db_pass');
		} else {
			$data['admin_password'] = SHA1($this->input->post('admin_password'));				
		}
		// echo '<pre>';
		// print_r($data);
		// exit;
		
		if($data['page_mode'] == "ADD_RECORD") {

			$result = $this->model_adminuser->add_data($data);

			if($result == "No")
			{
			  	$this->session->set_flashdata('admin_err', 'Phone or Email already exists!');
			  	redirect('admin/adminuser');
			}
			else
			{
				$data['admin_id'] = $result;
				
				// if($this->session->userdata('b_user_type') != "1")
				// {
				// 	$this->model_adminuser->add_permission($data, $this->session->userdata('property_id'));
				// }
				// else
				// {
				// 	foreach($data['properties'] as $value)
				// 	{
				// 		$this->model_adminuser->add_permission($data, $value);
				// 	}
				// }

			  	$this->session->set_flashdata('admin_msg', 'Information updated successfully!');
			  	redirect('admin/adminuser/edit/'.$result);
			}
		}

		if($data['page_mode'] == "UPDATE_RECORD") {

			$result = $this->model_adminuser->update_data($data);

			if($result == "No")
			{
				$this->session->set_flashdata('admin_err', 'Username or Email already exists!');
				redirect('admin/adminuser/edit/'.$data['admin_id']);
		  	}
		  	else
		  	{
		  // 		if($this->session->userdata('b_user_type') == "1")
		  // 		{
				// 	$this->model_adminuser->delete_permission($data);

				// 	foreach($data['properties'] as $value)
				// 	{
				// 		$this->model_adminuser->add_permission($data, $value);
				// 	}
				// }

				$this->session->set_flashdata('admin_msg', 'Information updated successfully!');
				redirect('admin/adminuser/edit/'.$data['admin_id']);
			}
		}
	}
	
	public function editstatus($id)
	{
		$data['status'] = $this->input->post('status');

		if($data['status'] == "Active"){
			$data['admin_id'] = $id;
			$data['status'] = "Inactive";
			$result = $this->model_adminuser->change_status($data);
			$this->session->set_flashdata('admin_msg', 'Status updated successfully!');
			redirect('admin/adminuser');
		}

		if($data['status'] == "Inactive"){
			$data['admin_id'] = $id;
			$data['status'] = "Active";
			$result = $this->model_adminuser->change_status($data);
			$this->session->set_flashdata('admin_msg', 'Status updated successfully!');
			redirect('admin/adminuser');
		}
	}

	public function delete($id)
	{
		$data['admin_id'] = $id;
		$result = $this->model_adminuser->delete($data);

		if($result == 1){
			$this->session->set_flashdata('admin_msg', 'Information deleted successfully!');
			redirect('admin/adminuser');
		}	
	}

}//END CLASS

/* End of file Adminuser.php */
/* Location: ./application/controllers/admin/Adminuser.php */