<?php 

if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Services extends CI_Controller {



	function __construct()

    {

		parent::__construct();

		$this->load->model('model_services');



		// CORS headers

		header("Access-Control-Allow-Methods: GET, POST");

		header("Access-Control-Allow-Headers: Content-Type, Content-Length, Accept-Encoding");

		header("Access-Control-Allow-Origin: *");

    }



	public function index()

	{

		// initialize array variable

		$data = array();

		$response = array();



		// initialize required variables

		$data['action'] = '';

		$data['api_key'] = '';



		// get all posted variables - get or post

		if($this->input->method() == 'post') {

			foreach($_POST as $key => $value) {

				$data[$key] = $this->input->post($key);

			}

		} else {

			foreach($_GET as $key => $value) {

				$data[$key] = $this->input->get($key);

			}

		}

		// validate the retrieved data

		if($data['action'] == '' || $data['api_key'] == '') {

			$response['success'] = 0;

			$response['message'] = 'Invalid data or required parameter missing.';

            $response['site_url'] = "";

			$response['values'] = "";

			//$response = 'Invalid data or required parameter missing.';

		} else if($data['api_key'] != API_KEY) {

			$response['success'] = 0;

			$response['message'] = 'Invalid API key.';

            $response['site_url'] = "";

			$response['values'] = "";

			//$response = 'Invalid API key.';

		} else {

			switch($data['action']) {				

				case 'checkUserAuthentication':

					$response = $this->checkUserAuthentication($data);					

					break;

				case 'checkCLBUserAuthentication':

				    //echo "111";exit;

					$response = $this->checkCLBUserAuthentication($data);					

					break;	

				case 'checkCRSUserAuthentication':

					$response = $this->checkCRSUserAuthentication($data);					

					break;

				case 'checkBCPNPUserAuthentication':

					$response = $this->checkBCPNPUserAuthentication($data);					

					break;
					
				case 'checkEXPRESSUserAuthentication':

					$response = $this->checkEXPRESSUserAuthentication($data);					

					break;
					
				case 'check67UserAuthentication':

					$response = $this->check67UserAuthentication($data);					

					break;	

				case 'checkSINPUserAuthentication':

					$response = $this->checkSINPUserAuthentication($data);					

					break;

				case 'checkOINPUserAuthentication':

					$response = $this->checkOINPUserAuthentication($data);					

					break;		

				default: 

					$response['success'] = 0;

					$response['message'] = 'Invalid action specified.';

                    $response['site_url'] = "";

			        $response['values'] = "";

					//$response = 'Invalid action specified.';

			}

		}

		/*echo "<pre>";

		print_r($response);

		exit;*/

	   echo json_encode($response);

	}



	// check if user authentication exists in MPNP

	public function checkUserAuthentication($data)

	{

		if(!isset($data['license_key']) || $data['license_key'] == '') {

			$response['success'] = 0;

			$response['message'] = 'Invalid data or required parameter missing.';

            $response['site_url'] = "";

			$response['values'] = "";

			//$response = 'Invalid data or required parameter missing.';

		} else {

			$result = $this->model_services->checkUserAuthentication($data);

            if($result > 0) {

                $result1 = $this->model_services->checkLickeyValid($data);

                 if($result1 > 0){

                    $result = $this->model_services->getData($data);

                    $response['success'] = 1;

                    $response['message'] = 'License verified and saved successfully!';

                    $response['site_url'] = $result->site_url;

                    $response['values'] = $result->calculator;

                 }else{

                    $response['success'] = 0;

                    $response['message'] = 'Licence key does not exist.';

                    $response['site_url'] = "";

                    $response['values'] = ""; 

                    //$response = 'Licence key date expired.';  

                 }

			} else {

				$response['success'] = 0;

				$response['message'] = 'Licence key not active.';

                $response['site_url'] = "";

			    $response['values'] = "";

				//$response = 'Licence key does not exist.';

			}

		}



		return $response;

	}

	

	// check if user authentication exists in CLB

	public function checkCLBUserAuthentication($data)

	{

		if(!isset($data['license_key']) || $data['license_key'] == '') {

			$response['success'] = 0;

			$response['message'] = 'Invalid data or required parameter missing.';

            $response['site_url'] = "";

			$response['values'] = "";

			//$response = 'Invalid data or required parameter missing.';

		} else {

			$result = $this->model_services->checkCLBUserAuthentication($data);

            if($result > 0) {

                $result1 = $this->model_services->checkCLBLickeyValid($data);

                

                 if($result1 > 0){

                    $result = $this->model_services->getCLBData($data);

                    $response['success'] = 1;

                    $response['message'] = 'License verified and saved successfully!';

                    $response['site_url'] = $result->site_url;

                    $response['values'] = $result->calculator;

                 }else{

                    $response['success'] = 0;

                    $response['message'] = 'Licence key does not exist.xxx';

                    $response['site_url'] = "";

                    $response['values'] = ""; 

                    //$response = 'Licence key date expired.';  

                 }

			} else {

				$response['success'] = 0;

				$response['message'] = 'Licence key not active.';

                $response['site_url'] = "";

			    $response['values'] = "";

				//$response = 'Licence key does not exist.';

			}

		}



		return $response;

	}

	

	// check if user authentication exists in CRS

	public function checkCRSUserAuthentication($data)

	{

		if(!isset($data['license_key']) || $data['license_key'] == '') {

			$response['success'] = 0;

			$response['message'] = 'Invalid data or required parameter missing.';

            $response['site_url'] = "";

			$response['values'] = "";

			//$response = 'Invalid data or required parameter missing.';

		} else {

			$result = $this->model_services->checkCRSUserAuthentication($data);

            if($result > 0) {

                $result1 = $this->model_services->checkCRSLickeyValid($data);

                

                 if($result1 > 0){

                    $result = $this->model_services->getCRSData($data);

                    $response['success'] = 1;

                    $response['message'] = 'License verified and saved successfully!';

                    $response['site_url'] = $result->site_url;

                    $response['values'] = $result->calculator;

                    

                    

                    

                    

                    

                 }else{

                    $response['success'] = 0;

                    $response['message'] = 'Licence key does not exist.xxx';

                    $response['site_url'] = "";

                    $response['values'] = ""; 

                    //$response = 'Licence key date expired.';  

                 }

			} else {

				$response['success'] = 0;

				$response['message'] = 'Licence key not active.';

                $response['site_url'] = "";

			    $response['values'] = "";

				//$response = 'Licence key does not exist.';

			}

		}



		return $response;

	}

	

	// check if user authentication exists in BCPNP

	public function checkBCPNPUserAuthentication($data)

	{

	    

		if(!isset($data['license_key']) || $data['license_key'] == '') {

			$response['success'] = 0;

			$response['message'] = 'Invalid data or required parameter missing.';

            $response['site_url'] = "";

			$response['values'] = "";

			//$response = 'Invalid data or required parameter missing.';

		} else {

			$result = $this->model_services->checkBCPNPUserAuthentication($data);

            if($result > 0) {

                //echo "1111";exit;

                $result1 = $this->model_services->checkBCPNPLickeyValid($data);

                

                 if($result1 > 0){

                    $result = $this->model_services->getBCPNPData($data);

                    $response['success'] = 1;

                    $response['message'] = 'License verified and saved successfully!';

                    $response['site_url'] = $result->site_url;

                    $response['values'] = $result->calculator;

                 }else{

                    $response['success'] = 0;

                    $response['message'] = 'Licence key does not exist.';

                    $response['site_url'] = "";

                    $response['values'] = ""; 

                    //$response = 'Licence key date expired.';  

                 }

			} else {

				$response['success'] = 0;

				$response['message'] = 'Licence key not active.';

                $response['site_url'] = "";

			    $response['values'] = "";

				//$response = 'Licence key does not exist.';

			}

		}



		return $response;

	}
	
	// check if user authentication exists in 67

	public function check67UserAuthentication($data)

	{

	    

		if(!isset($data['license_key']) || $data['license_key'] == '') {

			$response['success'] = 0;

			$response['message'] = 'Invalid data or required parameter missing.';

            $response['site_url'] = "";

			$response['values'] = "";

			//$response = 'Invalid data or required parameter missing.';

		} else {

			$result = $this->model_services->check67UserAuthentication($data);

            if($result > 0) {

                //echo "1111";exit;

                $result1 = $this->model_services->check67LickeyValid($data);

                

                 if($result1 > 0){

                    $result = $this->model_services->get67Data($data);

                    $response['success'] = 1;

                    $response['message'] = 'License verified and saved successfully!';

                    $response['site_url'] = $result->site_url;

                    $response['values'] = $result->calculator;

                 }else{

                    $response['success'] = 0;

                    $response['message'] = 'Licence key does not exist.';

                    $response['site_url'] = "";

                    $response['values'] = ""; 

                    //$response = 'Licence key date expired.';  

                 }

			} else {

				$response['success'] = 0;

				$response['message'] = 'Licence key not active.';

                $response['site_url'] = "";

			    $response['values'] = "";

				//$response = 'Licence key does not exist.';

			}

		}



		return $response;

	}

	// check if user authentication exists in EXPRESS

	public function checkEXPRESSUserAuthentication($data)

	{

	    

		if(!isset($data['license_key']) || $data['license_key'] == '') {

			$response['success'] = 0;

			$response['message'] = 'Invalid data or required parameter missing.';

            $response['site_url'] = "";

			$response['values'] = "";

			//$response = 'Invalid data or required parameter missing.';

		} else {

			$result = $this->model_services->checkEXPRESSUserAuthentication($data);

            if($result > 0) {

                //echo "1111";exit;

                $result1 = $this->model_services->checkEXPRESSLickeyValid($data);

                

                 if($result1 > 0){

                    $result = $this->model_services->getEXPRESSData($data);

                    $response['success'] = 1;

                    $response['message'] = 'License verified and saved successfully!';

                    $response['site_url'] = $result->site_url;

                    $response['values'] = $result->calculator;

                 }else{

                    $response['success'] = 0;

                    $response['message'] = 'Licence key does not exist.';

                    $response['site_url'] = "";

                    $response['values'] = ""; 

                    //$response = 'Licence key date expired.';  

                 }

			} else {

				$response['success'] = 0;

				$response['message'] = 'Licence key not active.';

                $response['site_url'] = "";

			    $response['values'] = "";

				//$response = 'Licence key does not exist.';

			}

		}



		return $response;

	}	

	// check if user authentication exists in SINP

	public function checkSINPUserAuthentication($data)

	{

	    

		if(!isset($data['license_key']) || $data['license_key'] == '') {

			$response['success'] = 0;

			$response['message'] = 'Invalid data or required parameter missing.';

            $response['site_url'] = "";

			$response['values'] = "";

			//$response = 'Invalid data or required parameter missing.';

		} else {

			$result = $this->model_services->checkSINPUserAuthentication($data);

            if($result > 0) {

                $result1 = $this->model_services->checkSINPLickeyValid($data);

                

                 if($result1 > 0){

                    $result = $this->model_services->getSINPData($data);

                    $response['success'] = 1;

                    $response['message'] = 'License verified and saved successfully!';

                    $response['site_url'] = $result->site_url;

                    $response['values'] = $result->calculator;

                    

                 }else{

                    $response['success'] = 0;

                    $response['message'] = 'Licence key does not exist.xxx';

                    $response['site_url'] = "";

                    $response['values'] = ""; 

                    //$response = 'Licence key date expired.';  

                 }

			} else {

				$response['success'] = 0;

				$response['message'] = 'Licence key not active.';

                $response['site_url'] = "";

			    $response['values'] = "";

				//$response = 'Licence key does not exist.';

			}

		}



		return $response;

	}


	// check if user authentication exists in SINP

	public function checkOINPUserAuthentication($data)

	{

	    

		if(!isset($data['license_key']) || $data['license_key'] == '') {

			$response['success'] = 0;

			$response['message'] = 'Invalid data or required parameter missing.';

            $response['site_url'] = "";

			$response['values'] = "";

			//$response = 'Invalid data or required parameter missing.';

		} else {

			$result = $this->model_services->checkOINPUserAuthentication($data);

            if($result > 0) {

                $result1 = $this->model_services->checkOINPLickeyValid($data);

                

                 if($result1 > 0){

                    $result = $this->model_services->getOINPData($data);

                    $response['success'] = 1;

                    $response['message'] = 'License verified and saved successfully!';

                    $response['site_url'] = $result->site_url;

                    $response['values'] = $result->calculator;

                    

                 }else{

                    $response['success'] = 0;

                    $response['message'] = 'Licence key does not exist.xxx';

                    $response['site_url'] = "";

                    $response['values'] = ""; 

                    //$response = 'Licence key date expired.';  

                 }

			} else {

				$response['success'] = 0;

				$response['message'] = 'Licence key not active.';

                $response['site_url'] = "";

			    $response['values'] = "";

				//$response = 'Licence key does not exist.';

			}

		}



		return $response;

	}



} //END CLASS

 

/* End of file Services.php */

/* Location: ./application/controllers/Services.php */