<?php
/*
* Template Name: Listing Page
*/
?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'thumbnail' );
   if($url != "")
   {
   $img = $url; 
   }else{
   $img = $template_url."images/crumbs/about-us.jpg";
   }
?>
<?php $postID = get_queried_object_id();
$parent_id = $post->post_parent;
?>
<!-- breadcrumb start -->
    <section class="page_breadcrumb position-relative" style="background-image: url(<?php echo $img;?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb_wrapper d-flex flex-column align-items-center justify-content-center">
                        <h2 class="breadcrumb_title text-white"><?php the_title();?></h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php the_title();?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section id="page_services" class="padding_t margin_t">
        <div class="container">
            <div class="services_header">
                <?php the_content();?>
                <div class="d-flex mx-auto justify-content-center">
                    <a href="#" class="theme_button" data-text="Book&nbsp;an&nbsp;Appointment">
                    </a>
                </div>
            </div>
        </div>
    </section>
    <section id="page_services_wrap">
        <div class="container">
            <div class="row services_row services_slider justify-content-center">
                <?php
                    $args = array(
                                'post_type'      => 'page',
                                'posts_per_page' => -1,
                                'post_parent'    => $postID,
                                'order'          => 'DESC',
                                'orderby'        => 'menu_order'
                             );
                    $query = new WP_Query($args);
                    

                    $post_count = $query->post_count;
                    if ( $query->have_posts() ){
                    $i = 1;
                      while ( $query->have_posts() ){
                        $query->the_post();
                        $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                        $post = get_post(get_the_ID());
                  ?>
                    <div class="col-md-6 col-lg-4">
                        <div class="slider-card">
                            <a href="<?php the_permalink();?>">
                                <div class="slider-card_img d-flex justify-content-center align-items-center mb-4">
                                    <img src="<?php the_field('front_image'); ?>" alt="" class="img-fluid">
                                </div>
                                <div class="slider_card_text">
                                    <h4 class="text-center"><?php echo get_the_title();?></h4>
                                    <p class="text-center"><?php the_field('short_content'); ?></p>
                                </div>
                                <div class="d-flex mx-auto justify-content-center mb-4">
                                    <p class="theme_button" data-text="Read&nbsp;More">
                                    </p>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php
                     $i++;
                    }
                  }wp_reset_postdata();
                  ?>
            </div>
        </div>
    </section>
<?php get_footer(); ?>