<?php
/*
* Template Name: Details Page
*/
?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'thumbnail' );
   if($url != "")
   {
   $img = $url; 
   }else{
   $img = $template_url."images/crumbs/about-us.jpg";
   }
?>
<?php 
$postID = get_queried_object_id();
$parent_id = $post->post_parent;
$parent_post = get_post($parent_id);
$parent_post_title = $parent_post->post_title;
?>
<!-- breadcrumb start -->
    <section class="page_breadcrumb position-relative" style="background-image: url(<?php echo $img;?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb_wrapper d-flex flex-column align-items-center justify-content-center">
                        <h2 class="breadcrumb_title text-white"><?php the_title();?></h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php the_title();?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>
<!-- Page Service Single Start -->
    <main class="page-service-single">
        <div class="container">
            <div class="row d-flex">
                <div class="col-lg-4 order-2 order-lg-1">
                    <aside class="page-single-sidebar">
                        <section class="service-catagery-list" aria-label="Temporary Services">
                            <h3 class="mb-2">Other <?php echo $parent_post_title;?></h3>
                            <hr class="hr mb-4">
                            <nav>
                                <ul class="list-unstyled">
                                 <?php 
                                       $args = array(
                                         'post_type'      => 'page',
                                         'posts_per_page' => -1,
                                         'post_parent'    => $parent_id,
                                         'order'          => 'ASC',
                                         'orderby'        => 'menu_order'
                                      );
                                      $parent = new WP_Query( $args );
                                     if ( $parent->have_posts() ) :
                                         while ( $parent->have_posts() ) : $parent->the_post();?>
                                          <li><a href="<?php the_permalink(); ?>"><span><?php the_title(); ?></span></a></li>
                                   <?php endwhile; ?>
                                   <?php endif; wp_reset_query(); ?>
                                </ul>
                            </nav>
                        </section>

                        <!-- CTA Sidebar -->
                        <section class="sidebar-cta-box wow fadeInUp my-5" data-wow-delay="0.25s">
                            <header class="sidebar-cta-content">
                                <h3 class="text-center">How can we help</h3>
                                <p>If you need any help, please feel free to contact us.</p>
                            </header>
                            <div class="sidebar-cta-contact">
                                <a href="tel:<?php echo html_entity_decode( get_option( 'option_5' ) );?>">
                                    <div class="sidebar-cta-contact-item d-flex align-items-center gap-4 mb-4">
                                        <div class="icon-box">
                                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/logo&icons/call.png" alt="">
                                        </div>
                                        <div class="cta-contact-item-content">
                                            <p><?php echo html_entity_decode( get_option( 'option_5' ) );?></p>
                                        </div>
                                    </div>
                                </a>
                                <a href="mailto:<?php echo html_entity_decode( get_option( 'option_8' ) );?>">
                                    <div class="sidebar-cta-contact-item d-flex align-items-center gap-4">
                                        <div class="icon-box">
                                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/logo&icons/email.png" alt="">
                                        </div>
                                        <div class="cta-contact-item-content">
                                            <p><?php echo html_entity_decode( get_option( 'option_8' ) );?></p>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </section>

                        <!-- Contact Form -->
                        <div class="contact_form_body">
                            <h3 class="">Quick contact</h3>
                           <?php echo do_shortcode('[contact-form-7 id="c68fcf6" title="Contact form"]');?>
                        </div>

                    </aside>
                    <!-- Page Single Sidebar End -->
                </div>

                <div class="col-lg-8 order-1 order-lg-2">
                    <article>
                        <?php echo $content = apply_filters( 'the_content', get_post_field( 'post_content', $postID ) );?>
                    </article>
                </div>
            </div>
        </div>
    </main>
    <!-- Page Service Single End -->  
<?php get_footer(); ?>