<?php
   if ( ! defined( 'ABSPATH' ) ) {
     exit; // Exit if accessed directly
   }
   ?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'thumbnail' );
   if($url != "")
   {
   $img = $url; 
   }else{
   $img = $template_url."images/crumbs/about-us.jpg"; 
   }
?>
<!-- breadcrumb start -->
<section class="page_breadcrumb position-relative" style="background-image: url(<?php echo $img;?>);">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="breadcrumb_wrapper d-flex flex-column align-items-center justify-content-center">
                    <h2 class="breadcrumb_title text-white">Blog Details</h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Blog Details</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>
<main class="page-service-single page-blogs-single">
        <div class="container">
            <div class="row d-flex">
                <div class="col-lg-8">
                    <article><?php echo get_the_content();?></article>
                </div>
                <div class="col-lg-4">
                    <aside class="page-single-sidebar">
                        <section class="service-catagery-list" aria-label="Temporary Services">
                            <h3 class="mb-2">More Blogs</h3>
                            <hr class="hr mb-4">
                            <nav>
                                <ul class="list-unstyled">
									<?php
                        $args = array ( 
                            'post_type'      => 'post',
                            'post_status'    => 'publish', 
                            'orderby' => 'publish_date',
                            'order' => 'DESC',  
                            'posts_per_page' => 10
                        );
                    $query = new WP_Query($args);
                    $post_count = $query->post_count;
                    if ( $query->have_posts() ){
                      $i = 1;
                    while ( $query->have_posts() ){
                        $blog_img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                        $query->the_post();
                    ?>
									<li>
                                        <a href="<?php the_permalink();?>" class="d-flex align-items-center">
                                            <figure>
                                                <img src="<?php the_field('front_image');?>" alt="">
                                            </figure>
                                            <div class="more_blog_details d-flex flex-column">
                                                <p><?php echo get_the_title();?></p>
                                                <span class="date">
                                                    <?php echo get_the_date( 'D M j' );?>
                                                </span>
                                            </div>
                                        </a>
                                    </li>
                     <?php
                          $i++;
                          }
                        }wp_reset_postdata();
                      ?>
                                </ul>
                            </nav>
                        </section>

                        <!-- CTA Sidebar -->
                        <section class="sidebar-cta-box wow fadeInUp my-5" data-wow-delay="0.25s">
                            <header class="sidebar-cta-content">
                                <h3 class="text-center">How can we help</h3>
                            </header>
                            <div class="sidebar-cta-contact">
                                <a href="tel:<?php echo html_entity_decode( get_option( 'option_5' ) );?>">
                                    <div class="sidebar-cta-contact-item d-flex align-items-center gap-4 mb-4">
                                        <div class="icon-box">
                                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/logo&icons/call.png" alt="">
                                        </div>
                                        <div class="cta-contact-item-content">
                                            <p><?php echo html_entity_decode( get_option( 'option_5' ) );?></p>
                                        </div>
                                    </div>
                                </a>
                                <a href="mailto:<?php echo html_entity_decode( get_option( 'option_8' ) );?>">
                                    <div class="sidebar-cta-contact-item d-flex align-items-center gap-4">
                                        <div class="icon-box">
                                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/logo&icons/email.png" alt="">
                                        </div>
                                        <div class="cta-contact-item-content">
                                            <p><?php echo html_entity_decode( get_option( 'option_8' ) );?></p>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </section>

                        <!-- Contact Form -->
                        <div class="contact_form_body">
                            <h3 class="">Quick contact</h3>
                            <?php echo do_shortcode('[contact-form-7 id="c68fcf6" title="Contact form"]');?>
                        </div>

                    </aside>
                    <!-- Page Single Sidebar End -->
                </div>
            </div>
        </div>
    </main>
<?php get_footer(); ?>