<?php
   if ( ! defined( 'ABSPATH' ) ) {
     exit; // Exit if accessed directly
   }
   ?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'thumbnail' );
   if($url != "")
   {
   $img = $url; 
   }else{
   $img = $template_url."images/crumbs/about-us.jpg"; 
   }
?>
<!-- breadcrumb start -->
    <section class="page_breadcrumb position-relative" style="background-image: url(<?php echo $img;?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb_wrapper d-flex flex-column align-items-center justify-content-center">
                        <h2 class="breadcrumb_title text-white"><?php the_title();?></h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php the_title();?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section id="page_team" class="margin_t margin_b">
        <div class="container">
            <div class="row justify-content-center g-5">
                <div class="col-10 text-center">
                    <?php the_content();?>
                </div>
                <?php
                    $args = array(
                                'post_type'      => 'page',
                                'posts_per_page' => -1,
                                'post_parent'    => 20,
                                'order'          => 'DESC',
                                'orderby'        => 'menu_order'
                             );
                    $query = new WP_Query($args);
                    

                    $post_count = $query->post_count;
                    if ( $query->have_posts() ){
                    $i = 1;
                      while ( $query->have_posts() ){
                        $query->the_post();
                        $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                        $post = get_post(get_the_ID());
                  ?>
                    <div class="col-md-4">
                        <a href="<?php the_permalink();?>">
                            <div class="member_card mx-5">
                                <div class="member_imgBx">
                                    <img src="<?php the_field('front_image'); ?>" alt="team1">
                                </div>
                                <div class="member_content">
                                    <div class="content_details">
                                        <h3><?php echo get_the_title();?></h3>
                                        <p class="designation"><?php the_field('designation'); ?></p>
                                        <div class="details_data">
                                            <p><?php the_field('short_content'); ?></p>
                                        </div>
                                        <div class="d-flex w-75 mx-auto justify-content-center mb-5">
                                            <p href="<?php the_permalink();?>" class="theme_button" data-text="Read&nbsp;More">
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php
                     $i++;
                    }
                  }wp_reset_postdata();
                  ?>
            </div>
        </div>
    </section>
<?php get_footer(); ?>