<?php
   if ( ! defined( 'ABSPATH' ) ) {
     exit; // Exit if accessed directly
   }
   ?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'thumbnail' );
   if($url != "")
   {
   $img = $url; 
   }else{
   $img = $template_url."images/crumbs/about-us.jpg"; 
   }
?>
<!-- breadcrumb start -->
    <section class="page_breadcrumb position-relative" style="background-image: url(<?php echo $img;?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb_wrapper d-flex flex-column align-items-center justify-content-center">
                        <h2 class="breadcrumb_title text-white"><?php the_title();?></h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php the_title();?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="career_top position-relative padding_b padding_t">
        <div class="container-xxl">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="career_top_wrapper position-relative d-inline-block">
                        <div class="img_wrap position-relative">
                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/career/gif.gif" class="img-fluid" alt="Career" />
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="career_top_text text-md-start text-center">
                        <?php the_content();?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="our-faqs-section rounded page__faq padding_b padding_t">
        <div class="container">
            <h2 class="text-anime-style-3 mb-4 text-center">Frequently Asked Questions</h2>

            <div class="accordion" id="faqaccordion">

                <?php if(have_rows('faqs_points')): ?>
                <?php $i=0; while(have_rows('faqs_points')): ?>
                <?php the_row(); ?>
                <!-- FAQ Item -->
                <div class="accordion-item wow fadeInUp">
                    <h2 class="accordion-header" id="heading<?=$i?>">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapse<?=$i?>" aria-expanded="true" aria-controls="collapse<?=$i?>">
                            <?php the_sub_field('question'); ?>
                        </button>
                    </h2>
                    <div id="collapse<?=$i?>" class="accordion-collapse collapse <?php if($i==0){?> show <?php }?>" aria-labelledby="heading<?=$i?>"
                        data-bs-parent="#faqaccordion">
                        <div class="accordion-body">
                            <p><?php the_sub_field('answer'); ?></p>
                        </div>
                    </div>
                </div>
                <?php $i++; endwhile; ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php get_footer(); ?>