<?php
   if ( ! defined( 'ABSPATH' ) ) {
     exit; // Exit if accessed directly
   }
   ?>
<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'thumbnail' );
   if($url != "")
   {
   $img = $url; 
   }else{
   $img = $template_url."images/crumbs/about-us.jpg"; 
   }
?>
<!-- breadcrumb start -->
    <section class="page_breadcrumb position-relative" style="background-image: url(<?php echo $img;?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb_wrapper d-flex flex-column align-items-center justify-content-center">
                        <h2 class="breadcrumb_title text-white"><?php the_title();?></h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php the_title();?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section id="page_contact" class="padding_t padding_b">
        <div class="container">
            <div class="row g-3">

                <!-- Contact Box 1 -->
                <div class="col-md-4 d-flex">
                    <a href="#" class="w-100">
                        <div class="contact_details h-100">
                            <div class="contact_details_wrap d-flex">
                                <div class="contact_icon">
                                    <img src="<?php echo get_stylesheet_directory_uri();?>/images/logo&icons/call.png" alt="" />
                                </div>
                                <div class="contact_text">
                                    <h5>Call Us</h5>
                                    <p><?php echo html_entity_decode( get_option( 'option_5' ) );?></p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

                <!-- Contact Box 2 -->
                <div class="col-md-4 d-flex">
                    <a href="#" class="w-100">
                        <div class="contact_details h-100">
                            <div class="contact_details_wrap d-flex">
                                <div class="contact_icon">
                                    <img src="<?php echo get_stylesheet_directory_uri();?>/images/logo&icons/email.png" alt="" />
                                </div>
                                <div class="contact_text">
                                    <h5>Email Us</h5>
                                    <p><?php echo html_entity_decode( get_option( 'option_8' ) );?></p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

                <!-- Contact Box 3 -->
                <div class="col-md-4 d-flex">
                    <a href="#" class="w-100">
                        <div class="contact_details h-100">
                            <div class="contact_details_wrap d-flex">
                                <div class="contact_icon">
                                    <img src="<?php echo get_stylesheet_directory_uri();?>/images/logo&icons/location.png" alt="" />
                                </div>
                                <div class="contact_text">
                                    <h5>Visit</h5>
                                    <p><?php echo html_entity_decode( get_option( 'option_10' ) );?></p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

            </div>
        </div>
    </section>

    <!-- contact form -->
    <section class="page_contact_form padding_t padding_b">
        <div class="container">
            <div class="row g-4 align-items-stretch">
                <div class="col-lg-7">
                    <div class="contact_form_wrapper padding_t padding_b h-100">
                        <div class="contact_form_title">
                            <h2 class="contact_title position-relative text-center mb-5">Get In Touch</h2>
                        </div>
                        <div class="contact_form_body">
                                <?php echo do_shortcode('[contact-form-7 id="c68fcf6" title="Contact form"]');?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5">
                    <figure class="m-0 page_form_img h-100">
                        <img src="<?php echo get_stylesheet_directory_uri();?>/images/contact/page-contact.png" alt="" />
                    </figure>
                </div>
            </div>
        </div>
    </section>  
    <section id="map">
<!--        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3572.5084778190762!2d78.03956727536514!3d27.175149548763326!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39747121d702ff6d%3A0xdd2ae4803f767dde!2sTaj%20Mahal!5e1!3m2!1sen!2sin!4v1754083438220!5m2!1sen!2sin"allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe> -->
    </section>
<?php get_footer(); ?>