<?php
/**
 * Author: Ranjan deb
 *
 */
if (!function_exists('BP_setup')):
    function BP_setup() {

        add_theme_support('title-tag');
        add_theme_support('post-thumbnails');
        set_post_thumbnail_size(825, 510, true);
        register_nav_menus(array('primary' => __('Header Menu', 'BP'),'footer_menu' => __('Footer Menu', 'BP'),'footer_service' => __('Footer Service Menu', 'BP')));
        add_theme_support('custom-logo', array('height' => 300, 'width' => 300, 'flex-height' => true,));
        add_theme_support('wc-product-gallery-zoom');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');
        add_theme_support('post-thumbnails');
        add_theme_support('title-tag');
        add_theme_support('woocommerce');
        add_theme_support(
            'post-formats',
            array(
                'link',
                'aside',
                'gallery',
                'image',
                'quote',
                'status',
                'video',
                'audio',
                'chat',
            )
        );

        add_theme_support(
            'html5',
            array(
                'comment-form',
                'comment-list',
                'gallery',
                'caption',
                'style',
                'script',
                'navigation-widgets',
            )
        );

        $logo_width  = 300;
        $logo_height = 300;
        add_theme_support(
            'custom-logo',
            array(
                'height'               => $logo_height,
                'width'                => $logo_width,
                'flex-width'           => true,
                'flex-height'          => true,
                'unlink-homepage-logo' => true,
            )
        );
        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );
        // Add support for Block Styles.
        add_theme_support( 'wp-block-styles' );
        // Add support for full and wide align images.
        add_theme_support( 'align-wide' );
    }
endif;
add_action('after_setup_theme', 'BP_setup');


require_once ('inc-BP/navwalker-functions.php');
require_once ('inc-BP/bs4navwalker.php');
require_once ('inc-BP/wordpress-extrafeatures-fuctions.php');


/**
* For Home Blog
* =========
*
*/
add_shortcode( 'BP_HOME_BLOG', 'BP_HOME_BLOG_list' );

function BP_HOME_BLOG_list($atts = array(), $content = '', $post_id = '' ) {
        
?>
          <?php
                $args = array ( 
                    'post_type'      => 'post',
                    'post_status'    => 'publish',  
                    'orderby' => 'publish_date',
                    'order' => 'DESC',  
                    'posts_per_page' => 2
                );
                $query = new WP_Query($args);
                

                $post_count = $query->post_count;
                if ( $query->have_posts() ){
                $i = 1;
                  while ( $query->have_posts() ){
                    $query->the_post();
                    $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                    $post = get_post(get_the_ID());
                    $the_cat = get_the_category(get_the_ID());
                    $cat_name = $the_cat[0]->name;
              ?>
              <div class="col-md-6 col-lg-4">
        <a href="<?php the_permalink();?>">
            <div class="blog-card">
                <div class="thumbnail">
                    <img class="" src="<?php the_field('front_image');?>" alt="Blog thumbnail">
                </div>
                <div class="cont_right">
                    <h4><?php echo get_the_title();?></h4>
                    <div class="author">
                        <h6 class="h6 mb-0">Admin</h6>
                    </div>
                    <div class="separator"></div>
                    <p class="text-dark"><?php the_field('short_content');?></p>

                    <div class="card-footer-custom">
                        <div>
                            <h5 class="mb-0"><?php echo get_the_date( 'D' );?></h5>
                            <h6 class="text-muted"><?php echo get_the_date( 'M' );?></h6>
                        </div>

                    </div>

                    <div class="fab">
                        <i class="fa fa-arrow-down fa-2x"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>
              <?php
                 $i++;
                }
              }wp_reset_postdata();
              ?>
<?php
}

/**
 * For Blog 
 * =========
 *
 */
     
add_shortcode( 'BP_blog', 'BP_blog_list' );

function BP_blog_list($atts = array(), $content = '', $post_id = '' ) {
    //function sp_cpt_shortcode( $atts, $content = null ) {
    extract(shortcode_atts(array(
        "limit" => '12'
    ), $atts));
    
    // Define limit
    if( $limit ) { 
        $posts_per_page = $limit; 
    } else {
        $posts_per_page = '-1';
    }
    $atts = shortcode_atts( array(), $atts );
    global $wpdb;
    global $post;

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $args = array ( 
    'post_type'      => array( 'post' ), 
    'orderby'        => 'post_date', 
    'order'          => 'DESC',
    'posts_per_page' => $posts_per_page,
    'paged' => $paged
    ); 

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ( $query->have_posts() ){
    $i = 1;
      while ( $query->have_posts() ){ $query->the_post();
            $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
            $post = get_post(get_the_ID());
            //$the_cat = get_the_category(get_the_ID());
            //$cat_name = $the_cat[0]->name;
    ?>
    <div class="col-md-6 col-lg-4">
        <a href="<?php the_permalink();?>">
            <div class="blog-card">
                <div class="thumbnail">
                    <img class="" src="<?php the_field('front_image');?>" alt="Blog thumbnail">
                </div>
                <div class="cont_right">
                    <h4><?php echo get_the_title();?></h4>
                    <div class="author">
                        <h6 class="h6 mb-0">Admin</h6>
                    </div>
                    <div class="separator"></div>
                    <p class="text-dark"><?php the_field('short_content');?></p>

                    <div class="card-footer-custom">
                        <div>
                            <h5 class="mb-0"><?php echo get_the_date( 'D' );?></h5>
                            <h6 class="text-muted"><?php echo get_the_date( 'M' );?></h6>
                        </div>

                    </div>

                    <div class="fab">
                        <i class="fa fa-arrow-down fa-2x"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>
<?php
    $i++;
    }
    ?>
    <div class="col-lg-12"><nav class="pagination">
     <?php
     $big = 999999999;
     echo paginate_links( array(
          'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $query->max_num_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;'
     ) );
?>
</nav></div>
    <?php
        }else{
        echo '<h2>No posts are found</h2>';
        }
        wp_reset_postdata();
    }
