<?php
if ( ! defined( 'ABSPATH' ) ) {  
  exit; // Exit if accessed directly 
} 
get_header();
$src = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' ); 
?>
<section id="hero_banner">
        <video class="bg_video"autoplay muted loop playsinline webkit-playsinline preload="auto">
            <source src="<?php echo get_stylesheet_directory_uri();?>/assets/video/rehabmantra.webm" type="video/webm">
        </video>
        <div class="hero_content container">
            <h1 class="hero_headertxt"><?php the_field('banner_heading');?></h1>
            <p class="hero_bodytxt"><?php the_field('banner_content');?></p>
            <div class="d-flex me-lg-3">
                <a href="#." class="theme_button" data-text="Book&nbsp;an&nbsp;Appointment">
                </a>
            </div>
        </div>
    </section>

    <section id="usp" class="py-4">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <div class="usp_item_wrap usp1">
                        <div class="usp_item">
                            <div class="usp_icon">
                                <img src="<?php echo get_stylesheet_directory_uri();?>/images/usp/usp1.png" alt="">
                            </div>
                            <h4><?php the_field('left_title');?></h4>
                            <p><?php the_field('left_content');?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="usp_item_wrap usp2">
                        <div class="usp_item">
                            <div class="usp_icon">
                                <img src="<?php echo get_stylesheet_directory_uri();?>/images/usp/usp2.png" alt="">
                            </div>
                            <h4><?php the_field('middle_title');?></h4>
                            <p><?php the_field('middle_content');?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="usp_item_wrap usp3">
                        <div class="usp_item">
                            <div class="usp_icon">
                                <img src="<?php echo get_stylesheet_directory_uri();?>/images/usp/usp3.png" alt="">
                            </div>
                            <h4><?php the_field('right_title');?></h4>
                            <p><?php the_field('right_content');?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="aboutus" class="padding_b padding_t">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 d-flex align-items-center">
                    <div class="aboutus_content">
                        <?php the_field('third_section_left_content');?>
						 <div class="d-flex nav_btn_bx">
                            <a href="#." class="theme_button" data-text="Read&nbsp;More"></a>
                        </div>
                    </div>
					
                      
                </div>

                <div class="col-lg-6">
                    <div class="about_img_wrap">
                        <div class="about_img1 about__img">
                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/about/90377.jpg" alt="" class="img-fluid">
                        </div>
                        <div class="about_img2 about__img">
                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/logo&icons/Rehab_Mantra_02.png" alt="">
                        </div>
                        <div class="about_img3 about__img">
                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/about/abou2.jpg" alt="" class="">
                        </div>
                        <div class="about_img4 about__img">
                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/about/about3.jpg" alt="">
                        </div>
                        <div class="about_img5 about__img">
                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/about/2148847891.jpg" alt="">
                        </div>
                        <div class="about_img6 about__img">
                            <img src="<?php echo get_stylesheet_directory_uri();?>/images/about/	
2149115587.jpg" alt="">
                        </div>
                        <div class="about_img7 about__img d-flex align-items-center justify-content-center">
                            <div class="d-flex me-lg-3 w-75">
                                <a href="#." class="theme_button w-100" data-text="Book&nbsp;Now">
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="services" class="padding_t margin_t">
        <div class="container">
            <div class="services_header">
                <?php the_field('service_section_heading');?>
                <div class="d-flex mx-auto justify-content-center">
<!--                     <a href="#." class="theme_button" data-text="More&nbsp;Services">
                    </a> -->
                </div>
            </div>
            <div class="services_slider">
                <div class="owl-carousel">
                     <?php
                          $args = array(
                                      'post_type'      => 'page',
                                      'posts_per_page' => -1,
                                      'post_parent'    => 16,
                                      'order'          => 'DESC',
                                      'orderby'        => 'menu_order'
                                   );
                          $query = new WP_Query($args);
                          

                          $post_count = $query->post_count;
                          if ( $query->have_posts() ){
                          $i = 1;
                            while ( $query->have_posts() ){
                              $query->the_post();
                              $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                              $post = get_post(get_the_ID());
                        ?>
                          
                              <div class="slider-card">
                                  <a href="<?php the_permalink();?>">
                                      <div class="slider-card_img d-flex justify-content-center align-items-center mb-4">
                                          <img src="<?php the_field('front_image'); ?>" alt="" class="img-fluid">
                                      </div>
                                      <div class="slider_card_text">
                                          <h4 class="text-center"><?php echo get_the_title();?></h4>
                                          <p class="text-center"><?php the_field('short_content'); ?></p>
                                      </div>
                                      <div class="d-flex mx-auto justify-content-center mb-4">
                                          <p class="theme_button" data-text="Read&nbsp;More">
                                          </p>
                                      </div>
                                  </a>
                              </div>
                         
                      <?php
                           $i++;
                          }
                        }wp_reset_postdata();
                        ?>
                </div>
            </div>
        </div>
    </section>

<section id="footer_call2" class="margin_t ">
  <div class="container-xxl">
      <h2 class="call_headertxt text-center"><?php echo html_entity_decode( get_option( 'option_11' ) );?></h2>
      <div class="footer_call_wrapper d-flex align-items-center justify-content-between">
          <div class="call_text">
              <p class="call_bodytxt"><span><?php echo html_entity_decode( get_option( 'option_12' ) );?></span></p>
          </div>
           <div class="d-flex nav_btn_bx justify-content-end">
               <a href="#." class="theme_button" data-text="Book&nbsp;an&nbsp;Appointment"></a>
		  </div>
      </div>
  </div>
</section>

    <section id="practices" class="padding_t padding_b">
        <div class="container">
            <div class="practices_header">
               <?php the_field('condition_section_heading');?>
            </div>
            <div class="condition_slider">
                <div class="owl-carousel">
                     <?php
                          $args = array(
                                      'post_type'      => 'page',
                                      'posts_per_page' => -1,
                                      'post_parent'    => 18,
                                      'order'          => 'DESC',
                                      'orderby'        => 'menu_order'
                                   );
                          $query = new WP_Query($args);
                          

                          $post_count = $query->post_count;
                          if ( $query->have_posts() ){
                          $i = 1;
                            while ( $query->have_posts() ){
                              $query->the_post();
                              $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                              $post = get_post(get_the_ID());
                        ?>
                        <a href="<?php the_permalink();?>">
                              <div class="slider-card">
                                  <div class="slider-card_img d-flex justify-content-center align-items-center mb-4">
                                      <img src="<?php the_field('front_image'); ?>" alt="">
                                  </div>
                                  <div class="slider_card_text">
                                      <h4 class="text-center"><?php echo get_the_title();?></h4>
                                      <p class="text-center"><?php the_field('short_content'); ?></p>
                                  </div>
                              </div>
                          </a>
                      <?php
                           $i++;
                          }
                        }wp_reset_postdata();
                        ?>
                </div>
            </div>

        </div>
    </section>
    <!-- team slider -->
<!--     <section id="team" class="padding_t">
<!--         <div class="container">
            <div class="team_header"> -->
<!--                 <//?php the_field('team_section_heading');?> -->
<!--             </div>
            <div class="team_slider mt-5">
                <div class="owl-carousel"> -->
<!--                   <//?php
                    $args = array(
                                'post_type'      => 'page',
                                'posts_per_page' => -1,
                                'post_parent'    => 20,
                                'order'          => 'DESC',
                                'orderby'        => 'menu_order'
                             );
                   // $query = new WP_Query($args);
                    

                   // $post_count = $query->post_count;
                   // if ( $query->have_posts() ){
                   // $i = 1;
                     // while ( $query->have_posts() ){
                      //  $query->the_post();
                       // $img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                       // $post = get_post(get_the_ID());
                  ?> -->
<!--                   <a href="<//?php the_permalink();?>">
                        <div class="member_card">
                            <div class="member_imgBx">
                                <img src="<//?php the_field('front_image'); ?>" alt="team1">
                            </div>
                            <div class="member_content">
                                <div class="content_details">
                                    <h3><//?php echo get_the_title();?></h3>
                                    <p class="designation"><?//php the_field('designation'); ?></p>
                                    <div class="details_data">
                                        <p><//?php the_field('short_content'); ?></p>
                                    </div>
                                    <div class="d-flex w-75 mx-auto justify-content-center mb-5">
                                        <p href="<//?php the_permalink();?>" class="theme_button" data-text="Read&nbsp;More">
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a> -->
<!--                 <//?php
                   //  $i++;
                  //  }
                //  }wp_reset_postdata();
                  ?> -->
              <!--  </div>
            </div>
        </div>
    </section> -->

    <!-- blogs  -->
    <section id="blogs" class="padding_t padding_b">
        <div class="container">
            <div class="row align-items-stretch justify-content-center">
                <div class="col-sm-10 col-lg-4 mx-auto">
                    <div class="blog-card Blogs_card1 pt-4 h-100 d-flex align-items-center">
                        <div class="Blogs_header d-flex flex-column justify-content-around">
                            <h2 class="Blogs_headertxt position-relative text-center"><span><?php the_field('heading');?></span></h2>
                            <p class="team_para text-center mx-auto"><?php the_field('content');?></p>
                            <div class="d-flex w-75 mx-auto justify-content-center mb-5">
                                <a href="<?php the_field('link');?>" class="theme_button" data-text="More&nbsp;Blogs">
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php echo do_shortcode('[BP_HOME_BLOG]');?>
            </div>
        </div>
    </section>
<?php get_footer();?>
