<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'client_testimonial' );

function client_testimonial() {
	$labels = array(
		'name'               => _x( 'Testimonial', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'Testimonial', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'Testimonial', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'Testimonial', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'Testimonial', 'asdesign' ),
		'add_new_item'       => __( 'Add New Testimonial', 'asdesign' ),
		'new_item'           => __( 'New Testimonial', 'asdesign' ),
		'edit_item'          => __( 'Edit Testimonial', 'asdesign' ),
		'view_item'          => __( 'View Testimonial', 'asdesign' ),
		'all_items'          => __( 'All Testimonial', 'asdesign' ),
		'search_items'       => __( 'Search Testimonial', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent Testimonial:', 'asdesign' ),
		'not_found'          => __( 'No Testimonial found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No Testimonial found in Trash.', 'asdesign' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => false,
		'publicly_queryable' => false,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);
	register_post_type( 'my_testimonial', $args );
}
?>