<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'client_staff' );

function client_staff() {
	$labels = array(
		'name'               => _x( 'Staff', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'Staff', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'Staff', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'Staff', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'Staff', 'asdesign' ),
		'add_new_item'       => __( 'Add New Staff', 'asdesign' ),
		'new_item'           => __( 'New Staff', 'asdesign' ),
		'edit_item'          => __( 'Edit Staff', 'asdesign' ),
		'view_item'          => __( 'View Staff', 'asdesign' ),
		'all_items'          => __( 'All Staff', 'asdesign' ),
		'search_items'       => __( 'Search Staff', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent Staff:', 'asdesign' ),
		'not_found'          => __( 'No Staff found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No Staff found in Trash.', 'asdesign' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => true,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);
	register_post_type( 'our-staff', $args );
}
?>