<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'client_services' );

function client_services() {
	$labels = array(
		'name'               => _x( 'Services', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'Services', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'Services', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'Services', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'Services', 'asdesign' ),
		'add_new_item'       => __( 'Add New Services', 'asdesign' ),
		'new_item'           => __( 'New Services', 'asdesign' ),
		'edit_item'          => __( 'Edit Services', 'asdesign' ),
		'view_item'          => __( 'View Services', 'asdesign' ),
		'all_items'          => __( 'All Services', 'asdesign' ),
		'search_items'       => __( 'Search Services', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent Services:', 'asdesign' ),
		'not_found'          => __( 'No Services found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No Services found in Trash.', 'asdesign' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => true,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);
	register_post_type( 'services', $args );
}
?>