<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'client_how_it_works' );

function client_how_it_works() {
	$labels = array(
		'name'               => _x( 'How It Works', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'How It Works', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'How It Works', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'How It Works', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'How It Works', 'asdesign' ),
		'add_new_item'       => __( 'Add New How It Works', 'asdesign' ),
		'new_item'           => __( 'New How It Works', 'asdesign' ),
		'edit_item'          => __( 'Edit How It Works', 'asdesign' ),
		'view_item'          => __( 'View How It Works', 'asdesign' ),
		'all_items'          => __( 'All How It Works', 'asdesign' ),
		'search_items'       => __( 'Search How It Works', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent How It Works:', 'asdesign' ),
		'not_found'          => __( 'No How It Works found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No How It Works found in Trash.', 'asdesign' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => true,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);
	register_post_type( 'my_how_it_works', $args );
	

}
?>